/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.ExecutableElementException;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.memory.InterruptDataPacket;
import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mics.processor.FloatRegister;
import net.wasamon.mics.processor.IntRegister;
import net.wasamon.mics.processor.Register;
import net.wasamon.mics.util.ChannelManager;
import net.wasamon.mics.util.MicsTableModel;
import net.wasamon.mics.util.MicsTablePanel;
import net.wasamon.mjlib.print.FormatException;
import net.wasamon.mjlib.print.PrintFormat;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class SimpleProcessor32
extends MicsElement
implements ExecutableElement,
ChannelConnectable,
DataBuffer,
MicsViewable {
    private IntRegister[] intRegister = new IntRegister[8];
    private static final int INST_HALT = 0;
    private static final int INST_NOP = 1;
    private static final int INST_ADD = 16;
    private static final int INST_SUB = 17;
    private static final int INST_MULT = 18;
    private static final int INST_DIV = 19;
    private static final int INST_ADDI = 20;
    private static final int INST_SUBI = 21;
    private static final int INST_MOD = 22;
    private static final int INST_LSHS = 23;
    private static final int INST_RSHS = 24;
    private static final int INST_NEG = 25;
    private static final int INST_OR = 32;
    private static final int INST_AND = 33;
    private static final int INST_JMP = 48;
    private static final int INST_JMPI = 49;
    private static final int INST_JCC = 50;
    private static final int INST_JCCI = 51;
    private static final int INST_EQ = 64;
    private static final int INST_NEQ = 65;
    private static final int INST_LT = 66;
    private static final int INST_GT = 67;
    private static final int INST_LEQ = 68;
    private static final int INST_GEQ = 69;
    private static final int INST_MOV = 80;
    private static final int INST_MOVI = 81;
    private static final int INST_MOVIL = 82;
    private static final int INST_MOVIH = 83;
    private static final int INST_POP = 96;
    private static final int INST_PUSH = 97;
    private static final int INST_CALL = 100;
    private static final int INST_CALLI = 101;
    private static final int INST_RET = 102;
    private static final int INST_LDA = 103;
    private static final int INST_STA = 104;
    private static final byte INST_LDR = -128;
    private static final byte INST_STR = -127;
    private static final byte INST_LDR8 = -126;
    private static final byte INST_STR8 = -125;
    private static final byte INST_LDR32 = -124;
    private static final byte INST_STR32 = -123;
    private static final byte INST_LDRF = -122;
    private static final byte INST_SIN = -112;
    private static final byte INST_COS = -111;
    private static final byte INST_SINF = -110;
    private static final byte INST_COSF = -109;
    private static final byte INST_SQRT = -108;
    private static final byte INST_SQRTF = -107;
    private static final int REGISTER_SIZE = 32;
    private static final int PROGRAM_COUNTER = 31;
    private static final int FRAME_POINTER = 30;
    private static final int STACK_POINTER = 29;
    private IntRegister[] register = new IntRegister[32];
    private FloatRegister[] fregister = new FloatRegister[32];
    private StateFlagGroup status = new StateFlagGroup();
    private RandomAccessMemory memory;
    private int programOffset;
    private int CODE_LENGTH = 4;
    private int readRequestRegID;
    private boolean waitFlag;
    private final int MULT_DIV_CYCLE = 2;
    private final int SIN_COS_CYCLE = 24;
    private final int SQRT_CYCLE = 24;
    private ChannelManager channelManager;
    MicsTablePanel table;

    public SimpleProcessor32() {
        int i = 0;
        while (i < 32) {
            this.register[i] = new IntRegister();
            this.fregister[i] = new FloatRegister();
            ++i;
        }
    }

    private boolean isFloatRegister(int index) {
        return index >= 32;
    }

    private Register getRegister(int index) {
        if (this.isFloatRegister(index)) {
            return this.fregister[index - 32];
        }
        return this.register[index];
    }

    public void initialize(String base, Node n) throws MicsException {
        this.channelManager = new ChannelManager(this.composite);
        try {
            Node init_var_node = n;
            int init_var_memory = DataUtil.parseInt(XMLParser.getAttribute(init_var_node, "memory").getNodeValue());
            this.memory = new RandomAccessMemory(init_var_memory);
            Node[] init_var__channel_obj = XMLParser.getNamedNodeArray(n, "channel");
            int i = 0;
            while (i < init_var__channel_obj.length) {
                Node init_var__channel_node = init_var__channel_obj[i];
                String init_var__channel_id = XMLParser.getAttribute(init_var__channel_node, "id").getNodeValue();
                int init_var__channel_offset = DataUtil.parseInt(XMLParser.getAttribute(init_var__channel_node, "offset").getNodeValue());
                this.channelManager.add(init_var__channel_id, init_var__channel_offset);
                ++i;
            }
            Node[] init_var__init_obj = XMLParser.getNamedNodeArray(n, "init");
            i = 0;
            while (i < init_var__init_obj.length) {
                Node init_var__init_node = init_var__init_obj[i];
                String init_var__init_file = XMLParser.getAttribute(init_var__init_node, "file").getNodeValue();
                if (init_var__init_file.charAt(0) != '/') {
                    init_var__init_file = String.valueOf(base) + "/" + init_var__init_file;
                }
                int init_var__init_offset = DataUtil.parseInt(XMLParser.getAttribute(init_var__init_node, "offset").getNodeValue());
                try {
                    this.write(init_var__init_offset, new BufferedInputStream(new FileInputStream(init_var__init_file)));
                }
                catch (FileNotFoundException e) {
                    System.out.println("no such file: " + init_var__init_file);
                    System.out.println("[W] no data is written as initialize.");
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.SimpleProcessor");
        }
        catch (XMLParserException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.SimpleProcessor");
        }
    }

    public MicsDataPacket read(MicsDataPacket data) {
        return this.memory.read(data);
    }

    public void write(MicsDataPacket data) {
        this.memory.write(data);
    }

    public void write(int addr, InputStream reader) throws DataBufferException {
        this.memory.write(addr, reader);
    }

    public void dump(int offset, int len, OutputStream writer) throws DataBufferException {
        this.memory.dump(offset, len, writer);
    }

    public int size() {
        return this.memory.size();
    }

    public String toString(int offset, int length) {
        return this.memory.toString(offset, length);
    }

    public void execWait() {
        this.waitFlag = true;
    }

    public void execRestart() {
        this.waitFlag = false;
    }

    public void reset() {
        this.waitFlag = false;
        int i = 0;
        while (i < 32) {
            this.register[i].reset();
            this.fregister[i].reset();
            ++i;
        }
    }

    public ExecInfo exec_second() {
        return null;
    }

    public ExecInfo exec_first() throws ExecutableElementException {
        OperationCode op = null;
        ExecInfo info = new ExecInfo();
        info.setCycle(1);
        info.setTerminatableFlag(false);
        try {
            op = this.readProgram(this.register[31].intValue());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ExecutableElementException("program address error");
        }
        if (this.waitFlag) {
            return info;
        }
        switch (op.inst) {
            case 0: {
                info.setTerminatableFlag(true);
                break;
            }
            case 1: {
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 16: {
                Register reg0 = this.getRegister(op.args[1]);
                Register reg1 = this.getRegister(op.args[2]);
                this.getRegister(op.args[0]).add(reg0, reg1);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 20: {
                this.getRegister(op.args[0]).add(DataUtil.toSiginedInteger(DataUtil.toChar(op.args[1], op.args[2])));
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 17: {
                Register reg0 = this.getRegister(op.args[1]);
                Register reg1 = this.getRegister(op.args[2]);
                this.getRegister(op.args[0]).sub(reg0, reg1);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 25: {
                Register reg0 = this.getRegister(op.args[0]);
                Register reg1 = this.getRegister(op.args[1]);
                reg0.neg(reg1);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 21: {
                this.getRegister(op.args[0]).add(-DataUtil.toSiginedInteger(DataUtil.toChar(op.args[1], op.args[2])));
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 18: {
                Register reg0 = this.getRegister(op.args[1]);
                Register reg1 = this.getRegister(op.args[2]);
                this.getRegister(op.args[0]).mult(reg0, reg1);
                this.register[31].add(this.CODE_LENGTH);
                info.setCycle(2);
                break;
            }
            case 19: {
                try {
                    Register reg0 = this.getRegister(op.args[1]);
                    Register reg1 = this.getRegister(op.args[2]);
                    this.getRegister(op.args[0]).div(reg0, reg1);
                }
                catch (ArithmeticException e) {
                    this.status.fNaN = true;
                }
                this.register[31].add(this.CODE_LENGTH);
                info.setCycle(2);
                break;
            }
            case 22: {
                Register reg0 = this.getRegister(op.args[1]);
                Register reg1 = this.getRegister(op.args[2]);
                this.getRegister(op.args[0]).mod(reg0, reg1);
                this.register[31].add(this.CODE_LENGTH);
                info.setCycle(2);
                break;
            }
            case 23: {
                Register reg0 = this.getRegister(op.args[1]);
                Register reg1 = this.getRegister(op.args[2]);
                this.getRegister(op.args[0]).shiftL(reg0, reg1);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 24: {
                Register reg0 = this.getRegister(op.args[1]);
                Register reg1 = this.getRegister(op.args[2]);
                this.getRegister(op.args[0]).shiftR(reg0, reg1);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 32: {
                Register reg0 = this.getRegister(op.args[1]);
                Register reg1 = this.getRegister(op.args[2]);
                this.getRegister(op.args[0]).or(reg0, reg1);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 33: {
                Register reg0 = this.getRegister(op.args[1]);
                Register reg1 = this.getRegister(op.args[2]);
                this.getRegister(op.args[0]).and(reg0, reg1);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 48: {
                this.register[31].set(this.register[op.args[0]].intValue());
                break;
            }
            case 49: {
                this.register[31].set(DataUtil.toChar(op.args[0], op.args[1]));
                break;
            }
            case 50: {
                if (this.status.fCondition) {
                    this.register[31].set(this.register[op.args[0]].intValue());
                    break;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 51: {
                if (this.status.fCondition) {
                    this.register[31].set(DataUtil.toChar(op.args[0], op.args[1]));
                    break;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 64: {
                Register reg0 = this.getRegister(op.args[1]);
                Register reg1 = this.getRegister(op.args[2]);
                if (reg0.eqeq(reg1)) {
                    this.getRegister(op.args[0]).set(0);
                    this.status.fCondition = true;
                } else {
                    this.getRegister(op.args[0]).set(1);
                    this.status.fCondition = false;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 65: {
                Register reg0 = this.getRegister(op.args[1]);
                Register reg1 = this.getRegister(op.args[2]);
                if (!reg0.eqeq(reg1)) {
                    this.getRegister(op.args[0]).set(0);
                    this.status.fCondition = true;
                } else {
                    this.getRegister(op.args[0]).set(1);
                    this.status.fCondition = false;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 66: {
                Register reg0 = this.getRegister(op.args[1]);
                Register reg1 = this.getRegister(op.args[2]);
                if (!reg0.gt(reg1) && !reg0.eqeq(reg1)) {
                    this.getRegister(op.args[0]).set(0);
                    this.status.fCondition = true;
                } else {
                    this.getRegister(op.args[0]).set(1);
                    this.status.fCondition = false;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 67: {
                Register reg0 = this.getRegister(op.args[1]);
                Register reg1 = this.getRegister(op.args[2]);
                if (reg0.gt(reg1)) {
                    this.getRegister(op.args[0]).set(0);
                    this.status.fCondition = true;
                } else {
                    this.getRegister(op.args[0]).set(1);
                    this.status.fCondition = false;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 68: {
                Register reg0 = this.getRegister(op.args[1]);
                Register reg1 = this.getRegister(op.args[2]);
                if (!reg0.gt(reg1)) {
                    this.getRegister(op.args[0]).set(0);
                    this.status.fCondition = true;
                } else {
                    this.getRegister(op.args[0]).set(1);
                    this.status.fCondition = false;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 69: {
                Register reg0 = this.getRegister(op.args[1]);
                Register reg1 = this.getRegister(op.args[2]);
                if (reg0.gt(reg1) || reg0.eqeq(reg1)) {
                    this.getRegister(op.args[0]).set(0);
                    this.status.fCondition = true;
                } else {
                    this.getRegister(op.args[0]).set(1);
                    this.status.fCondition = false;
                }
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -128: {
                this.loadData(op.args[1], this.getRegister(op.args[0]).intValue(), 2);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -126: {
                this.loadData(op.args[1], this.getRegister(op.args[0]).intValue(), 1);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -124: {
                this.loadData(op.args[1], this.getRegister(op.args[0]).intValue(), 4);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -122: {
                this.loadData(op.args[1], this.getRegister(op.args[0]).intValue(), 4);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -127: {
                this.storeData(this.getRegister(op.args[1]).byteArray(2, 2), this.getRegister(op.args[0]).intValue(), 2);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -125: {
                this.storeData(this.getRegister(op.args[1]).byteArray(3, 1), this.getRegister(op.args[0]).intValue(), 1);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -123: {
                this.storeData(this.getRegister(op.args[1]).byteArray(), this.getRegister(op.args[0]).intValue(), 4);
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 81: {
                Register reg0 = this.getRegister(op.args[0]);
                reg0.set(DataUtil.subArray(op.args, 1, 2));
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 80: {
                this.getRegister(op.args[0]).set(this.getRegister(op.args[1]));
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 96: {
                this.getRegister(op.args[0]).set(this.pop());
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 97: {
                this.push(this.getRegister(op.args[0]));
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 100: {
                this.push(this.register[31]);
                this.register[31].set(this.getRegister(op.args[0]).intValue());
                break;
            }
            case 101: {
                this.push(this.register[31]);
                this.register[31].set(DataUtil.toChar(op.args[0], op.args[1]));
                break;
            }
            case 102: {
                this.register[31].set(this.pop().intValue() + this.CODE_LENGTH);
                break;
            }
            case 103: {
                int fp = this.register[30].intValue();
                int offset = DataUtil.toSiginedInteger(DataUtil.toChar(DataUtil.subArray(op.args, 1, 2), 0, 2));
                this.getRegister(op.args[0]).set(this.memory.read(fp + offset, 4));
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case 104: {
                int fp = this.register[30].intValue();
                int offset = DataUtil.toSiginedInteger(DataUtil.toChar(DataUtil.subArray(op.args, 1, 2), 0, 2));
                this.memory.write(fp + offset, 4, this.getRegister(op.args[0]).byteArray());
                this.register[31].add(this.CODE_LENGTH);
                break;
            }
            case -112: {
                Register reg0 = this.getRegister(op.args[0]);
                Register reg1 = this.getRegister(op.args[1]);
                this.getRegister(op.args[0]).set((int)Math.sin(reg1.intValue()));
                this.register[31].add(this.CODE_LENGTH);
                info.setCycle(24);
                break;
            }
            case -111: {
                Register reg0 = this.getRegister(op.args[0]);
                Register reg1 = this.getRegister(op.args[1]);
                this.getRegister(op.args[0]).set((int)Math.cos(reg1.intValue()));
                this.register[31].add(this.CODE_LENGTH);
                info.setCycle(24);
                break;
            }
            case -110: {
                Register reg0 = this.getRegister(op.args[0]);
                Register reg1 = this.getRegister(op.args[1]);
                ((FloatRegister)this.getRegister(op.args[0])).set((float)Math.sin(reg1.floatValue()));
                this.register[31].add(this.CODE_LENGTH);
                info.setCycle(24);
                break;
            }
            case -109: {
                Register reg0 = this.getRegister(op.args[0]);
                Register reg1 = this.getRegister(op.args[1]);
                ((FloatRegister)this.getRegister(op.args[0])).set((float)Math.sin(reg1.floatValue()));
                this.register[31].add(this.CODE_LENGTH);
                info.setCycle(24);
                break;
            }
            case -108: {
                Register reg0 = this.getRegister(op.args[0]);
                Register reg1 = this.getRegister(op.args[1]);
                this.getRegister(op.args[0]).set((int)Math.sqrt(reg1.intValue()));
                this.register[31].add(this.CODE_LENGTH);
                info.setCycle(24);
                break;
            }
            case -107: {
                Register reg0 = this.getRegister(op.args[0]);
                Register reg1 = this.getRegister(op.args[1]);
                ((FloatRegister)this.getRegister(op.args[0])).set((float)Math.sqrt(reg1.floatValue()));
                this.register[31].add(this.CODE_LENGTH);
                info.setCycle(24);
                break;
            }
            default: {
                throw new ExecutableElementException("unknow op code " + String.valueOf(op.inst));
            }
        }
        return info;
    }

    private void storeData(byte[] data, int addr, int length) throws ExecutableElementException {
        if (addr < this.memory.size()) {
            this.memory.write(addr, length, data);
        } else {
            ChannelManager.Element c = this.channelManager.search(addr);
            try {
                c.getChannel().writeRequest(this, RandomAccessMemoryDataPacket.writePacket(addr - c.offset, length, 8, data));
            }
            catch (MicsException e) {
                throw new ExecutableElementException(e);
            }
        }
    }

    private void loadData(int dest, int addr, int length) throws ExecutableElementException {
        if (addr < this.memory.size()) {
            this.getRegister(dest).set(this.memory.read(addr, length));
        } else {
            this.readRequestRegID = dest;
            ChannelManager.Element c = this.channelManager.search(addr);
            try {
                c.getChannel().readRequest(this, RandomAccessMemoryDataPacket.readPacket(addr - c.offset, length, 8));
            }
            catch (MicsException e) {
                throw new ExecutableElementException(e);
            }
        }
    }

    private Register pop() throws ExecutableElementException {
        if (this.register[29].intValue() < this.memory.size() - 1) {
            IntRegister data = new IntRegister();
            data.set(this.memory.read(this.register[29].intValue(), 4));
            this.register[29].add(4);
            return data;
        }
        throw new ExecutableElementException("stack under flow");
    }

    private void push(Register v) throws ExecutableElementException {
        if (this.register[29].intValue() <= 4) {
            System.out.println("stack pointer " + this.register[29]);
            throw new ExecutableElementException("stack over flow");
        }
        this.register[29].add(-4);
        this.memory.write(this.register[29].intValue(), 4, v.byteArray());
    }

    private OperationCode readProgram(int addr) {
        byte[] data = this.memory.read(addr + this.programOffset, 4);
        return new OperationCode(data[0], data[1], data[2], data[3]);
    }

    public void writeback(MicsDataPacket data) {
        if (data instanceof RandomAccessMemoryDataPacket) {
            RandomAccessMemoryDataPacket rd = (RandomAccessMemoryDataPacket)data;
            switch (rd.length * rd.width / 8) {
                case 1: {
                    this.register[this.readRequestRegID].set(rd.data);
                    break;
                }
                case 2: {
                    this.register[this.readRequestRegID].set(rd.data);
                    break;
                }
                case 4: {
                    this.register[this.readRequestRegID].set(rd.data);
                }
            }
        } else if (data instanceof InterruptDataPacket) {
            InterruptDataPacket d = (InterruptDataPacket)data;
            try {
                this.storeData(d.data, 0xA000002, d.data.length);
            }
            catch (ExecutableElementException executableElementException) {
                // empty catch block
            }
        }
    }

    public int getChannelOffset(Channel c) {
        return this.channelManager.search(c);
    }

    public String getInfo() {
        String s = "";
        s = String.valueOf(s) + "SimpleProcessor32\n";
        s = String.valueOf(s) + "  CLASS: " + this.getClass().getName() + "\n";
        s = String.valueOf(s) + "  ID: " + this.id() + "\n";
        s = String.valueOf(s) + "  Local Memory ID: " + this.memory.id() + ",";
        s = String.valueOf(s) + " offset = " + DataUtil.toBigEndianValueString(DataUtil.toByteArray(this.programOffset)) + "\n";
        ChannelManager.Element[] channels = this.channelManager.array();
        int i = 0;
        while (i < channels.length) {
            ChannelManager.Element element = channels[i];
            s = String.valueOf(s) + "  Channel ID: " + element.id + ",";
            s = String.valueOf(s) + " offset = " + element.offset + "\n";
            ++i;
        }
        return s;
    }

    public String toString() {
        try {
            String str = "";
            try {
                str = String.valueOf(str) + this.register[31] + ":";
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
            str = String.valueOf(str) + this.readProgram(this.register[31].intValue()).toString();
            str = String.valueOf(str) + "\n";
            int i = 0;
            while (i < 32) {
                try {
                    str = String.valueOf(str) + this.register[i];
                    str = i % 8 == 7 ? String.valueOf(str) + "\n" : String.valueOf(str) + " ";
                }
                catch (FormatException formatException) {
                    // empty catch block
                }
                ++i;
            }
            return str;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new String(String.valueOf(this.register[31].intValue()) + ": illegal program counter");
        }
    }

    public String[] getConnectedElements() {
        return this.channelManager.getConnectedElements();
    }

    public void show() {
        if (this.table == null) {
            String[] label = new String[32];
            String[] flabel = new String[32];
            int i = 0;
            while (i < 32) {
                label[i] = String.valueOf(i);
                ++i;
            }
            i = 0;
            while (i < 32) {
                flabel[i] = String.valueOf(i + 32);
                ++i;
            }
            this.table = new MicsTablePanel("SimpleProcessor32 Register", new MicsTableModel(new String[]{"name", "value", "name", "value"}, new Object[][]{label, this.register, flabel, this.fregister}));
        }
        this.table.setVisible(true);
    }

    public String getImagePath() {
        return "combo_processor.png";
    }

    class OperationCode {
        private byte inst;
        private byte[] args = new byte[3];

        OperationCode(byte inst, byte arg0, byte arg1, byte arg2) {
            this.inst = inst;
            this.args[0] = arg0;
            this.args[1] = arg1;
            this.args[2] = arg2;
        }

        public String toString() {
            String str = "";
            switch (this.inst) {
                case 0: {
                    str = String.valueOf(str) + "HALT ";
                    break;
                }
                case 1: {
                    str = String.valueOf(str) + "NOP  ";
                    break;
                }
                case 16: {
                    str = String.valueOf(str) + "ADD  ";
                    break;
                }
                case 20: {
                    str = String.valueOf(str) + "ADDI ";
                    break;
                }
                case 17: {
                    str = String.valueOf(str) + "SUB  ";
                    break;
                }
                case 25: {
                    str = String.valueOf(str) + "NEG  ";
                    break;
                }
                case 21: {
                    str = String.valueOf(str) + "SUBI ";
                    break;
                }
                case 18: {
                    str = String.valueOf(str) + "MULT ";
                    break;
                }
                case 19: {
                    str = String.valueOf(str) + "DIV  ";
                    break;
                }
                case 22: {
                    str = String.valueOf(str) + "MOD  ";
                    break;
                }
                case 23: {
                    str = String.valueOf(str) + "LSHS ";
                    break;
                }
                case 24: {
                    str = String.valueOf(str) + "RSHS ";
                    break;
                }
                case 32: {
                    str = String.valueOf(str) + "OR   ";
                    break;
                }
                case 33: {
                    str = String.valueOf(str) + "AND  ";
                    break;
                }
                case 48: {
                    str = String.valueOf(str) + "JMP  ";
                    break;
                }
                case 49: {
                    str = String.valueOf(str) + "JMPI ";
                    break;
                }
                case 50: {
                    str = String.valueOf(str) + "JCC  ";
                    break;
                }
                case 51: {
                    str = String.valueOf(str) + "JCCI ";
                    break;
                }
                case 64: {
                    str = String.valueOf(str) + "EQ   ";
                    break;
                }
                case 65: {
                    str = String.valueOf(str) + "NEQ  ";
                    break;
                }
                case 66: {
                    str = String.valueOf(str) + "LT   ";
                    break;
                }
                case 67: {
                    str = String.valueOf(str) + "GT   ";
                    break;
                }
                case 68: {
                    str = String.valueOf(str) + "LEQ  ";
                    break;
                }
                case 69: {
                    str = String.valueOf(str) + "GEQ  ";
                    break;
                }
                case -128: {
                    str = String.valueOf(str) + "LDR  ";
                    break;
                }
                case -127: {
                    str = String.valueOf(str) + "STR  ";
                    break;
                }
                case -126: {
                    str = String.valueOf(str) + "LDR8 ";
                    break;
                }
                case -125: {
                    str = String.valueOf(str) + "STR8 ";
                    break;
                }
                case -124: {
                    str = String.valueOf(str) + "LDR32";
                    break;
                }
                case -123: {
                    str = String.valueOf(str) + "STR32";
                    break;
                }
                case -122: {
                    str = String.valueOf(str) + "LDRF ";
                    break;
                }
                case 80: {
                    str = String.valueOf(str) + "MOV  ";
                    break;
                }
                case 81: {
                    str = String.valueOf(str) + "MOVI ";
                    break;
                }
                case 82: {
                    str = String.valueOf(str) + "MOVIL";
                    break;
                }
                case 83: {
                    str = String.valueOf(str) + "MOVIH";
                    break;
                }
                case 96: {
                    str = String.valueOf(str) + "POP  ";
                    break;
                }
                case 97: {
                    str = String.valueOf(str) + "PUSH ";
                    break;
                }
                case 100: {
                    str = String.valueOf(str) + "CALL ";
                    break;
                }
                case 101: {
                    str = String.valueOf(str) + "CALLI";
                    break;
                }
                case 102: {
                    str = String.valueOf(str) + "RET  ";
                    break;
                }
                case 103: {
                    str = String.valueOf(str) + "LDA  ";
                    break;
                }
                case 104: {
                    str = String.valueOf(str) + "STA  ";
                    break;
                }
                case -111: {
                    str = String.valueOf(str) + "COS  ";
                    break;
                }
                case -112: {
                    str = String.valueOf(str) + "SIN  ";
                    break;
                }
                case -109: {
                    str = String.valueOf(str) + "COSF  ";
                    break;
                }
                case -110: {
                    str = String.valueOf(str) + "SINF  ";
                    break;
                }
                case -108: {
                    str = String.valueOf(str) + "SQRT  ";
                    break;
                }
                case -107: {
                    str = String.valueOf(str) + "SQRTF ";
                    break;
                }
                default: {
                    str = String.valueOf(str) + "ERROR";
                }
            }
            str = String.valueOf(str) + ",";
            try {
                str = String.valueOf(str) + PrintFormat.print("%02x", this.args[0]);
                str = String.valueOf(str) + ",";
                str = String.valueOf(str) + PrintFormat.print("%02x", this.args[1]);
                str = String.valueOf(str) + ",";
                str = String.valueOf(str) + PrintFormat.print("%02x", this.args[2]);
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
            return str;
        }
    }

    class StateFlagGroup {
        public boolean fNaN = false;
        public boolean fAddressError = false;
        public boolean fCondition = false;
        public boolean fCarry = false;

        StateFlagGroup() {
        }

        public void reset() {
            this.fNaN = false;
            this.fAddressError = false;
            this.fCondition = false;
            this.fCarry = false;
        }
    }
}

