/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor;

import java.io.InputStream;
import java.io.OutputStream;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.ExecutableElementException;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mics.util.ChannelManager;
import net.wasamon.mjlib.print.FormatException;
import net.wasamon.mjlib.print.PrintFormat;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import net.wasamon.wallet.binutils.UnknownInstructionException;
import org.w3c.dom.Node;

public class SimpleProcessor
extends MicsElement
implements ExecutableElement,
ChannelConnectable,
DataBuffer {
    private static final int INST_HALT = 0;
    private static final int INST_NOP = 1;
    private static final int INST_ADD = 16;
    private static final int INST_SUB = 17;
    private static final int INST_MULT = 18;
    private static final int INST_DIV = 19;
    private static final int INST_ADDI = 20;
    private static final int INST_SUBI = 21;
    private static final int INST_MOD = 22;
    private static final int INST_LSHS = 23;
    private static final int INST_RSHS = 24;
    private static final int INST_OR = 32;
    private static final int INST_AND = 33;
    private static final int INST_JMP = 48;
    private static final int INST_JMPI = 49;
    private static final int INST_JCC = 50;
    private static final int INST_JCCI = 51;
    private static final int INST_EQ = 64;
    private static final int INST_NEQ = 65;
    private static final int INST_LT = 66;
    private static final int INST_GT = 67;
    private static final int INST_LEQ = 68;
    private static final int INST_GEQ = 69;
    private static final int INST_MOV = 80;
    private static final int INST_MOVI = 81;
    private static final int INST_POP = 96;
    private static final int INST_PUSH = 97;
    private static final int INST_CALL = 100;
    private static final int INST_CALLI = 101;
    private static final int INST_RET = 102;
    private static final int INST_LDA = 103;
    private static final int INST_STA = 104;
    private static final byte INST_LDR = -128;
    private static final byte INST_STR = -127;
    private static final byte INST_LDR8 = -126;
    private static final byte INST_STR8 = -125;
    private static final int REGISTER_SIZE = 32;
    private static final int PROGRAM_COUNTER = 31;
    private static final int FRAME_POINTER = 30;
    private static final int STACK_POINTER = 29;
    private char[] register = new char[32];
    private boolean condition = false;
    private RandomAccessMemory memory;
    private int programOffset;
    private int CODE_LENGTH = 4;
    private int readRequestRegID;
    private boolean waitFlag;
    private final int MULT_DIV_CYCLE = 2;
    private ChannelManager channelManager;

    public void initialize(String base, Node n) throws MicsException {
        this.channelManager = new ChannelManager(this.composite);
        try {
            Node init_var_node = n;
            int init_var_memory = DataUtil.parseInt(XMLParser.getAttribute(init_var_node, "memory").getNodeValue());
            this.memory = new RandomAccessMemory(init_var_memory);
            Node[] init_var__channel_obj = XMLParser.getNamedNodeArray(n, "channel");
            int i = 0;
            while (i < init_var__channel_obj.length) {
                Node init_var__channel_node = init_var__channel_obj[i];
                String init_var__channel_id = XMLParser.getAttribute(init_var__channel_node, "id").getNodeValue();
                int init_var__channel_offset = DataUtil.parseInt(XMLParser.getAttribute(init_var__channel_node, "offset").getNodeValue());
                this.channelManager.add(init_var__channel_id, init_var__channel_offset);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.SimpleProcessor");
        }
        catch (XMLParserException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.SimpleProcessor");
        }
    }

    public MicsDataPacket read(MicsDataPacket data) {
        return this.memory.read(data);
    }

    public void write(MicsDataPacket data) {
        this.memory.write(data);
    }

    public void write(int addr, InputStream reader) throws DataBufferException {
        this.memory.write(addr, reader);
    }

    public void dump(int offset, int len, OutputStream writer) throws DataBufferException {
        this.memory.dump(offset, len, writer);
    }

    public int size() {
        return this.memory.size();
    }

    public String toString(int offset, int length) {
        return this.memory.toString(offset, length);
    }

    public void execWait() {
        this.waitFlag = true;
    }

    public void execRestart() {
        this.waitFlag = false;
    }

    public void reset() {
        this.waitFlag = false;
        int i = 0;
        while (i < 32) {
            this.register[i] = '\u0000';
            ++i;
        }
    }

    public ExecInfo exec_second() {
        return null;
    }

    public ExecInfo exec_first() throws ExecutableElementException {
        OperationCode op = null;
        ExecInfo info = new ExecInfo();
        info.setCycle(1);
        info.setTerminatableFlag(false);
        try {
            op = this.readProgram(this.register[31]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ExecutableElementException("program address error");
        }
        if (this.waitFlag) {
            return info;
        }
        int tmp = 0;
        switch (op.inst) {
            case 0: {
                info.setTerminatableFlag(true);
                break;
            }
            case 1: {
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 16: {
                tmp = this.register[op.args[1]] + this.register[op.args[2]];
                this.register[((OperationCode)op).args[0]] = DataUtil.toCharL(tmp);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 20: {
                char imm = (char)(((op.args[1] & 0xFF) << 8) + (op.args[2] & 0xFF));
                byte by = op.args[0];
                this.register[by] = (char)(this.register[by] + imm);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 17: {
                tmp = this.register[op.args[1]] - this.register[op.args[2]];
                this.register[((OperationCode)op).args[0]] = DataUtil.toCharL(tmp);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 21: {
                char imm = (char)(((op.args[1] & 0xFF) << 8) + (op.args[2] & 0xFF));
                byte by = op.args[0];
                this.register[by] = (char)(this.register[by] - imm);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 18: {
                tmp = this.register[op.args[1]] * this.register[op.args[2]];
                this.register[((OperationCode)op).args[0]] = DataUtil.toCharL(tmp);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                info.setCycle(2);
                break;
            }
            case 19: {
                this.register[((OperationCode)op).args[0]] = DataUtil.toCharL(this.register[op.args[1]] / this.register[op.args[2]]);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                info.setCycle(2);
                break;
            }
            case 22: {
                this.register[((OperationCode)op).args[0]] = DataUtil.toCharL(this.register[op.args[1]] % this.register[op.args[2]]);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                info.setCycle(2);
                break;
            }
            case 23: {
                this.register[((OperationCode)op).args[0]] = DataUtil.toCharL(this.register[op.args[1]] << this.register[op.args[2]]);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 24: {
                this.register[((OperationCode)op).args[0]] = DataUtil.toCharL(this.register[op.args[1]] >> this.register[op.args[2]]);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 32: {
                tmp = this.register[op.args[1]] | this.register[op.args[2]];
                this.register[((OperationCode)op).args[0]] = DataUtil.toCharL(tmp);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 33: {
                tmp = this.register[op.args[1]] & this.register[op.args[2]];
                this.register[((OperationCode)op).args[0]] = DataUtil.toCharL(tmp);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 48: {
                this.register[31] = (char)(this.register[op.args[0]] * this.CODE_LENGTH);
                break;
            }
            case 49: {
                this.register[31] = (char)(DataUtil.toChar(op.args[0], op.args[1]) * this.CODE_LENGTH);
                break;
            }
            case 50: {
                if (this.condition) {
                    this.register[31] = (char)(this.register[op.args[0]] * this.CODE_LENGTH);
                    break;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 51: {
                if (this.condition) {
                    this.register[31] = (char)(DataUtil.toChar(op.args[0], op.args[1]) * this.CODE_LENGTH);
                    break;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 64: {
                if (this.register[op.args[1]] == this.register[op.args[2]]) {
                    this.register[((OperationCode)op).args[0]] = '\u0000';
                    this.condition = true;
                } else {
                    this.register[((OperationCode)op).args[0]] = '\u0001';
                    this.condition = false;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 65: {
                if (this.register[op.args[1]] != this.register[op.args[2]]) {
                    this.register[((OperationCode)op).args[0]] = '\u0000';
                    this.condition = true;
                } else {
                    this.register[((OperationCode)op).args[0]] = '\u0001';
                    this.condition = false;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 66: {
                if (DataUtil.toSiginedInteger(this.register[op.args[1]]) < DataUtil.toSiginedInteger(this.register[op.args[2]])) {
                    this.register[((OperationCode)op).args[0]] = '\u0000';
                    this.condition = true;
                } else {
                    this.register[((OperationCode)op).args[0]] = '\u0001';
                    this.condition = false;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 67: {
                if (DataUtil.toSiginedInteger(this.register[op.args[1]]) > DataUtil.toSiginedInteger(this.register[op.args[2]])) {
                    this.register[((OperationCode)op).args[0]] = '\u0000';
                    this.condition = true;
                } else {
                    this.register[((OperationCode)op).args[0]] = '\u0001';
                    this.condition = false;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 68: {
                if (DataUtil.toSiginedInteger(this.register[op.args[1]]) <= DataUtil.toSiginedInteger(this.register[op.args[2]])) {
                    this.register[((OperationCode)op).args[0]] = '\u0000';
                    this.condition = true;
                } else {
                    this.register[((OperationCode)op).args[0]] = '\u0001';
                    this.condition = false;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 69: {
                if (DataUtil.toSiginedInteger(this.register[op.args[1]]) >= DataUtil.toSiginedInteger(this.register[op.args[2]])) {
                    this.register[((OperationCode)op).args[0]] = '\u0000';
                    this.condition = true;
                } else {
                    this.register[((OperationCode)op).args[0]] = '\u0001';
                    this.condition = false;
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case -128: {
                if (this.register[op.args[0]] < this.memory.size()) {
                    this.register[((OperationCode)op).args[1]] = DataUtil.toChar(this.memory.read(this.register[op.args[0]], 2), 0, 2);
                } else {
                    this.readRequestRegID = op.args[1];
                    ChannelManager.Element c = this.channelManager.search(this.register[op.args[0]]);
                    try {
                        c.getChannel().readRequest(this, RandomAccessMemoryDataPacket.readPacket(this.register[op.args[0]] - c.offset, 1, 16));
                    }
                    catch (MicsException e) {
                        throw new ExecutableElementException(e);
                    }
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case -126: {
                if (this.register[op.args[0]] < this.memory.size()) {
                    this.register[((OperationCode)op).args[1]] = DataUtil.toChar(this.memory.read(this.register[op.args[0]], 1), 0, 1);
                } else {
                    this.readRequestRegID = op.args[1];
                    ChannelManager.Element c = this.channelManager.search(this.register[op.args[0]]);
                    try {
                        c.getChannel().readRequest(this, RandomAccessMemoryDataPacket.readPacket(this.register[op.args[0]] - c.offset, 1, 8));
                    }
                    catch (MicsException e) {
                        throw new ExecutableElementException(e);
                    }
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case -127: {
                if (this.register[op.args[0]] < this.memory.size()) {
                    this.memory.write(this.register[op.args[0]], 2, DataUtil.toByteArray(this.register[op.args[1]]));
                } else {
                    ChannelManager.Element c = this.channelManager.search(this.register[op.args[0]]);
                    try {
                        c.getChannel().writeRequest(this, RandomAccessMemoryDataPacket.writePacket(this.register[op.args[0]] - c.offset, 2, 8, DataUtil.toByteArray(this.register[op.args[1]])));
                    }
                    catch (MicsException e) {
                        throw new ExecutableElementException(e);
                    }
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case -125: {
                if (this.register[op.args[0]] < this.memory.size()) {
                    this.memory.write((int)this.register[op.args[0]], DataUtil.toByteL(this.register[op.args[1]]));
                } else {
                    ChannelManager.Element c = this.channelManager.search(this.register[op.args[0]]);
                    try {
                        c.getChannel().writeRequest(this, RandomAccessMemoryDataPacket.writePacket(this.register[op.args[0]] - c.offset, 1, 8, new byte[]{DataUtil.toByteL(this.register[op.args[1]])}));
                    }
                    catch (MicsException e) {
                        throw new ExecutableElementException(e);
                    }
                }
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 81: {
                this.register[((OperationCode)op).args[0]] = DataUtil.toChar(op.args[1], op.args[2]);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 80: {
                this.register[((OperationCode)op).args[0]] = this.register[op.args[1]];
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 96: {
                this.register[((OperationCode)op).args[0]] = this.pop();
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 97: {
                this.push(this.register[op.args[0]]);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 100: {
                this.push((char)(this.register[31] + this.CODE_LENGTH));
                this.register[31] = (char)(this.register[op.args[0]] * this.CODE_LENGTH);
                break;
            }
            case 101: {
                this.push((char)(this.register[31] + this.CODE_LENGTH));
                this.register[31] = (char)(DataUtil.toChar(op.args[0], op.args[1]) * this.CODE_LENGTH);
                break;
            }
            case 102: {
                this.register[31] = this.pop();
                break;
            }
            case 103: {
                char fp = this.register[30];
                int imm = DataUtil.toChar(new byte[]{op.args[1], op.args[2]}, 0, 2);
                int offset = 0;
                offset = (imm & 0x8000) == 32768 ? imm - 65536 : imm;
                this.register[((OperationCode)op).args[0]] = DataUtil.toChar(this.memory.read(fp + offset, 2), 0, 2);
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            case 104: {
                char fp = this.register[30];
                int imm = DataUtil.toChar(new byte[]{op.args[1], op.args[2]}, 0, 2);
                int offset = 0;
                offset = (imm & 0x8000) == 32768 ? imm - 65536 : imm;
                this.memory.write(fp + offset, 2, DataUtil.toByteArray(this.register[op.args[0]]));
                this.register[31] = (char)(this.register[31] + this.CODE_LENGTH);
                break;
            }
            default: {
                throw new ExecutableElementException("unknow op code " + String.valueOf(op.inst));
            }
        }
        return info;
    }

    private char pop() throws ExecutableElementException {
        if (this.register[29] < this.memory.size() - 1) {
            char data = DataUtil.toChar(this.memory.read(this.register[29], 2), 0, 2);
            this.register[29] = (char)(this.register[29] + 2);
            return data;
        }
        throw new ExecutableElementException("stack under flow");
    }

    private void push(char v) throws ExecutableElementException {
        if (this.register[29] <= '\u0002') {
            throw new ExecutableElementException("stack over flow");
        }
        this.register[29] = (char)(this.register[29] - 2);
        this.memory.write(this.register[29], 2, DataUtil.toByteArray(v));
    }

    private OperationCode readProgram(int addr) {
        byte[] data = this.memory.read(addr + this.programOffset, 4);
        return new OperationCode(data[0], data[1], data[2], data[3]);
    }

    public void writeback(MicsDataPacket data) {
        RandomAccessMemoryDataPacket rd = (RandomAccessMemoryDataPacket)data;
        System.out.println(rd);
        this.register[this.readRequestRegID] = rd.length * rd.width / 8 == 2 ? DataUtil.toChar(rd.data, 0, 2) : DataUtil.toChar(rd.data, 0, 1);
    }

    public int getChannelOffset(Channel c) {
        return this.channelManager.search(c);
    }

    public String getInfo() {
        String s = "";
        s = String.valueOf(s) + "SimpleProcessor\n";
        s = String.valueOf(s) + "  CLASS: " + this.getClass().getName() + "\n";
        s = String.valueOf(s) + "  ID: " + this.id() + "\n";
        s = String.valueOf(s) + "  Local Memory ID: " + this.memory.id() + ",";
        s = String.valueOf(s) + " offset = " + this.programOffset + "\n";
        ChannelManager.Element[] channels = this.channelManager.array();
        int i = 0;
        while (i < channels.length) {
            ChannelManager.Element element = channels[i];
            s = String.valueOf(s) + "  Channel ID: " + element.id + ",";
            s = String.valueOf(s) + " offset = " + element.offset + "\n";
            ++i;
        }
        return s;
    }

    public String toString() {
        try {
            String str = "";
            try {
                str = String.valueOf(str) + PrintFormat.print("%04d", this.register[31]) + ":";
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
            str = String.valueOf(str) + this.readProgram(this.register[31]).toString();
            str = String.valueOf(str) + "\n";
            int i = 0;
            while (i < 32) {
                try {
                    str = String.valueOf(str) + PrintFormat.print("%04x", this.register[i]);
                    str = i % 8 == 7 ? String.valueOf(str) + "\n" : String.valueOf(str) + " ";
                }
                catch (FormatException formatException) {
                    // empty catch block
                }
                ++i;
            }
            return str;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new String(String.valueOf((int)this.register[31]) + ": illegal program counter");
        }
    }

    public static int getInstructionCode(String str) throws UnknownInstructionException {
        if (str.equals("HALT")) {
            return 0;
        }
        if (str.equals("NOP")) {
            return 1;
        }
        if (str.equals("ADD")) {
            return 16;
        }
        if (str.equals("ADDI")) {
            return 20;
        }
        if (str.equals("SUB")) {
            return 17;
        }
        if (str.equals("SUBI")) {
            return 21;
        }
        if (str.equals("MULT")) {
            return 18;
        }
        if (str.equals("DIV")) {
            return 19;
        }
        if (str.equals("MOD")) {
            return 22;
        }
        if (str.equals("LSHS")) {
            return 23;
        }
        if (str.equals("RSHS")) {
            return 24;
        }
        if (str.equals("OR")) {
            return 32;
        }
        if (str.equals("AND")) {
            return 33;
        }
        if (str.equals("JMP")) {
            return 48;
        }
        if (str.equals("JMPI")) {
            return 49;
        }
        if (str.equals("JCC")) {
            return 50;
        }
        if (str.equals("JCCI")) {
            return 51;
        }
        if (str.equals("EQ")) {
            return 64;
        }
        if (str.equals("NEQ")) {
            return 65;
        }
        if (str.equals("LT")) {
            return 66;
        }
        if (str.equals("GT")) {
            return 67;
        }
        if (str.equals("LEQ")) {
            return 68;
        }
        if (str.equals("GEQ")) {
            return 69;
        }
        if (str.equals("MOVI")) {
            return 81;
        }
        if (str.equals("MOV")) {
            return 80;
        }
        if (str.equals("POP")) {
            return 96;
        }
        if (str.equals("PUSH")) {
            return 97;
        }
        if (str.equals("CALL")) {
            return 100;
        }
        if (str.equals("CALLI")) {
            return 101;
        }
        if (str.equals("RET")) {
            return 102;
        }
        if (str.equals("LDA")) {
            return 103;
        }
        if (str.equals("STA")) {
            return 104;
        }
        if (str.equals("LDR")) {
            return -128;
        }
        if (str.equals("STR")) {
            return -127;
        }
        if (str.equals("LDR8")) {
            return -126;
        }
        if (str.equals("STR8")) {
            return -125;
        }
        throw new UnknownInstructionException("unknown instruction " + str);
    }

    public String[] getConnectedElements() {
        return this.channelManager.getConnectedElements();
    }

    public String getImagePath() {
        return "combo_processor.png";
    }

    class OperationCode {
        private byte inst;
        private byte[] args = new byte[3];

        OperationCode(byte inst, byte arg0, byte arg1, byte arg2) {
            this.inst = inst;
            this.args[0] = arg0;
            this.args[1] = arg1;
            this.args[2] = arg2;
        }

        public String toString() {
            String str = "";
            switch (this.inst) {
                case 0: {
                    str = String.valueOf(str) + "HALT ";
                    break;
                }
                case 1: {
                    str = String.valueOf(str) + "NOP  ";
                    break;
                }
                case 16: {
                    str = String.valueOf(str) + "ADD  ";
                    break;
                }
                case 20: {
                    str = String.valueOf(str) + "ADDI ";
                    break;
                }
                case 17: {
                    str = String.valueOf(str) + "SUB  ";
                    break;
                }
                case 21: {
                    str = String.valueOf(str) + "SUBI ";
                    break;
                }
                case 18: {
                    str = String.valueOf(str) + "MULT ";
                    break;
                }
                case 19: {
                    str = String.valueOf(str) + "DIV  ";
                    break;
                }
                case 22: {
                    str = String.valueOf(str) + "MOD  ";
                    break;
                }
                case 23: {
                    str = String.valueOf(str) + "LSHS ";
                    break;
                }
                case 24: {
                    str = String.valueOf(str) + "RSHS ";
                    break;
                }
                case 32: {
                    str = String.valueOf(str) + "OR   ";
                    break;
                }
                case 33: {
                    str = String.valueOf(str) + "AND  ";
                    break;
                }
                case 48: {
                    str = String.valueOf(str) + "JMP  ";
                    break;
                }
                case 49: {
                    str = String.valueOf(str) + "JMPI ";
                    break;
                }
                case 50: {
                    str = String.valueOf(str) + "JCC  ";
                    break;
                }
                case 51: {
                    str = String.valueOf(str) + "JCCI ";
                    break;
                }
                case 64: {
                    str = String.valueOf(str) + "EQ   ";
                    break;
                }
                case 65: {
                    str = String.valueOf(str) + "NEQ  ";
                    break;
                }
                case 66: {
                    str = String.valueOf(str) + "LT   ";
                    break;
                }
                case 67: {
                    str = String.valueOf(str) + "GT   ";
                    break;
                }
                case 68: {
                    str = String.valueOf(str) + "LEQ  ";
                    break;
                }
                case 69: {
                    str = String.valueOf(str) + "GEQ  ";
                    break;
                }
                case -128: {
                    str = String.valueOf(str) + "LDR  ";
                    break;
                }
                case -127: {
                    str = String.valueOf(str) + "STR  ";
                    break;
                }
                case -126: {
                    str = String.valueOf(str) + "LDR8 ";
                    break;
                }
                case -125: {
                    str = String.valueOf(str) + "STR8 ";
                    break;
                }
                case 80: {
                    str = String.valueOf(str) + "MOV  ";
                    break;
                }
                case 81: {
                    str = String.valueOf(str) + "MOVI ";
                    break;
                }
                case 96: {
                    str = String.valueOf(str) + "POP  ";
                    break;
                }
                case 97: {
                    str = String.valueOf(str) + "PUSH ";
                    break;
                }
                case 100: {
                    str = String.valueOf(str) + "CALL ";
                    break;
                }
                case 101: {
                    str = String.valueOf(str) + "CALLI";
                    break;
                }
                case 102: {
                    str = String.valueOf(str) + "RET  ";
                    break;
                }
                case 103: {
                    str = String.valueOf(str) + "LDA  ";
                    break;
                }
                case 104: {
                    str = String.valueOf(str) + "STA  ";
                    break;
                }
                default: {
                    str = String.valueOf(str) + "ERROR";
                }
            }
            str = String.valueOf(str) + ",";
            try {
                str = String.valueOf(str) + PrintFormat.print("%02x", this.args[0]);
                str = String.valueOf(str) + ",";
                str = String.valueOf(str) + PrintFormat.print("%02x", this.args[1]);
                str = String.valueOf(str) + ",";
                str = String.valueOf(str) + PrintFormat.print("%02x", this.args[2]);
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
            return str;
        }
    }
}

