/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.peripheral;

import java.awt.Font;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class CharacterDisplay
extends MicsElement
implements DataBuffer,
ExecutableElement,
MicsViewable,
Runnable {
    private RandomAccessMemory memory;
    private JFrame frame = new JFrame();
    private JTextArea textarea = new JTextArea();
    private int cols;
    Thread t;
    private int refresh_rate = 300;

    public String getImagePath() {
        return "pp_ekisyodisplay1_1.gif";
    }

    public CharacterDisplay() {
        this.textarea.setFont(new Font("MonoSpaced", 0, 12));
        this.textarea.setEditable(false);
        this.frame.setSize(12 * this.cols, 48);
        this.frame.getContentPane().add(new JScrollPane(this.textarea, 20, 30));
        this.frame.setVisible(false);
    }

    private void initialize(int rows, int cols) {
        this.cols = cols;
        this.memory = new RandomAccessMemory(rows * cols);
        this.reset();
        this.textarea.setColumns(cols);
        this.textarea.setRows(rows);
        this.frame.setTitle(this.id());
        this.frame.pack();
        this.t = new Thread(this);
        this.t.start();
    }

    public void initialize(String base, Node n) throws MicsException {
        try {
            Node init_var_node = n;
            int init_var_rows = Integer.parseInt(XMLParser.getAttribute(init_var_node, "rows").getNodeValue());
            int init_var_cols = Integer.parseInt(XMLParser.getAttribute(init_var_node, "cols").getNodeValue());
            this.initialize(init_var_rows, init_var_cols);
            if (XMLParser.isAttribute(init_var_node, "refresh")) {
                this.refresh_rate = DataUtil.parseInt(XMLParser.getAttribute(init_var_node, "refresh").getNodeValue());
            }
        }
        catch (NumberFormatException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.peripheral.CharacterDisplay");
        }
        catch (XMLParserException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.peripheral.CharacterDisplay");
        }
    }

    public MicsDataPacket read(MicsDataPacket data) {
        return this.memory.read(data);
    }

    public int size() {
        return this.memory.size();
    }

    public String toString(int addr, int length) {
        return this.memory.toString(addr, length);
    }

    public void write(MicsDataPacket data) {
        this.memory.write(data);
    }

    public void write(int addr, InputStream reader) throws DataBufferException {
        this.memory.write(addr, reader);
    }

    public void dump(int offset, int len, OutputStream writer) throws DataBufferException {
        this.memory.dump(offset, len, writer);
    }

    public ExecInfo exec_first() throws MicsException {
        return null;
    }

    private void print_memory_data() {
        StringBuffer buf = new StringBuffer();
        byte[] src = this.memory.read(0, this.memory.size());
        int i = 0;
        while (i < src.length) {
            buf.append((char)src[i]);
            if (i % 16 == 15) {
                buf.append("\n");
            }
            ++i;
        }
        this.textarea.setText(buf.toString());
    }

    public ExecInfo exec_second() throws MicsException {
        return null;
    }

    public void reset() {
        byte[] d = new byte[this.memory.size()];
        int i = 0;
        while (i < d.length) {
            d[i] = 32;
            ++i;
        }
        this.memory.write(0, this.memory.size(), d);
    }

    public void show() {
        this.frame.setVisible(true);
        this.print_memory_data();
    }

    public String[] getConnectedElements() {
        return null;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.refresh_rate);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.print_memory_data();
        }
    }
}

