/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.peripheral;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JFrame;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class BitMapDumpDisplay
extends MicsElement
implements DataBuffer,
MicsViewable,
Runnable {
    private RandomAccessMemory ram;
    private BitMapDumpDisplayCanvas canvas;
    private JFrame frame;
    Thread t;
    private int refresh_rate = 500;

    public String[] getConnectedElements() {
        return null;
    }

    public String getImagePath() {
        return "pp_ekisyodisplay1_1.gif";
    }

    public void initialize(int width, int height) {
        this.frame = new JFrame();
        this.frame.setVisible(false);
        this.frame.setTitle(this.id());
        this.ram = new RandomAccessMemory(width * height * 3);
        this.canvas = new BitMapDumpDisplayCanvas(width, height);
        this.frame.getContentPane().add(this.canvas);
        this.frame.pack();
        this.t = new Thread(this);
        this.t.start();
    }

    public void initialize(String base, Node n) throws MicsException {
        try {
            Node init_var_node = n;
            int init_var_width = DataUtil.parseInt(XMLParser.getAttribute(init_var_node, "width").getNodeValue());
            int init_var_height = DataUtil.parseInt(XMLParser.getAttribute(init_var_node, "height").getNodeValue());
            this.initialize(init_var_width, init_var_height);
            if (XMLParser.isAttribute(init_var_node, "refresh")) {
                this.refresh_rate = DataUtil.parseInt(XMLParser.getAttribute(init_var_node, "refresh").getNodeValue());
            }
        }
        catch (NumberFormatException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.peripheral.CharacterDisplay");
        }
        catch (XMLParserException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.peripheral.CharacterDisplay");
        }
    }

    public MicsDataPacket read(MicsDataPacket data) {
        return this.ram.read(data);
    }

    public int size() {
        return this.ram.size();
    }

    public String toString(int addr, int length) {
        return this.ram.toString(addr, length);
    }

    public void write(MicsDataPacket data) {
        this.ram.write(data);
    }

    public void write(int offset, InputStream reader) throws DataBufferException {
        this.ram.write(offset, reader);
    }

    public void dump(int offset, int len, OutputStream writer) throws DataBufferException {
        this.ram.dump(offset, len, writer);
    }

    public void show() {
        this.canvas.repaint();
        this.frame.setVisible(true);
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.refresh_rate);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.canvas.repaint();
        }
    }

    public void reset() {
    }

    class BitMapDumpDisplayCanvas
    extends Canvas {
        Image buf;
        int width;
        int height;

        public BitMapDumpDisplayCanvas(int width, int height) {
            this.width = width;
            this.height = height;
            this.setSize(width, height);
        }

        public void paint(Graphics g) {
            if (this.buf == null) {
                this.buf = this.createImage(this.width, this.height);
            }
            Graphics gbuf = this.buf.getGraphics();
            int i = 0;
            while (i < this.height) {
                int line = (this.height - i - 1) * this.width;
                int j = 0;
                while (j < this.width) {
                    int xpos = (line + j) * 3;
                    int blue = DataUtil.toInteger(BitMapDumpDisplay.this.ram.read(xpos));
                    int green = DataUtil.toInteger(BitMapDumpDisplay.this.ram.read(xpos + 1));
                    int red = DataUtil.toInteger(BitMapDumpDisplay.this.ram.read(xpos + 2));
                    gbuf.setColor(new Color(red, green, blue));
                    gbuf.fillRect(j, i, 1, 1);
                    ++j;
                }
                ++i;
            }
            g.drawImage(this.buf, 0, 0, this);
        }

        public void update(Graphics g) {
            this.paint(g);
        }
    }
}

