/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.gui.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.Mics;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.gui.awt.MemoryLoader;

public class ArchitectureList
implements TreeSelectionListener,
ActionListener {
    private static ArchitectureList instance = new ArchitectureList();
    private JFrame frame = new JFrame("Architecture Viewer");
    private JTree tree;
    private JButton btnLoad;
    private JButton btnView;

    public static ArchitectureList getInstance() {
        return instance;
    }

    private ArchitectureList() {
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ArchitectureList.this.frame.setVisible(false);
            }
        });
        this.frame.setBounds(10, 10, 640, 240);
        this.frame.getContentPane().add((Component)this.getToolBar(), "North");
        JScrollPane scrPane = new JScrollPane();
        this.tree = new JTree(this.makeArchitectureTree());
        this.tree.addTreeSelectionListener(this);
        scrPane.getViewport().setView(this.tree);
        this.frame.getContentPane().add((Component)scrPane, "Center");
    }

    private TreeModel makeArchitectureTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Mics");
        DefaultMutableTreeNode proc = new DefaultMutableTreeNode("ExecutableElement");
        DefaultMutableTreeNode memory = new DefaultMutableTreeNode("DataBuffer");
        DefaultMutableTreeNode bus = new DefaultMutableTreeNode("Channel");
        DefaultMutableTreeNode cc = new DefaultMutableTreeNode("ChannelConnectable");
        MicsElement[] elements = Mics.getInstance().getMicsElementArray();
        int i = 0;
        while (i < elements.length) {
            DefaultMutableTreeNode node;
            MicsElement element = elements[i];
            String name = element.getClass().getName();
            if (element instanceof DataBuffer) {
                node = new DefaultMutableTreeNode(String.valueOf(element.id()) + ":" + name);
                memory.add(node);
            }
            if (element instanceof Channel) {
                node = new DefaultMutableTreeNode(String.valueOf(element.id()) + ":" + name);
                bus.add(node);
            }
            if (element instanceof ExecutableElement) {
                node = new DefaultMutableTreeNode(String.valueOf(element.id()) + ":" + name);
                proc.add(node);
            }
            if (element instanceof ChannelConnectable) {
                node = new DefaultMutableTreeNode(String.valueOf(element.id()) + ":" + name);
                cc.add(node);
            }
            ++i;
        }
        root.add(proc);
        root.add(memory);
        root.add(bus);
        root.add(cc);
        return new DefaultTreeModel(root);
    }

    private MicsElement getSelectedElement() {
        TreePath path = this.tree.getSelectionPath();
        MicsElement element = null;
        if (path == null) {
            return null;
        }
        if (path.getPath().length < 3) {
            return null;
        }
        String value = path.getLastPathComponent().toString();
        String[] label = value.split(":");
        if (label.length < 2) {
            return null;
        }
        try {
            element = Mics.getInstance().engine().getMicsElement(label[0]);
        }
        catch (MicsException e) {
            return null;
        }
        return element;
    }

    public void valueChanged(TreeSelectionEvent ev) {
        MicsElement element = this.getSelectedElement();
        if (element != null) {
            System.out.println(element.getInfo());
            if (element instanceof DataBuffer) {
                this.btnLoad.setEnabled(true);
            } else {
                this.btnLoad.setEnabled(false);
            }
            if (element instanceof MicsViewable) {
                this.btnView.setEnabled(true);
            } else {
                this.btnView.setEnabled(false);
            }
        } else {
            this.btnView.setEnabled(false);
            this.btnLoad.setEnabled(false);
        }
    }

    private JToolBar getToolBar() {
        JToolBar bar = new JToolBar();
        this.btnLoad = new JButton("Load");
        this.btnLoad.addActionListener(this);
        bar.add(this.btnLoad);
        this.btnView = new JButton("View");
        this.btnView.addActionListener(this);
        bar.add(this.btnView);
        return bar;
    }

    public void update() {
        this.tree.setModel(this.makeArchitectureTree());
    }

    public void show() {
        this.update();
        this.frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src != null) {
            MicsElement element;
            if (src == this.btnView) {
                MicsElement element2 = this.getSelectedElement();
                if (element2 != null && element2 instanceof MicsViewable) {
                    ((MicsViewable)((Object)element2)).show();
                }
            } else if (src == this.btnLoad && (element = this.getSelectedElement()) != null && element instanceof DataBuffer) {
                MemoryLoader.getInstance().show((DataBuffer)((Object)element));
            }
        }
    }
}

