/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.gui.awt;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import net.wasamon.mics.Mics;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsPrompt;
import net.wasamon.mics.MicsShell;
import net.wasamon.mics.gui.MicsArchitectureViewer;
import net.wasamon.mics.gui.awt.AWTArchitectureViewer;
import net.wasamon.mics.processor.rlu.ConfigDataAssembler;
import net.wasamon.mics.tools.AsciiToBinary;
import net.wasamon.mjlib.ui.AWTOptionPane;
import net.wasamon.mjlib.ui.TextAreaOutputStream;
import net.wasamon.wallet.WalletGUI;
import net.wasamon.wallet.binutils.AssemblerException;

public class MicsAWTWindow
implements MicsShell,
ActionListener {
    private static MicsAWTWindow instance = new MicsAWTWindow();
    private Frame frame = new Frame("Mics " + Mics.printVersion());
    private TextArea log;
    private TextField input;
    private Button btnStep;
    private Button btnRun;
    private Button btnStop;
    private Button btnReset;
    private Button btnLoad;
    private TextField stepNumber;
    private MenuItem openMenuItem;
    private MenuItem viewMenuItem;
    private MenuItem exitMenuItem;
    private MenuItem walletMenuItem;
    private MenuItem configMenuItem;
    private MenuItem a2bMenuItem;

    public static MicsAWTWindow getInstance() {
        return instance;
    }

    private void exit(int stat) {
        Mics.getInstance().shutdown(stat);
    }

    private MicsAWTWindow() {
        this.frame.setSize(640, 540);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MicsAWTWindow.this.exit(0);
            }
        });
        this.frame.setMenuBar(this.getMenuBar());
        this.frame.add((Component)this.getToolBar(), "North");
        this.log = new TextArea();
        this.log.setFont(new Font("MonoSpaced", 0, 12));
        this.log.setEditable(false);
        this.log.setBackground(Color.WHITE);
        this.frame.add((Component)this.log, "Center");
        PrintStream stream = new PrintStream(new TextAreaOutputStream(this.log), true);
        System.setOut(stream);
        System.setErr(stream);
        TextField prompt = new TextField("[command]");
        prompt.setEditable(false);
        this.input = new TextField();
        this.input.addActionListener(this);
        Panel p0 = new Panel(new BorderLayout());
        p0.add((Component)prompt, "West");
        p0.add(this.input);
        this.frame.add((Component)p0, "South");
        this.frame.setVisible(false);
    }

    private Panel getToolBar() {
        Panel bar = new Panel();
        Panel p = new Panel();
        p.setLayout(new GridLayout(1, 5));
        this.btnReset = new Button("Reset");
        this.btnReset.addActionListener(this);
        this.btnStep = new Button("Step");
        this.btnStep.addActionListener(this);
        this.stepNumber = new TextField("1", 3);
        this.stepNumber.addActionListener(this);
        this.btnRun = new Button("Run");
        this.btnRun.addActionListener(this);
        this.btnStop = new Button("Stop");
        this.btnStop.addActionListener(this);
        p.add(this.btnReset);
        p.add(this.btnRun);
        p.add(this.btnStop);
        p.add(this.btnStep);
        p.add(this.stepNumber);
        this.setMicsEngineEnableState(true);
        bar.add(p);
        return bar;
    }

    public void setLogField(TextArea a) {
        this.log = a;
    }

    private MenuBar getMenuBar() {
        MenuBar bar = new MenuBar();
        Menu m = new Menu("File");
        this.exitMenuItem = new MenuItem("Exit", new MenuShortcut(88));
        this.exitMenuItem.addActionListener(this);
        m.add(this.exitMenuItem);
        bar.add(m);
        m = new Menu("Architecture");
        this.openMenuItem = new MenuItem("Load");
        this.openMenuItem.addActionListener(this);
        m.add(this.openMenuItem);
        this.viewMenuItem = new MenuItem("View");
        this.viewMenuItem.addActionListener(this);
        m.add(this.viewMenuItem);
        bar.add(m);
        m = new Menu("Compile");
        this.walletMenuItem = new MenuItem("Wallet/COINS");
        this.walletMenuItem.addActionListener(this);
        m.add(this.walletMenuItem);
        this.configMenuItem = new MenuItem("Context");
        this.configMenuItem.addActionListener(this);
        m.add(this.configMenuItem);
        this.a2bMenuItem = new MenuItem("Ascii to Binary");
        this.a2bMenuItem.addActionListener(this);
        m.add(this.a2bMenuItem);
        bar.add(m);
        return bar;
    }

    public void exec() {
        this.frame.setVisible(true);
    }

    public void exec(File batch) {
        this.exec();
    }

    public void setMicsEngineEnableState(boolean flag) {
        if (flag) {
            this.btnStep.setEnabled(true);
            this.btnReset.setEnabled(true);
            this.btnRun.setEnabled(true);
            this.btnStop.setEnabled(false);
        } else {
            this.btnStep.setEnabled(false);
            this.btnReset.setEnabled(false);
            this.btnRun.setEnabled(false);
            this.btnStop.setEnabled(true);
        }
    }

    public File openFile(String title, FilenameFilter filter) {
        File f = null;
        FileDialog fd = new FileDialog(this.frame, title, 0);
        fd.setFilenameFilter(filter);
        fd.setVisible(true);
        if (fd.getFile() != null) {
            f = new File(fd.getDirectory(), fd.getFile());
        }
        return f;
    }

    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        if (obj == this.input) {
            try {
                MicsPrompt.execLine(((TextField)obj).getText());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ((TextField)obj).setText("");
        } else if (obj == this.openMenuItem || obj == this.btnLoad) {
            File f = this.openFile("Open Config File", new MicsConfigFileFilter());
            if (f != null) {
                try {
                    Mics.getInstance().configTargetArchitecture(f);
                }
                catch (Exception e) {
                    AWTOptionPane.showErrorDialog(this.frame, "configuration error", e + ":" + e.getMessage());
                    e.printStackTrace();
                }
                Mics.getInstance().engine().show();
            }
        } else if (obj == this.exitMenuItem) {
            this.exit(0);
        } else if (obj == this.walletMenuItem) {
            WalletGUI.getInstance().openGUI();
        } else if (obj == this.configMenuItem) {
            File f = this.openFile("Open Context Source", new ConfigDataSourceFilter());
            if (f != null) {
                try {
                    ConfigDataAssembler asm = new ConfigDataAssembler();
                    File dest = asm.parser(f);
                    System.out.println("compile succeeded: " + dest.getAbsolutePath());
                }
                catch (AssemblerException e) {
                    System.out.println(e.getMessage());
                }
                catch (FileNotFoundException e) {
                    System.out.println("no such file: " + f.getAbsolutePath());
                }
                catch (IOException e) {
                    System.out.println("File I/O error");
                }
            }
        } else if (obj == this.a2bMenuItem) {
            File f = this.openFile("Open", null);
            if (f != null) {
                try {
                    AsciiToBinary asm = new AsciiToBinary();
                    File dest = asm.parser(f);
                    System.out.println("compile succeeded: " + dest.getAbsolutePath());
                }
                catch (NumberFormatException e) {
                    System.out.println(e.getMessage());
                }
                catch (FileNotFoundException e) {
                    System.out.println("no such file: " + f.getAbsolutePath());
                }
                catch (IOException e) {
                    System.out.println("File I/O error");
                }
            }
        } else if (obj == this.btnRun) {
            this.setMicsEngineEnableState(false);
            Mics.getInstance().execEngine();
        } else if (obj == this.btnStop) {
            Mics.getInstance().stopEngine();
            this.setMicsEngineEnableState(true);
        } else if (obj == this.btnStep) {
            try {
                int count = 1;
                try {
                    count = Integer.parseInt(this.stepNumber.getText());
                }
                catch (NumberFormatException e) {
                    count = 1;
                    this.stepNumber.setText("1");
                }
                if (count < 1) {
                    count = 1;
                    this.stepNumber.setText("1");
                }
                Mics.getInstance().execStepByStep(count);
            }
            catch (MicsException e) {
                System.out.println(e);
            }
        } else if (obj == this.btnReset) {
            try {
                Mics.getInstance().reset();
            }
            catch (MicsException e) {
                System.out.println(e);
            }
        } else if (obj == this.viewMenuItem) {
            if (Mics.getInstance().engine() != null) {
                Mics.getInstance().engine().show();
            }
        } else {
            System.out.println("Uninitialized as architecture config.");
        }
    }

    public MicsArchitectureViewer getMicsArchitectureViewerData(MicsCompositeElement composite) {
        return new AWTArchitectureViewer(composite);
    }

    class CoinsInputFilter
    implements FilenameFilter {
        CoinsInputFilter() {
        }

        public boolean accept(File dir, String name) {
            if (name.endsWith(".c")) {
                return true;
            }
            if (name.endsWith(".i")) {
                return true;
            }
            return name.endsWith(".lir");
        }
    }

    class ConfigDataSourceFilter
    implements FilenameFilter {
        ConfigDataSourceFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".context");
        }
    }

    class MicsConfigFileFilter
    implements FilenameFilter {
        MicsConfigFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    }

    class SimpleProcessorAssemblerFilter
    implements FilenameFilter {
        SimpleProcessorAssemblerFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".s");
        }
    }
}

