/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.bus;

import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class SingleDataBus
extends MicsElement
implements Channel,
ExecutableElement {
    private String dest;
    private ChannelConnectable src;
    private MicsDataPacket reqData;
    private int mode;
    private int number;
    private static final int NONE = 0;
    private static final int READ = 1;
    private static final int WRITE = 2;
    private DataBuffer destDataBufferInstance;

    public String getImagePath() {
        return "combo_bus3.png";
    }

    public void initialize(String base, Node n) throws MicsException {
        try {
            String init_var_ram;
            Node init_var_node = n;
            this.dest = init_var_ram = XMLParser.getAttribute(init_var_node, "ram").getNodeValue();
        }
        catch (NumberFormatException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.bus.SingleDataBus16");
        }
        catch (XMLParserException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.bus.SingleDataBus16");
        }
    }

    public void reset() {
        this.number = 0;
        this.mode = 0;
    }

    public void readRequest(ChannelConnectable src, MicsDataPacket data) {
        this.src = src;
        this.reqData = data;
        this.mode = 1;
        ++this.number;
    }

    public void writeRequest(ChannelConnectable src, MicsDataPacket data) {
        this.src = src;
        this.reqData = data;
        this.mode = 2;
        ++this.number;
    }

    public ExecInfo exec_first() throws MicsException {
        return null;
    }

    private DataBuffer destDataBuffer() throws MicsException {
        if (this.destDataBufferInstance == null) {
            this.destDataBufferInstance = this.composite.getDataBuffer(this.dest);
        }
        return this.destDataBufferInstance;
    }

    public ExecInfo exec_second() throws MicsException {
        if (this.number > 1) {
            System.out.println("bus conflict: transfer " + this.dest + "<->" + this.src.id());
        }
        switch (this.mode) {
            case 2: {
                this.destDataBuffer().write(this.reqData);
                break;
            }
            case 1: {
                this.src.writeback(this.destDataBuffer().read(this.reqData));
                break;
            }
            case 0: {
                break;
            }
        }
        this.number = 0;
        this.src = null;
        this.mode = 0;
        return new ExecInfo();
    }

    public String getInfo() {
        String s = "";
        s = String.valueOf(s) + "SingleDataBus16\n";
        s = String.valueOf(s) + "  CLASS: " + this.getClass().getName() + "\n";
        s = String.valueOf(s) + "  Dest Memory ID: " + this.dest;
        return s;
    }

    public String[] getConnectedElements() {
        return new String[]{this.dest};
    }
}

