/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import net.wasamon.mics.Mics;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsShell;
import net.wasamon.mics.gui.MicsArchitectureViewer;

public class MicsPrompt
implements MicsShell {
    private static String[] parseInput(String line) throws IOException {
        String[] cmd = null;
        StringTokenizer st = new StringTokenizer(line, " ");
        cmd = new String[st.countTokens()];
        int i = 0;
        while (i < cmd.length) {
            cmd[i] = st.nextToken();
            ++i;
        }
        return cmd;
    }

    public void exec(File f) throws MicsException {
        try {
            InputStreamReader fis = new InputStreamReader(new FileInputStream(f));
            this.exec(new BufferedReader(fis), "");
            fis.close();
            Mics.getInstance().shutdown(0);
        }
        catch (IOException e) {
            throw new MicsException(e);
        }
    }

    public void exec() throws MicsException {
        try {
            this.exec(new BufferedReader(new InputStreamReader(System.in)), "MICS> ");
            System.out.println();
            Mics.getInstance().shutdown(0);
        }
        catch (IOException e) {
            throw new MicsException(e);
        }
    }

    private void exec(BufferedReader buf, String prompt) throws IOException {
        String line = "";
        System.out.print(prompt);
        while ((line = buf.readLine()) != null) {
            if (!MicsPrompt.execLine(line)) break;
            System.out.print(prompt);
        }
        buf.close();
    }

    public static boolean execLine(String line) throws IOException {
        String[] cmd = MicsPrompt.parseInput(line);
        boolean flag = true;
        try {
            if (cmd.length != 0 && cmd != null) {
                if (cmd[0].equals("version")) {
                    System.out.println(Mics.printVersion());
                } else if (cmd[0].equals("quit")) {
                    flag = false;
                } else if (cmd[0].equals("load")) {
                    Mics.getInstance().loadFile(cmd);
                } else if (cmd[0].equals("l")) {
                    Mics.getInstance().loadFile(cmd);
                } else if (cmd[0].equals("echo")) {
                    int i = 1;
                    while (i < cmd.length) {
                        System.out.print(String.valueOf(cmd[i]) + " ");
                        ++i;
                    }
                    System.out.println();
                } else if (cmd[0].equals("run")) {
                    System.out.println("run");
                    Mics.getInstance().execEngine();
                } else if (cmd[0].equals("xrun")) {
                    Mics.getInstance().execEngineBlock();
                } else if (cmd[0].equals("step") || cmd[0].equals("s")) {
                    if (cmd.length == 2) {
                        Mics.getInstance().execStepByStep(Integer.parseInt(cmd[1]));
                    } else {
                        Mics.getInstance().execStepByStep();
                    }
                } else if (cmd[0].equals("reset")) {
                    Mics.getInstance().reset();
                } else if (cmd[0].equals("config")) {
                    if (cmd.length > 1) {
                        Mics.getInstance().configTargetArchitecture(new File(cmd[1]));
                    } else {
                        MicsPrompt.println("no input file");
                    }
                } else if (cmd[0].equals("mem")) {
                    Mics.getInstance().readMemory(cmd);
                } else if (cmd[0].equals("m")) {
                    Mics.getInstance().readMemory(cmd);
                } else if (cmd[0].equals("list")) {
                    MicsElement[] elems = Mics.getInstance().getMicsElementArray();
                    int i = 0;
                    while (i < elems.length) {
                        MicsPrompt.println(elems[i].getInfo());
                        ++i;
                    }
                } else if (cmd[0].equals("help")) {
                    MicsPrompt.println("version     print version");
                    MicsPrompt.println("quit        quit this program");
                    MicsPrompt.println("list        print all architecture elements");
                    MicsPrompt.println("load        load data to memory");
                    MicsPrompt.println("l           load data to memory");
                    MicsPrompt.println("run         run your program");
                    MicsPrompt.println("xrun        run your program and block user controll");
                    MicsPrompt.println("step        run your program step by step");
                    MicsPrompt.println("s           run your program step by step");
                    MicsPrompt.println("reset       reset program counter");
                    MicsPrompt.println("config      config architecture");
                    MicsPrompt.println("mem         print memory data");
                    MicsPrompt.println("m           print memory data");
                    MicsPrompt.println("echo        print argument and new line");
                } else {
                    MicsPrompt.println("unknwon command: " + cmd[0]);
                }
            }
        }
        catch (MicsException e) {
            System.out.println(e.getMessage());
        }
        catch (NumberFormatException e) {
            System.out.println("argument syntax error.");
        }
        return flag;
    }

    public static void println(String mesg) {
        System.out.println(mesg);
    }

    public void setMicsEngineEnableState(boolean flag) {
    }

    public MicsArchitectureViewer getMicsArchitectureViewerData(MicsCompositeElement composite) {
        return null;
    }
}

