/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics;

import net.wasamon.mics.IMicsElement;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public abstract class MicsElement
implements IMicsElement {
    private String _id;
    protected MicsCompositeElement composite;
    private Appearance appearance;

    public Appearance getAppearance() {
        return this.appearance;
    }

    public void initialize_base(MicsCompositeElement composite, String base, String id, Node node) throws MicsException {
        this._id = id;
        this.composite = composite;
        this.appearance = new Appearance(base, this.getNamedNode(node, "appearance"));
        this.initialize(base, node);
    }

    public abstract void initialize(String var1, Node var2) throws MicsException;

    public String getInfo() {
        String str = "";
        str = String.valueOf(str) + "id: " + this.id() + "\n";
        str = String.valueOf(str) + "class: " + this.getClass().getName() + "\n";
        str = String.valueOf(str) + "Override MicsElement.getInfo() to print information\n";
        return str;
    }

    public String id() {
        return this._id;
    }

    public void shutdown() {
    }

    public abstract String[] getConnectedElements();

    public abstract String getImagePath();

    protected Node[] getNamedNodeArray(Node node, String name) {
        return XMLParser.getNamedNodeArray(node, name);
    }

    protected Node getNamedNode(Node node, String name) {
        try {
            return XMLParser.getNamedNode(node, name);
        }
        catch (XMLParserException e) {
            return null;
        }
    }

    protected String getAttributeAsString(Node node, String key) {
        if (node == null) {
            return null;
        }
        try {
            return XMLParser.getAttribute(node, key).getNodeValue();
        }
        catch (XMLParserException e) {
            return null;
        }
    }

    protected Integer getAttributeAsInt(Node node, String key) {
        if (node == null) {
            return null;
        }
        try {
            return new Integer(DataUtil.parseInt(XMLParser.getAttribute(node, key).getNodeValue()));
        }
        catch (XMLParserException e) {
            return null;
        }
    }

    public class Appearance {
        public final Integer x;
        public final Integer y;
        public final Integer width;
        public final Integer height;
        public final String image;

        Appearance(String b, Node node) {
            String str = MicsElement.this.getAttributeAsString(node, "image");
            this.image = str != null ? String.valueOf(b) + "/" + str : MicsElement.this.getImagePath();
            this.x = MicsElement.this.getAttributeAsInt(node, "x");
            this.y = MicsElement.this.getAttributeAsInt(node, "y");
            this.width = MicsElement.this.getAttributeAsInt(node, "width");
            this.height = MicsElement.this.getAttributeAsInt(node, "height");
        }
    }
}

