/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.wallet.binutils.simpleprocessor;

import java.util.Hashtable;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.wallet.binutils.InstructionTable;
import net.wasamon.wallet.binutils.UnknownInstructionException;

public class SimpleProcessor32InstructionTable
implements InstructionTable {
    private static String[] defautlBootStrap = new String[]{".section \".text\"", "nop", "nop", "nop", "nop", "nop", "nop", "nop", "nop", "movi\tr29," + DataUtil.parseInt("0x7000"), "mov\tr30,r29", "calli\t_main", "halt"};
    private static SimpleProcessor32InstructionTable instance = new SimpleProcessor32InstructionTable();
    private Hashtable instTable;

    public static SimpleProcessor32InstructionTable getInstance() {
        return instance;
    }

    private SimpleProcessor32InstructionTable() {
        this.initInstTable();
    }

    private void instTablePut(String label, int code) {
        this.instTable.put(label, new Integer(code));
    }

    private void initInstTable() {
        this.instTable = new Hashtable();
        this.instTablePut("HALT", 0);
        this.instTablePut("NOP", 1);
        this.instTablePut("ADD", 16);
        this.instTablePut("SUB", 17);
        this.instTablePut("MULT", 18);
        this.instTablePut("DIV", 19);
        this.instTablePut("ADDI", 20);
        this.instTablePut("SUBI", 21);
        this.instTablePut("MOD", 22);
        this.instTablePut("LSHS", 23);
        this.instTablePut("RSHS", 24);
        this.instTablePut("NEG", 25);
        this.instTablePut("OR", 32);
        this.instTablePut("AND", 33);
        this.instTablePut("JMP", 48);
        this.instTablePut("JMPI", 49);
        this.instTablePut("JCC", 50);
        this.instTablePut("JCCI", 51);
        this.instTablePut("EQ", 64);
        this.instTablePut("NEQ", 65);
        this.instTablePut("LT", 66);
        this.instTablePut("GT", 67);
        this.instTablePut("LEQ", 68);
        this.instTablePut("GEQ", 69);
        this.instTablePut("MOV", 80);
        this.instTablePut("MOVI", 81);
        this.instTablePut("MOVIL", 82);
        this.instTablePut("MOVIH", 83);
        this.instTablePut("POP", 96);
        this.instTablePut("PUSH", 97);
        this.instTablePut("CALL", 100);
        this.instTablePut("CALLI", 101);
        this.instTablePut("RET", 102);
        this.instTablePut("LDA", 103);
        this.instTablePut("STA", 104);
        this.instTablePut("LDR", 128);
        this.instTablePut("STR", 129);
        this.instTablePut("LDR8", 130);
        this.instTablePut("STR8", 131);
        this.instTablePut("LDR32", 132);
        this.instTablePut("STR32", 133);
        this.instTablePut("LDRF", 134);
        this.instTablePut("SIN", 144);
        this.instTablePut("COS", 145);
        this.instTablePut("SINF", 146);
        this.instTablePut("COSF", 147);
        this.instTablePut("SQRT", 148);
        this.instTablePut("SQRTF", 149);
    }

    public int toInstructionCode(String str) throws UnknownInstructionException {
        if (this.instTable.containsKey(str)) {
            return (Integer)this.instTable.get(str);
        }
        throw new UnknownInstructionException("unknown instruction " + str);
    }

    public String[] getDefaultBootStrap() {
        return defautlBootStrap;
    }
}

