/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.wallet.binutils;

import java.io.IOException;
import java.io.PrintWriter;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import net.wasamon.mjlib.xml.XMLUtil;
import org.w3c.dom.Node;

public class ProgramCode {
    public String inst = null;
    public String[] args = new String[3];

    public ProgramCode(String inst, String[] args) {
        this.inst = inst.toUpperCase();
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                this.args[i] = args[i];
                ++i;
            }
        }
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + "[ProgramCode insta=" + this.inst + ", args=" + this.args[0] + "," + this.args[1] + "," + this.args[2] + "]";
        return s;
    }

    public void outputAsXML(PrintWriter writer) throws IOException {
        String c = "";
        int i = 0;
        while (i < this.args.length) {
            c = String.valueOf(c) + XMLUtil.toElementString("args", new String[]{"value", this.args[i]});
            c = String.valueOf(c) + "\n";
            ++i;
        }
        writer.println(XMLUtil.toElementString("code", new String[]{"inst", this.inst}, c));
    }

    public static ProgramCode inputFromXML(Node node) throws XMLParserException {
        String inst = XMLParser.getAttribute(node, "inst").getNodeValue();
        Node[] argNodes = XMLParser.getNamedNodeArray(node, "args");
        String[] args = new String[argNodes.length];
        int i = 0;
        while (i < args.length) {
            String v = XMLParser.getAttribute(argNodes[i], "value").getNodeValue();
            args[i] = "null".equals(v) ? null : v;
            ++i;
        }
        return new ProgramCode(inst, args);
    }
}

