/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.wallet.binutils;

import java.io.IOException;
import java.io.PrintWriter;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import net.wasamon.wallet.binutils.AssemblerException;
import net.wasamon.wallet.binutils.DataRegion;
import net.wasamon.wallet.binutils.Section;
import net.wasamon.wallet.binutils.TextRegion;
import org.w3c.dom.Node;

public class ObjectData {
    public TextRegion text = new TextRegion();
    public DataRegion data = new DataRegion();

    public ObjectData(TextRegion text, DataRegion data) {
        this.text = text;
        this.data = data;
    }

    public Section getSection(String key) throws AssemblerException {
        if (key.equals(".text")) {
            return this.text;
        }
        if (key.equals(".data")) {
            return this.data;
        }
        throw new AssemblerException("unknown section: " + key);
    }

    public int setTextRegionOffset(int offset) {
        this.text.setOffset(offset);
        return offset + this.text.size();
    }

    public int setDataRegionOffset(int offset) {
        this.data.setOffset(offset);
        return offset + this.data.size();
    }

    public static ObjectData readFromXML(Node node) throws XMLParserException {
        TextRegion text = new TextRegion();
        DataRegion data = new DataRegion();
        Node[] sections = XMLParser.getNamedNodeArray(node, "section");
        int i = 0;
        while (i < sections.length) {
            String type = XMLParser.getAttribute(sections[i], "type").getNodeValue();
            if (type.equals(".text")) {
                text.inputFromXML(sections[i]);
            } else if (type.equals(".data")) {
                data.inputFromXML(sections[i]);
            }
            ++i;
        }
        return new ObjectData(text, data);
    }

    public void writeAsXML(PrintWriter writer) throws IOException {
        writer.println("<section type=\".text\">");
        this.text.outputAsXML(writer);
        writer.println("</section>");
        writer.println("<section type=\".data\">");
        this.data.outputAsXML(writer);
        writer.println("</section>");
    }

    public int getLabelValue(String key) {
        int v = -1;
        v = this.text.getLabelValue(key);
        if (v < 0) {
            v = this.data.getLabelValue(key);
        }
        return v;
    }
}

