/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.wallet.binutils;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import net.wasamon.mjlib.xml.XMLUtil;
import org.w3c.dom.Node;

public class DataElement {
    public int offset;
    public int length;
    public int type;
    public ByteArrayOutputStream data = new ByteArrayOutputStream();
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_INT = 0;
    public static final int TYPE_FLOAT = 1;
    public static final int TYPE_ARRAY = 2;

    public DataElement(int offset) {
        this.offset = offset;
        this.length = 4;
        this.type = -1;
    }

    public static DataElement inputFromXML(Node node) throws XMLParserException {
        int offset = DataUtil.parseInt(XMLParser.getAttribute(node, "offset").getNodeValue());
        DataElement data = new DataElement(offset);
        String t = XMLParser.getAttribute(node, "type").getNodeValue();
        if (t.equals("int")) {
            data.type = 0;
        } else if (t.equals("float")) {
            data.type = 1;
        } else if (t.equals("array")) {
            data.type = 2;
        }
        String[] s = XMLParser.getNodeText(node).split("\\s*,\\s*");
        int i = 0;
        while (i < s.length) {
            data.data.write(Byte.parseByte(s[i]));
            ++i;
        }
        return data;
    }

    public void outputAsXML(PrintWriter writer, String label) {
        String s = "";
        byte[] d = this.data.toByteArray();
        int i = 0;
        while (i < d.length) {
            s = String.valueOf(s) + "," + d[i];
            ++i;
        }
        String t = "unknown";
        switch (this.type) {
            case 0: {
                t = "int";
                break;
            }
            case 1: {
                t = "float";
                break;
            }
            case 2: {
                t = "array";
            }
        }
        writer.println(XMLUtil.toElementString("data", new String[]{"label", label, "type", t, "offset", String.valueOf(this.offset)}, s.substring(1)));
    }
}

