/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.wallet.binutils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import net.wasamon.wallet.binutils.AssemblerException;
import net.wasamon.wallet.binutils.DataRegion;
import net.wasamon.wallet.binutils.ObjectData;
import net.wasamon.wallet.binutils.Parser;
import net.wasamon.wallet.binutils.Section;
import net.wasamon.wallet.binutils.TextRegion;

public class AssemblerDriver {
    private Parser parser;
    public ObjectData data;
    private Section currentSection;

    public AssemblerDriver(Parser parser) {
        this.parser = parser;
        this.data = new ObjectData(new TextRegion(), new DataRegion());
    }

    public int doParse(Reader r) throws IOException, AssemblerException {
        int status = 0;
        int count = 0;
        String line = "";
        BufferedReader reader = new BufferedReader(r);
        while ((line = reader.readLine()) != null) {
            ++count;
            try {
                this.parseLine(line);
            }
            catch (AssemblerException e) {
                throw new AssemblerException(String.valueOf(e.getMessage()) + " at " + line);
            }
        }
        return status;
    }

    public int doParse(String[] str) throws IOException, AssemblerException {
        int status = 0;
        int count = 0;
        int i = 0;
        while (i < str.length) {
            ++count;
            try {
                this.parseLine(str[i]);
            }
            catch (AssemblerException e) {
                throw new AssemblerException(String.valueOf(e.getMessage()) + " at " + str[i]);
            }
            ++i;
        }
        return status;
    }

    private void parseLine(String str) throws AssemblerException {
        if (!(str = str.trim()).equals("") && !this.parser.isComment(str)) {
            if (this.parser.isSection(str)) {
                this.currentSection = this.data.getSection(this.parser.getSectionName(str));
            } else if (this.parser.isLabel(str)) {
                this.currentSection.addLabel(this.parser.getLabelStr(str));
            } else if (this.parser.isAssemblerCommand(str)) {
                if (this.currentSection != null) {
                    this.currentSection.execCommand(this.parser, str);
                }
            } else {
                this.currentSection.addData(this.parser, str);
            }
        }
    }

    private void outputData(OutputStream out) throws IOException {
        PrintWriter writer = new PrintWriter(out);
        writer.println("<assembler>");
        this.data.writeAsXML(writer);
        writer.println("</assembler>");
        writer.flush();
    }

    public void go(InputStream in, OutputStream out) throws AssemblerException, IOException {
        this.doParse(new InputStreamReader(in));
        this.outputData(out);
        out.flush();
        out.close();
    }
}

