/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.wallet;

import java.util.ArrayList;

public class WalletOptionSpec {
    private int outputType = 6;
    public static final int outputTypeAsm = 1;
    public static final int outputTypeLIR = 2;
    public static final int outputTypeHIR = 3;
    public static final int outputTypeSnapShot = 4;
    public static final int outputTypeBin = 6;
    private String[] filename;
    private String outFileName;
    private String processor;
    private boolean checkNoAlign;

    public String[] getFileName() {
        return this.filename;
    }

    public void setFileName(String[] filename) {
        this.filename = filename;
    }

    public String getProcessor() {
        return this.processor;
    }

    public void setProcessor(String arg) {
        this.processor = arg;
    }

    public void setOutputFileName(String filename, String ext) {
        int idx = filename.lastIndexOf(46);
        this.outFileName = idx > 0 ? String.valueOf(filename.substring(0, idx)) + "." + ext : String.valueOf(filename) + "." + ext;
    }

    public String getOutputFileName() {
        return this.outFileName;
    }

    public void setOutputType(int value) {
        this.outputType = value;
    }

    public int getOutputType() {
        return this.outputType;
    }

    public void setCheckNoAlign(boolean flag) {
        this.checkNoAlign = flag;
    }

    public boolean isCheckNoAlign() {
        return this.checkNoAlign;
    }

    public String[] getCoinsArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.filename == null || this.filename.length == 0) {
            return new String[0];
        }
        args.add("-b");
        args.add(this.processor);
        switch (this.outputType) {
            case 1: {
                args.add("-S");
                break;
            }
            case 2: {
                args.add("-coins:suffixoption=out-newlir");
                args.add("-S");
                break;
            }
            case 4: {
                args.add("-coins:snapshot");
                args.add("-S");
                break;
            }
            case 3: {
                args.add("-coins:dumphir=t1");
                args.add("-S");
                break;
            }
            case 6: {
                args.add("-o");
                args.add(this.getOutputFileName());
            }
        }
        if (this.checkNoAlign) {
            args.add("-coins:no-align");
        }
        int i = 0;
        while (i < this.filename.length) {
            args.add(this.filename[i]);
            ++i;
        }
        return args.toArray(new String[args.size()]);
    }
}

