/*
 * Decompiled with CFR 0.152.
 */
package coins.util;

import coins.util.FloatConst;
import java.math.BigInteger;

public abstract class IntConst
implements Comparable {
    final int size;
    public static final IntConst I8_M1 = L.I8_M1;
    public static final IntConst I8_0 = L.I8_0;
    public static final IntConst I8_1 = L.I8_1;
    public static final IntConst I8_2 = L.I8_2;
    public static final IntConst I16_M1 = L.I16_M1;
    public static final IntConst I16_0 = L.I16_0;
    public static final IntConst I16_1 = L.I16_1;
    public static final IntConst I16_2 = L.I16_2;
    public static final IntConst I32_M1 = L.I32_M1;
    public static final IntConst I32_0 = L.I32_0;
    public static final IntConst I32_1 = L.I32_1;
    public static final IntConst I32_2 = L.I32_2;
    private static final BigInteger BIG_LONG_MASK = IntConst.bigMask(64);

    private IntConst(int size) {
        this.size = size;
    }

    public static IntConst valueOf(int size, long val) {
        if (size <= 0) {
            throw new IllegalArgumentException(String.valueOf(size));
        }
        if (size <= 64) {
            return L.valueOfL(size, val);
        }
        return B.valueOfB(size, BigInteger.valueOf(val).and(BIG_LONG_MASK));
    }

    public static IntConst valueOf(int size, BigInteger val) {
        if (size <= 0) {
            throw new IllegalArgumentException(String.valueOf(size));
        }
        if (size <= 64) {
            return L.valueOfL(size, val.longValue());
        }
        if (val.getClass() != BigInteger.class) {
            val = new BigInteger(val.toByteArray());
        }
        return B.valueOfB(size, val);
    }

    public int size() {
        return this.size;
    }

    public abstract IntConst add(IntConst var1);

    public abstract IntConst sub(IntConst var1);

    public abstract IntConst mul(IntConst var1);

    public abstract IntConst divu(IntConst var1);

    public abstract IntConst divs(IntConst var1);

    public abstract IntConst modu(IntConst var1);

    public abstract IntConst mods(IntConst var1);

    public abstract IntConst band(IntConst var1);

    public abstract IntConst bor(IntConst var1);

    public abstract IntConst bxor(IntConst var1);

    public abstract IntConst lsh(IntConst var1);

    public abstract IntConst rshu(IntConst var1);

    public abstract IntConst rshs(IntConst var1);

    public abstract IntConst lsh(int var1);

    public abstract IntConst rshu(int var1);

    public abstract IntConst rshs(int var1);

    public abstract IntConst neg();

    public abstract IntConst bnot();

    public abstract IntConst tsteq(IntConst var1, int var2);

    public abstract IntConst tstne(IntConst var1, int var2);

    public abstract IntConst tstltu(IntConst var1, int var2);

    public abstract IntConst tstgtu(IntConst var1, int var2);

    public abstract IntConst tstleu(IntConst var1, int var2);

    public abstract IntConst tstgeu(IntConst var1, int var2);

    public abstract IntConst tstlts(IntConst var1, int var2);

    public abstract IntConst tstgts(IntConst var1, int var2);

    public abstract IntConst tstles(IntConst var1, int var2);

    public abstract IntConst tstges(IntConst var1, int var2);

    public abstract IntConst convzx(int var1);

    public abstract IntConst convsx(int var1);

    public abstract IntConst convit(int var1);

    public abstract FloatConst convuf(int var1, int var2);

    public abstract FloatConst convsf(int var1, int var2);

    public abstract IntConst ifthenelse(IntConst var1, IntConst var2);

    public abstract FloatConst ifthenelse(FloatConst var1, FloatConst var2);

    public abstract long longValue();

    public abstract long signedLongValue();

    public abstract BigInteger bigValue();

    public abstract BigInteger signedBigValue();

    public abstract int compareTo(Object var1);

    public abstract int signedCompareTo(Object var1);

    public abstract int signum();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public String toString() {
        return "(IntConst I" + this.size + ' ' + this.toString(10) + ')';
    }

    public abstract String toString(int var1);

    public abstract String toSignedString(int var1);

    abstract int count(int var1);

    private static long longMask(int size) {
        return size == 64 ? -1L : (1L << size) - 1L;
    }

    private static BigInteger bigMask(int size) {
        return BigInteger.ONE.shiftLeft(size).subtract(BigInteger.ONE);
    }

    private static class B
    extends IntConst {
        private BigInteger b;

        private B(int size, BigInteger val) {
            super(size);
            this.b = val;
        }

        static B valueOfB(int size, BigInteger val) {
            return new B(size, val.and(IntConst.bigMask(size)));
        }

        public IntConst add(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOfB(this.size, this.b.add(((B)c).b));
        }

        public IntConst sub(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOfB(this.size, this.b.subtract(((B)c).b));
        }

        public IntConst mul(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOfB(this.size, this.b.multiply(((B)c).b));
        }

        public IntConst divu(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOfB(this.size, this.b.divide(((B)c).b));
        }

        public IntConst divs(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOfB(this.size, this.signedBigValue().divide(c.signedBigValue()));
        }

        public IntConst modu(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOfB(this.size, this.b.remainder(((B)c).b));
        }

        public IntConst mods(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOfB(this.size, this.signedBigValue().remainder(c.signedBigValue()));
        }

        public IntConst band(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOfB(this.size, this.b.and(((B)c).b));
        }

        public IntConst bor(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOfB(this.size, this.b.or(((B)c).b));
        }

        public IntConst bxor(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOfB(this.size, this.b.xor(((B)c).b));
        }

        public IntConst lsh(IntConst c) {
            return this.lsh(c.count(this.size));
        }

        public IntConst rshu(IntConst c) {
            return this.rshu(c.count(this.size));
        }

        public IntConst rshs(IntConst c) {
            return this.rshs(c.count(this.size));
        }

        public IntConst lsh(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            return B.valueOfB(this.size, n < this.size ? this.b.shiftLeft(n) : BigInteger.ZERO);
        }

        public IntConst rshu(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            return B.valueOfB(this.size, this.b.shiftRight(n));
        }

        public IntConst rshs(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            return B.valueOfB(this.size, this.signedBigValue().shiftRight(n));
        }

        public IntConst neg() {
            return B.valueOfB(this.size, this.b.negate());
        }

        public IntConst bnot() {
            return B.valueOfB(this.size, this.b.not());
        }

        public IntConst tsteq(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOf(s, this.b.equals(((B)c).b) ? 1L : 0L);
        }

        public IntConst tstne(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOf(s, !this.b.equals(((B)c).b) ? 1L : 0L);
        }

        public IntConst tstltu(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOf(s, this.b.compareTo(((B)c).b) < 0 ? 1L : 0L);
        }

        public IntConst tstgtu(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOf(s, this.b.compareTo(((B)c).b) > 0 ? 1L : 0L);
        }

        public IntConst tstleu(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOf(s, this.b.compareTo(((B)c).b) <= 0 ? 1L : 0L);
        }

        public IntConst tstgeu(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOf(s, this.b.compareTo(((B)c).b) >= 0 ? 1L : 0L);
        }

        public IntConst tstlts(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOf(s, this.signedBigValue().compareTo(c.signedBigValue()) < 0 ? 1L : 0L);
        }

        public IntConst tstgts(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOf(s, this.signedBigValue().compareTo(c.signedBigValue()) > 0 ? 1L : 0L);
        }

        public IntConst tstles(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOf(s, this.signedBigValue().compareTo(c.signedBigValue()) <= 0 ? 1L : 0L);
        }

        public IntConst tstges(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return B.valueOf(s, this.signedBigValue().compareTo(c.signedBigValue()) >= 0 ? 1L : 0L);
        }

        public IntConst convzx(int s) {
            if (s < this.size) {
                throw new IllegalArgumentException(this + " " + s);
            }
            return B.valueOfB(s, this.b);
        }

        public IntConst convsx(int s) {
            if (s < this.size) {
                throw new IllegalArgumentException(this + " " + s);
            }
            return B.valueOfB(s, this.signedBigValue());
        }

        public IntConst convit(int s) {
            if (s > this.size || s <= 0) {
                throw new IllegalArgumentException(this + " " + s);
            }
            return B.valueOf(s, this.b);
        }

        public FloatConst convuf(int msize, int esize) {
            return FloatConst.valueOf(msize, esize, this.b);
        }

        public FloatConst convsf(int msize, int esize) {
            return FloatConst.valueOf(msize, esize, this.signedBigValue());
        }

        public IntConst ifthenelse(IntConst t, IntConst f) {
            if (t.size != f.size) {
                throw new IllegalArgumentException(this + " " + t + ' ' + f);
            }
            return this.b.signum() != 0 ? t : f;
        }

        public FloatConst ifthenelse(FloatConst t, FloatConst f) {
            if (t.msize() != f.msize() || t.esize() != f.esize()) {
                throw new IllegalArgumentException(this + " " + t + ' ' + f);
            }
            return this.b.signum() != 0 ? t : f;
        }

        public long longValue() {
            return this.b.longValue();
        }

        public long signedLongValue() {
            return this.b.longValue();
        }

        public BigInteger bigValue() {
            return this.b;
        }

        public BigInteger signedBigValue() {
            return this.b.testBit(this.size - 1) ? this.b.subtract(BigInteger.ONE.shiftLeft(this.size)) : this.b;
        }

        public int compareTo(Object o) {
            IntConst c = (IntConst)o;
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return this.b.compareTo(((B)c).b);
        }

        public int signedCompareTo(Object o) {
            IntConst c = (IntConst)o;
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return this.signedBigValue().compareTo(c.signedBigValue());
        }

        public int signum() {
            return this.b.signum() == 0 ? 0 : (this.b.testBit(this.size - 1) ? -1 : 1);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof B && this.size == ((B)o).size && this.b.equals(((B)o).b);
        }

        public int hashCode() {
            return this.size * 37 + this.b.hashCode();
        }

        public String toString(int radix) {
            return this.b.toString(radix);
        }

        public String toSignedString(int radix) {
            return this.signedBigValue().toString(radix);
        }

        int count(int size) {
            return this.b.compareTo(BigInteger.valueOf(size)) < 0 ? (int)this.b.longValue() : size;
        }
    }

    private static class L
    extends IntConst {
        private long l;
        static final L I8_M1 = new L(8, 255L);
        static final L I8_0 = new L(8, 0L);
        static final L I8_1 = new L(8, 1L);
        static final L I8_2 = new L(8, 2L);
        static final L I16_M1 = new L(16, 65535L);
        static final L I16_0 = new L(16, 0L);
        static final L I16_1 = new L(16, 1L);
        static final L I16_2 = new L(16, 2L);
        static final L I32_M1 = new L(32, 0xFFFFFFFFL);
        static final L I32_0 = new L(32, 0L);
        static final L I32_1 = new L(32, 1L);
        static final L I32_2 = new L(32, 2L);
        private static final L[] I8_CONST = new L[]{I8_M1, I8_0, I8_1, I8_2};
        private static final L[] I16_CONST = new L[]{I16_M1, I16_0, I16_1, I16_2};
        private static final L[] I32_CONST = new L[]{I32_M1, I32_0, I32_1, I32_2};
        private static final long MSB = Long.MIN_VALUE;

        private L(int size, long val) {
            super(size);
            this.l = val;
        }

        static L valueOfL(int size, long val) {
            if (val >= -1L && val <= 2L) {
                if (size == 8) {
                    return I8_CONST[(int)(val + 1L)];
                }
                if (size == 16) {
                    return I16_CONST[(int)(val + 1L)];
                }
                if (size == 32) {
                    return I32_CONST[(int)(val + 1L)];
                }
            }
            return new L(size, val & IntConst.longMask(size));
        }

        public IntConst add(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(this.size, this.l + ((L)c).l);
        }

        public IntConst sub(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(this.size, this.l - ((L)c).l);
        }

        public IntConst mul(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(this.size, this.l * ((L)c).l);
        }

        public IntConst divu(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            long x = this.l;
            long y = ((L)c).l;
            if (x >= 0L && y >= 0L) {
                return L.valueOfL(this.size, x / y);
            }
            BigInteger x1 = BigInteger.valueOf(x).and(BIG_LONG_MASK);
            BigInteger y1 = BigInteger.valueOf(y).and(BIG_LONG_MASK);
            return L.valueOfL(this.size, x1.divide(y1).longValue());
        }

        public IntConst divs(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(this.size, this.signedLongValue() / c.signedLongValue());
        }

        public IntConst modu(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            long x = this.l;
            long y = ((L)c).l;
            if (x >= 0L && y >= 0L) {
                return L.valueOfL(this.size, x % y);
            }
            BigInteger x1 = BigInteger.valueOf(x).and(BIG_LONG_MASK);
            BigInteger y1 = BigInteger.valueOf(y).and(BIG_LONG_MASK);
            return L.valueOfL(this.size, x1.remainder(y1).longValue());
        }

        public IntConst mods(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(this.size, this.signedLongValue() % c.signedLongValue());
        }

        public IntConst band(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(this.size, this.l & ((L)c).l);
        }

        public IntConst bor(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(this.size, this.l | ((L)c).l);
        }

        public IntConst bxor(IntConst c) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(this.size, this.l ^ ((L)c).l);
        }

        public IntConst lsh(IntConst c) {
            return this.lsh(c.count(this.size));
        }

        public IntConst rshu(IntConst c) {
            return this.rshu(c.count(this.size));
        }

        public IntConst rshs(IntConst c) {
            return this.rshs(c.count(this.size));
        }

        public IntConst lsh(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            return L.valueOfL(this.size, n < this.size ? this.l << n : 0L);
        }

        public IntConst rshu(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            return L.valueOfL(this.size, n < this.size ? this.l >>> n : 0L);
        }

        public IntConst rshs(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            if (n >= this.size) {
                n = this.size - 1;
            }
            return L.valueOfL(this.size, this.l << 64 - this.size >> 64 - this.size + n);
        }

        public IntConst neg() {
            return L.valueOfL(this.size, -this.l);
        }

        public IntConst bnot() {
            return L.valueOfL(this.size, this.l ^ 0xFFFFFFFFFFFFFFFFL);
        }

        public IntConst tsteq(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(s, this.l == ((L)c).l ? 1L : 0L);
        }

        public IntConst tstne(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(s, this.l != ((L)c).l ? 1L : 0L);
        }

        public IntConst tstltu(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(s, (this.l ^ Long.MIN_VALUE) < (((L)c).l ^ Long.MIN_VALUE) ? 1L : 0L);
        }

        public IntConst tstgtu(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(s, (this.l ^ Long.MIN_VALUE) > (((L)c).l ^ Long.MIN_VALUE) ? 1L : 0L);
        }

        public IntConst tstleu(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(s, (this.l ^ Long.MIN_VALUE) <= (((L)c).l ^ Long.MIN_VALUE) ? 1L : 0L);
        }

        public IntConst tstgeu(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(s, (this.l ^ Long.MIN_VALUE) >= (((L)c).l ^ Long.MIN_VALUE) ? 1L : 0L);
        }

        public IntConst tstlts(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(s, this.signedLongValue() < c.signedLongValue() ? 1L : 0L);
        }

        public IntConst tstgts(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(s, this.signedLongValue() > c.signedLongValue() ? 1L : 0L);
        }

        public IntConst tstles(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(s, this.signedLongValue() <= c.signedLongValue() ? 1L : 0L);
        }

        public IntConst tstges(IntConst c, int s) {
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return L.valueOfL(s, this.signedLongValue() >= c.signedLongValue() ? 1L : 0L);
        }

        public IntConst convzx(int s) {
            if (s < this.size) {
                throw new IllegalArgumentException(this + " " + s);
            }
            return L.valueOf(s, this.l);
        }

        public IntConst convsx(int s) {
            if (s < this.size) {
                throw new IllegalArgumentException(this + " " + s);
            }
            if (s <= 64) {
                return L.valueOfL(s, this.signedLongValue());
            }
            return L.valueOf(s, this.signedBigValue());
        }

        public IntConst convit(int s) {
            if (s > this.size || s <= 0) {
                throw new IllegalArgumentException(this + " " + s);
            }
            return L.valueOfL(s, this.l);
        }

        public FloatConst convuf(int msize, int esize) {
            if (this.l >= 0L) {
                return FloatConst.valueOf(msize, esize, this.l);
            }
            return FloatConst.valueOf(msize, esize, BigInteger.valueOf(this.l).and(BIG_LONG_MASK));
        }

        public FloatConst convsf(int msize, int esize) {
            return FloatConst.valueOf(msize, esize, this.signedLongValue());
        }

        public IntConst ifthenelse(IntConst t, IntConst f) {
            if (t.size != f.size) {
                throw new IllegalArgumentException(this + " " + t + ' ' + f);
            }
            return this.l != 0L ? t : f;
        }

        public FloatConst ifthenelse(FloatConst t, FloatConst f) {
            if (t.msize() != f.msize() || t.esize() != f.esize()) {
                throw new IllegalArgumentException(this + " " + t + ' ' + f);
            }
            return this.l != 0L ? t : f;
        }

        public long longValue() {
            return this.l;
        }

        public long signedLongValue() {
            return this.l << 64 - this.size >> 64 - this.size;
        }

        public BigInteger bigValue() {
            return BigInteger.valueOf(this.l).and(BIG_LONG_MASK);
        }

        public BigInteger signedBigValue() {
            return BigInteger.valueOf(this.signedLongValue());
        }

        public int compareTo(Object o) {
            IntConst c = (IntConst)o;
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return this.l == ((L)c).l ? 0 : ((this.l ^ Long.MIN_VALUE) < (((L)c).l ^ Long.MIN_VALUE) ? -1 : 1);
        }

        public int signedCompareTo(Object o) {
            IntConst c = (IntConst)o;
            if (c.size != this.size) {
                throw new IllegalArgumentException(this + " " + c);
            }
            return this.l == ((L)c).l ? 0 : (this.signedLongValue() < c.signedLongValue() ? -1 : 1);
        }

        public int signum() {
            return this.l == 0L ? 0 : (this.l << 64 - this.size < 0L ? -1 : 1);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof L && this.size == ((L)o).size && this.l == ((L)o).l;
        }

        public int hashCode() {
            return this.size * 37 + (int)(this.l >>> 32 ^ this.l);
        }

        public String toString(int radix) {
            if (radix == 10 && this.size < 64) {
                return String.valueOf(this.l);
            }
            return this.bigValue().toString(radix);
        }

        public String toSignedString(int radix) {
            if (radix == 10) {
                return String.valueOf(this.l);
            }
            return this.signedBigValue().toString(radix);
        }

        int count(int size) {
            return this.l >= 0L || this.l < (long)size ? (int)this.l : size;
        }
    }
}

