/*
 * Decompiled with CFR 0.152.
 */
package coins.sym;

import coins.MachineParam;
import coins.SymRoot;
import coins.ir.IrList;
import coins.ir.hir.Exp;
import coins.sym.Const;
import coins.sym.Elem;
import coins.sym.EnumType;
import coins.sym.PointerType;
import coins.sym.StructType;
import coins.sym.Sym;
import coins.sym.SymImpl;
import coins.sym.SymIterator;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.UnionType;
import coins.sym.VectorType;
import java.util.ListIterator;

public class TypeImpl
extends SymImpl
implements Type {
    protected int fTypeKind = 0;
    protected Type fOrigin = null;
    private Exp fSizeExp = null;
    private long fSizeValue = -1L;
    protected boolean fConst = false;
    protected boolean fVolatile = false;
    protected Type fCompleteType;
    protected String fTypeCore;

    public TypeImpl() {
    }

    public TypeImpl(SymRoot pSymRoot) {
        super(pSymRoot);
        this.fKind = 13;
        this.fType = this;
        this.fCompleteType = this;
    }

    public int getTypeKind() {
        return this.fTypeKind;
    }

    public Type getOrigin() {
        return this.fOrigin;
    }

    public Type getFinalOrigin() {
        if (this.fOrigin == this) {
            return this.fOrigin;
        }
        if (this.fOrigin != null) {
            return this.fOrigin.getFinalOrigin();
        }
        return this;
    }

    public Type getUnqualifiedType() {
        if ((this.fConst || this.fVolatile) && this.fOrigin != null && this.fOrigin != this) {
            return this.fOrigin.getUnqualifiedType();
        }
        return this;
    }

    public void setOrigin(Type pOrigin) {
        this.fOrigin = pOrigin;
    }

    public boolean isBasicType() {
        return this.fTypeKind <= 20;
    }

    public boolean isInteger() {
        return this.fTypeKind >= 3 && this.fTypeKind <= 12;
    }

    public boolean isUnsigned() {
        return this.fTypeKind >= 8 && this.fTypeKind <= 12;
    }

    public boolean isFloating() {
        return this.fTypeKind >= 16 && this.fTypeKind <= 19;
    }

    public boolean isScalar() {
        int lTypeKind;
        if (this.fTypeKind <= 19 || this.fTypeKind == 22) {
            return true;
        }
        Type lOrigin = this.getFinalOrigin();
        return lOrigin != null && ((lTypeKind = lOrigin.getTypeKind()) <= 19 || lTypeKind == 22);
    }

    public Exp getSizeExp() {
        return this.fSizeExp;
    }

    public void setSizeExp(Exp pSizeExp) {
        this.fSizeExp = pSizeExp;
        if (this.fSizeExp != null) {
            Const c = this.fSizeExp.evaluate();
            if (c != null && c.getSymKind() == 4) {
                this.fSizeValue = c.longValue();
            } else {
                this.symRoot.ioRoot.dbgSym.print(3, "evaluate size exp: ", "not evaluable");
            }
        }
    }

    public long getSizeValue() {
        return this.fSizeValue;
    }

    public void setSizeValue(long pSizeValue) {
        if (pSizeValue >= 0L) {
            this.fSizeExp = this.symRoot.getHirRoot().hir.offsetConstNode(pSizeValue);
            this.fSizeValue = pSizeValue;
        } else {
            this.fSizeValue = -1L;
        }
    }

    public boolean isSizeEvaluable() {
        return this.fSizeValue >= 0L;
    }

    public Type makeConstType() {
        if (this.isConst()) {
            return this;
        }
        Type lType = this.makeQualifiedType("const");
        if (lType != this) {
            ((TypeImpl)lType).fConst = true;
        }
        return lType;
    }

    public Type makeVolatileType() {
        if (this.isVolatile()) {
            return this;
        }
        Type lType = this.makeQualifiedType("volatile");
        if (lType != this) {
            ((TypeImpl)lType).fVolatile = true;
        }
        return lType;
    }

    private Type makeQualifiedType(String pQualifier) {
        Type lType;
        String lTypeCore;
        int lTypeKind = this.getTypeKind();
        String lName = lTypeCore = this.fTypeCore;
        if (pQualifier == "const") {
            if (this.isConst()) {
                return this;
            }
            lName = this.isVolatile() ? (lTypeCore + " const volatile").intern() : (this.getName() + " " + pQualifier).intern();
        } else if (pQualifier == "volatile") {
            if (this.isVolatile()) {
                return this;
            }
            lName = this.isConst() ? (lTypeCore + " const volatile").intern() : (this.getName() + " " + pQualifier).intern();
        }
        SymTable lSymTable = this.symRoot.symTableCurrent.searchTableHaving(this);
        Sym lSym = lSymTable.search(lName);
        if (lSym != null && lSym.getSymKind() == 13) {
            return (Type)lSym;
        }
        if (lTypeKind <= 20) {
            lType = this.symRoot.sym.baseType(lName, lTypeKind);
        } else {
            Sym lDefinedIn = this.symRoot.symTableCurrent.getOwner();
            switch (lTypeKind) {
                case 21: {
                    lType = ((SymImpl)this.symRoot.sym).enumType(lName, ((EnumType)((Object)this)).getElemList(), null);
                    break;
                }
                case 22: {
                    lType = ((SymImpl)this.symRoot.sym).pointerType(lName, ((PointerType)((Object)this)).getPointedType(), lDefinedIn);
                    break;
                }
                case 23: {
                    lType = this.symRoot.sym.vectorType(lName, ((VectorType)((Object)this)).getElemType(), ((VectorType)((Object)this)).getElemCount(), ((VectorType)((Object)this)).getLowerBound());
                    break;
                }
                case 24: {
                    lType = ((SymImpl)this.symRoot.sym).structType(lName, ((StructType)((Object)this)).getElemList(), null);
                    break;
                }
                case 25: {
                    lType = ((SymImpl)this.symRoot.sym).unionType(lName, ((UnionType)((Object)this)).getElemList(), null);
                    break;
                }
                case 28: {
                    lType = this.symRoot.sym.regionType(lName, 6);
                    break;
                }
                case 26: {
                    lType = this.symRoot.sym.definedType(lName, this);
                    break;
                }
                default: {
                    this.symRoot.ioRoot.msgRecovered.put(1011, "illegal qualification " + this.getName() + " " + pQualifier);
                    return this;
                }
            }
        }
        lType.setOrigin(this);
        ((TypeImpl)lType).fTypeCore = this.fTypeCore;
        return lType;
    }

    public boolean isConst() {
        return this.fConst;
    }

    public boolean isVolatile() {
        return this.fVolatile;
    }

    public int getTypeRank() {
        return Type.KIND_RANKS[this.fTypeKind];
    }

    public int getDimension() {
        return 0;
    }

    public IrList getElemList() {
        return null;
    }

    public Type getPointedType() {
        return null;
    }

    public String getElemListString() {
        IrList lElemList = this.getElemList();
        StringBuffer lBuffer = new StringBuffer();
        if (lElemList == null) {
            return "{}";
        }
        lBuffer.append("(");
        ListIterator lElemIterator = lElemList.iterator();
        while (lElemIterator.hasNext()) {
            Elem lElem = (Elem)lElemIterator.next();
            if (lElem == null) continue;
            lBuffer.append("(").append(lElem.getSymType().toStringShort()).append(" ").append(lElem.getName()).append(") ");
        }
        lBuffer.append(")");
        return lBuffer.toString().intern();
    }

    public static String getElemListString(IrList pElemList) {
        StringBuffer lBuffer = new StringBuffer();
        if (pElemList == null) {
            return "( )";
        }
        ListIterator lElemIterator = pElemList.iterator();
        while (lElemIterator.hasNext()) {
            Elem lElem = (Elem)lElemIterator.next();
            if (lElem == null) continue;
            lBuffer.append("(").append(lElem.getSymType().toStringShort()).append(" ").append(lElem.getName()).append(") ");
        }
        return lBuffer.toString().intern();
    }

    public static String getEnumListString(IrList pEnumList) {
        IrList lElemList = pEnumList;
        StringBuffer lBuffer = new StringBuffer();
        if (lElemList == null) {
            return "( )";
        }
        lBuffer.append("(");
        ListIterator lElemIterator = lElemList.iterator();
        while (lElemIterator.hasNext()) {
            IrList lElemIndexPair = (IrList)lElemIterator.next();
            if (lElemIndexPair == null) continue;
            lBuffer.append("(").append(lElemIndexPair.get(0).toString()).append(") ");
        }
        lBuffer.append(")");
        return lBuffer.toString().intern();
    }

    public int getAlignment() {
        int lAlignment = Type.KIND_ALIGNMENT[this.fTypeKind];
        return lAlignment;
    }

    public int getAlignmentGap(long pPrecedingSize) {
        int lAlignment = this.getAlignment();
        long lResidue = pPrecedingSize % (long)lAlignment;
        int lAlignmentGap = lResidue == 0L ? 0 : (int)((long)lAlignment - lResidue);
        return lAlignmentGap;
    }

    public boolean isCompatibleWith(Type pType) {
        Type lType2;
        if (pType == this) {
            return true;
        }
        Type lType1 = this.getFinalOrigin();
        return lType1 == (lType2 = pType.getFinalOrigin());
    }

    public Type getCompleteType() {
        return this.fCompleteType;
    }

    public Type searchTypeCompatibleWithThis() {
        SymTable lSymTable = this.getRecordedIn();
        if (lSymTable == null) {
            return null;
        }
        SymIterator lIterator = lSymTable.getSymIterator();
        while (lIterator.hasNext()) {
            Sym lSym = lIterator.next();
            if (lSym == null || lSym.getSymKind() != 13 || ((Type)lSym).getTypeKind() != this.getTypeKind() || !((Type)lSym).isCompatibleWith(this)) continue;
            return (Type)lSym;
        }
        return null;
    }

    public void setStaticTable(MachineParam pMachineParam) {
        for (int i = 0; i < KIND_ALIGNMENT.length; ++i) {
            TypeImpl.KIND_ALIGNMENT[i] = pMachineParam.getAlignment(i);
        }
    }

    public String toString() {
        String symString = this.fName;
        return symString;
    }

    public String toStringShort() {
        String symString = this.fName;
        return symString;
    }

    public String toStringDetail() {
        String symString = super.toStringDetail();
        if (this.fSizeValue > 0L) {
            symString = symString + " size " + this.fSizeValue;
        } else if (this.fSizeExp != null) {
            symString = symString + " sizeExp " + this.fSizeExp.toStringWithChildren();
        }
        if (this.getFlag(17)) {
            symString = symString + " unfixedSize";
        }
        if (this.fConst) {
            symString = symString + " const";
        }
        if (this.fVolatile) {
            symString = symString + " volatile";
        }
        if (this.fOrigin != null && this.fOrigin != this) {
            symString = symString + " org " + this.fOrigin.toStringShort();
        }
        if (this.fDbgLevel >= 4) {
            Type lType2;
            Type lType = this.searchTypeCompatibleWithThis();
            if (lType != null && lType != this) {
                symString = symString + " compatibleWith " + lType.toStringShort();
            }
            if ((lType2 = this.getCompleteType()) == null) {
                symString = symString + " completeType unfixed ";
            } else if (lType2 != this) {
                symString = symString + " completeType " + lType2.toStringShort();
            }
        }
        return symString;
    }
}

