/*
 * Decompiled with CFR 0.152.
 */
package coins.sym;

import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.ir.IrList;
import coins.ir.hir.Program;
import coins.ir.hir.SubpDefinition;
import coins.sym.Sym;
import coins.sym.SymIterator;
import coins.sym.SymNestIterator;
import coins.sym.SymTable;
import coins.sym.SymTableIterator;
import coins.sym.Type;
import java.util.ListIterator;

public class TestSym {
    public final IoRoot ioRoot;
    public final SymRoot symRoot;
    public final HirRoot hirRoot;

    public TestSym(HirRoot pHirRoot) {
        this.ioRoot = pHirRoot.ioRoot;
        this.symRoot = pHirRoot.symRoot;
        this.hirRoot = pHirRoot;
        if (this.ioRoot.dbgSym.getLevel() >= 3) {
            this.symRoot.symTableRoot.printSymTableAll(this.symRoot.symTableRoot);
            this.testSymTable();
            if (this.ioRoot.dbgSym.getLevel() >= 6) {
                this.testRemove(this.symRoot.symTableRoot.getFirstChild());
            }
        }
    }

    private void testSymTable() {
        Sym lSym;
        this.ioRoot.dbgSym.print(4, "\nTest generateDerivedSym & SymTableIterator\n");
        SymTableIterator lSymTIterator = this.symRoot.symTableRoot.getSymTableIterator();
        while (lSymTIterator.hasNext()) {
            SymTable lSymTable = lSymTIterator.next();
            this.ioRoot.dbgSym.print(4, lSymTable.toString() + "\n");
            SymIterator lSymIterator = lSymTable.getSymIterator();
            while (lSymIterator.hasNext()) {
                lSym = lSymIterator.next();
                if (lSym == null || lSym.getFlag(1)) continue;
                Sym lSym1 = this.symRoot.symTableRoot.generateDerivedSym(lSym);
                Sym lSym2 = this.symRoot.symTableRoot.generateDerivedSym(lSym);
                this.ioRoot.dbgSym.print(4, lSym.toString() + " " + lSym1.toString() + " " + lSym2.toString() + "\n");
                if (lSym.getSymKind() != 13 || ((Type)lSym).getTypeKind() == 27) continue;
                Type lType = ((Type)lSym).makeConstType();
                this.ioRoot.dbgSym.print(4, lType.toString() + "\n");
            }
        }
        this.ioRoot.dbgSym.print(4, "\nTest SymNestIterator symTableRoot\n");
        SymNestIterator lIterator = this.symRoot.symTableRoot.getSymNestIterator();
        while (lIterator.hasNext()) {
            lSym = lIterator.next();
            if (lSym == null) continue;
            this.ioRoot.dbgSym.print(4, lSym.toString() + "\n");
        }
        IrList lSubpDefList = ((Program)this.hirRoot.programRoot).getSubpDefinitionList();
        ListIterator lSubpDefIterator = lSubpDefList.iterator();
        while (lSubpDefIterator.hasNext()) {
            SubpDefinition lSubpDef = (SubpDefinition)lSubpDefIterator.next();
            this.ioRoot.dbgSym.print(4, "\nTest SymNestIterator " + lSubpDef.getSubpSym().getName());
            SymNestIterator lIterator2 = lSubpDef.getSubpSym().getSymTable().getSymNestIterator();
            while (lIterator2.hasNext()) {
                lSym = lIterator2.next();
                if (lSym == null) continue;
                this.ioRoot.dbgSym.print(4, lSym.toString() + "\n");
            }
        }
    }

    private void testSymTable0() {
        this.ioRoot.dbgSym.print(2, "\nTest SymTableIterator\n");
        SymTableIterator lSymTIterator = this.symRoot.symTableRoot.getSymTableIterator();
        while (lSymTIterator.hasNext()) {
            SymTable lSymTable = lSymTIterator.next();
            this.ioRoot.dbgSym.print(2, lSymTable.toString() + "\n");
            SymIterator lSymIterator = lSymTable.getSymIterator();
            while (lSymIterator.hasNext()) {
                Sym lSym = lSymIterator.next();
                this.ioRoot.dbgSym.print(2, lSym.toString(), " ");
            }
        }
    }

    private void testRemove(SymTable pSymTable) {
        if (pSymTable == null) {
            return;
        }
        this.ioRoot.dbgSym.print(2, "\nTest remove", pSymTable.getOwner().toString());
        SymIterator lSymIterator = pSymTable.getSymIterator();
        while (lSymIterator.hasNext()) {
            Sym lSym = lSymIterator.next();
            if (lSym == null || lSym.getFlag(2)) continue;
            this.ioRoot.dbgSym.print(2, " " + lSym.toString());
            String lName = lSym.getName();
            int lKind = lSym.getSymKind();
            Type lType = lSym.getSymType();
            Sym lOwner = lSym.getRecordedIn() != null ? lSym.getRecordedIn().getOwner() : null;
            lSym.remove();
            Sym lNewSym = pSymTable.searchOrAdd(lName, lKind, lOwner, true, true);
            lNewSym.setFlag(2, true);
        }
        pSymTable.printSymTableDetail();
    }
}

