/*
 * Decompiled with CFR 0.152.
 */
package coins.sym;

import coins.SymRoot;
import coins.ir.IrList;
import coins.sym.Elem;
import coins.sym.RegionType;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.SymImpl;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.TypeImpl;
import coins.sym.Var;
import java.util.ListIterator;

public class RegionTypeImpl
extends TypeImpl
implements RegionType {
    protected IrList fSubpList;
    protected IrList fSymTableList;
    protected IrList fListOfElemList;
    protected IrList fCurrentElemList;
    protected SymTable fCurrentSymTable;
    protected Var fRegionVar;
    protected String fRegionName;
    protected Sym fTag;
    protected int fStorageClass;

    public RegionTypeImpl(SymRoot pSymRoot, String pRegionName, int pStorageClass) {
        super(pSymRoot);
        this.fSubpList = this.symRoot.getHirRoot().hir.irList();
        this.fSymTableList = this.symRoot.getHirRoot().hir.irList();
        this.fListOfElemList = this.symRoot.getHirRoot().hir.irList();
        this.fKind = 13;
        this.fType = this;
        this.fTypeKind = 28;
        String lTypeName = ("<REGION " + pRegionName + ">").intern();
        this.fTag = this.symRoot.symTableRoot.generateTag();
        this.fTag.setSymType(this);
        if (this.symRoot.symTableCurrentSubp != null) {
            this.fSubpList.add(this.symRoot.symTableCurrentSubp);
        }
        this.fSymTableList.add(this.symRoot.symTableRoot);
        this.setFlag(11, true);
        this.fCompleteType = null;
        this.fName = lTypeName;
        this.fRegionName = pRegionName;
        this.setFlag(12, false);
        this.fStorageClass = pStorageClass;
    }

    public int addSubp(Subp pSubp, SymTable pRegionSymTable) {
        int lIndex;
        if (pSubp == null) {
            lIndex = 0;
        } else {
            this.fSubpList.add(pSubp);
            lIndex = this.fSubpList.indexOf(pSubp);
        }
        this.fSymTableList.add(lIndex, pRegionSymTable);
        this.fCurrentSymTable = pRegionSymTable;
        this.fCurrentElemList = this.symRoot.getHirRoot().hir.irList(null);
        this.fListOfElemList.add(this.fCurrentElemList);
        return lIndex;
    }

    public SymTable getCurrentRegionSymTable() {
        return this.fCurrentSymTable;
    }

    public SymTable getRegionSymTable(Subp pSubp) {
        if (pSubp == null) {
            return (SymTable)this.fSymTableList.get(0);
        }
        int lIndex = this.fSubpList.indexOf(pSubp);
        if (lIndex >= 0) {
            return (SymTable)this.fSymTableList.get(lIndex);
        }
        return null;
    }

    public SymTable getRegionSymTable(int pIndex) {
        return (SymTable)this.fSymTableList.get(pIndex);
    }

    public IrList getSubpList() {
        return this.fSubpList;
    }

    public void addElemToCurrentRegion(Elem pElem) {
        this.fCurrentElemList.add(pElem);
        pElem.setDisplacement(0L);
        pElem.setDispExp(this.symRoot.getHirRoot().hir.constNode(this.symRoot.intConst0));
        pElem.setFlag(13, true);
        pElem.setStorageClass(this.fStorageClass);
    }

    public IrList getRegionElemList(Subp pSubp) {
        int lIndex = this.fSubpList.indexOf(pSubp);
        if (lIndex >= 0) {
            return (IrList)this.fListOfElemList.get(lIndex);
        }
        return null;
    }

    public void finishCurrentRegion() {
        Type lElemType = null;
        if (this.fDbgLevel > 3) {
            this.symRoot.ioRoot.dbgSym.print(4, "finishCurrentRegion", this.getName());
        }
        long lSize = 0L;
        long lDisplacement = 0L;
        int lAlignment = machineParam.getLargestAlignment();
        int lElemAlignment = 1;
        boolean lSizeIsSet = true;
        ListIterator lElemIterator = this.fCurrentElemList.iterator();
        while (lElemIterator.hasNext()) {
            Elem lElem = (Elem)lElemIterator.next();
            if (lElem == null) continue;
            lElemType = lElem.getSymType();
            long lElemSize = lElemType.getSizeValue();
            lDisplacement = lSize + (long)lElemType.getAlignmentGap(lSize);
            lElem.setDisplacement(lDisplacement);
            lSize = lDisplacement + lElemSize;
            lElemAlignment = lElemType.getAlignment();
            if (!lElemType.isSizeEvaluable()) {
                lSizeIsSet = false;
            }
            if (this.fDbgLevel <= 3) continue;
            this.symRoot.ioRoot.dbgSym.print(4, " elem " + lElem.getName(), " size " + lSize + " disp " + lDisplacement);
        }
        int lAlignmentGap = 0;
        if (lElemType != null) {
            long lResidue = lSize % (long)lAlignment;
            if (lResidue != 0L) {
                lAlignmentGap = (int)((long)lAlignment - lResidue);
            }
            lSize += (long)lAlignmentGap;
        }
        if (this.fDbgLevel > 3) {
            this.symRoot.ioRoot.dbgSym.print(4, " total " + lSize);
        }
        if (this.getSizeValue() < lSize) {
            this.setSizeValue(lSize);
        }
        this.fRegionVar = ((SymImpl)this.symRoot.sym).defineRegionVar(this.fRegionName, this);
        this.fOrigin = this;
        this.fCompleteType = this;
        this.fRegionVar.setStorageClass(this.fStorageClass);
    }

    public Var getRegionVar() {
        return this.fRegionVar;
    }

    public Sym getTag() {
        return this.fTag;
    }

    public void setTag(Sym pTag) {
        this.fTag = pTag;
    }

    public String toStringDetail() {
        String symString = super.toStringDetail();
        ListIterator lIterator = this.fSubpList.iterator();
        while (lIterator.hasNext()) {
            String lSubpName = lIterator.next().toString();
            symString = symString + " " + lSubpName;
        }
        return symString;
    }
}

