/*
 * Decompiled with CFR 0.152.
 */
package coins.sym;

import coins.SymRoot;
import coins.ir.IrList;
import coins.ir.hir.Exp;
import coins.sym.Elem;
import coins.sym.StructType;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.UnionType;
import coins.sym.Var;
import coins.sym.VarImpl;
import java.util.ListIterator;

public class ElemImpl
extends VarImpl
implements Elem {
    private long fDisplacement = 0L;
    private Exp fDispExp = null;
    private boolean fIsBitField;
    private int fBitSize;
    private int fBitOffset;
    private boolean fDispIsSet = false;

    public ElemImpl(SymRoot pSymRoot) {
        super(pSymRoot);
    }

    public ElemImpl(SymRoot pSymRoot, String pElemName, Sym pDefinedIn) {
        super(pSymRoot);
        this.fName = pElemName;
        this.fDefinedIn = pDefinedIn;
        this.fKind = 10;
    }

    public ElemImpl(SymRoot pSymRoot, String pElemName, Sym pDefinedIn, Exp pDispExp) {
        super(pSymRoot);
        this.fName = pElemName;
        this.fDefinedIn = pDefinedIn;
        this.fDispExp = pDispExp;
        if (pDispExp != null && pDispExp.isEvaluable()) {
            this.fDisplacement = pDispExp.evaluateAsInt();
            this.fDispIsSet = true;
        }
        this.fKind = 10;
        this.fIsBitField = false;
        this.fBitOffset = 0;
    }

    public boolean isDispEvaluable() {
        if (this.fDispIsSet) {
            return true;
        }
        return this.fDispExp != null && this.fDispExp.isEvaluable();
    }

    public long evaluateDisp() {
        if (this.fDispIsSet) {
            return this.fDisplacement;
        }
        if (this.fDispExp != null) {
            this.fDisplacement = this.fDispExp.evaluateAsInt();
            this.fDispIsSet = true;
            return this.fDisplacement;
        }
        this.symRoot.ioRoot.msgRecovered.put(1014, "Displacement is not evaluable " + this.getName());
        return 0L;
    }

    public void setDispExp(Exp pDispExp) {
        this.fDispExp = pDispExp;
    }

    public void setDisplacement(long pDisplacement) {
        this.fDisplacement = pDisplacement;
        this.fDispIsSet = true;
    }

    public void setBitFieldSize(int pBitSize) {
        this.fBitSize = pBitSize;
        this.fIsBitField = true;
    }

    public void setBitFieldOffset(int pBitOffset) {
        this.fBitOffset = pBitOffset;
    }

    public void setBitField(int pBitSize, int pBitOffset) {
        this.fBitSize = pBitSize;
        this.fBitOffset = pBitOffset;
        this.fIsBitField = true;
    }

    public int getBitSize() {
        return this.fBitSize;
    }

    public int getBitOffset() {
        return this.fBitOffset;
    }

    public boolean isBitField() {
        return this.fIsBitField;
    }

    public Elem searchElem(Var pVar) {
        return this.searchElem(pVar.getSymType());
    }

    public Elem searchElem(Type pRecordedIn) {
        IrList lElemList = null;
        Elem lElem = null;
        String lThisName = this.getName();
        if (pRecordedIn instanceof StructType) {
            lElemList = ((StructType)pRecordedIn).getElemList();
        } else if (pRecordedIn instanceof UnionType) {
            lElemList = ((UnionType)pRecordedIn).getElemList();
        }
        if (lElemList != null) {
            ListIterator lIterator = lElemList.iterator();
            while (lIterator.hasNext()) {
                lElem = (Elem)lIterator.next();
                if (lThisName != lElem.getName()) continue;
                return lElem;
            }
        }
        return null;
    }

    public Type getUpperType() {
        if (this.fRecordedIn != null) {
            Sym lOwner = this.fRecordedIn.getOwner();
            if (lOwner.getSymKind() == 13 && (lOwner instanceof StructType || lOwner instanceof UnionType)) {
                return (Type)lOwner;
            }
            return null;
        }
        return null;
    }

    public String toString() {
        String lString = super.toString();
        if (this.fDispIsSet) {
            lString = lString + " disp " + this.fDisplacement;
        }
        if (this.fIsBitField) {
            lString = lString + " bitSize " + this.fBitSize + " bitOffset " + this.fBitOffset;
        }
        return lString;
    }
}

