/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Type;
import coins.backend.ana.Dominators;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.AddressAnalyze;
import coins.ssa.MemoryAliasAnalyze;
import coins.ssa.OperatorStrengthReduction;
import coins.ssa.SsaEnvironment;
import coins.ssa.SsaGraphNode;
import coins.ssa.SsaSymTab;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Stack;

class SsaGraph
implements LocalTransformer {
    public static final String symName = "_ssag";
    public final String optName;
    private SsaEnvironment env;
    private SsaSymTab sstab;
    private Function f;
    private Hashtable table;
    private BiList nodeList;
    private SsaGraphNode[] prologues;
    private LirNode prologueNode;
    public static final int THR = 2000;
    private MemoryAliasAnalyze alias;
    private Hashtable aggrMayDef;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "SsaGraph";
    }

    public String subject() {
        return "Make SSA graph.";
    }

    public SsaGraph(SsaEnvironment e, SsaSymTab symtab, String opt) {
        this.env = e;
        this.sstab = symtab;
        this.optName = opt;
        this.alias = null;
        if (opt.equals("ssag")) {
            this.env.println("  Make SSA Graph", 100);
        } else if (opt.equals("osr")) {
            this.env.println("  Operator Strength Reduction", 100);
        }
    }

    public boolean doIt(Function function, ImList args) {
        this.f = function;
        this.nodeList = new BiList();
        this.table = new Hashtable();
        this.aggrMayDef = new Hashtable();
        AddressAnalyze addressAnalyze = new AddressAnalyze(this.env, this.f, this.sstab);
        this.alias = new MemoryAliasAnalyze(this.env, this.f);
        this.make();
        if (this.env.shouldDo(10000)) {
            this.printGraph("before_ssa_graph.dot");
        }
        if (this.optName != null) {
            if (this.optName.equals("ssag")) {
                this.env.println("****************** doing SSAG to " + function.symbol.name, 1000);
                this.env.println("SSAG : make SSA Graph only", 2000);
                this.env.println("", 2000);
            } else if (this.optName.equals("osr")) {
                this.f.apply(new OperatorStrengthReduction(this.env, this.sstab, this));
            }
        }
        if (this.env.shouldDo(10000)) {
            this.printGraph("after_ssa_graph.dot");
        }
        this.apply();
        this.alias.annul();
        addressAnalyze.annul();
        return true;
    }

    SsaGraphNode appendNode(LirNode node, BasicBlk blk, int numOfParents) {
        SsaGraphNode ssaNode = new SsaGraphNode(this.env, node, blk, numOfParents);
        this.nodeList.add(ssaNode);
        return ssaNode;
    }

    BiList nodeList() {
        return this.nodeList;
    }

    private void apply() {
        Hashtable<BasicBlk, BiList> blkMap = new Hashtable<BasicBlk, BiList>();
        Hashtable<BasicBlk, BiList> blkMapLir = new Hashtable<BasicBlk, BiList>();
        boolean[] checked = new boolean[this.nodeList.length()];
        for (int i = 0; i < this.nodeList.length(); ++i) {
            checked[i] = false;
        }
        BiLink p = this.nodeList.first();
        while (!p.atEnd()) {
            SsaGraphNode node = (SsaGraphNode)p.elem();
            BiList instrList = (BiList)blkMap.get(node.belong);
            if (instrList == null) {
                instrList = new BiList();
                blkMap.put(node.belong, instrList);
            }
            instrList.add(node);
            p = p.next();
        }
        Dominators dom = (Dominators)this.f.require(Dominators.analyzer);
        Stack<Object> stack = new Stack<Object>();
        stack.push(this.f.flowGraph().entryBlk());
        while (!stack.empty()) {
            SsaGraphNode node;
            BiLink p2;
            BasicBlk blk = (BasicBlk)stack.pop();
            BiList instrList = (BiList)blkMap.get(blk);
            BiList lirInstrList = new BiList();
            blkMapLir.put(blk, lirInstrList);
            BiList earlyBird = new BiList();
            Hashtable<SsaGraphNode, SsaGraphNode> callMap = new Hashtable<SsaGraphNode, SsaGraphNode>();
            BiLink p3 = instrList.first();
            while (!p3.atEnd()) {
                SsaGraphNode node2 = (SsaGraphNode)p3.elem();
                if (node2.opCode == 47 && node2.parents[1] != null && node2.parents[1].opCode == 53) {
                    callMap.put(node2.parents[1], node2);
                }
                p3 = p3.next();
            }
            BiList sortedList = new BiList();
            SsaGraphNode jumpNode = null;
            boolean again = true;
            block14: while (again) {
                again = false;
                p2 = instrList.first();
                while (!p2.atEnd()) {
                    node = (SsaGraphNode)p2.elem();
                    if (!checked[this.nodeList.whereIs(node)]) {
                        switch (node.opCode) {
                            case 49: 
                            case 50: 
                            case 51: {
                                checked[this.nodeList.whereIs((Object)node)] = true;
                                jumpNode = node;
                                break;
                            }
                            default: {
                                boolean isOk;
                                if (node.opCode == 5 || node.opCode == 4) {
                                    isOk = true;
                                    BiLink pp = instrList.first();
                                    while (!pp.atEnd()) {
                                        SsaGraphNode addrNode = (SsaGraphNode)pp.elem();
                                        if (addrNode.opCode == node.opCode && addrNode != node) {
                                            Symbol sym1 = ((LirSymRef)node.node).symbol;
                                            Symbol sym2 = ((LirSymRef)addrNode.node).symbol;
                                            if (this.sstab.orgSym((Symbol)sym1).name.equals(this.sstab.orgSym((Symbol)sym2).name)) {
                                                SsaGraphNode aggDef;
                                                int cmp = this.sstab.compare(sym1, sym2);
                                                if (!checked[this.nodeList.whereIs(addrNode)] && cmp > 0) {
                                                    isOk = false;
                                                    again = true;
                                                    break;
                                                }
                                                if (checked[this.nodeList.whereIs(addrNode)] && cmp <= 0 && (aggDef = (SsaGraphNode)this.aggrMayDef.get(addrNode)) != null && aggDef.belong.id == blk.id && !checked[this.nodeList.whereIs(aggDef)]) {
                                                    isOk = false;
                                                    again = true;
                                                    break;
                                                }
                                            }
                                        }
                                        pp = pp.next();
                                    }
                                    if (!isOk) break;
                                    checked[this.nodeList.whereIs((Object)node)] = true;
                                    sortedList.addNew(node);
                                    break;
                                }
                                if (node.opCode == 59 || node.parents.length == 0) {
                                    checked[this.nodeList.whereIs((Object)node)] = true;
                                    if (node.opCode == 59) {
                                        sortedList.addFirst(node);
                                        break;
                                    }
                                    sortedList.addNew(node);
                                    break;
                                }
                                isOk = true;
                                for (int i = 0; i < node.parents.length; ++i) {
                                    if (node.parents[i] != null) {
                                        switch (node.parents[i].opCode) {
                                            case 2: 
                                            case 3: {
                                                if (node.parents[i].symbol() == null) break;
                                            }
                                            default: {
                                                if (node.belong != node.parents[i].belong || checked[this.nodeList.whereIs(node.parents[i])]) break;
                                                isOk = false;
                                                again = true;
                                            }
                                        }
                                    }
                                    if (!isOk) break;
                                }
                                if (isOk && node.opCode == 47) {
                                    BiLink pp = instrList.first();
                                    while (!pp.atEnd()) {
                                        long ssaVal2;
                                        long ssaVal1;
                                        SsaGraphNode memNode = (SsaGraphNode)pp.elem();
                                        if (memNode.opCode == 53 && !checked[this.nodeList.whereIs(memNode)] && (ssaVal1 = ((LirIconst)node.node.kid((int)1)).value) >= (ssaVal2 = this.alias.callThreshold(memNode.node))) {
                                            isOk = false;
                                            again = true;
                                            break;
                                        }
                                        if (memNode.opCode == 47 && memNode != node && !checked[this.nodeList.whereIs(memNode)]) {
                                            ssaVal1 = ((LirIconst)node.node.kid((int)1)).value;
                                            ssaVal2 = ((LirIconst)memNode.node.kid((int)1)).value;
                                            boolean isLoad = false;
                                            if (memNode.parents[1] == null) {
                                                isLoad = true;
                                            }
                                            if (isLoad && ssaVal2 < ssaVal1 || !isLoad && ssaVal2 <= ssaVal1) {
                                                isOk = false;
                                                again = true;
                                                break;
                                            }
                                        }
                                        pp = pp.next();
                                    }
                                }
                                if (isOk && node.opCode == 53) {
                                    SsaGraphNode memNode = (SsaGraphNode)callMap.get(node);
                                    if (memNode != null && memNode.symbol() == null && !checked[this.nodeList.whereIs(memNode.parents[0])]) {
                                        isOk = false;
                                        again = true;
                                    }
                                    BiLink pp = instrList.first();
                                    while (!pp.atEnd()) {
                                        long ssaVal2;
                                        long ssaVal1;
                                        SsaGraphNode targetNode = (SsaGraphNode)pp.elem();
                                        if (targetNode.opCode == 53 && targetNode != node && !checked[this.nodeList.whereIs(targetNode)]) {
                                            ssaVal1 = this.alias.callThreshold(node.node);
                                            if (ssaVal1 >= (ssaVal2 = this.alias.callThreshold(targetNode.node))) {
                                                isOk = false;
                                                again = true;
                                                break;
                                            }
                                        } else if (targetNode.opCode == 47 && !checked[this.nodeList.whereIs(targetNode)] && (ssaVal1 = this.alias.callThreshold(node.node)) > (ssaVal2 = ((LirIconst)targetNode.node.kid((int)1)).value)) {
                                            isOk = false;
                                            again = true;
                                            break;
                                        }
                                        pp = pp.next();
                                    }
                                }
                                if (!isOk) break;
                                checked[this.nodeList.whereIs((Object)node)] = true;
                                sortedList.addNew(node);
                                if (again) continue block14;
                            }
                        }
                    }
                    p2 = p2.next();
                }
            }
            if (jumpNode != null) {
                sortedList.add(jumpNode);
            }
            p2 = sortedList.first();
            while (!p2.atEnd()) {
                node = (SsaGraphNode)p2.elem();
                switch (node.opCode) {
                    case 54: {
                        break;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 53: 
                    case 55: 
                    case 59: {
                        LirNode lir = node.apply(this.nodeList);
                        if (lir != null) {
                            this.env.println("SSAG : " + blk.id + " " + lir, 10000);
                            lirInstrList.add(lir);
                            break;
                        }
                        this.env.output.println("fail : " + node.node);
                        break;
                    }
                    default: {
                        if (node.symbol() == null) break;
                        LirNode lir = node.apply(this.nodeList);
                        if (lir != null) {
                            this.env.println("SSAG : " + blk.id + " " + lir, 10000);
                            lirInstrList.add(lir);
                            break;
                        }
                        this.env.output.println("fail : " + node.node);
                    }
                }
                p2 = p2.next();
            }
            p2 = dom.kids[blk.id].first();
            while (!p2.atEnd()) {
                stack.push(p2.elem());
                p2 = p2.next();
            }
        }
        for (int i = 0; i < this.prologues.length; ++i) {
            Symbol s = this.prologues[i].symbol();
            if (s != null) {
                this.prologueNode.setKid(i + 1, this.env.lir.symRef(s));
                continue;
            }
            BiLink p4 = this.nodeList.first();
            while (!p4.atEnd()) {
                SsaGraphNode n = (SsaGraphNode)p4.elem();
                for (int j = 0; j < n.parents.length; ++j) {
                    if (n.parents[j] != this.prologues[i]) continue;
                    LirNode argNode = n.apply(this.nodeList);
                    if (argNode.opCode == 48) {
                        argNode = argNode.kid(1);
                    }
                    this.prologueNode.setKid(i + 1, argNode.makeCopy(this.env.lir));
                }
                p4 = p4.next();
            }
        }
        BiList entryBlkList = (BiList)blkMapLir.get(this.f.flowGraph().entryBlk());
        entryBlkList.addFirst(this.prologueNode);
        BiLink p5 = this.f.flowGraph().basicBlkList.first();
        while (!p5.atEnd()) {
            BasicBlk blk = (BasicBlk)p5.elem();
            BiList l = (BiList)blkMapLir.get(blk);
            if (l != null) {
                blk.instrList().clear();
                blk.instrList().concatenate(l);
            }
            p5 = p5.next();
        }
        this.f.flowGraph().touch();
    }

    private void make() {
        Dominators dom = (Dominators)this.f.require(Dominators.analyzer);
        Stack<Object> stack = new Stack<Object>();
        stack.push(this.f.flowGraph().entryBlk());
        while (!stack.empty()) {
            BasicBlk blk = (BasicBlk)stack.pop();
            BiLink p = blk.instrList().first();
            while (!p.atEnd()) {
                this.makeGraph(blk, (LirNode)p.elem());
                p = p.next();
            }
            p = dom.kids[blk.id].first();
            while (!p.atEnd()) {
                stack.push(p.elem());
                p = p.next();
            }
        }
        if (this.optName.equals("ssag") && this.env.opt.isSet("ssa-ssag-pruning")) {
            this.pruning();
        }
    }

    private void pruning() {
        BiList removeList = new BiList();
        boolean again = true;
        while (again) {
            again = false;
            BiLink p = this.nodeList.first();
            while (!p.atEnd()) {
                SsaGraphNode node = (SsaGraphNode)p.elem();
                BiLink q = p.next();
                while (!q.atEnd()) {
                    SsaGraphNode target = (SsaGraphNode)q.elem();
                    if (!removeList.contains(target) && node.opCode == target.opCode && node.node.type == target.node.type) {
                        switch (node.opCode) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 8: {
                                SsaGraphNode remove;
                                if (!node.node.equals(target.node) || (remove = this.replace(node, target)) == null) break;
                                removeList.add(remove);
                                again = true;
                                break;
                            }
                            case 10: 
                            case 12: 
                            case 27: 
                            case 28: 
                            case 29: {
                                if (Type.tag(node.node.type) == 2) {
                                    SsaGraphNode remove;
                                    boolean[] targetCheck = new boolean[target.parents.length];
                                    for (int i = 0; i < target.parents.length; ++i) {
                                        targetCheck[i] = false;
                                    }
                                    if (node.parents.length != target.parents.length) break;
                                    boolean isOk = true;
                                    for (int i = 0; i < node.parents.length; ++i) {
                                        boolean nomatch = true;
                                        for (int j = 0; j < target.parents.length; ++j) {
                                            if (targetCheck[j] || node.parents[i] != target.parents[j]) continue;
                                            targetCheck[j] = true;
                                            nomatch = false;
                                            break;
                                        }
                                        if (!nomatch) continue;
                                        isOk = false;
                                        break;
                                    }
                                    if (!isOk || (remove = this.replace(node, target)) == null) break;
                                    removeList.add(remove);
                                    again = true;
                                    break;
                                }
                            }
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 47: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 59: {
                                break;
                            }
                            default: {
                                SsaGraphNode remove;
                                if (node.parents.length != target.parents.length) break;
                                boolean isOk = true;
                                for (int i = 0; i < node.parents.length; ++i) {
                                    if (node.parents[i] == target.parents[i]) continue;
                                    isOk = false;
                                    break;
                                }
                                if (!isOk || (remove = this.replace(node, target)) == null) break;
                                removeList.add(remove);
                                again = true;
                            }
                        }
                    }
                    q = q.next();
                }
                p = p.next();
            }
            p = removeList.first();
            while (!p.atEnd()) {
                this.nodeList.remove(p.elem());
                p = p.next();
            }
            removeList.clear();
        }
    }

    private SsaGraphNode replace(SsaGraphNode n1, SsaGraphNode n2) {
        Dominators dom = (Dominators)this.f.require(Dominators.analyzer);
        BiList list1 = new BiList();
        BiList list2 = new BiList();
        BiLink p = this.nodeList.first();
        while (!p.atEnd()) {
            SsaGraphNode node = (SsaGraphNode)p.elem();
            for (int i = 0; i < node.parents.length; ++i) {
                if (node.parents[i] == n1) {
                    list1.addNew(node);
                }
                if (node.parents[i] != n2) continue;
                list2.addNew(node);
            }
            p = p.next();
        }
        boolean isOk = true;
        BiLink p2 = list1.first();
        while (!p2.atEnd()) {
            SsaGraphNode node = (SsaGraphNode)p2.elem();
            if (!dom.dominates(n2.belong, node.belong)) {
                isOk = false;
                break;
            }
            p2 = p2.next();
        }
        if (isOk) {
            p2 = list1.first();
            while (!p2.atEnd()) {
                SsaGraphNode node = (SsaGraphNode)p2.elem();
                for (int i = 0; i < node.parents.length; ++i) {
                    if (node.parents[i] != n1) continue;
                    node.parents[i] = n2;
                }
                p2 = p2.next();
            }
            return n1;
        }
        isOk = true;
        p2 = list2.first();
        while (!p2.atEnd()) {
            SsaGraphNode node = (SsaGraphNode)p2.elem();
            if (!dom.dominates(n1.belong, node.belong)) {
                isOk = false;
                break;
            }
            p2 = p2.next();
        }
        if (isOk) {
            p2 = list2.first();
            while (!p2.atEnd()) {
                SsaGraphNode node = (SsaGraphNode)p2.elem();
                for (int i = 0; i < node.parents.length; ++i) {
                    if (node.parents[i] != n2) continue;
                    node.parents[i] = n1;
                }
                p2 = p2.next();
            }
            return n2;
        }
        return null;
    }

    private SsaGraphNode makeGraph(BasicBlk blk, LirNode node) {
        SsaGraphNode returnNode = null;
        switch (node.opCode) {
            case 48: {
                SsaGraphNode uNode = this.makeGraph(blk, node.kid(1));
                if (node.kid((int)0).opCode == 6) {
                    Symbol s = ((LirSymRef)node.kid((int)0)).symbol;
                    this.setSymbol(s, uNode);
                    break;
                }
                SsaGraphNode mNode = this.makeGraph(blk, node.kid(0));
                Symbol s = this.sstab.newSsaSymbol(symName, Type.type(2, 32L));
                this.setSymbol(s, mNode);
                mNode.parents[1] = uNode;
                break;
            }
            case 59: {
                Symbol s = ((LirSymRef)node.kid((int)0)).symbol;
                SsaGraphNode phiNode = this.appendNode(node, blk, node.nKids());
                this.setSymbol(s, phiNode);
                for (int i = 1; i < node.nKids(); ++i) {
                    BasicBlk target = ((LirLabelRef)node.kid((int)i).kid((int)1)).label.basicBlk();
                    phiNode.parents[i] = this.makeGraph(target, node.kid(i).kid(0));
                }
                break;
            }
            case 47: {
                SsaGraphNode addressNode = this.makeGraph(blk, node.kid(0));
                Symbol s = this.sstab.newSsaSymbol(symName, node.type);
                returnNode = this.appendNode(node, blk, 2);
                if (s != null) {
                    this.setSymbol(s, returnNode);
                }
                returnNode.parents[0] = addressNode;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                SsaGraphNode lNode = this.makeGraph(blk, node.kid(0));
                returnNode = this.appendNode(node, blk, 1);
                returnNode.parents[0] = lNode;
                break;
            }
            case 9: 
            case 30: {
                SsaGraphNode lNode = this.makeGraph(blk, node.kid(0));
                Symbol s = this.sstab.newSsaSymbol(symName, node.type);
                returnNode = this.appendNode(node, blk, 1);
                if (s != null) {
                    this.setSymbol(s, returnNode);
                }
                returnNode.parents[0] = lNode;
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                SsaGraphNode lNode = this.makeGraph(blk, node.kid(0));
                SsaGraphNode rNode = this.makeGraph(blk, node.kid(1));
                returnNode = this.appendNode(node, blk, 2);
                returnNode.parents[0] = lNode;
                returnNode.parents[1] = rNode;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                SsaGraphNode lNode = this.makeGraph(blk, node.kid(0));
                SsaGraphNode rNode = this.makeGraph(blk, node.kid(1));
                Symbol s = this.sstab.newSsaSymbol(symName, node.type);
                returnNode = this.appendNode(node, blk, 2);
                if (s != null) {
                    this.setSymbol(s, returnNode);
                }
                returnNode.parents[0] = lNode;
                returnNode.parents[1] = rNode;
                break;
            }
            case 49: {
                SsaGraphNode lNode = this.makeGraph(blk, node.kid(0));
                returnNode = this.appendNode(node, blk, 1);
                returnNode.parents[0] = lNode;
                break;
            }
            case 50: {
                SsaGraphNode tstNode = this.makeGraph(blk, node.kid(0));
                SsaGraphNode lab1Node = this.makeGraph(blk, node.kid(1));
                SsaGraphNode lab2Node = this.makeGraph(blk, node.kid(2));
                returnNode = this.appendNode(node, blk, 3);
                returnNode.parents[0] = tstNode;
                returnNode.parents[1] = lab1Node;
                returnNode.parents[2] = lab2Node;
                break;
            }
            case 51: {
                int number = node.nKids();
                number = number - 1 + node.kid(1).nKids();
                returnNode = this.appendNode(node, blk, number);
                returnNode.parents[0] = this.makeGraph(blk, node.kid(0));
                for (int i = 1; i < number - 1; ++i) {
                    SsaGraphNode labNode;
                    SsaGraphNode cnstNode = this.appendNode(node.kid(1).kid(i - 1).kid(0), blk, 1);
                    cnstNode.parents[0] = labNode = this.makeGraph(blk, node.kid(1).kid(i - 1).kid(1));
                    returnNode.parents[i] = cnstNode;
                }
                returnNode.parents[number - 1] = this.makeGraph(blk, node.kid(2));
                break;
            }
            case 53: {
                int i;
                int number = node.kid(1).nKids() + 1;
                returnNode = this.appendNode(node, blk, number);
                SsaGraphNode nameNode = this.makeGraph(blk, node.kid(0));
                SsaGraphNode[] argNodes = new SsaGraphNode[node.kid(1).nKids()];
                for (i = 0; i < node.kid(1).nKids(); ++i) {
                    if (node.kid((int)1).kid((int)i).opCode == 5 || node.kid((int)1).kid((int)i).opCode == 4) {
                        this.aggrMayDef.put(node.kid(1).kid(i), returnNode);
                    }
                    argNodes[i] = this.makeGraph(blk, node.kid(1).kid(i));
                }
                returnNode.parents[0] = nameNode;
                for (i = 0; i < node.kid(1).nKids(); ++i) {
                    returnNode.parents[i + 1] = argNodes[i];
                }
                if (node.kid(2).nKids() <= 0) break;
                if (node.kid((int)2).kid((int)0).opCode == 6) {
                    Symbol s = ((LirSymRef)node.kid((int)2).kid((int)0)).symbol;
                    this.setSymbol(s, returnNode);
                    break;
                }
                SsaGraphNode mNode = this.makeGraph(blk, node.kid(2).kid(0));
                mNode.setSymbol(null);
                mNode.parents[1] = returnNode;
                break;
            }
            case 54: {
                this.prologueNode = node;
                this.prologues = new SsaGraphNode[node.nKids() - 1];
                if (node.nKids() > 1) {
                    for (int i = 1; i < node.nKids(); ++i) {
                        this.prologues[i - 1] = returnNode = this.appendNode(node, blk, 0);
                        if (node.kid((int)i).opCode == 6) {
                            Symbol s = ((LirSymRef)node.kid((int)i)).symbol;
                            this.setSymbol(s, returnNode);
                            continue;
                        }
                        SsaGraphNode mNode = this.makeGraph(blk, node.kid(i));
                        mNode.parents[1] = returnNode;
                    }
                    break;
                }
                returnNode = this.appendNode(node, blk, 0);
                break;
            }
            case 55: {
                if (node.nKids() > 1) {
                    int i;
                    SsaGraphNode[] vals = new SsaGraphNode[node.nKids() - 1];
                    for (i = 1; i < node.nKids(); ++i) {
                        vals[i - 1] = this.makeGraph(blk, node.kid(i));
                    }
                    returnNode = this.appendNode(node, blk, node.nKids() - 1);
                    for (i = 0; i < vals.length; ++i) {
                        returnNode.parents[i] = vals[i];
                    }
                    break;
                }
                returnNode = this.appendNode(node, blk, 0);
                break;
            }
            case 6: {
                Symbol s = ((LirSymRef)node).symbol;
                returnNode = (SsaGraphNode)this.table.get(s);
                if (returnNode != null) break;
                returnNode = this.appendNode(node, blk, 0);
                this.table.put(s, returnNode);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                if (this.optName.equals("ssag") && this.env.opt.isSet("ssa-ssag-pruning")) {
                    SsaGraphNode tmp = (SsaGraphNode)this.table.get(node.toString().intern());
                    if (tmp == null) {
                        returnNode = this.appendNode(node, blk, 0);
                        this.table.put(node.toString().intern(), returnNode);
                        break;
                    }
                    Dominators dom = (Dominators)this.f.require(Dominators.analyzer);
                    if (dom.dominates(tmp.belong, blk)) {
                        returnNode = tmp;
                        break;
                    }
                    returnNode = dom.dominates(blk, tmp.belong) ? this.appendNode(node, blk, 0) : this.appendNode(node, this.f.flowGraph().entryBlk(), 0);
                    BiLink p = this.nodeList.first();
                    while (!p.atEnd()) {
                        SsaGraphNode n = (SsaGraphNode)p.elem();
                        for (int i = 0; i < n.parents.length; ++i) {
                            if (n.parents[i] != tmp) continue;
                            n.parents[i] = returnNode;
                        }
                        p = p.next();
                    }
                    if (tmp.symbol() != null) {
                        this.setSymbol(tmp.symbol(), returnNode);
                    }
                    this.nodeList.remove(tmp);
                    this.table.remove(tmp);
                    this.table.put(node.toString().intern(), returnNode);
                    break;
                }
                returnNode = this.appendNode(node, blk, 0);
                break;
            }
        }
        return returnNode;
    }

    void setSymbol(Symbol s, SsaGraphNode node) {
        node.setSymbol(s);
        SsaGraphNode tmp = (SsaGraphNode)this.table.get(s);
        if (tmp != null) {
            this.table.remove(tmp);
            this.nodeList.remove(tmp);
            BiLink p = this.nodeList.first();
            while (!p.atEnd()) {
                SsaGraphNode n = (SsaGraphNode)p.elem();
                for (int i = 0; i < n.parents.length; ++i) {
                    if (n.parents[i] != tmp) continue;
                    n.parents[i] = node;
                }
                p = p.next();
            }
        }
        this.table.put(s, node);
    }

    void printGraph(String filename) {
        OutputStreamWriter output = new OutputStreamWriter(System.out);
        try {
            FileOutputStream outStream = new FileOutputStream(filename);
            output = new OutputStreamWriter(outStream);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            output.write("digraph G {\n");
        }
        catch (IOException e) {
            System.out.println("digraph G {");
        }
        BiLink p = this.nodeList.first();
        while (!p.atEnd()) {
            SsaGraphNode node = (SsaGraphNode)p.elem();
            node.printGraph(output, this.nodeList);
            p = p.next();
        }
        try {
            output.write("}\n");
            output.close();
        }
        catch (IOException e) {
            System.out.println("}");
        }
    }
}

