/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.ana.DFST;
import coins.backend.ana.Dominators;
import coins.backend.ana.LiveVariableAnalysis;
import coins.backend.ana.LiveVariableSlotwise;
import coins.backend.ana.LoopAnalysis;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.MemoryAliasAnalyze;
import coins.ssa.SsaEnvironment;
import coins.ssa.SsaSymTab;
import coins.ssa.Util;
import java.util.Hashtable;
import java.util.Stack;

class HoistingLoopInvariant
implements LocalTransformer {
    private SsaEnvironment env;
    public static final int THR = 2000;
    private final String hliSymName = "_hli";
    private SsaSymTab sstab;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "HoistingLoopInvariant";
    }

    public String subject() {
        return "Hoisting loop invariant variables on SSA form.";
    }

    public HoistingLoopInvariant(SsaEnvironment e, SsaSymTab symtab) {
        this.env = e;
        this.sstab = symtab;
        this.env.println("  Hoisting Loop Invariant Variables", 100);
    }

    public boolean doIt(Function f, ImList args) {
        BiLink q;
        Loops l;
        this.env.println("****************** doing HLI to " + f.symbol.name, 1000);
        MemoryAliasAnalyze alias = new MemoryAliasAnalyze(this.env, f);
        Util util = new Util(this.env, f);
        LoopAnalysis loop = (LoopAnalysis)f.require(LoopAnalysis.analyzer);
        DFST dfst = (DFST)f.require(DFST.analyzer);
        BasicBlk[] v = dfst.blkVectorByPre();
        int n = dfst.maxDfn;
        Hashtable<BasicBlk, Loops> loopTable = new Hashtable<BasicBlk, Loops>();
        BiList loopList = new BiList();
        for (int i = 1; i <= n; ++i) {
            if (!loop.isLoop[v[i].id]) continue;
            l = new Loops(v[i], loop.nestLevel[v[i].id]);
            for (int j = i + 1; j <= n; ++j) {
                if (loop.loopHeader[v[j].id] == null || loop.loopHeader[v[j].id].id != v[i].id) continue;
                l.body.addNew(v[j]);
            }
            if (l.nestLevel == 1) {
                loopList.addNew(l);
            } else {
                BiLink p = loopList.first();
                while (!p.atEnd()) {
                    Loops ll = (Loops)p.elem();
                    if (l.nestLevel > ll.nestLevel) {
                        p.addBefore(l);
                        break;
                    }
                    p = p.next();
                }
            }
            loopTable.put(l.header, l);
        }
        BiLink p = loopList.first();
        while (!p.atEnd()) {
            l = (Loops)p.elem();
            BiList all = l.body.copy();
            all.add(l.header);
            BiLink pp = all.first();
            while (!pp.atEnd()) {
                BasicBlk blk = (BasicBlk)pp.elem();
                BiList succ = blk.succList();
                q = succ.first();
                while (!q.atEnd()) {
                    BasicBlk s = (BasicBlk)q.elem();
                    if (!all.contains(s)) {
                        if (loop.isLoop[blk.id]) {
                            Loops ll = (Loops)loopTable.get(blk);
                            if (!ll.body.contains(s)) {
                                l.exits.addNew(blk);
                            }
                        } else {
                            l.exits.addNew(blk);
                        }
                    }
                    q = q.next();
                }
                pp = pp.next();
            }
            p = p.next();
        }
        boolean isChanged = true;
        while (isChanged) {
            isChanged = false;
            Hashtable<BasicBlk, BiList> defineVarMap = new Hashtable<BasicBlk, BiList>();
            BiLink p2 = loopList.first();
            while (!p2.atEnd()) {
                Loops l2 = (Loops)p2.elem();
                if (l2.preheader().length() <= 1) {
                    BasicBlk blk;
                    BiList all = l2.body.copy();
                    all.add(l2.header);
                    BiList defined = new BiList();
                    q = all.first();
                    while (!q.atEnd()) {
                        BiLink r;
                        blk = (BasicBlk)q.elem();
                        BiList nestLoopDefs = (BiList)defineVarMap.get(blk);
                        if (nestLoopDefs != null) {
                            r = nestLoopDefs.first();
                            while (!r.atEnd()) {
                                LirSymRef symRef = (LirSymRef)r.elem();
                                defined.addNew(symRef);
                                r = r.next();
                            }
                        } else {
                            r = blk.instrList().first();
                            while (!r.atEnd()) {
                                LirNode node = (LirNode)r.elem();
                                switch (node.opCode) {
                                    case 48: {
                                        if (node.kid((int)0).opCode != 6) break;
                                        defined.addNew(node.kid(0));
                                        break;
                                    }
                                    case 59: {
                                        defined.addNew(node.kid(0));
                                        break;
                                    }
                                    case 53: {
                                        if (node.kid(2).nKids() <= 0 || node.kid((int)2).kid((int)0).opCode != 6) break;
                                        defined.addNew(node.kid(2).kid(0));
                                    }
                                }
                                r = r.next();
                            }
                        }
                        q = q.next();
                    }
                    q = all.first();
                    while (!q.atEnd()) {
                        blk = (BasicBlk)q.elem();
                        BiLink r = blk.instrList().first();
                        while (!r.atEnd()) {
                            LirNode node = (LirNode)r.elem();
                            if (node.opCode == 48 && node.kid((int)0).opCode == 6) {
                                boolean hoistable = true;
                                if (node.kid((int)1).opCode != 6) {
                                    BiList mems = util.findTargetLir(node.kid(1), 47, new BiList());
                                    if (mems.length() > 0) {
                                        long[] phRank = new long[l2.preheader().length()];
                                        int i = 0;
                                        BiLink pp = l2.preheader().first();
                                        while (!pp.atEnd()) {
                                            BasicBlk phBlk = (BasicBlk)pp.elem();
                                            phRank[i++] = alias.blkRank(phBlk);
                                            pp = pp.next();
                                        }
                                        pp = mems.first();
                                        while (!pp.atEnd()) {
                                            LirNode memNode = (LirNode)pp.elem();
                                            for (i = 0; i < phRank.length; ++i) {
                                                if (phRank[i] == ((LirIconst)memNode.kid((int)1)).value) continue;
                                                hoistable = false;
                                                break;
                                            }
                                            if (!hoistable) break;
                                            pp = pp.next();
                                        }
                                    }
                                    if (hoistable) {
                                        BiList list = util.findTargetLir(node.kid(1), 6, new BiList());
                                        BiLink pp = list.first();
                                        while (!pp.atEnd()) {
                                            LirNode n1 = (LirNode)pp.elem();
                                            BiLink qq = defined.first();
                                            while (!qq.atEnd()) {
                                                LirNode n2 = (LirNode)qq.elem();
                                                if (n1.equals(n2)) {
                                                    hoistable = false;
                                                    break;
                                                }
                                                qq = qq.next();
                                            }
                                            if (!hoistable) break;
                                            pp = pp.next();
                                        }
                                    }
                                    if (hoistable) {
                                        BiLink pp;
                                        this.env.println("HLI : Loop invariant " + node + " in block " + blk.id, 2000);
                                        if (!this.mayCauseException(node)) {
                                            LiveVariableAnalysis ana = (LiveVariableAnalysis)f.require(LiveVariableSlotwise.analyzer);
                                            BiLink pp2 = l2.exits.first();
                                            while (!pp2.atEnd()) {
                                                BasicBlk exitBlk = (BasicBlk)pp2.elem();
                                                BiList liveOut = ana.liveOut(exitBlk);
                                                if (liveOut.contains(((LirSymRef)node.kid((int)0)).symbol)) {
                                                    Dominators dom = (Dominators)f.require(Dominators.analyzer);
                                                    boolean isOk = false;
                                                    if (!dom.dominates(blk, exitBlk)) {
                                                        hoistable = false;
                                                    }
                                                }
                                                pp2 = pp2.next();
                                            }
                                        } else {
                                            pp = l2.exits.first();
                                            while (!pp.atEnd()) {
                                                BasicBlk exitBlk = (BasicBlk)pp.elem();
                                                Dominators dom = (Dominators)f.require(Dominators.analyzer);
                                                boolean isOk = false;
                                                if (!dom.dominates(blk, exitBlk)) {
                                                    hoistable = false;
                                                }
                                                pp = pp.next();
                                            }
                                        }
                                        if (hoistable) {
                                            isChanged = true;
                                            pp = l2.preheader().first();
                                            while (!pp.atEnd()) {
                                                BasicBlk preheader = (BasicBlk)pp.elem();
                                                this.env.println("HLI : Hoisted " + node + " into block " + preheader.id, 2000);
                                                Symbol s = this.sstab.newSsaSymbol("_hli", node.type);
                                                LirNode regNode = this.env.lir.symRef(s);
                                                LirNode cpy = this.env.lir.operator(48, node.type, regNode, node.kid(1).makeCopy(this.env.lir), ImList.Empty);
                                                BiList instr = preheader.instrList();
                                                instr.last().addBefore(cpy);
                                                node.setKid(1, regNode.makeCopy(this.env.lir));
                                                pp = pp.next();
                                            }
                                            f.touch();
                                        }
                                    }
                                }
                            }
                            r = r.next();
                        }
                        q = q.next();
                    }
                    defineVarMap.put(l2.header, defined);
                }
                p2 = p2.next();
            }
        }
        this.env.println("", 2000);
        alias.annul();
        return true;
    }

    private boolean mayCauseException(LirNode node) {
        Stack<LirNode> stack = new Stack<LirNode>();
        stack.push(node);
        block3: while (!stack.empty()) {
            LirNode n = (LirNode)stack.pop();
            switch (n.opCode) {
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    LirNode kid = n.kid(1);
                    if (kid.opCode == 2) {
                        long i = ((LirIconst)kid).value;
                        if (i == 0L) {
                            return true;
                        }
                        stack.push(n.kid(0));
                        continue block3;
                    }
                    if (kid.opCode == 3) {
                        double f = ((LirFconst)kid).value;
                        if (f == 0.0) {
                            return true;
                        }
                        stack.push(n.kid(0));
                        continue block3;
                    }
                    return true;
                }
            }
            for (int i = 0; i < n.nKids(); ++i) {
                stack.push(n.kid(i));
            }
        }
        return false;
    }

    private class Loops {
        BasicBlk header;
        BiList body;
        BiList exits;
        final int nestLevel;
        private BiList preheader;

        Loops(BasicBlk h, int nestLev) {
            this.header = h;
            this.nestLevel = nestLev;
            this.body = new BiList();
            this.exits = new BiList();
            this.preheader = null;
        }

        BiList preheader() {
            if (this.preheader == null) {
                this.preheader = new BiList();
                BiLink p = this.header.predList().first();
                while (!p.atEnd()) {
                    BasicBlk blk = (BasicBlk)p.elem();
                    if (blk != this.header && !this.body.contains(blk)) {
                        this.preheader.addNew(blk);
                    }
                    p = p.next();
                }
            }
            return this.preheader;
        }

        void print() {
            BasicBlk blk;
            ((HoistingLoopInvariant)HoistingLoopInvariant.this).env.output.print("[NestLevel: " + this.nestLevel + "] ");
            ((HoistingLoopInvariant)HoistingLoopInvariant.this).env.output.print("[Header: " + this.header.id + "] ");
            ((HoistingLoopInvariant)HoistingLoopInvariant.this).env.output.print("[Body:");
            BiLink p = this.body.first();
            while (!p.atEnd()) {
                blk = (BasicBlk)p.elem();
                ((HoistingLoopInvariant)HoistingLoopInvariant.this).env.output.print(" " + blk.id);
                p = p.next();
            }
            ((HoistingLoopInvariant)HoistingLoopInvariant.this).env.output.print("] ");
            ((HoistingLoopInvariant)HoistingLoopInvariant.this).env.output.print("[ExitBlock:");
            p = this.exits.first();
            while (!p.atEnd()) {
                blk = (BasicBlk)p.elem();
                ((HoistingLoopInvariant)HoistingLoopInvariant.this).env.output.print(" " + blk.id);
                p = p.next();
            }
            ((HoistingLoopInvariant)HoistingLoopInvariant.this).env.output.println("]");
        }
    }
}

