/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Op;
import coins.backend.Type;
import coins.backend.ana.DFST;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;
import coins.ssa.Util;
import java.util.Hashtable;

class GlobalReassociation
implements LocalTransformer {
    private SsaEnvironment env;
    public static final int THR = 2000;
    private Hashtable rankMap;
    private Function f;
    private Util util;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "GlobalReassociation";
    }

    public String subject() {
        return "Global Reassociation for the expressions.";
    }

    public GlobalReassociation(SsaEnvironment e) {
        this.env = e;
        this.env.println("  Global Reassociation for the expressions", 100);
    }

    public boolean doIt(Function function, ImList args) {
        this.env.println("****************** doing GRA to " + function.symbol.name, 1000);
        this.f = function;
        this.util = new Util(this.env, this.f);
        this.rankMap = new Hashtable();
        this.computeRank();
        this.sortExpression();
        return true;
    }

    private void computeRank() {
        DFST dfst = (DFST)this.f.require(DFST.analyzer);
        BasicBlk[] blks = dfst.blkVectorByRPost();
        for (int blkRank = 1; blkRank < blks.length; ++blkRank) {
            BiLink p = blks[blkRank].instrList().first();
            while (!p.atEnd()) {
                LirNode node = (LirNode)p.elem();
                switch (node.opCode) {
                    case 48: {
                        if (node.kid((int)0).opCode != 6) break;
                        BiList list = this.util.findTargetLir(node.kid(1), 47, new BiList());
                        int rank = 0;
                        if (list.length() > 0) {
                            rank = blkRank;
                        }
                        list = this.util.findTargetLir(node.kid(1), 6, new BiList());
                        BiLink q = list.first();
                        while (!q.atEnd()) {
                            LirNode n = (LirNode)q.elem();
                            Integer i = (Integer)this.rankMap.get(n);
                            if (i != null && i > rank) {
                                rank = i;
                            }
                            q = q.next();
                        }
                        LirNode reg = node.kid(0);
                        this.rankMap.put(reg, new Integer(rank));
                        this.env.println("GRA : " + reg + " --> rank[" + rank + "]", 2000);
                        break;
                    }
                    case 54: {
                        LirNode reg;
                        BiList list = this.util.findTargetLir(node, 6, new BiList());
                        BiLink q = list.first();
                        while (!q.atEnd()) {
                            reg = (LirNode)q.elem();
                            this.rankMap.put(reg, new Integer(blkRank));
                            this.env.println("GRA : " + reg + " --> rank[" + blkRank + "]", 2000);
                            q = q.next();
                        }
                        break;
                    }
                    case 59: {
                        LirNode reg = node.kid(0);
                        this.rankMap.put(reg, new Integer(blkRank));
                        this.env.println("GRA : " + reg + " --> rank[" + blkRank + "]", 2000);
                        break;
                    }
                    case 53: {
                        if (node.kid(2).nKids() <= 0 || node.kid((int)2).kid((int)0).opCode != 6) break;
                        LirNode reg = node.kid(2).kid(0);
                        this.rankMap.put(reg, new Integer(blkRank));
                        this.env.println("GRA : " + reg + " --> rank[" + blkRank + "]", 2000);
                    }
                }
                p = p.next();
            }
        }
    }

    private void sortExpression() {
        BiLink p = this.f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            boolean again = true;
            while (again) {
                LirNode node;
                again = false;
                BiLink q = blk.instrList().first();
                while (!q.atEnd()) {
                    node = (LirNode)q.elem();
                    this.rewriteExp(null, node, -1);
                    q = q.next();
                }
                q = blk.instrList().first();
                while (!q.atEnd()) {
                    node = (LirNode)q.elem();
                    this.env.lir.evalTree(node);
                    switch (node.opCode) {
                        case 48: 
                        case 53: {
                            for (int i = 0; i < node.nKids(); ++i) {
                                SortData data = this.getInfo(node.kid(i));
                                this.sortByRank(data);
                                this.sortByAlphabetic(data);
                                node.setKid(i, data.makeLirNode());
                                this.f.touch();
                            }
                            break;
                        }
                        case 50: 
                        case 51: {
                            SortData data = this.getInfo(node.kid(0));
                            this.sortByRank(data);
                            this.sortByAlphabetic(data);
                            node.setKid(0, data.makeLirNode());
                            this.f.touch();
                            break;
                        }
                    }
                    q = q.next();
                }
                q = blk.instrList().first();
                while (!q.atEnd()) {
                    LirNode reconst;
                    node = (LirNode)q.elem();
                    String cmp = node.toString();
                    if (!cmp.equals((reconst = this.distribute(node)).toString())) {
                        q.setElem(reconst);
                        again = true;
                    }
                    q = q.next();
                }
                this.f.touch();
            }
            p = p.next();
        }
    }

    private LirNode distribute(LirNode node) {
        if (Type.tag(node.type) != 2) {
            return node;
        }
        LirNode result = node;
        if (node.opCode == 12 && (node.kid((int)0).opCode == 10 || node.kid((int)1).opCode == 10)) {
            LirNode kid1;
            LirNode kid0;
            SortData data0 = this.getInfo(node.kid(0));
            SortData data1 = this.getInfo(node.kid(1));
            if (data0.rank > data1.rank && node.kid((int)0).opCode == 10) {
                this.env.println("GRA : distribute " + node, 2000);
                kid0 = node.makeCopy(this.env.lir);
                kid1 = node.makeCopy(this.env.lir);
                kid0.setKid(0, node.kid(0).kid(0).makeCopy(this.env.lir));
                kid1.setKid(0, node.kid(0).kid(1).makeCopy(this.env.lir));
                result = this.env.lir.operator(node.kid((int)0).opCode, node.kid((int)0).type, kid0.makeCopy(this.env.lir), kid1.makeCopy(this.env.lir), ImList.Empty);
                this.env.println("GRA : ---> " + result, 2000);
            } else if (data0.rank < data1.rank && node.kid((int)1).opCode == 10) {
                this.env.println("GRA : distribute " + node, 2000);
                kid0 = node.makeCopy(this.env.lir);
                kid1 = node.makeCopy(this.env.lir);
                kid0.setKid(1, node.kid(1).kid(0).makeCopy(this.env.lir));
                kid1.setKid(1, node.kid(1).kid(1).makeCopy(this.env.lir));
                result = this.env.lir.operator(node.kid((int)1).opCode, node.kid((int)1).type, kid0.makeCopy(this.env.lir), kid1.makeCopy(this.env.lir), ImList.Empty);
                this.env.println("GRA : ---> " + result, 2000);
            }
        }
        for (int i = 0; i < result.nKids(); ++i) {
            result.setKid(i, this.distribute(result.kid(i)));
        }
        return result;
    }

    private void sortByRank(SortData data) {
        switch (data.opCode) {
            case 10: 
            case 12: 
            case 27: 
            case 28: 
            case 29: {
                SortData sd;
                BiList sorted = new BiList();
                SortData min = null;
                BiLink p = data.list.first();
                while (!p.atEnd()) {
                    Object obj = p.elem();
                    if (obj instanceof SortData) {
                        this.sortByRank((SortData)obj);
                    }
                    p = p.next();
                }
                if (Type.tag(data.type) != 2) {
                    return;
                }
                p = data.list.first();
                while (!p.atEnd()) {
                    sd = (SortData)p.elem();
                    this.sortByRank(sd);
                    if (min == null) {
                        min = sd;
                    } else if (min.rank > sd.rank) {
                        min = sd;
                    }
                    p = p.next();
                }
                sorted.add(min);
                p = data.list.first();
                while (!p.atEnd()) {
                    sd = (SortData)p.elem();
                    if (min != sd) {
                        boolean ins = false;
                        BiLink q = sorted.first();
                        while (!q.atEnd()) {
                            SortData target = (SortData)q.elem();
                            if (target.rank > sd.rank) {
                                q.addBefore(sd);
                                ins = true;
                                break;
                            }
                            q = q.next();
                        }
                        if (!ins) {
                            sorted.add(sd);
                        }
                    }
                    p = p.next();
                }
                data.list.clear();
                p = sorted.first();
                while (!p.atEnd()) {
                    data.list.add(p.elem());
                    p = p.next();
                }
                break;
            }
            default: {
                BiLink p = data.list.first();
                while (!p.atEnd()) {
                    Object obj = p.elem();
                    if (obj instanceof SortData) {
                        this.sortByRank((SortData)obj);
                    }
                    p = p.next();
                }
                break block0;
            }
        }
    }

    private void sortByAlphabetic(SortData data) {
        switch (data.opCode) {
            case 10: 
            case 12: 
            case 27: 
            case 28: 
            case 29: {
                BiList sorted = new BiList();
                BiList subList = new BiList();
                BiLink p = data.list.first();
                while (!p.atEnd()) {
                    Object obj = p.elem();
                    if (obj instanceof SortData) {
                        this.sortByAlphabetic((SortData)obj);
                    }
                    p = p.next();
                }
                if (Type.tag(data.type) != 2) {
                    return;
                }
                int currentRank = -1;
                BiLink p2 = data.list.first();
                while (!p2.atEnd()) {
                    SortData sd = (SortData)p2.elem();
                    if (sd.rank == currentRank) {
                        subList.add(sd);
                    } else {
                        this.sortSubList(subList, sorted);
                        subList = new BiList();
                        subList.add(sd);
                        currentRank = sd.rank;
                    }
                    p2 = p2.next();
                }
                this.sortSubList(subList, sorted);
                data.list.clear();
                p2 = sorted.first();
                while (!p2.atEnd()) {
                    data.list.add(p2.elem());
                    p2 = p2.next();
                }
                break;
            }
            default: {
                BiLink p = data.list.first();
                while (!p.atEnd()) {
                    Object obj = p.elem();
                    if (obj instanceof SortData) {
                        this.sortByAlphabetic((SortData)obj);
                    }
                    p = p.next();
                }
                break block0;
            }
        }
    }

    private void sortSubList(BiList subList, BiList sorted) {
        SortData sd;
        SortData min = null;
        BiLink p = subList.first();
        while (!p.atEnd()) {
            sd = (SortData)p.elem();
            if (min == null) {
                min = sd;
            } else if (min.toString().compareTo(sd.toString()) < 0) {
                min = sd;
            }
            p = p.next();
        }
        if (min == null) {
            return;
        }
        sorted.add(min);
        p = subList.first();
        while (!p.atEnd()) {
            sd = (SortData)p.elem();
            if (min != sd) {
                boolean ins = false;
                BiLink q = sorted.first();
                while (!q.atEnd()) {
                    SortData target = (SortData)q.elem();
                    if (target.rank == sd.rank && target.toString().compareTo(sd.toString()) > 0) {
                        q.addBefore(sd);
                        ins = true;
                        break;
                    }
                    q = q.next();
                }
                if (!ins) {
                    sorted.add(sd);
                }
            }
            p = p.next();
        }
    }

    private SortData getInfo(LirNode root) {
        if (root.nKids() == 0) {
            Integer integer = (Integer)this.rankMap.get(root);
            int rank = Integer.MAX_VALUE;
            if (integer != null) {
                rank = integer;
            } else {
                switch (root.opCode) {
                    case 61: {
                        return new SortData(rank, root.opCode, root.type);
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        rank = 0;
                    }
                }
            }
            return new SortData(rank, root.opCode, root.type, root);
        }
        SortData[] children = new SortData[root.nKids()];
        for (int i = 0; i < root.nKids(); ++i) {
            children[i] = this.getInfo(root.kid(i));
        }
        int maxRank = -1;
        for (int i = 0; i < children.length; ++i) {
            if (children[i].rank <= maxRank) continue;
            maxRank = children[i].rank;
        }
        SortData data = new SortData(maxRank, root.opCode, root.type);
        switch (root.opCode) {
            case 10: 
            case 12: 
            case 27: 
            case 28: 
            case 29: {
                for (int i = 0; i < children.length; ++i) {
                    if (root.opCode == children[i].opCode) {
                        BiLink p = children[i].list.first();
                        while (!p.atEnd()) {
                            data.list.add(p.elem());
                            p = p.next();
                        }
                        continue;
                    }
                    data.list.add(children[i]);
                }
                return data;
            }
        }
        for (int i = 0; i < children.length; ++i) {
            data.list.add(children[i]);
        }
        return data;
    }

    private void rewriteExp(LirNode parent, LirNode node, int place) {
        for (int i = 0; i < node.nKids(); ++i) {
            this.rewriteExp(node, node.kid(i), i);
        }
        switch (node.opCode) {
            case 11: {
                LirNode neg = this.env.lir.operator(9, node.kid((int)1).type, node.kid(1).makeCopy(this.env.lir), ImList.Empty);
                LirNode add = this.env.lir.operator(10, node.type, node.kid(0).makeCopy(this.env.lir), neg, ImList.Empty);
                parent.setKid(place, add);
                this.f.touch();
                break;
            }
        }
    }

    class SortData {
        final int rank;
        final int opCode;
        final int type;
        final BiList list;

        SortData(int r, int c, int t) {
            this.rank = r;
            this.opCode = c;
            this.type = t;
            this.list = new BiList();
        }

        SortData(int r, int c, int t, LirNode node) {
            this.rank = r;
            this.opCode = c;
            this.type = t;
            this.list = new BiList();
            this.list.add(node);
        }

        LirNode makeLirNode() {
            LirNode result = null;
            BiLink p = this.list.first();
            while (!p.atEnd()) {
                Object obj = p.elem();
                if (obj instanceof SortData) {
                    LirNode node = ((SortData)obj).makeLirNode();
                    p.setElem(node);
                }
                p = p.next();
            }
            switch (this.opCode) {
                case 9: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 30: 
                case 47: {
                    if (this.list.length() != 1) {
                        System.err.println("ERROR 1");
                        System.exit(1);
                    }
                    Object elem = (LirNode)this.list.first().elem();
                    result = ((GlobalReassociation)GlobalReassociation.this).env.lir.operator(this.opCode, this.type, ((LirNode)elem).makeCopy(((GlobalReassociation)GlobalReassociation.this).env.lir), ImList.Empty);
                    break;
                }
                case 10: 
                case 12: 
                case 27: 
                case 28: 
                case 29: {
                    Object elem = new LirNode[this.list.length()];
                    int i = 0;
                    BiLink p2 = this.list.first();
                    while (!p2.atEnd()) {
                        elem[i++] = (LirNode)p2.elem();
                        p2 = p2.next();
                    }
                    result = ((GlobalReassociation)GlobalReassociation.this).env.lir.operator(this.opCode, this.type, ((LirNode)elem[0]).makeCopy(((GlobalReassociation)GlobalReassociation.this).env.lir), ((LirNode)elem[1]).makeCopy(((GlobalReassociation)GlobalReassociation.this).env.lir), ImList.Empty);
                    for (i = 2; i < ((Object)elem).length; ++i) {
                        result = ((GlobalReassociation)GlobalReassociation.this).env.lir.operator(this.opCode, this.type, result, ((LirNode)elem[i]).makeCopy(((GlobalReassociation)GlobalReassociation.this).env.lir), ImList.Empty);
                    }
                    break;
                }
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    if (this.list.length() != 2) {
                        System.err.println("ERROR 2");
                        System.exit(1);
                    }
                    Object elem = new LirNode[2];
                    int i = 0;
                    BiLink p2 = this.list.first();
                    while (!p2.atEnd()) {
                        elem[i++] = (LirNode)p2.elem();
                        p2 = p2.next();
                    }
                    result = ((GlobalReassociation)GlobalReassociation.this).env.lir.operator(this.opCode, this.type, ((LirNode)elem[0]).makeCopy(((GlobalReassociation)GlobalReassociation.this).env.lir), ((LirNode)elem[1]).makeCopy(((GlobalReassociation)GlobalReassociation.this).env.lir), ImList.Empty);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    result = ((LirNode)this.list.first().elem()).makeCopy(((GlobalReassociation)GlobalReassociation.this).env.lir);
                    break;
                }
                case 61: {
                    Object elem = new LirNode[this.list.length()];
                    int i = 0;
                    BiLink p2 = this.list.first();
                    while (!p2.atEnd()) {
                        elem[i] = (LirNode)p2.elem();
                        ++i;
                        p2 = p2.next();
                    }
                    result = ((GlobalReassociation)GlobalReassociation.this).env.lir.operator(this.opCode, this.type, (LirNode[])elem, ImList.Empty);
                    break;
                }
            }
            return result;
        }

        public String toString() {
            String result = "[";
            result = result + Op.toName(this.opCode) + ",{";
            BiLink p = this.list.first();
            while (!p.atEnd()) {
                Object obj = p.elem();
                result = result + obj.toString();
                p = p.next();
            }
            result = result + "},(" + this.rank + ")] ";
            return result;
        }
    }
}

