/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.sym.Label;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;

class EdgeSplit
implements LocalTransformer {
    private SsaEnvironment env;
    private Function f;
    public static final int THR = 2000;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "EdgeSplit";
    }

    public String subject() {
        return "Split critical edges on SSA form.";
    }

    public EdgeSplit(SsaEnvironment e) {
        this.env = e;
        this.env.println("  Split Critical Edges", 100);
    }

    public boolean doIt(Function function, ImList args) {
        this.env.println("****************** doing ESPLT to " + function.symbol.name, 1000);
        this.f = function;
        BiLink p = this.f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            LirNode lastNode = (LirNode)blk.instrList().last().elem();
            if (lastNode.opCode == 50 || lastNode.opCode == 51) {
                Label[] succ = lastNode.getTargets();
                for (int i = 0; i < succ.length; ++i) {
                    if (succ[i].basicBlk().predList().length() <= 1) continue;
                    this.env.println("ESPLT : find critical edge " + blk.label() + " --> " + succ[i], 2000);
                    this.insertNewBlk(blk, succ[i].basicBlk());
                    this.f.touch();
                }
            }
            p = p.next();
        }
        this.env.println("", 2000);
        return true;
    }

    private void maintEdges(BasicBlk newBlk, BasicBlk fromBlk, BasicBlk toBlk) {
        newBlk.maintEdges();
        toBlk.maintEdges();
        fromBlk.maintEdges();
        this.env.println("ESPLT : insert " + newBlk.label() + " and maint edges " + fromBlk.label() + " --> " + newBlk.label() + " --> " + toBlk.label(), 2000);
    }

    private void insertNewBlk(BasicBlk fromBlk, BasicBlk toBlk) {
        BasicBlk newBlk = this.f.flowGraph().insertNewBlkBefore(toBlk);
        LirNode newJump = (LirNode)newBlk.instrList().last().elem();
        LirLabelRef newLab = (LirLabelRef)this.env.lir.labelRefVariant(((LirLabelRef)newJump.kid((int)0)).label);
        newJump.setKid(0, newLab);
        LirNode jumpNode = (LirNode)fromBlk.instrList().last().elem();
        Label lab1 = toBlk.label();
        if (jumpNode.opCode == 50) {
            for (int j = 1; j < jumpNode.nKids(); ++j) {
                LirLabelRef orgLab = (LirLabelRef)jumpNode.kid(j);
                Label lab2 = orgLab.label;
                if (lab1.basicBlk() != lab2.basicBlk()) continue;
                LirNode newLabel = this.env.lir.labelRefVariant(newBlk.label());
                jumpNode.setKid(j, newLabel);
                this.maintPhiParam(newLab, orgLab, toBlk, newBlk.label());
                this.maintEdges(newBlk, fromBlk, toBlk);
                break;
            }
        } else {
            boolean changed = false;
            for (int j = 0; j < jumpNode.kid(1).nKids(); ++j) {
                LirLabelRef orgLab = (LirLabelRef)jumpNode.kid(1).kid(j).kid(1);
                Label lab2 = orgLab.label;
                if (lab1.basicBlk() != lab2.basicBlk()) continue;
                LirNode newLabel = this.env.lir.labelRefVariant(newBlk.label());
                jumpNode.kid(1).kid(j).setKid(1, newLabel);
                this.maintPhiParam(newLab, orgLab, toBlk, newBlk.label());
                this.maintEdges(newBlk, fromBlk, toBlk);
                changed = true;
                break;
            }
            if (!changed) {
                LirLabelRef orgLab = (LirLabelRef)jumpNode.kid(2);
                Label lab2 = orgLab.label;
                if (lab1.basicBlk() == lab2.basicBlk()) {
                    LirNode newLabel = this.env.lir.labelRefVariant(newBlk.label());
                    jumpNode.setKid(2, newLabel);
                    this.maintPhiParam(newLab, orgLab, toBlk, newBlk.label());
                    this.maintEdges(newBlk, fromBlk, toBlk);
                }
            }
        }
    }

    private void maintPhiParam(LirLabelRef newLab, LirLabelRef orgLab, BasicBlk blk, Label label) {
        BiLink p = blk.instrList().first();
        while (!p.atEnd()) {
            LirNode node = (LirNode)p.elem();
            if (node.opCode == 59) {
                for (int i = 1; i < node.nKids(); ++i) {
                    LirNode args = node.kid(i);
                    LirLabelRef edge = (LirLabelRef)args.kid(2);
                    LirLabelRef labInPhi = (LirLabelRef)args.kid(2);
                    if (labInPhi != orgLab) continue;
                    args.setKid(1, this.env.lir.labelRefVariant(label));
                    args.setKid(2, newLab);
                }
            }
            p = p.next();
        }
    }
}

