/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;
import coins.ssa.SsaSymTab;

class DivideExpression
implements LocalTransformer {
    private SsaEnvironment env;
    private SsaSymTab sstab;
    public static final int THR = 2000;
    public static final String DIVEX = "_divex";

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "DivideExpression";
    }

    public String subject() {
        return "Divide expression into three adress code on SSA form.";
    }

    public DivideExpression(SsaEnvironment e, SsaSymTab symtab) {
        this.env = e;
        this.sstab = symtab;
        this.env.println("  Divide Expressions into 3 Address Expression", 100);
    }

    public boolean doIt(Function f, ImList args) {
        this.env.println("****************** doing DIVEX to " + f.symbol.name, 1000);
        BiLink p = f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                q.setElem(this.divide(node, q, false, false));
                q = q.next();
            }
            p = p.next();
        }
        this.env.println("", 2000);
        f.touch();
        return true;
    }

    LirNode divide(LirNode node, BiLink link, boolean setSrc, boolean setDst) {
        LirNode result;
        switch (node.opCode) {
            case 47: {
                LirNode leftNode = this.divide(node.kid(0), link, false, false);
                LirNode oper = this.env.lir.operator(node.opCode, node.type, leftNode, node.opt);
                if (setDst) {
                    result = oper;
                    break;
                }
                Symbol dstSym = this.sstab.newSsaSymbol(DIVEX, node.type);
                if (dstSym != null) {
                    result = this.env.lir.symRef(6, dstSym.type, dstSym, ImList.Empty);
                    LirNode dst = this.env.lir.operator(48, node.type, result, oper, node.opt);
                    link.addBefore(dst);
                    break;
                }
                result = oper;
                break;
            }
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: {
                LirNode oper;
                LirNode leftNode = this.divide(node.kid(0), link, false, false);
                result = oper = this.env.lir.operator(node.opCode, node.type, leftNode, node.opt);
                if (setSrc) {
                    result = oper;
                    break;
                }
                Symbol dstSym = this.sstab.newSsaSymbol(DIVEX, node.type);
                if (dstSym != null) {
                    result = this.env.lir.symRef(6, dstSym.type, dstSym, ImList.Empty);
                    LirNode dst = this.env.lir.operator(48, node.type, result, oper, node.opt);
                    link.addBefore(dst);
                    break;
                }
                result = oper;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                LirNode leftNode = this.divide(node.kid(0), link, false, false);
                LirNode rightNode = this.divide(node.kid(1), link, false, false);
                LirNode oper = this.env.lir.operator(node.opCode, node.type, leftNode, rightNode, node.opt);
                if (setSrc) {
                    result = oper;
                    break;
                }
                Symbol dstSym = this.sstab.newSsaSymbol(DIVEX, node.type);
                if (dstSym != null) {
                    result = this.env.lir.symRef(6, dstSym.type, dstSym, ImList.Empty);
                    LirNode dst = this.env.lir.operator(48, node.type, result, oper, node.opt);
                    link.addBefore(dst);
                    break;
                }
                result = oper;
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                result = node.makeCopy(this.env.lir);
                result.setKid(0, this.divide(result.kid(0), link, false, false));
                result.setKid(1, this.divide(result.kid(1), link, false, false));
                break;
            }
            case 48: {
                Symbol dstSym;
                result = node.makeCopy(this.env.lir);
                LirNode n = this.divide(result.kid(1), link, true, false);
                if (result.kid((int)0).opCode == 47 && n.opCode != 6 && (dstSym = this.sstab.newSsaSymbol(DIVEX, n.type)) != null) {
                    LirNode nn = this.env.lir.symRef(6, dstSym.type, dstSym, ImList.Empty);
                    LirNode newNode = this.env.lir.operator(48, n.type, nn, n, ImList.Empty);
                    link.addBefore(newNode);
                    n = nn.makeCopy(this.env.lir);
                }
                result.setKid(1, n);
                result.setKid(0, this.divide(result.kid(0), link, false, true));
                break;
            }
            case 53: {
                result = node.makeCopy(this.env.lir);
                result.setKid(0, this.divide(result.kid(0), link, false, false));
                result.setKid(1, this.divide(result.kid(1), link, false, false));
                result.setKid(2, this.divide(result.kid(2), link, false, true));
                break;
            }
            case 50: {
                result = node.makeCopy(this.env.lir);
                result.setKid(0, this.divide(result.kid(0), link, false, false));
                break;
            }
            case 51: {
                result = node.makeCopy(this.env.lir);
                result.setKid(0, this.divide(result.kid(0), link, false, false));
                break;
            }
            case 61: {
                result = node.makeCopy(this.env.lir);
                for (int i = 0; i < result.nKids(); ++i) {
                    result.setKid(i, this.divide(result.kid(i), link, setSrc, setDst));
                }
                break;
            }
            case 4: 
            case 5: {
                if (this.env.opt.isSet("ssa-extend-divex")) {
                    Symbol dstSym = this.sstab.newSsaSymbol(DIVEX, node.type);
                    result = this.env.lir.symRef(6, dstSym.type, dstSym, ImList.Empty);
                    LirNode dst = this.env.lir.operator(48, node.type, result, node.makeCopy(this.env.lir), node.opt);
                    link.addBefore(dst);
                    break;
                }
            }
            default: {
                result = node.makeCopy(this.env.lir);
            }
        }
        return result.makeCopy(this.env.lir);
    }
}

