/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;
import java.util.Hashtable;
import java.util.Stack;

class CopyPropagation
implements LocalTransformer {
    private SsaEnvironment env;
    public static final int THR = 2000;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "CopyPropagation";
    }

    public String subject() {
        return "Copy propagation on SSA form.";
    }

    public CopyPropagation(SsaEnvironment e) {
        this.env = e;
        this.env.println("  Copy Propagation on SSA form", 100);
    }

    public boolean doIt(Function function, ImList args) {
        LirNode node;
        BiLink q;
        BasicBlk blk;
        this.env.println("****************** doing CPYP to " + function.symbol.name, 1000);
        FlowGraph g = function.flowGraph();
        Hashtable<Symbol, Symbol> variableMap = new Hashtable<Symbol, Symbol>();
        BiLink p = g.basicBlkList.first();
        while (!p.atEnd()) {
            blk = (BasicBlk)p.elem();
            q = blk.instrList().first();
            while (!q.atEnd()) {
                node = (LirNode)q.elem();
                if (node.opCode == 48 && node.kid((int)0).opCode == 6 && node.kid((int)1).opCode == 6) {
                    Symbol key = ((LirSymRef)node.kid((int)0)).symbol;
                    Symbol val = ((LirSymRef)node.kid((int)1)).symbol;
                    if (variableMap.containsKey(key)) {
                        System.err.println("CopyPropagation.java : There is not SSA form");
                        System.exit(1);
                    }
                    Symbol s = val;
                    while ((s = (Symbol)variableMap.get(s)) != null) {
                        val = s;
                    }
                    variableMap.put(key, val);
                    q.unlink();
                    g.touch();
                    this.env.println("CPYP : remove " + node + " in block " + blk.id, 2000);
                }
                q = q.next();
            }
            p = p.next();
        }
        p = g.basicBlkList.first();
        while (!p.atEnd()) {
            blk = (BasicBlk)p.elem();
            q = blk.instrList().first();
            while (!q.atEnd()) {
                node = (LirNode)q.elem();
                Stack<LirNode> stack = new Stack<LirNode>();
                stack.push(node);
                while (!stack.empty()) {
                    LirNode n = (LirNode)stack.pop();
                    for (int i = 0; i < n.nKids(); ++i) {
                        if (n.kid((int)i).opCode == 6) {
                            Symbol s = ((LirSymRef)n.kid((int)i)).symbol;
                            Symbol newSym = null;
                            while (variableMap.get(s) != null) {
                                newSym = (Symbol)variableMap.get(s);
                                if (newSym == null) {
                                    newSym = s;
                                    break;
                                }
                                s = newSym;
                            }
                            if (newSym == null) continue;
                            this.env.println("CPYP : in " + node + " in block " + blk.id, 2000);
                            this.env.print("CPYP : " + n.kid(i) + " ---> ", 2000);
                            LirNode newNode = this.env.lir.symRef(n.kid((int)i).opCode, n.kid((int)i).type, newSym, ImList.Empty);
                            n.setKid(i, newNode);
                            this.env.println(n.kid(i).toString(), 2000);
                            g.touch();
                            continue;
                        }
                        stack.push(n.kid(i));
                    }
                }
                q = q.next();
            }
            p = p.next();
        }
        this.env.println("", 2000);
        return true;
    }
}

