/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.ana.InterferenceGraph;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;
import java.util.Stack;

class Coalescing
implements LocalTransformer {
    private SsaEnvironment env;
    public static final int THR = 2000;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "Coalescing";
    }

    public String subject() {
        return "Coalesce variables.";
    }

    public Coalescing(SsaEnvironment e) {
        this.env = e;
        this.env.println("  Coalescing by Chaitin", 100);
    }

    public boolean doIt(Function function, ImList args) {
        this.env.println("****************** doing CHAIC to " + function.symbol.name, 1000);
        FlowGraph g = function.flowGraph();
        Symbol dst = null;
        Symbol src = null;
        boolean changed = true;
        while (changed) {
            BasicBlk blk;
            changed = false;
            BiLink p = g.basicBlkList.first();
            while (!p.atEnd()) {
                blk = (BasicBlk)p.elem();
                boolean flag = false;
                BiLink q = blk.instrList().first();
                while (!q.atEnd()) {
                    src = null;
                    dst = null;
                    LirNode node = (LirNode)q.elem();
                    if (node.opCode == 48 && node.kid((int)0).opCode == 6 && node.kid((int)1).opCode == 6) {
                        dst = ((LirSymRef)node.kid((int)0)).symbol;
                        src = ((LirSymRef)node.kid((int)1)).symbol;
                        InterferenceGraph ig = (InterferenceGraph)function.require(InterferenceGraph.analyzer);
                        if (!ig.interfere(src, dst)) {
                            this.env.println("CHAIC : remove " + node + " in block " + blk.id, 2000);
                            q.unlink();
                            g.touch();
                            changed = true;
                            flag = true;
                            break;
                        }
                    }
                    q = q.next();
                }
                if (flag) break;
                p = p.next();
            }
            if (dst == null || src == null) continue;
            p = g.basicBlkList.first();
            while (!p.atEnd()) {
                blk = (BasicBlk)p.elem();
                BiLink q = blk.instrList().first();
                while (!q.atEnd()) {
                    LirNode node = (LirNode)q.elem();
                    Stack<LirNode> stack = new Stack<LirNode>();
                    stack.push(node);
                    while (!stack.empty()) {
                        LirNode n = (LirNode)stack.pop();
                        for (int i = 0; i < n.nKids(); ++i) {
                            if (n.kid((int)i).opCode == 6) {
                                Symbol s = ((LirSymRef)n.kid((int)i)).symbol;
                                if (!s.equals(dst)) continue;
                                this.env.println("CHAIC : in " + node, 2000);
                                this.env.print("CHAIC : " + n.kid(i) + " ---> ", 2000);
                                LirNode newNode = this.env.lir.symRef(n.kid((int)i).opCode, n.kid((int)i).type, src, ImList.Empty);
                                n.setKid(i, newNode);
                                this.env.println(n.kid(i) + " in block " + blk.id, 2000);
                                g.touch();
                                continue;
                            }
                            stack.push(n.kid(i));
                        }
                    }
                    q = q.next();
                }
                p = p.next();
            }
        }
        this.env.println("", 2000);
        return true;
    }
}

