/*
 * Decompiled with CFR 0.152.
 */
package coins.snapshot;

import coins.aflow.BBlock;
import coins.aflow.BBlockSubtreeIterator;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.IfStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SwitchStmt;
import coins.lir2c.Convert;
import coins.snapshot.ExpTag;

class StatementType {
    static final int HIR = 0;
    static final int LIR = 1;
    static final int HIR2C = 2;
    static final int LIR2C = 3;
    private BiList exp;

    static StatementType hir(BBlockSubtreeIterator subtreeIte) {
        return new StatementType(0, subtreeIte);
    }

    static StatementType lir(BiList instr) {
        return new StatementType(1, instr);
    }

    static StatementType lir2c(BiList instr) {
        return new StatementType(3, instr);
    }

    static StatementType mdf(BBlock[] blks) {
        return new StatementType(0, blks);
    }

    private StatementType(int type, BiList instr) {
        this.exp = new BiList();
        int currentLine = -1;
        BiLink p = instr.first();
        while (!p.atEnd()) {
            LirNode node = (LirNode)p.elem();
            if (node.opCode == 65) {
                currentLine = (int)((LirIconst)node.kid((int)0)).value;
            } else {
                switch (type) {
                    case 1: {
                        this.exp.add(new ExpTag(node.toString(), currentLine));
                        break;
                    }
                    case 3: {
                        Convert conv = new Convert();
                        String str = conv.invoke(node);
                        if (str.equals("")) break;
                        this.exp.add(new ExpTag(str, currentLine));
                        break;
                    }
                }
                currentLine = -1;
            }
            p = p.next();
        }
    }

    private StatementType(int type, BBlockSubtreeIterator ite) {
        this.exp = this.getHir(type, ite, new BiList());
    }

    private StatementType(int type, BBlock[] blks) {
        this.exp = new BiList();
        for (int i = 0; i < blks.length; ++i) {
            this.exp = this.getHir(type, blks[i].bblockSubtreeIterator(), this.exp);
        }
    }

    private BiList getHir(int type, BBlockSubtreeIterator ite, BiList exp) {
        while (ite.hasNext()) {
            HIR node = (HIR)ite.next();
            int currentLine = -1;
            boolean shortTerm = false;
            if (node instanceof Stmt) {
                if (node instanceof BlockStmt || node instanceof LabeledStmt || node instanceof IfStmt || node instanceof SwitchStmt || node instanceof LoopStmt) {
                    shortTerm = true;
                }
                currentLine = ((Stmt)node).getLineNumber();
            }
            if (currentLine == 0) {
                currentLine = -1;
            }
            switch (type) {
                case 0: {
                    if (shortTerm) {
                        exp.add(new ExpTag(((Object)node).toString(), currentLine));
                        break;
                    }
                    exp.add(new ExpTag(node.toStringWithChildren(), currentLine));
                }
            }
        }
        return exp;
    }

    public String toString(int space) {
        String str = "";
        BiLink p = this.exp.first();
        while (!p.atEnd()) {
            ExpTag eTag = (ExpTag)p.elem();
            str = str + eTag.toString(space) + "\n";
            p = p.next();
        }
        return str;
    }

    public String toString() {
        return this.toString(0);
    }
}

