/*
 * Decompiled with CFR 0.152.
 */
package coins.snapshot;

import coins.HirRoot;
import coins.PassException;
import coins.backend.Module;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.mdf.MdfModule;
import coins.snapshot.ModuleTag;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class SnapShot {
    public static final String TMP_FILE_NAME = "coins.xml";
    public static final String TMP_NAME = "coins snapshot";
    private PrintWriter output;
    private final File source;
    private BiList modules;
    private String name;

    public SnapShot(File sourceFile, String snapName) {
        this.source = sourceFile;
        String sourceName = this.source.getAbsolutePath();
        String outputFileName = sourceName.substring(0, sourceName.lastIndexOf(46)) + ".xml";
        try {
            this.output = new PrintWriter(new FileOutputStream(outputFileName), true);
        }
        catch (Exception e) {
            this.output = new PrintWriter(System.out, true);
        }
        this.modules = new BiList();
        this.name = snapName.intern();
    }

    public void shot(Module m, String mName) {
        ModuleTag mTag = new ModuleTag(m, mName, this.source.getAbsolutePath());
        this.modules.add(mTag);
    }

    public void shot(HirRoot hirRoot, String mName) {
        ModuleTag mTag = new ModuleTag(hirRoot, mName, this.source.getAbsolutePath());
        this.modules.add(mTag);
    }

    public void shot(MdfModule m, String mName) throws PassException {
        ModuleTag mTag = new ModuleTag(m, mName, this.source.getAbsolutePath());
        this.modules.add(mTag);
    }

    public void generateXml() {
        this.output.println(this.toString());
    }

    public String toString() {
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
        str = str + "<program name=\"" + this.name + "\"\n" + "         xmlns=\"coins\"\n" + "         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n" + "         xsi:schemaLocation=\"coins ./coins.xsd\">\n";
        BiLink p = this.modules.first();
        while (!p.atEnd()) {
            ModuleTag mTag = (ModuleTag)p.elem();
            str = str + mTag.toString(1);
            p = p.next();
        }
        str = str + "</program>\n";
        return str;
    }
}

