/*
 * Decompiled with CFR 0.152.
 */
package coins.snapshot;

import coins.PassException;
import coins.aflow.BBlock;
import coins.aflow.SubpFlow;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.mdf.MacroFlowGraph;
import coins.mdf.MacroTask;
import coins.snapshot.NodeTag;
import java.util.Iterator;
import java.util.ListIterator;

class GraphTag {
    private BiList nodes;
    private final String displayName;

    GraphTag(String dName, FlowGraph cfg) {
        this.displayName = dName;
        this.nodes = new BiList();
        BiLink p = cfg.basicBlkList.first();
        while (!p.atEnd()) {
            this.nodes.add(new NodeTag(dName, (BasicBlk)p.elem()));
            p = p.next();
        }
    }

    GraphTag(String dName, SubpFlow cfg) {
        this.displayName = dName;
        this.nodes = new BiList();
        Iterator ite = cfg.getReachableBBlocks().iterator();
        while (ite.hasNext()) {
            this.nodes.add(new NodeTag(dName, (BBlock)ite.next()));
        }
    }

    GraphTag(String dName, MacroFlowGraph mfg) throws PassException {
        this.displayName = dName;
        this.nodes = new BiList();
        ListIterator ite = mfg.listIterator();
        while (ite.hasNext()) {
            this.nodes.add(new NodeTag(dName, (MacroTask)ite.next()));
        }
    }

    private String displayName() {
        return "\"" + this.displayName + "\"";
    }

    public String toString(int space) {
        String ws = "";
        for (int i = 0; i < space; ++i) {
            ws = ws + "  ";
        }
        String str = "";
        str = str + ws + "<" + "graph" + " " + "displayName" + "=" + this.displayName() + ">\n";
        BiLink p = this.nodes.first();
        while (!p.atEnd()) {
            NodeTag nTag = (NodeTag)p.elem();
            str = str + nTag.toString(space + 1);
            p = p.next();
        }
        str = str + ws + "</" + "graph" + ">\n";
        return str;
    }

    public String toString() {
        return this.toString(0);
    }
}

