/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.Type;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.util.ImList;
import coins.simd.BoundanalysisDwForLir;
import coins.util.IntConst;
import coins.util.IntLive;

public class SizeConv {
    private BoundanalysisDwForLir badw;
    private Function function;
    private LirFactory factory;

    SizeConv(Function f, BoundanalysisDwForLir bd) {
        this.badw = bd;
        this.function = f;
        this.factory = f.newLir;
    }

    public LirNode convert(LirNode ins) {
        if (ins.opCode != 48) {
            return ins;
        }
        LirNode insbody = this.reduce(this.convert2(ins.kid(1), ins.type));
        return this.factory.operator(ins.opCode, ins.type, ins.kid(0), insbody, ImList.Empty);
    }

    private LirNode convert2(LirNode ins, int ty) {
        if (ins.opCode == 2) {
            if (Type.bits(this.intToType(ins)) < Type.bits(ty)) {
                return this.factory.operator(17, ins.type, this.factory.operator(19, ty, ins, ImList.Empty), ImList.Empty);
            }
            return this.factory.operator(17, ins.type, this.factory.operator(19, this.intToType(ins), ins, ImList.Empty), ImList.Empty);
        }
        IntLive lv = this.badw.get(ins);
        if (lv == null) {
            throw new IllegalArgumentException(ins.toString() + "has no value");
        }
        int tp = this.bitsToType(lv);
        if (Type.bits(tp) < Type.bits(ty)) {
            tp = ty;
        }
        if (ins.opCode == 47 || ins.opCode == 6 || ins.opCode == 5) {
            if (Type.bits(ins.type) <= Type.bits(tp)) {
                return ins;
            }
            return this.factory.operator(17, ins.type, this.factory.operator(19, tp, ins, ImList.Empty), ImList.Empty);
        }
        LirNode[] children = new LirNode[ins.nKids()];
        for (int i = 0; i < ins.nKids(); ++i) {
            children[i] = this.convert2(ins.kid(i), tp);
        }
        if (Type.bits(ins.type) <= Type.bits(tp)) {
            return this.operator(ins.opCode, ins.type, children, ImList.Empty);
        }
        return this.factory.operator(17, ins.type, this.factory.operator(19, tp, this.operator(ins.opCode, ins.type, children, ImList.Empty), ImList.Empty), ImList.Empty);
    }

    private int bitsToType(IntLive lv) {
        try {
            return Type.decode("I" + this.adjustTypenum(this.leftmostPos(lv)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Type generation error:" + lv.toString());
        }
    }

    private int adjustTypenum(int n) {
        if (n > 128) {
            throw new IllegalArgumentException("Too large type" + n);
        }
        if (n > 64) {
            return 128;
        }
        if (n > 32) {
            return 64;
        }
        if (n > 16) {
            return 32;
        }
        if (n > 8) {
            return 16;
        }
        return 8;
    }

    private int leftmostPos(IntLive lv) {
        int i;
        IntConst c = lv.intConstValue();
        IntConst t = IntConst.valueOf(c.size(), 1L).lsh(i);
        for (i = c.size() - 1; i >= 0 && !t.band(c).equals(t); --i) {
            t = t.rshu(1);
        }
        return i;
    }

    private LirNode operator(int c, int t, LirNode[] srcs, ImList opt) {
        int size = srcs.length;
        if (size == 0) {
            throw new IllegalArgumentException("No children.");
        }
        if (size == 1) {
            return this.factory.operator(c, t, srcs[0], opt);
        }
        if (size == 2) {
            return this.factory.operator(c, t, srcs[0], srcs[1], opt);
        }
        return this.factory.operator(c, t, srcs, opt);
    }

    private LirNode reduce(LirNode ins) {
        return this.redSimpleConv(this.reduce2(ins, ins.type));
    }

    private LirNode reduce2(LirNode ins, int ty) {
        if (ins.opCode == 2 || ins.opCode == 6 || ins.opCode == 47 || ins.opCode == 5) {
            return this.chngType(ins, ty);
        }
        if (this.reducible(ins)) {
            return this.reduce3(ins, ty);
        }
        LirNode[] children = new LirNode[ins.nKids()];
        for (int i = 0; i < ins.nKids(); ++i) {
            children[i] = this.reduce2(ins.kid(i), ty);
        }
        return this.operator(ins.opCode, ty, children, ImList.Empty);
    }

    private LirNode reduce3(LirNode ins, int ty) {
        if (ins.opCode != 19) {
            throw new IllegalArgumentException("reduce3" + ins.toString());
        }
        LirNode inschild = ins.kid(0);
        LirNode[] children = new LirNode[inschild.nKids()];
        if (Type.bits(ins.type) < Type.bits(ty)) {
            ty = ins.type;
        }
        for (int i = 0; i < inschild.nKids(); ++i) {
            children[i] = this.reduce4(inschild.kid(i), ty);
        }
        return this.operator(inschild.opCode, ty, children, ImList.Empty);
    }

    private LirNode reduce4(LirNode ins, int ty) {
        if (ins.opCode == 2 || ins.opCode == 6 || ins.opCode == 47 || ins.opCode == 5) {
            return this.chngType(ins, ty);
        }
        if (ins.opCode != 17) {
            throw new IllegalArgumentException("reduce4" + ins.toString());
        }
        return this.reduce2(ins.kid(0), ty);
    }

    private LirNode chngType(LirNode ins, int ty) {
        switch (ins.opCode) {
            case 2: {
                if (Type.bits(ins.type) != Type.bits(ty)) {
                    return this.factory.iconst(ty, ((LirIconst)ins).value, ins.opt);
                }
                return ins;
            }
            case 5: 
            case 6: 
            case 47: {
                if (Type.bits(ins.type) < Type.bits(ty)) {
                    LirNode[] children = new LirNode[]{ins};
                    return this.factory.operator(17, ty, children, ImList.Empty);
                }
                if (Type.bits(ins.type) > Type.bits(ty)) {
                    LirNode[] children = new LirNode[]{ins};
                    return this.factory.operator(19, ty, children, ImList.Empty);
                }
                return ins;
            }
        }
        throw new IllegalArgumentException("chngType" + ins.toString());
    }

    private boolean reducible(LirNode ins) {
        if (ins.opCode == 19) {
            if (ins.kid((int)0).opCode == 2 || ins.kid((int)0).opCode == 6 || ins.kid((int)0).opCode == 47 || ins.kid((int)0).opCode == 5) {
                return false;
            }
            if (ins.kid((int)0).opCode == 31 || ins.kid((int)0).opCode == 32 || ins.kid((int)0).opCode == 33 || ins.kid((int)0).opCode == 34) {
                return ins.kid((int)0).kid((int)0).opCode == 17;
            }
            for (int i = 0; i < ins.kid(0).nKids(); ++i) {
                if (ins.kid((int)0).kid((int)i).opCode == 17) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private LirNode redSimpleConv(LirNode ins) {
        LirNode nxt;
        if (ins.opCode == 2 || ins.opCode == 6 || ins.opCode == 47 || ins.opCode == 5) {
            return ins;
        }
        if (this.isCONV(ins) && ins.type == ins.kid((int)0).type) {
            return this.redSimpleConv(ins.kid(0));
        }
        if (ins.opCode == 19) {
            nxt = ins.kid(0);
            if ((nxt.opCode == 17 || nxt.opCode == 18) && ins.type == nxt.kid((int)0).type) {
                return this.redSimpleConv(nxt.kid(0));
            }
            if (nxt.opCode == 2 && Type.bits(ins.type) < Type.bits(nxt.type)) {
                return this.factory.iconst(ins.type, ((LirIconst)nxt).value, ImList.Empty);
            }
        }
        if (ins.opCode == 17) {
            nxt = ins.kid(0);
            if (nxt.opCode == 19 && ins.type == nxt.type) {
                return this.redSimpleConv(nxt.kid(0));
            }
        }
        LirNode[] children = new LirNode[ins.nKids()];
        for (int i = 0; i < ins.nKids(); ++i) {
            children[i] = this.redSimpleConv(ins.kid(i));
        }
        return this.operator(ins.opCode, ins.type, children, ImList.Empty);
    }

    private boolean isCONV(LirNode exp) {
        return exp.opCode == 19 || exp.opCode == 17 || exp.opCode == 18;
    }

    private int intToType(LirNode ins) {
        if (!(ins instanceof LirIconst)) {
            throw new IllegalArgumentException("Not LirIconst:" + ins.toString());
        }
        LirIconst ic = (LirIconst)ins;
        IntConst c = IntConst.valueOf(Type.bits(ic.type), ic.value);
        IntLive lv = IntLive.valueOf(c);
        return this.bitsToType(lv);
    }
}

