/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.IoRoot;
import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Module;
import coins.backend.SyntaxError;
import coins.backend.ana.LiveVariableAnalysis;
import coins.backend.ana.LiveVariableSlotwise;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.opt.JumpOpt;
import coins.backend.sym.Label;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.driver.CompileSpecification;
import coins.simd.AlignmentTest;
import coins.simd.BoundanalysisForLir;
import coins.simd.ConstantFolding;
import coins.simd.GenerateDag;
import coins.simd.IfConvert;
import coins.simd.LirUtil;
import coins.simd.ReplaceRegNames;
import coins.simd.SimdEnvironment;
import coins.simd.SimdEstimation;
import coins.simd.SimdOpt;
import coins.simd.SimdOptException;
import coins.simd.Util;
import coins.ssa.PublicSsa;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Vector;

public class SimdDriver
implements LocalTransformer {
    public final IoRoot ioRoot;
    public static final int THR = 100;
    private SimdEnvironment env;
    private boolean alignmentTestOption = false;
    private boolean memAccessOverlappingTestOption = false;
    private boolean simdEstimationOption = false;
    private BiList copiedBlkInfo;
    private int addrtype;
    private ImList optDefault = ImList.Empty;
    private Vector savedInstrLists;
    private Vector savedLabelList;
    private HashMap labelMap = new HashMap();

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "SimdDriver";
    }

    public String subject() {
        return "SIMD optimizations";
    }

    public SimdDriver(Module m, IoRoot io, CompileSpecification coinsSpec) {
        this.ioRoot = io;
        PrintWriter out = new PrintWriter(io.printOut, true);
        this.env = new SimdEnvironment(m, coinsSpec, out);
        this.addrtype = m.targetMachine.typeAddress;
        this.alignmentTestOption |= this.memAccessOverlappingTestOption;
        this.savedInstrLists = new Vector();
        this.savedLabelList = new Vector();
    }

    public boolean doIt(Function f, ImList args) {
        AlignmentTest aligntest;
        BiList aligns;
        this.setOptions();
        this.saveBasicBlkInfo(f);
        boolean simdrslt = this.callSimdOpt(f, args);
        if (simdrslt && (this.getTestOption("alignmentTest") || this.getTestOption("memAccessOverlappingTest")) && !(aligns = (aligntest = new AlignmentTest(f)).doIt()).isEmpty()) {
            Label simdlabel = this.genLabel(f, ".simdlabel");
            LirNode simdlabelRef = f.newLir.labelRef(simdlabel);
            Label nosimdlabel = this.genLabel(f, ".nosimdlabel");
            LirNode nosimdlabelRef = f.newLir.labelRef(nosimdlabel);
            this.makeSimdBlkList(f, simdlabel);
            this.insertNosimdBlks(f);
            BasicBlk condBlk = this.makeCondBlk(f, aligntest, aligns, simdlabelRef, nosimdlabelRef);
            BasicBlk nosimdfstblk = (BasicBlk)f.flowGraph().basicBlkList.first().next().elem();
            LirNode prologue = (LirNode)nosimdfstblk.instrList().takeFirst();
            condBlk.instrList().addFirst(prologue);
            nosimdfstblk.setLabel(nosimdlabel);
            nosimdlabel.setBasicBlk(nosimdfstblk);
            BiLink bp = f.flowGraph().basicBlkList.first();
            while (!bp.atEnd()) {
                BasicBlk blk = (BasicBlk)bp.elem();
                blk.maintEdges();
                bp = bp.next();
            }
            f.flowGraph().touch();
            f.flowGraph().dfstOrder();
            f.lirList();
        }
        return true;
    }

    private void setOptions() {
        String optstr = this.env.opt.getArg("simd");
        BiList options = this.decodeOptions(optstr);
        if (this.containsStr(options, "memAccessOverlappingTestOption")) {
            this.memAccessOverlappingTestOption = true;
        }
        if (this.containsStr(options, "alignmentTestOption")) {
            this.alignmentTestOption = true;
        }
        if (this.containsStr(options, "simdEstimationOption")) {
            this.simdEstimationOption = true;
        }
    }

    private boolean containsStr(BiList s, String str) {
        BiLink p = s.first();
        while (!p.atEnd()) {
            if (str.equals((String)p.elem())) {
                return true;
            }
            p = p.next();
        }
        return false;
    }

    private BiList decodeOptions(String options) {
        int delimiter = 47;
        BiList optionString = new BiList();
        int beginIndex = 0;
        int length = options.length();
        for (int endIndex = 0; endIndex <= length; ++endIndex) {
            beginIndex = endIndex;
            if ((endIndex = options.indexOf(47, beginIndex)) == -1) {
                endIndex = length;
            }
            if (endIndex <= beginIndex) continue;
            String opt = options.substring(beginIndex, endIndex);
            opt = opt.trim();
            optionString.add(opt);
        }
        return optionString;
    }

    public boolean callSimdOpt(Function f, ImList args) {
        boolean simdrslt;
        IfConvert ifConvert = new IfConvert(this.env, f);
        ifConvert.invoke();
        f.apply(JumpOpt.trig);
        HashMap<BasicBlk, BiList> blkContents = new HashMap<BasicBlk, BiList>();
        BiLink p = f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiList instrs = blk.instrList().copy();
            BiLink q = instrs.first();
            while (!q.atEnd()) {
                LirNode ins = (LirNode)q.elem();
                q.setElem(ins.makeCopy(f.newLir));
                q = q.next();
            }
            blkContents.put(blk, instrs);
            p = p.next();
        }
        try {
            PublicSsa ssa = new PublicSsa(f, this.ioRoot);
            ssa.translate();
            GenerateDag generateDag = new GenerateDag(this.env, f);
            ssa.backTranslate();
            BiLink p2 = f.flowGraph().basicBlkList.first();
            while (!p2.atEnd()) {
                BasicBlk blk = (BasicBlk)p2.elem();
                ReplaceRegNames rrn = new ReplaceRegNames(f);
                rrn.toNewName(blk);
                BoundanalysisForLir ba = new BoundanalysisForLir(f);
                ba.invoke(blk);
                ConstantFolding constFold = new ConstantFolding(f);
                constFold.invoke(blk);
                if (!blk.instrList().isEmpty()) {
                    Vector vs = Util.blkToVecs(blk);
                    SimdOpt simdOpt = new SimdOpt(f);
                    simdOpt.messageFlag = this.env.shouldDo(100);
                    Vector<Vector> out = new Vector<Vector>();
                    LiveVariableAnalysis liveAna = (LiveVariableAnalysis)f.require(LiveVariableSlotwise.analyzer);
                    BiList liveOut = liveAna.liveOut(blk);
                    Vector los = this.calcLiveOut(simdOpt, vs, LirUtil.btov(liveOut));
                    for (int i = 0; i < vs.size(); ++i) {
                        Vector v = (Vector)vs.elementAt(i);
                        if (!this.chkSimd(v)) {
                            out.addElement(v);
                            continue;
                        }
                        liveOut = LirUtil.vtob((Vector)los.elementAt(i));
                        out.addElement(simdOpt.invoke(liveOut, v, rrn));
                    }
                    Util.vecsToBlk(blk, out);
                }
                p2 = p2.next();
            }
            if (this.simdEstimationOption) {
                SimdEstimation se = new SimdEstimation(f);
                se.doIt();
            }
            simdrslt = true;
        }
        catch (SimdOptException e) {
            BiLink p3 = f.flowGraph().basicBlkList.first();
            while (!p3.atEnd()) {
                BasicBlk blk = (BasicBlk)p3.elem();
                BiList instrs = (BiList)blkContents.get(blk);
                blk.setInstrList(instrs);
                p3 = p3.next();
            }
            simdrslt = false;
        }
        ifConvert.makeIfNode();
        return simdrslt;
    }

    private Vector calcLiveOut(SimdOpt so, Vector vs, Vector init) {
        Vector<Vector> out = new Vector<Vector>();
        out.setSize(vs.size());
        Vector lo = init;
        int i = vs.size();
        while (i > 0) {
            Vector li = so.liveReg((Vector)vs.elementAt(--i), lo);
            lo = (Vector)li.elementAt(0);
            out.setElementAt(lo, i);
        }
        return out;
    }

    private boolean chkSimd(Vector v) {
        if (v.size() > 0) {
            LirNode ins = (LirNode)v.elementAt(0);
            if (ins.opCode == 48) {
                return true;
            }
        }
        return false;
    }

    private boolean alignmentTestOption() {
        return this.alignmentTestOption;
    }

    private void setAlignmentTestOption(boolean b) {
        this.alignmentTestOption = b;
    }

    private void saveBasicBlkInfo(Function func) {
        BiLink p = func.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiList instrs = blk.instrList().copy();
            BiLink q = instrs.first();
            while (!q.atEnd()) {
                LirNode ins = (LirNode)q.elem();
                q.setElem(ins.makeCopy(func.newLir));
                q = q.next();
            }
            this.savedInstrLists.add(instrs);
            this.savedLabelList.add(blk.label());
            p = p.next();
        }
    }

    LirNode makeAlignmentTestCode(Function func, BiList aligns) {
        BiLink p = aligns.first();
        LirNode code = ((AlignmentTest.Alignment)p.elem()).toCondition();
        if (aligns.length() > 1) {
            p = p.next();
            while (!p.atEnd()) {
                AlignmentTest.Alignment a = (AlignmentTest.Alignment)p.elem();
                code = func.newLir.operator(10, this.addrtype, code, a.toCondition(), this.optDefault);
                p = p.next();
            }
        }
        LirNode iconst0 = func.newLir.iconst(this.addrtype, 0L, this.optDefault);
        code = func.newLir.operator(36, this.addrtype, code, iconst0, this.optDefault);
        return code;
    }

    private BasicBlk makeCondBlk(Function func, AlignmentTest atest, BiList aligns, LirNode simdlabelRef, LirNode nosimdlabelRef) {
        LirNode cond = this.makeAlignmentTestCode(func, aligns);
        if (this.memAccessOverlappingTestOption) {
            cond = func.newLir.operator(35, this.addrtype, func.newLir.operator(28, this.addrtype, cond, atest.memAccessOverlappingTest(), this.optDefault), func.newLir.iconst(this.addrtype, 1L), this.optDefault);
        }
        LirNode jumpcode = this.makeBranch(func, cond, simdlabelRef, nosimdlabelRef);
        BiList instrList = new BiList();
        instrList.add(jumpcode);
        BiLink p = func.flowGraph().basicBlkList.first().next();
        BasicBlk blk = (BasicBlk)p.elem();
        BasicBlk newBlk = func.flowGraph().insertNewBlkBefore(blk);
        BasicBlk entryblk = func.flowGraph().entryBlk();
        newBlk.setInstrList(entryblk.instrList());
        entryblk.setInstrList(instrList);
        return entryblk;
    }

    private Label genLabel(Function func, String str) {
        return this.genLabel(func, str, 0);
    }

    private Label genLabel(Function func, String str, int n) {
        Label label;
        try {
            String strn = Integer.toString(n);
            label = func.internLabel(str + "_" + strn);
        }
        catch (SyntaxError e) {
            label = this.genLabel(func, str, ++n);
        }
        return label;
    }

    LirNode makeBranch(Function func, LirNode cond, LirNode to1, LirNode to2) {
        LirNode[] src = new LirNode[]{cond, to1, to2};
        LirNode branch = func.newLir.operator(50, 0, src, this.optDefault);
        return branch;
    }

    private BiList makeSimdBlkList(Function func, Label simdlabel) {
        String PREFIX = ".__simd__";
        BiList simdblks = func.flowGraph().basicBlkList;
        this.changeLabels(func, simdblks, PREFIX);
        BasicBlk fstblk = (BasicBlk)simdblks.first().elem();
        fstblk.instrList().takeFirst();
        fstblk.setLabel(simdlabel);
        simdlabel.setBasicBlk(fstblk);
        return simdblks;
    }

    private void changeLabels(Function func, BiList blks, String str) {
        BiLink p = blks.first();
        while (!p.atEnd()) {
            Label newLabel;
            BasicBlk blk = (BasicBlk)p.elem();
            Label label = blk.label();
            try {
                newLabel = func.internLabel(str + label.name());
                blk.setLabel(newLabel);
                newLabel.setBasicBlk(blk);
            }
            catch (SyntaxError e) {
                newLabel = label;
            }
            this.labelMap.put(label, newLabel);
            p = p.next();
        }
        p = blks.first();
        while (!p.atEnd()) {
            BiLink ip = ((BasicBlk)p.elem()).instrList().first();
            while (!ip.atEnd()) {
                LirNode ins = (LirNode)ip.elem();
                this.changeLabel(func, ins, this.labelMap, str);
                ip = ip.next();
            }
            p = p.next();
        }
    }

    private void changeLabel(Function func, LirNode e, HashMap labelMap, String str) {
        for (int i = 0; i < e.nKids(); ++i) {
            LirNode kid = e.kid(i);
            if (kid instanceof LirLabelRef) {
                Label label = ((LirLabelRef)kid).label;
                Label newLabel = (Label)labelMap.get(kid);
                if (newLabel == null) {
                    try {
                        newLabel = func.internLabel(str + label.name());
                    }
                    catch (SyntaxError err) {
                        newLabel = label;
                    }
                }
                e.setKid(i, func.newLir.labelRef(newLabel));
                continue;
            }
            this.changeLabel(func, kid, labelMap, str);
        }
    }

    private void insertNosimdBlks(Function func) {
        BiLink bp = func.flowGraph().basicBlkList.first().next();
        BasicBlk blk = (BasicBlk)bp.elem();
        for (int i = 0; i < this.savedInstrLists.size() - 1; ++i) {
            blk = func.flowGraph().insertNewBlkBefore(blk);
        }
        BasicBlk exitblk = func.flowGraph().exitBlk();
        Label exitlabel = exitblk.label();
        Label nosimdexitlabel = (Label)this.savedLabelList.lastElement();
        for (int i = 0; i < this.savedInstrLists.size() - 1; ++i) {
            BiList instrList = (BiList)this.savedInstrLists.elementAt(i);
            BiLink insp = instrList.first();
            while (!insp.atEnd()) {
                LirNode ins = (LirNode)insp.elem();
                if (ins.isBranch()) {
                    ins.replaceLabel(nosimdexitlabel, exitlabel, func.newLir);
                }
                insp = insp.next();
            }
        }
        BiLink p = func.flowGraph().basicBlkList.first();
        BasicBlk simdfstblk = (BasicBlk)p.elem();
        BiList instrList_0 = simdfstblk.instrList();
        Label label_0 = simdfstblk.label();
        for (int i = 0; i < this.savedInstrLists.size() - 1; ++i) {
            BasicBlk b = (BasicBlk)p.elem();
            BiList instrList = (BiList)this.savedInstrLists.elementAt(i);
            b.setInstrList(instrList);
            Label label = (Label)this.savedLabelList.elementAt(i);
            if (label != null) {
                b.setLabel(label);
                label.clear();
                label.setBasicBlk(b);
            }
            p = p.next();
        }
        simdfstblk = (BasicBlk)p.elem();
        simdfstblk.setInstrList(instrList_0);
        simdfstblk.setLabel(label_0);
    }

    private boolean getTestOption(String str) {
        if (str == "alignmentTest") {
            return this.alignmentTestOption;
        }
        if (str == "memAccessOverlappingTest") {
            return this.memAccessOverlappingTestOption;
        }
        return false;
    }
}

