/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.SyntaxError;
import coins.backend.lir.LirNode;
import coins.backend.util.ImList;
import coins.simd.LirDecoder;
import coins.simd.LirMatch;
import coins.simd.SimdOptException;
import coins.simd.Util;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;

public abstract class LirBopList
extends LirMatch {
    private static final int MAX_ENV_SIZE = 33;
    private LirDecoder decoder;
    public LirNode[] templateList;

    public void init(Function f) {
        this.newLir = f.newLir;
        this.decoder = new LirDecoder(f);
        this.templateList = this.initTemplist();
    }

    public abstract LirNode[] initTemplist();

    public LirNode find(LirNode inst, LirNode[] env) throws SimdOptException {
        for (int i = 0; i < this.templateList.length; ++i) {
            LirNode[] env2 = new LirNode[env.length];
            this.rewrite(env, env2);
            if (!this.match(this.templateList[i], inst, env2)) continue;
            this.rewrite(env2, env);
            return this.templateList[i];
        }
        return null;
    }

    private void rewrite(LirNode[] sa, LirNode[] ta) throws SimdOptException {
        if (sa.length != ta.length) {
            Util.abort("Illega input in rewrite/LirBopList");
        }
        for (int i = 0; i < sa.length; ++i) {
            ta[i] = sa[i];
        }
    }

    public LirNode mkBop(String s) {
        try {
            PushbackReader rd = new PushbackReader(new StringReader(s));
            ImList stmt = (ImList)ImList.readSexp(rd);
            return this.decoder.decodeLir(stmt);
        }
        catch (SyntaxError se) {
            System.out.println("mkBop:" + se.getMessage());
            return null;
        }
        catch (IOException msg) {
            System.out.println("mkBop:IOError");
            return null;
        }
    }
}

