/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.lir.LirNode;
import coins.simd.LirUtil;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

class CleanUpLir {
    private Hashtable srcAndDst;
    private List keyList;
    private List lirList;
    private Vector lirPos;

    CleanUpLir(List lir) {
        this.lirList = lir;
        this.lirPos = new Vector();
    }

    public void invoke() {
        this.analyze();
        this.clean();
    }

    private void analyze() {
        this.srcAndDst = new Hashtable();
        this.keyList = new LinkedList();
        for (int i = 0; i < this.lirList.size(); ++i) {
            LirNode inst = (LirNode)this.lirList.get(i);
            if (inst.opCode != 48) continue;
            LirNode dst = inst.kid(0);
            LirNode src = inst.kid(1);
            if (dst.opCode != 6 && dst.opCode != 7 || src.opCode != 6 && src.opCode != 7) continue;
            this.findRedef(inst, dst, src, i);
        }
    }

    private void findRedef(LirNode def, LirNode dst, LirNode src, int place) {
        for (int i = place + 1; i < this.lirList.size(); ++i) {
            LirNode cons = (LirNode)this.lirList.get(i);
            if (cons.opCode == 48 && src.equals(cons.kid(0)) && dst.equals(cons.kid(1))) {
                this.lirPos.addElement(new Integer(place));
                this.lirPos.addElement(new Integer(i));
                return;
            }
            if (!LirUtil.isUsed(dst, cons)) continue;
            return;
        }
    }

    private void clean() {
        Object[] lirPosArray = this.lirPos.toArray();
        Arrays.sort(lirPosArray);
        for (int i = lirPosArray.length - 1; i >= 0; --i) {
            this.lirList.remove((Integer)lirPosArray[i]);
        }
    }
}

