/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.Type;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.simd.BoundToLivebits;
import coins.simd.BoundanalysisUwForLir;
import coins.util.IntBound;
import coins.util.IntConst;
import coins.util.IntLive;
import java.util.Enumeration;
import java.util.Hashtable;

public class BoundanalysisDwForLir {
    private Function function;
    private BoundanalysisUwForLir bauw;
    private Hashtable boundTableDW;

    BoundanalysisDwForLir(Function f) {
        this.function = f;
        this.boundTableDW = new Hashtable();
    }

    public void boundanalysisDw(LirNode ins, BoundanalysisUwForLir bduw) {
        if (ins.opCode == 48) {
            int size = Type.bits(ins.type);
            this.inherit(ins.kid(1), IntLive.valueOf(size), this.boundTableDW, bduw);
        }
    }

    private void inherit(LirNode e, IntLive l, Hashtable tbldw, BoundanalysisUwForLir bduw) {
        switch (e.opCode) {
            case 2: {
                return;
            }
            case 4: 
            case 5: 
            case 6: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                return;
            }
            case 9: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                this.inherit(e.kid(0), l.inheritNeg(), tbldw, bduw);
                return;
            }
            case 30: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                this.inherit(e.kid(0), l.inheritBnot(), tbldw, bduw);
                return;
            }
            case 17: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                this.inherit(e.kid(0), l.inheritConvsx(Type.bits(e.kid((int)0).type)), tbldw, bduw);
                return;
            }
            case 18: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                this.inherit(e.kid(0), l.inheritConvzx(Type.bits(e.kid((int)0).type)), tbldw, bduw);
                return;
            }
            case 19: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                this.inherit(e.kid(0), l.inheritConvit(Type.bits(e.kid((int)0).type)), tbldw, bduw);
                return;
            }
            case 47: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                int size = Type.bits(e.kid((int)0).type);
                this.inherit(e.kid(0), IntLive.valueOf(size), tbldw, bduw);
                return;
            }
            case 10: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritAdd(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritAdd(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritAdd(), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritAdd(), tbldw, bduw);
                }
                return;
            }
            case 11: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritSub0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritSub1(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritSub0(), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritSub1(), tbldw, bduw);
                }
                return;
            }
            case 12: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritMul(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritMul(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritMul(), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritMul(), tbldw, bduw);
                }
                return;
            }
            case 13: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritDivs0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritDivs1(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritDivs0(), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritDivs1(), tbldw, bduw);
                }
                return;
            }
            case 14: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritDivu0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritDivu1(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritDivu0(), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritDivu1(), tbldw, bduw);
                }
                return;
            }
            case 15: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritMods0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritMods1(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritMods0(), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritMods1(), tbldw, bduw);
                }
                return;
            }
            case 16: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritModu0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritModu1(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritModu0(), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritModu1(), tbldw, bduw);
                }
                return;
            }
            case 27: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritBand(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritBand(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritBand(), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritBand(), tbldw, bduw);
                }
                return;
            }
            case 28: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritBor(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritBor(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritBor(), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritBor(), tbldw, bduw);
                }
                return;
            }
            case 29: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritBxor(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritBxor(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritBxor(), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritBxor(), tbldw, bduw);
                }
                return;
            }
            case 31: 
            case 32: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritLsh0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    int t = Type.bits(e.type);
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritLsh1(this.cnvLirToIntConst(c), t), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritLsh0(), tbldw, bduw);
                    int t = Type.bits(e.type);
                    this.inherit(e.kid(1), l.inheritLsh1(t), tbldw, bduw);
                }
                return;
            }
            case 33: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritRshs0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    int t = Type.bits(e.type);
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritRshs1(this.cnvLirToIntConst(c), t), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritRshs0(), tbldw, bduw);
                    int t = Type.bits(e.type);
                    this.inherit(e.kid(1), l.inheritRshs1(t), tbldw, bduw);
                }
                return;
            }
            case 34: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritRshu0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    int t = Type.bits(e.type);
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritRshu1(this.cnvLirToIntConst(c), t), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritRshu0(), tbldw, bduw);
                    int t = Type.bits(e.type);
                    this.inherit(e.kid(1), l.inheritRshu1(t), tbldw, bduw);
                }
                return;
            }
            case 35: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritTsteq(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritTsteq(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritTsteq(Type.bits(e.kid((int)0).type)), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritTsteq(Type.bits(e.kid((int)1).type)), tbldw, bduw);
                }
                return;
            }
            case 36: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritTstne(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritTstne(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritTstne(Type.bits(e.kid((int)0).type)), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritTstne(Type.bits(e.kid((int)1).type)), tbldw, bduw);
                }
                return;
            }
            case 37: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritTstne(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritTstne(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritTstne(Type.bits(e.kid((int)0).type)), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritTstne(Type.bits(e.kid((int)1).type)), tbldw, bduw);
                }
                return;
            }
            case 38: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritTstles0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritTstles1(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritTstles0(Type.bits(e.kid((int)0).type)), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritTstles1(Type.bits(e.kid((int)1).type)), tbldw, bduw);
                }
                return;
            }
            case 39: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritTstgts0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritTstgts1(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritTstgts0(Type.bits(e.kid((int)0).type)), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritTstgts1(Type.bits(e.kid((int)1).type)), tbldw, bduw);
                }
                return;
            }
            case 40: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritTstges0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritTstges1(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritTstges0(Type.bits(e.kid((int)0).type)), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritTstges1(Type.bits(e.kid((int)1).type)), tbldw, bduw);
                }
                return;
            }
            case 41: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritTstltu0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritTstltu1(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritTstltu0(Type.bits(e.kid((int)0).type)), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritTstltu1(Type.bits(e.kid((int)1).type)), tbldw, bduw);
                }
                return;
            }
            case 42: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritTstleu0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritTstleu1(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritTstleu0(Type.bits(e.kid((int)0).type)), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritTstleu1(Type.bits(e.kid((int)1).type)), tbldw, bduw);
                }
                return;
            }
            case 43: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritTstgtu0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritTstgtu1(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritTstgtu0(Type.bits(e.kid((int)0).type)), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritTstgtu1(Type.bits(e.kid((int)1).type)), tbldw, bduw);
                }
                return;
            }
            case 44: {
                IntBound bd = bduw.get(e);
                IntLive lv = this.bdToLive(bd);
                tbldw.put(e, l.intersection(lv));
                if (e.kid(1) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(1);
                    this.inherit(e.kid(0), l.inheritTstgeu0(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else if (e.kid(0) instanceof LirIconst) {
                    LirIconst c = (LirIconst)e.kid(0);
                    this.inherit(e.kid(1), l.inheritTstgeu1(this.cnvLirToIntConst(c)), tbldw, bduw);
                } else {
                    this.inherit(e.kid(0), l.inheritTstgeu0(Type.bits(e.kid((int)0).type)), tbldw, bduw);
                    this.inherit(e.kid(1), l.inheritTstgeu1(Type.bits(e.kid((int)1).type)), tbldw, bduw);
                }
                return;
            }
        }
    }

    private IntLive bdToLive(IntBound bd) {
        return BoundToLivebits.convert(bd);
    }

    private IntConst cnvLirToIntConst(LirIconst i) {
        return IntConst.valueOf(Type.bits(i.type), i.value);
    }

    public void show() {
        if (this.boundTableDW != null) {
            Enumeration keys = this.boundTableDW.keys();
            while (keys.hasMoreElements()) {
                LirNode nd = (LirNode)keys.nextElement();
                System.out.println("KEY:" + nd.toString());
                IntLive lv = (IntLive)this.boundTableDW.get(nd);
                System.out.println("BOUND:" + lv.toString());
            }
        }
    }

    public IntLive get(LirNode e) {
        return (IntLive)this.boundTableDW.get(e);
    }

    public void put(LirNode e, IntLive b) {
        this.boundTableDW.put(e, b);
    }
}

