/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.util.IntBound;
import coins.util.IntConst;
import coins.util.IntLive;

public final class BoundToLivebits {
    private static final IntBound posdom8 = BoundToLivebits.mkDom(8, 1);
    private static final IntBound negdom8 = BoundToLivebits.mkDom(8, -1);
    private static final IntBound posdom16 = BoundToLivebits.mkDom(16, 1);
    private static final IntBound negdom16 = BoundToLivebits.mkDom(16, -1);
    private static final IntBound posdom32 = BoundToLivebits.mkDom(32, 1);
    private static final IntBound negdom32 = BoundToLivebits.mkDom(32, -1);
    private static final IntBound posdom64 = BoundToLivebits.mkDom(64, 1);
    private static final IntBound negdom64 = BoundToLivebits.mkDom(64, -1);
    private static final IntBound[] posdoms = new IntBound[]{posdom8, posdom16, null, posdom32, null, null, null, posdom64};
    private static final IntBound[] negdoms = new IntBound[]{negdom8, negdom16, null, negdom32, null, null, null, negdom64};

    private static IntBound mkDom(int t, int s) {
        IntConst m = IntConst.valueOf(t, 1L);
        if (s > 0) {
            IntConst lo = IntConst.valueOf(t, 0L);
            IntConst up = m.lsh(t - 1).sub(m);
            return new IntBound(lo, up);
        }
        if (s < 0) {
            IntConst lo = m.lsh(t - 1);
            IntConst up = m.lsh(t).sub(m);
            return new IntBound(lo, up);
        }
        throw new IllegalArgumentException("mkDcom:" + String.valueOf(s));
    }

    public static IntLive convert(IntBound bd) {
        IntConst lo = bd.lower;
        IntConst up = bd.upper;
        int size = bd.size();
        IntBound posdom = posdoms[size / 8 - 1];
        IntBound negdom = negdoms[size / 8 - 1];
        if (posdom.contains(lo)) {
            if (posdom.contains(up)) {
                if (lo.compareTo(up) <= 0) {
                    return IntLive.valueOf(BoundToLivebits.cover(up));
                }
                return IntLive.valueOf(BoundToLivebits.alldom(size));
            }
            return IntLive.valueOf(BoundToLivebits.alldom(size));
        }
        if (posdom.contains(up)) {
            IntLive b1 = IntLive.valueOf(BoundToLivebits.cover(up));
            IntLive b2 = b1.union(IntLive.valueOf(BoundToLivebits.cover(lo.bnot())));
            return b2.union(IntLive.valueOf(b2.intConstValue().lsh(1)));
        }
        if (lo.compareTo(up) <= 0) {
            return IntLive.valueOf(BoundToLivebits.cover(lo.bnot()));
        }
        return IntLive.valueOf(BoundToLivebits.alldom(size));
    }

    public static IntConst cover(IntConst c) {
        int size = c.size();
        IntConst d = c;
        for (int i = 1; i <= size; i *= 2) {
            d = d.bor(d.rshu(i));
        }
        return d;
    }

    private static IntConst alldom(int t) {
        IntConst lo = IntConst.valueOf(t, 0L);
        return lo.bnot();
    }
}

