/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.FlowRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.flow.BBlock;
import coins.flow.BBlockNodeIterator;
import coins.flow.BBlockSubtreeIterator;
import coins.flow.ControlFlow;
import coins.flow.Flow;
import coins.flow.SubpFlow;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirList;
import coins.ir.hir.IfStmt;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabelDef;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SwitchStmt;
import coins.sym.Label;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class NormalizeHir {
    IoRoot ioRoot;
    SymRoot symRoot;
    FlowRoot flowRoot;
    Flow flow;
    SubpFlow fSubpFlow;
    HIR hir;
    SubpDefinition fSubpDef;
    protected boolean fTransformed;
    protected List fStmtWithCriticalEdge;
    protected int fCriticalStmtIndex;
    protected List fCriticalEdgeTargetLabels;
    protected int fDbgLevel;

    public NormalizeHir(FlowRoot pFlowRoot, SubpDefinition pSubpDef) {
        this.flowRoot = pFlowRoot;
        this.flow = pFlowRoot.flow;
        this.ioRoot = pFlowRoot.ioRoot;
        this.symRoot = pFlowRoot.symRoot;
        this.hir = pFlowRoot.hirRoot.hir;
        this.fSubpFlow = this.flow.getSubpFlow();
        this.fSubpDef = pSubpDef;
        this.fTransformed = false;
        this.fStmtWithCriticalEdge = new LinkedList();
        this.fDbgLevel = this.ioRoot.dbgOpt1.getLevel();
    }

    protected boolean processCriticalEdge() {
        boolean lDetected = false;
        Stmt lParentFrom = null;
        Stmt lParentTo = null;
        int maxBBlockNo = this.fSubpFlow.getNumberOfBBlocks();
        if (this.fDbgLevel > 1) {
            this.dbg(2, " processCriticalEdge for", this.fSubpDef.getSubpSym().toStringShort() + " " + this.ioRoot.getSourceFile().getName() + " maxBBlockNo " + maxBBlockNo + "\n");
        }
        this.fCriticalEdgeTargetLabels = new LinkedList();
        for (int i = 1; i <= maxBBlockNo; ++i) {
            BBlock lFromBBlock = this.fSubpFlow.getBBlock(i);
            List lSuccList = lFromBBlock.getSuccList();
            HIR lFromHir = (HIR)lFromBBlock.getIrLink();
            Stmt lContainingStmt = null;
            if (lSuccList.size() < 2) continue;
            LinkedList lEdgeList = new LinkedList();
            Stmt lCompoundControlStmtOfEdgeStart = this.getCompoundControlStmtOfBBlock(lFromBBlock);
            lParentFrom = lCompoundControlStmtOfEdgeStart != null ? lCompoundControlStmtOfEdgeStart : this.containingControlStmt(lFromHir);
            lParentTo = null;
            ListIterator lIterator = lSuccList.listIterator();
            while (lIterator.hasNext()) {
                BBlock lSuccBBlock = (BBlock)lIterator.next();
                List lPredList = lSuccBBlock.getPredList();
                if (lPredList.size() < 2) continue;
                lDetected = true;
                LinkedList<BBlock> lEdge = new LinkedList<BBlock>();
                lEdge.add(lFromBBlock);
                lEdge.add(lSuccBBlock);
                lEdgeList.add(lEdge);
                HIR lToHir = (HIR)lSuccBBlock.getIrLink();
                if (lToHir instanceof LabeledStmt) {
                    Label lLabel1 = ((LabeledStmt)lToHir).getLabel();
                    IrList lLabelDefList = ((LabeledStmt)lToHir).getLabelDefList();
                    ListIterator lLabelDefIterator = lLabelDefList.iterator();
                    while (lLabelDefIterator.hasNext()) {
                        LabelDef lLabelDef = (LabelDef)lLabelDefIterator.next();
                        if (this.fCriticalEdgeTargetLabels.contains(lLabelDef.getLabel())) continue;
                        this.fCriticalEdgeTargetLabels.add(lLabelDef.getLabel());
                    }
                }
                lParentTo = this.containingControlStmt(lToHir);
                lContainingStmt = this.containingStmt(lParentFrom, lParentTo);
                if (this.fDbgLevel <= 2) continue;
                this.dbg(3, "\n critical edge", "B" + lFromBBlock.getBBlockNumber() + " - B" + lSuccBBlock.getBBlockNumber() + " " + lFromHir.toStringShort() + " - " + lToHir.toStringShort() + " parentFrom " + IoRoot.toStringObjectShort(lParentFrom) + " parentTo " + IoRoot.toStringObjectShort(lParentTo));
            }
            if (lParentTo == null) continue;
            if (this.fDbgLevel > 2) {
                this.dbg(3, " containingStmt", IoRoot.toStringObject(lContainingStmt) + " parentFrom " + IoRoot.toStringObjectShort(lParentFrom) + " parentTo " + IoRoot.toStringObjectShort(lParentTo));
            }
            if (lContainingStmt == null) {
                lContainingStmt = lParentTo;
            }
            if (lContainingStmt == null) {
                lContainingStmt = this.fSubpDef.getHirBody();
            }
            if (!(lContainingStmt instanceof IfStmt) && !(lContainingStmt instanceof LoopStmt) && !(lContainingStmt instanceof SwitchStmt)) continue;
            this.fStmtWithCriticalEdge.add(lContainingStmt);
        }
        if (lDetected) {
            this.eliminateCriticalEdge();
        }
        return lDetected;
    }

    protected Stmt containingStmt(Stmt pHir1, Stmt pHir2) {
        Stmt lContainingStmt = null;
        if (pHir1 == pHir2) {
            lContainingStmt = pHir1;
        } else if (pHir1 == null) {
            lContainingStmt = pHir2;
        }
        if (lContainingStmt == null) {
            HIR lParent;
            for (lParent = pHir1; lParent != null && lParent != pHir2; lParent = (HIR)lParent.getParent()) {
            }
            if (lParent == pHir2) {
                lContainingStmt = pHir2;
            }
            if (lContainingStmt == null) {
                for (lParent = pHir2; lParent != null && lParent != pHir1; lParent = (HIR)lParent.getParent()) {
                }
                if (lParent == pHir1) {
                    lContainingStmt = pHir1;
                }
            }
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgOpt1.print(5, "containingStmt of", IoRoot.toStringObjectShort(pHir1) + " and " + IoRoot.toStringObjectShort(pHir2) + " = " + IoRoot.toStringObjectShort(lContainingStmt));
        }
        return lContainingStmt;
    }

    protected Stmt containingControlStmtInBBlock(HIR pHir, BBlock pFromBBlock) {
        Stmt lContainingStmt = this.containingControlStmt(pHir);
        if (lContainingStmt == null) {
            BBlockSubtreeIterator lIterator = pFromBBlock.bblockSubtreeIterator();
            while (lIterator.hasNext()) {
                HIR lStmt = (HIR)lIterator.next();
                if (!this.isCompoundControlStmt(lStmt)) continue;
                lContainingStmt = (Stmt)lStmt;
            }
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgOpt1.print(5, "containingControlStmtInBBlock B" + pFromBBlock.getBBlockNumber(), pHir.toStringShort() + " = " + IoRoot.toStringObjectShort(lContainingStmt));
        }
        return lContainingStmt;
    }

    protected Stmt containingControlStmt(HIR pHir) {
        HIR lParent;
        for (lParent = pHir; !(lParent == null || lParent instanceof LoopStmt || lParent instanceof SwitchStmt || lParent instanceof IfStmt); lParent = (HIR)lParent.getParent()) {
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgOpt1.print(5, "containingControlStmt of", pHir.toStringShort() + " = " + IoRoot.toStringObjectShort(lParent));
        }
        return (Stmt)lParent;
    }

    protected Stmt getCompoundControlStmtOfBBlock(BBlock pBBlock) {
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgOpt1.print(4, "getCompoundControlStmtOfBBlock", "B" + pBBlock.getBBlockNumber());
        }
        Stmt lControlStmt = null;
        BBlockNodeIterator lIterator = pBBlock.bblockNodeIterator();
        while (lIterator.hasNext()) {
            HIR lHir = (HIR)lIterator.next();
            if (!(lHir instanceof Stmt)) continue;
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgOpt1.print(5, " nextStmt " + IoRoot.toStringObjectShort(lHir));
            }
            if (!this.isCompoundControlStmt((Stmt)lHir)) continue;
            lControlStmt = (Stmt)lHir;
            break;
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgOpt1.print(4, " result ", IoRoot.toStringObjectShort(lControlStmt));
        }
        return lControlStmt;
    }

    protected boolean isCompoundControlStmt(HIR pHir) {
        if (pHir != null) {
            switch (pHir.getOperator()) {
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 32: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isEmptyStmt(Stmt pStmt) {
        if (pStmt == null || pStmt.getOperator() == 73) {
            return true;
        }
        if (pStmt instanceof LabeledStmt) {
            return NormalizeHir.isEmptyStmt(((LabeledStmt)pStmt).getStmt());
        }
        if (pStmt instanceof BlockStmt) {
            Stmt lFirstStmt = ((BlockStmt)pStmt).getFirstStmt();
            if (lFirstStmt == null) {
                return true;
            }
            if (NormalizeHir.isEmptyStmt(lFirstStmt) && lFirstStmt.getNextStmt() == null) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected void eliminateCriticalEdge() {
        void var2_4;
        if (this.fDbgLevel > 1) {
            this.dbg(2, "\n eliminateCriticalEdge of", this.fSubpDef.getSubpSym().toStringShort() + " " + this.ioRoot.getSourceFile().getName());
            this.dbg(3, " StmtWithCriticalEdge", this.fStmtWithCriticalEdge.toString());
            this.dbg(3, " CriticalEdgeTargetLabels", this.fCriticalEdgeTargetLabels.toString());
        }
        LinkedList<Stmt> lJumpList = new LinkedList<Stmt>();
        HirIterator hirIterator = this.hir.hirIterator(this.fSubpDef.getHirBody());
        while (hirIterator.hasNextStmt()) {
            Stmt lStmt3 = hirIterator.nextStmt();
            if (lStmt3 != null) {
                lStmt3.setWork(null);
            }
            if (!(lStmt3 instanceof JumpStmt)) continue;
            lJumpList.add(lStmt3);
        }
        if (this.fDbgLevel > 2) {
            this.dbg(3, " JumpList", ((Object)lJumpList).toString());
        }
        boolean bl = false;
        while (var2_4 < this.fStmtWithCriticalEdge.size()) {
            Stmt lStmt = (Stmt)this.fStmtWithCriticalEdge.get((int)var2_4);
            lStmt.setWork(Integer.toString((int)var2_4));
            if (this.fDbgLevel > 2) {
                this.dbg(3, " setWork " + (int)var2_4 + " to " + lStmt.toStringShort());
            }
            ++var2_4;
        }
        for (JumpStmt jumpStmt : lJumpList) {
            Label lLabel3 = jumpStmt.getLabel();
            LabeledStmt lLabeledStmt3 = lLabel3.getHirPosition();
            if (!this.labelListContainsLabelOfStmt(this.fCriticalEdgeTargetLabels, lLabeledStmt3)) continue;
            this.separateJumpTarget(jumpStmt, lLabeledStmt3);
        }
        this.fCriticalStmtIndex = 0;
        while (this.fCriticalStmtIndex < this.fStmtWithCriticalEdge.size()) {
            Stmt lStmt = (Stmt)this.fStmtWithCriticalEdge.get(this.fCriticalStmtIndex);
            this.eliminateCriticalEdgeOfCompoundStmt(lStmt);
            ++this.fCriticalStmtIndex;
        }
        this.fTransformed = true;
        this.fSubpFlow.resetComputedFlag(4);
        this.flow.setFlowAnalStateLevel(1);
    }

    protected void eliminateCriticalEdgeOfCompoundStmt(Stmt pStmt) {
        if (this.fDbgLevel > 2) {
            this.dbg(3, "\n eliminateCriticalEdgeOfCompoundStmt", pStmt.toStringShort());
        }
        if (pStmt instanceof IfStmt) {
            this.processIfStmt((IfStmt)pStmt);
        } else if (pStmt instanceof LoopStmt) {
            this.processLoopStmt((LoopStmt)pStmt);
        } else if (pStmt instanceof SwitchStmt) {
            this.processSwitchStmt((SwitchStmt)pStmt);
        } else if (pStmt instanceof BlockStmt) {
            for (Stmt lStmt = ((BlockStmt)pStmt).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                if (this.fDbgLevel > 2) {
                    this.dbg(3, " getWork " + IoRoot.toStringObject(lStmt.getWork()) + " of " + lStmt.toStringShort());
                }
                if (lStmt.getWork() == null) continue;
                this.eliminateCriticalEdgeOfCompoundStmt(lStmt);
            }
        }
        if (this.ioRoot.dbgOpt1.getLevel() >= 5) {
            this.dbg(2, "\n Transformed Stmt ");
            pStmt.print(2, false);
        }
    }

    protected void separateJumpTarget(JumpStmt pJumpStmt, LabeledStmt pLabeledStmt) {
        BlockStmt lLabeledBlock;
        Stmt lStmtBody;
        Label lLabel = pJumpStmt.getLabel();
        Label lNewLabel = this.symRoot.symTableCurrentSubp.generateLabel();
        int lLabelKind = lLabel.getLabelKind();
        if (this.fDbgLevel > 2) {
            this.dbg(3, "separateJumpTarget of", pJumpStmt.toStringShort() + " " + lLabel.getName() + " kind " + lLabelKind + " newLabel " + lNewLabel.getName() + " target " + pLabeledStmt.toStringShort());
        }
        if ((lStmtBody = pLabeledStmt.getStmt()) == null) {
            lLabeledBlock = this.hir.blockStmt(null);
            pLabeledStmt.setStmt(lLabeledBlock);
        } else if (lStmtBody instanceof BlockStmt) {
            lLabeledBlock = (BlockStmt)lStmtBody;
        } else {
            Stmt lCopyOfStmtBody = (Stmt)lStmtBody.copyWithOperands();
            lLabeledBlock = this.hir.blockStmt(lCopyOfStmtBody);
            pLabeledStmt.setStmt(lLabeledBlock);
        }
        LabeledStmt lDummyLabeledStmt = this.hir.labeledStmt(lNewLabel, null);
        lLabeledBlock.addFirstStmt(lDummyLabeledStmt);
        pJumpStmt.changeJumpLabel(lNewLabel);
        this.adjustLinkages(pLabeledStmt, pLabeledStmt);
    }

    protected void processIfStmt(IfStmt pIfStmt) {
        LabeledStmt lStmt;
        Label lLabel;
        if (this.fDbgLevel > 3) {
            this.dbg(4, "processIfStmt", pIfStmt.toStringShort());
        }
        LabeledStmt lThenPart = pIfStmt.getThenPart();
        LabeledStmt lElsePart = pIfStmt.getElsePart();
        if (lElsePart == null) {
            lLabel = this.flowRoot.symRoot.symTableCurrentSubp.generateLabel();
            lStmt = this.hir.labeledStmt(lLabel, null);
            pIfStmt.replaceElsePart(lStmt);
            lElsePart = pIfStmt.getElsePart();
            this.adjustLinkages(null, lElsePart);
            if (this.fDbgLevel > 2) {
                this.dbg(3, " Else-part added " + pIfStmt.toString() + "\n");
            }
        }
        if (lThenPart == null) {
            lLabel = this.flowRoot.symRoot.symTableCurrentSubp.generateLabel();
            lStmt = this.hir.labeledStmt(lLabel, null);
            pIfStmt.replaceThenPart(lStmt);
            lThenPart = pIfStmt.getThenPart();
            this.adjustLinkages(null, lThenPart);
            if (this.fDbgLevel > 2) {
                this.dbg(3, " Then-part added " + pIfStmt.toString() + "\n");
            }
        }
    }

    protected void processLoopStmt(LoopStmt pLoopStmt) {
        if (this.fDbgLevel > 3) {
            this.dbg(4, "processLoopStmt", pLoopStmt.toStringShort());
        }
        Stmt lLoopInitpart = pLoopStmt.getLoopInitPart();
        if (pLoopStmt.getLoopStartCondition() == null && pLoopStmt.getLoopEndCondition() != null) {
            JumpStmt lJumpStmt = this.hir.jumpStmt(pLoopStmt.getLoopBodyLabel());
            pLoopStmt.addToLoopInitPart(lJumpStmt);
            Stmt lNewLoopInitPart = pLoopStmt.getLoopInitPart();
            this.adjustLinkages(lLoopInitpart, lNewLoopInitPart);
        }
    }

    protected void processSwitchStmt(SwitchStmt pSwitchStmt) {
        if (this.fDbgLevel > 1) {
            this.dbg(2, "\nprocessSwitchStmt", pSwitchStmt.toStringShort());
        }
        int lCaseCount = pSwitchStmt.getCaseCount();
        ArrayList<Label> lCaseLabelList = new ArrayList<Label>();
        for (int i = 0; i < lCaseCount; ++i) {
            lCaseLabelList.add(pSwitchStmt.getCaseLabel(i));
        }
        lCaseLabelList.add(pSwitchStmt.getDefaultLabel());
        if (this.fDbgLevel > 2) {
            this.dbg(3, "case label list", ((Object)lCaseLabelList).toString());
        }
        for (int lCaseIndex = lCaseCount; lCaseIndex >= 0; --lCaseIndex) {
            Stmt lPreviousStmt;
            Label lCaseLabel = lCaseIndex < lCaseCount ? pSwitchStmt.getCaseLabel(lCaseIndex) : pSwitchStmt.getDefaultLabel();
            LabeledStmt lCaseStmt = lCaseLabel.getHirPosition();
            if (lCaseStmt == null) {
                if (this.fDbgLevel > 1) {
                    this.dbg(2, "\ncaseStmt is null for index " + lCaseIndex + " " + lCaseLabel.getName() + " May be ERROR\n");
                }
                this.adjustLinkages(pSwitchStmt, pSwitchStmt);
                lCaseStmt = lCaseLabel.getHirPosition();
            }
            boolean lCriticalEdgeTarget = this.labelListContainsLabelOfStmt(this.fCriticalEdgeTargetLabels, lCaseStmt);
            if (this.fDbgLevel > 2) {
                this.dbg(3, "\ncaseStmt " + lCaseIndex, IoRoot.toStringObjectShort(lCaseStmt) + " " + lCaseLabel.getName() + " criticalEdgeTarget " + lCriticalEdgeTarget);
            }
            Stmt lStmtBody = lCaseStmt.getStmt();
            if (this.fDbgLevel > 2) {
                this.dbg(3, "stmtBody", IoRoot.toStringObjectShort(lStmtBody));
            }
            if (!lCriticalEdgeTarget) continue;
            if (this.fDbgLevel > 2) {
                this.dbg(3, " lCaseStmt is critical edge target " + lCaseStmt.toStringShort());
            }
            if ((lPreviousStmt = this.getPreviousStmtOfCaseStmt(lCaseStmt, pSwitchStmt, lCaseIndex)) == null) continue;
            if (this.fDbgLevel > 2) {
                this.dbg(3, " Add jump to lPreviousStmt ", lPreviousStmt.toStringShort() + " jump " + lCaseLabel.getName());
            }
            JumpStmt lJumpStmt = this.hir.jumpStmt(lCaseLabel);
            Stmt lCopiedStmt = (Stmt)lPreviousStmt.copyWithOperands();
            Stmt lNewPreviousStmt = lCopiedStmt.combineStmt(lJumpStmt, true);
            if (this.fDbgLevel > 2) {
                this.dbg(3, " combined lNewStmt ", lNewPreviousStmt.toStringShort());
            }
            lPreviousStmt.replaceThisStmtWith(lNewPreviousStmt);
            this.adjustLinkages(lPreviousStmt, lNewPreviousStmt);
            this.separateJumpTarget(lJumpStmt, lCaseStmt);
        }
    }

    protected Stmt getPreviousStmtOfCaseStmt(Stmt pCaseStmt, SwitchStmt pSwitchStmt, int pCaseIndex) {
        Stmt lPreviousStmt;
        if (this.fDbgLevel > 3) {
            this.dbg(4, "\n getPreviousStmtOfCaseStmt " + pCaseStmt.toStringShort() + " index " + pCaseIndex);
        }
        if ((lPreviousStmt = pCaseStmt.getPreviousStmt()) == null) {
            if (pCaseIndex == pSwitchStmt.getCaseCount()) {
                lPreviousStmt = pSwitchStmt.getBodyStmt();
            } else {
                Stmt lGivenStmt = pCaseStmt;
                while (lGivenStmt.getPreviousStmt() == null && lGivenStmt.getParent() instanceof BlockStmt) {
                    lGivenStmt = (Stmt)lGivenStmt.getParent();
                }
                if (lGivenStmt != null) {
                    lPreviousStmt = lGivenStmt.getPreviousStmt();
                }
            }
        }
        while (lPreviousStmt instanceof BlockStmt) {
            lPreviousStmt = ((BlockStmt)lPreviousStmt).getLastStmt();
        }
        if (this.fDbgLevel > 3) {
            this.dbg(4, " result " + IoRoot.toStringObjectShort(lPreviousStmt));
        }
        return lPreviousStmt;
    }

    protected boolean labelListContainsLabelOfStmt(List pLabelList, LabeledStmt pLabeledStmt) {
        IrList lLabelDefList = pLabeledStmt.getLabelDefList();
        ListIterator lIterator = lLabelDefList.iterator();
        while (lIterator.hasNext()) {
            LabelDef lLabelDef = (LabelDef)lIterator.next();
            Label lLabel = lLabelDef.getLabel();
            if (!pLabelList.contains(lLabel)) continue;
            return true;
        }
        return false;
    }

    protected void mergeLabelsOfStmt1ToStmt2(LabeledStmt pStmt1, LabeledStmt pStmt2) {
        if (this.fDbgLevel > 2) {
            this.dbg(3, "mergeLabelsOfStmt1ToStmt2", pStmt1.toStringShort() + " to " + pStmt2.toStringShort());
        }
        HirList lLabelDefList1 = (HirList)pStmt1.getLabelDefList();
        HirList lLabelDefList2 = (HirList)pStmt2.getLabelDefList();
        ListIterator lIterator1 = lLabelDefList1.iterator();
        while (lIterator1.hasNext()) {
            LabelDef lLabelDef1 = (LabelDef)lIterator1.next();
            Label lLabel1 = lLabelDef1.getLabel();
            boolean lFound = false;
            ListIterator lIterator2 = lLabelDefList2.iterator();
            while (lIterator2.hasNext()) {
                LabelDef lLabelDef2 = (LabelDef)lIterator2.next();
                if (lLabelDef2.getLabel() != lLabel1) continue;
                lFound = true;
                break;
            }
            if (lFound) continue;
            pStmt2.attachLabel(lLabel1);
            lLabel1.setHirPosition(pStmt2);
        }
        if (this.fDbgLevel >= 3) {
            this.dbg(3, " resultant label list ");
            ListIterator lIterator3 = pStmt2.getLabelDefList().iterator();
            while (lIterator3.hasNext()) {
                LabelDef lLabelDef3 = (LabelDef)lIterator3.next();
                this.dbg(3, lLabelDef3.getLabel().getName() + " ");
            }
        }
    }

    protected void adjustLinkages(Stmt pOldStmt, Stmt pNewStmt) {
        int lOldStmtIndex;
        if (this.fDbgLevel > 2) {
            this.dbg(3, "adjustLinkages", IoRoot.toStringObjectShort(pOldStmt) + " newStmt " + IoRoot.toStringObjectShort(pNewStmt));
        }
        if (pOldStmt != null && (lOldStmtIndex = this.fStmtWithCriticalEdge.indexOf(pOldStmt)) >= 0) {
            if (lOldStmtIndex > this.fCriticalStmtIndex) {
                this.fStmtWithCriticalEdge.set(lOldStmtIndex, pNewStmt);
                if (this.fDbgLevel > 2) {
                    this.dbg(3, " replace " + lOldStmtIndex + " " + pNewStmt.toStringShort());
                }
            } else if (pOldStmt != pNewStmt) {
                this.fStmtWithCriticalEdge.add(pNewStmt);
                if (this.fDbgLevel > 2) {
                    this.dbg(3, " add " + pNewStmt.toStringShort());
                }
            }
        }
        if (pNewStmt != null) {
            HirIterator lIterator = pNewStmt.hirIterator(pNewStmt);
            while (lIterator.hasNextStmt()) {
                Stmt lStmt = lIterator.nextStmt();
                if (this.fDbgLevel > 3) {
                    this.dbg(4, " " + lStmt.toStringShort());
                }
                if (lStmt instanceof LabeledStmt) {
                    IrList lLabelDefList = ((LabeledStmt)lStmt).getLabelDefList();
                    ListIterator lLabelIterator = lLabelDefList.iterator();
                    while (lLabelIterator.hasNext()) {
                        LabelDef lLabelDef = (LabelDef)lLabelIterator.next();
                        Label lLabel = lLabelDef.getLabel();
                        lLabel.setHirPosition((LabeledStmt)lStmt);
                        if (this.fDbgLevel <= 3) continue;
                        this.dbg(4, " " + lLabel.getName() + " " + lStmt.toStringShort());
                    }
                }
                if (lStmt.getWork() == null || !(lStmt.getWork() instanceof String)) continue;
                String lString = (String)lStmt.getWork();
                if (this.fDbgLevel > 3) {
                    this.dbg(4, " work " + lString);
                }
                int lIndex = Integer.parseInt(lString);
                if (this.fDbgLevel > 3) {
                    this.dbg(4, " " + lIndex);
                }
                if (lIndex < 0 || lIndex >= this.fStmtWithCriticalEdge.size()) continue;
                this.fStmtWithCriticalEdge.set(lIndex, lStmt);
                if (this.fDbgLevel <= 3) continue;
                this.dbg(4, " replace by " + lStmt.toStringShort());
            }
        }
    }

    protected void adjustHirPositionOfLabels1(Stmt pStmt) {
        if (this.fDbgLevel > 2) {
            this.dbg(3, "adjustHirPositionOfLabels", IoRoot.toStringObjectShort(pStmt));
        }
        if (pStmt == null) {
            return;
        }
        HirIterator lIterator = pStmt.hirIterator(pStmt);
        while (lIterator.hasNextStmt()) {
            Stmt lStmt = lIterator.nextStmt();
            if (this.fDbgLevel > 3) {
                this.dbg(4, " " + lStmt.toStringShort());
            }
            if (!(lStmt instanceof LabeledStmt)) continue;
            IrList lLabelDefList = ((LabeledStmt)lStmt).getLabelDefList();
            ListIterator lLabelIterator = lLabelDefList.iterator();
            while (lLabelIterator.hasNext()) {
                LabelDef lLabelDef = (LabelDef)lLabelIterator.next();
                Label lLabel = lLabelDef.getLabel();
                lLabel.setHirPosition((LabeledStmt)lStmt);
                if (this.fDbgLevel <= 3) continue;
                this.dbg(4, " " + lLabel.getName() + " " + lStmt.toStringShort());
            }
        }
    }

    public boolean checkCriticalEdges(SubpFlow pSubpFlow, SubpDefinition pSubpDef) {
        this.flowRoot = pSubpFlow.getFlowRoot();
        IoRoot ioRoot = this.flowRoot.ioRoot;
        if (this.fDbgLevel > 1) {
            ioRoot.dbgOpt1.print(2, "checkCriticalEdge", pSubpDef.getSubpSym().getName());
        }
        ControlFlow lControlFlow = pSubpFlow.isComputed(4) ? this.flow.controlFlow() : this.flow.controlFlowAnal(this.fSubpFlow);
        boolean lDetected = false;
        for (int i = 1; i <= pSubpFlow.getNumberOfBBlocks(); ++i) {
            BBlock lBBlock = pSubpFlow.getBBlock(i);
            HIR lHir1 = (HIR)lBBlock.getIrLink();
            List lSuccList = lBBlock.getSuccList();
            if (lSuccList.size() < 2) continue;
            ListIterator lIterator = lSuccList.listIterator();
            while (lIterator.hasNext()) {
                BBlock lSuccBBlock = (BBlock)lIterator.next();
                List lPredList = lSuccBBlock.getPredList();
                if (lPredList.size() < 2) continue;
                lDetected = true;
                HIR lHir2 = (HIR)lSuccBBlock.getIrLink();
                if (this.fDbgLevel <= 2) continue;
                this.dbg(3, " critical edge", "B" + lBBlock.getBBlockNumber() + " - B" + lSuccBBlock.getBBlockNumber() + " " + lHir1.toStringShort() + " - " + lHir2.toStringShort());
            }
        }
        if (lDetected) {
            if (this.fDbgLevel > 0) {
                ioRoot.dbgOpt1.print(2, " Critical edge found. ");
            }
        } else if (this.fDbgLevel > 0) {
            ioRoot.dbgOpt1.print(2, " No critical edge found. ");
        }
        return lDetected;
    }

    public void dbg(int level, String pHeader, Object pObject) {
        this.ioRoot.dbgOpt1.printObject(level, pHeader, pObject);
        this.ioRoot.dbgOpt1.println(level);
    }

    public void dbg(int level, Object pObject) {
        if (pObject == null) {
            this.ioRoot.dbgOpt1.print(level, " null ");
        } else {
            this.ioRoot.dbgOpt1.print(level, " " + pObject.toString());
        }
    }
}

