/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.driver.CoinsOptions;
import coins.flow.FlowImpl;
import coins.ir.IrList;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirList;
import coins.ir.hir.IfStmt;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubpNode;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.VarNode;
import coins.sym.Elem;
import coins.sym.IntConst;
import coins.sym.Label;
import coins.sym.Param;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.SymTable;
import coins.sym.Var;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

public class Inline {
    protected final HirRoot hirRoot;
    protected final SymRoot symRoot;
    protected final IoRoot io;
    protected final int fDbgLevel;
    protected int fLimitOfExpansionDepth;
    protected int fUpperLimitOfNodeCount;
    protected int VALUESUM = 100;
    protected final FlowImpl fFlowImpl;
    private Subp fSubpWithStaticVar;
    protected Map fOptionMap;
    protected CoinsOptions fOptions;
    protected Vector SubpBlackList = new Vector();
    protected List fPragmaInlineList;
    protected boolean fWithHirOpt;

    public Inline(HirRoot pHirRoot, SymRoot pSymRoot, IoRoot pIoRoot, String pOptionValue, List pPragmaInlineList, boolean pWithHirOpt, String pInlineDepth) {
        this.hirRoot = pHirRoot;
        this.symRoot = pSymRoot;
        this.io = pIoRoot;
        this.fFlowImpl = (FlowImpl)this.hirRoot.getFlowRoot().flow;
        this.fSubpWithStaticVar = null;
        this.fDbgLevel = this.io.dbgOpt1.getLevel();
        if (pOptionValue != "" && Character.isDigit(pOptionValue.charAt(0))) {
            int lDigitCount;
            for (lDigitCount = 0; lDigitCount < pOptionValue.length() && Character.isDigit(pOptionValue.charAt(lDigitCount)); ++lDigitCount) {
            }
            String lOptionValue = pOptionValue.substring(0, lDigitCount);
            Integer lValue = Integer.valueOf(lOptionValue);
            this.fUpperLimitOfNodeCount = lValue;
        } else {
            this.fUpperLimitOfNodeCount = 100;
        }
        char lInlineDepth = pInlineDepth.charAt(0);
        this.fLimitOfExpansionDepth = lInlineDepth == '2' ? 2 : (lInlineDepth == '3' ? 3 : 1);
        if (this.fDbgLevel > 0) {
            this.io.dbgOpt1.print(2, "\ninline: upper limit of node count " + this.fUpperLimitOfNodeCount + " recursive inline depth " + this.fLimitOfExpansionDepth + " " + lInlineDepth);
        }
        this.fPragmaInlineList = pPragmaInlineList;
        this.fWithHirOpt = pWithHirOpt;
    }

    public boolean changeSubp(SubpDefinition pSubpDef) {
        SymTable lSubpSymTable;
        this.symRoot.symTableCurrent = lSubpSymTable = pSubpDef.getSymTable();
        this.symRoot.symTableCurrentSubp = lSubpSymTable;
        if (this.fDbgLevel > 0) {
            this.io.dbgOpt1.print(2, " changeSubp " + pSubpDef.getSubpSym().getName());
        }
        boolean lChanged = this.checkCallerSubp_B(pSubpDef, this.hirRoot, this.symRoot, this.io);
        return lChanged;
    }

    protected boolean checkCallerSubp_B(SubpDefinition lSubpDef, HirRoot hirRoot, SymRoot symRoot, IoRoot io) {
        boolean lChanged = false;
        HIR[] callNodeList = new HIR[100];
        int callNodeNum = 1;
        if (this.fDbgLevel > 0) {
            io.dbgOpt1.print(1, "Inline:checkCallerSubp_pattern_B " + lSubpDef.getSubpSym().getName() + "\n");
        }
        for (int lPass = 0; lPass < this.fLimitOfExpansionDepth; ++lPass) {
            if (this.fDbgLevel > 0) {
                io.dbgOpt1.print(2, "Inline: pass = " + lPass + "\n");
            }
            if (callNodeNum == 0) break;
            callNodeNum = 0;
            HirIterator linlineIterator = hirRoot.hir.hirIterator(lSubpDef.getHirBody());
            while (linlineIterator.hasNext()) {
                HIR lNode = linlineIterator.next();
                if (lNode == null || lNode.getOperator() != 33) continue;
                if (this.inlineCond(lNode)) {
                    callNodeList[callNodeNum] = lNode;
                    ++callNodeNum;
                    lChanged = true;
                    if (this.fDbgLevel <= 2) continue;
                    io.dbgOpt1.print(3, " expand ");
                    continue;
                }
                if (this.fDbgLevel <= 3) continue;
                io.dbgOpt1.print(4, " not to be expanded ");
            }
            for (int serchptr = 0; serchptr < callNodeNum; ++serchptr) {
                this.inlineExpansion(callNodeList[serchptr]);
            }
        }
        return lChanged;
    }

    protected boolean inlineCond(HIR pxNode) {
        boolean StmtCount = false;
        if (this.fDbgLevel > 2) {
            this.io.dbgOpt1.print(3, "\n inlineCond " + pxNode.toStringShort());
        }
        SubpNode lSubpNode = null;
        if (pxNode.getChild1().getOperator() == 64) {
            if (pxNode.getChild1().getChild1() instanceof SubpNode) {
                lSubpNode = (SubpNode)pxNode.getChild1().getChild1();
            }
        } else if (pxNode.getChild1() instanceof SubpNode) {
            lSubpNode = (SubpNode)pxNode.getChild1();
        }
        if (lSubpNode != null) {
            Subp lSubp = (Subp)lSubpNode.getSymNodeSym();
            if (!this.fWithHirOpt && !this.fPragmaInlineList.contains(lSubp)) {
                return false;
            }
            Sym lSubpName = ((FunctionExp)pxNode).getFunctionNode().getSymNodeSym();
            Stmt lSubpBody = lSubp.getHirBody();
            if (this.fDbgLevel > 2) {
                this.io.dbgOpt1.print(3, " of " + lSubpName);
            }
            SubpDefinition lSubpDefinition = lSubp.getSubpDefinition();
            if (lSubpBody == null) {
                return false;
            }
            if (lSubpDefinition == null) {
                return false;
            }
            if (lSubpDefinition.getNodeIndexMax() - lSubpDefinition.getNodeIndexMin() > this.fUpperLimitOfNodeCount && !this.fPragmaInlineList.contains(lSubp)) {
                return false;
            }
            HIR lCurrNode = pxNode;
            HIR lAncestor = pxNode;
            while (lAncestor != null && lAncestor.getType() != this.symRoot.typeBool) {
                lAncestor = (HIR)lCurrNode.getParent();
                if (lAncestor instanceof IfStmt) {
                    if (lAncestor.getChild1() == lCurrNode) {
                        return false;
                    }
                } else if (lAncestor instanceof LoopStmt) {
                    if (((LoopStmt)lAncestor).getLoopStartCondition() == lCurrNode) {
                        return false;
                    }
                    if (((LoopStmt)lAncestor).getLoopEndCondition() == lCurrNode) {
                        return false;
                    }
                } else if (lAncestor instanceof SwitchStmt) {
                    if (((SwitchStmt)lAncestor).getSelectionExp() == lCurrNode) {
                        return false;
                    }
                } else {
                    if (lAncestor instanceof HirList) {
                        return false;
                    }
                    if (lAncestor instanceof SubpDefinition) {
                        return true;
                    }
                }
                lCurrNode = lAncestor;
            }
            return lAncestor == null || lAncestor.getType() != this.symRoot.typeBool;
        }
        return false;
    }

    protected void inlineExpansion(HIR pCallNode) {
        HIR lSubptreeNode;
        SubpNode lSubpNode = (SubpNode)pCallNode.getChild1().getChild1();
        Subp lSubp = (Subp)lSubpNode.getSymNodeSym();
        Stmt lSubpBody = lSubp.getHirBody();
        HIR lSubpcopy = lSubpBody.copyWithOperandsChangingLabels(null);
        if (lSubpBody instanceof BlockStmt) {
            ((BlockStmt)lSubpcopy).setSymTable(null);
        } else if (lSubpBody instanceof LabeledStmt && ((LabeledStmt)lSubpBody).getStmt() instanceof BlockStmt) {
            ((BlockStmt)((LabeledStmt)lSubpcopy).getStmt()).setSymTable(null);
        }
        HIR lNode = pCallNode;
        if (this.fDbgLevel > 1) {
            this.io.dbgOpt1.print(2, "inlineExpansion", lSubp.getName() + "\n");
        }
        Var[] ltempVarTable = new Var[100];
        int ParamNum = 1;
        IrList lSubpFormalParamList = lSubp.getParamList();
        ListIterator lFIterator = lSubpFormalParamList.iterator();
        while (lFIterator.hasNext()) {
            Param lFormalParam = (Param)lFIterator.next();
            if (lFormalParam == null) continue;
            ltempVarTable[ParamNum] = this.hirRoot.symRoot.symTableCurrent.generateVar(lFormalParam.getSymType(), lSubp);
            if (this.fDbgLevel > 2) {
                this.io.dbgOpt1.print(3, "lFormalParam = " + lFormalParam.getName() + " ltempVar[" + ParamNum + "] = " + ltempVarTable[ParamNum].getName() + "\n");
            }
            ++ParamNum;
        }
        Sym[] lValueSym = new Sym[this.VALUESUM];
        Var[] ltempValueVar = new Var[this.VALUESUM];
        int ValueNum = 0;
        int ValueNumber = 0;
        HirIterator lSubpIterator = this.hirRoot.hir.hirIterator(lSubpcopy);
        block1: while (lSubpIterator.hasNext()) {
            lSubptreeNode = lSubpIterator.next();
            if (lSubptreeNode == null || !(lSubptreeNode instanceof VarNode)) continue;
            Sym lSym = ((VarNode)lSubptreeNode).getSymNodeSym();
            if (lSym instanceof Param) {
                if (this.fDbgLevel > 3) {
                    this.io.dbgOpt1.print(4, "\n param ", lSym.getName() + " paramIndex=" + ((Param)lSym).getParamIndex() + " ltempVar[" + ((Param)lSym).getParamIndex() + "]=" + ltempVarTable[((Param)lSym).getParamIndex()].getName());
                }
                ((VarNode)lSubptreeNode).setSymNodeSym(ltempVarTable[((Param)lSym).getParamIndex()]);
                continue;
            }
            if (!(lSym instanceof Var) || ((Var)lSym).getVisibility() != 4 || lSym instanceof Elem) continue;
            for (ValueNum = 0; ValueNum < this.VALUESUM; ++ValueNum) {
                if (lSym == lValueSym[ValueNum]) {
                    ((VarNode)lSubptreeNode).setSymNodeSym(ltempValueVar[ValueNum]);
                    continue block1;
                }
                if (ValueNum < ValueNumber) continue;
                lValueSym[ValueNum] = lSym;
                Var lTempVar = ((Var)lSym).getStorageClass() == 6 ? this.getTempForStaticVar((Var)lSym, lSubp) : this.hirRoot.symRoot.symTableCurrent.generateVar(lSubptreeNode.getType(), lSubp);
                ltempValueVar[ValueNum] = lTempVar;
                ++ValueNumber;
                ((VarNode)lSubptreeNode).setSymNodeSym(ltempValueVar[ValueNum]);
                continue block1;
            }
        }
        Var lReturnVar = null;
        AssignStmt lAssignReturnStmt = null;
        Stmt lcallStmt = null;
        HIR lReturncopy = null;
        HIR lReturnValueNode = null;
        Label lReturnLabel = null;
        JumpStmt lReturnJumpStmt = null;
        boolean lReturnIsLastStmt = true;
        boolean lChangeToReturnVar = false;
        lSubpIterator = this.hirRoot.hir.hirIterator(lSubpcopy);
        while (lSubpIterator.hasNext()) {
            lSubptreeNode = lSubpIterator.next();
            if (lSubptreeNode == null || lSubptreeNode.getOperator() != 34) continue;
            ReturnStmt lReturn = (ReturnStmt)lSubptreeNode;
            if (lReturn.getNextStmt() != null || !(lReturn.getParent() instanceof BlockStmt) || !(lReturn.getParent().getParent() instanceof LabeledStmt) || ((Stmt)lReturn.getParent().getParent()).getNextStmt() != null) {
                lReturnIsLastStmt = false;
            }
            lReturncopy = lSubptreeNode.copyWithOperands();
            lReturnValueNode = (HIR)lReturncopy.getChild1();
            if (this.fDbgLevel > 2) {
                this.io.dbgOpt1.print(3, "\nlReturnValueNode " + lReturnValueNode + "\n");
            }
            if (lReturnLabel == null && !lReturnIsLastStmt) {
                lReturnLabel = this.hirRoot.symRoot.symTableCurrent.generateLabel();
                if (this.fDbgLevel > 2) {
                    this.io.dbgOpt1.print(3, " returnLabel", lReturnLabel.getName());
                }
                lReturnJumpStmt = this.hirRoot.hir.jumpStmt(lReturnLabel);
            }
            if (lSubp.getReturnValueType() != this.symRoot.typeVoid) {
                if (lReturnVar == null) {
                    lReturnVar = this.hirRoot.symRoot.symTableCurrent.generateVar(lSubp.getReturnValueType(), lSubp);
                }
                if (lReturnValueNode == null) {
                    this.io.msgRecovered.put("Return value is not specified for " + lSubp.getName());
                    lReturnValueNode = this.hirRoot.hir.intConstNode(0);
                    if (!(lSubp.getReturnValueType() instanceof IntConst)) {
                        lReturnValueNode = this.hirRoot.hir.convExp(lSubp.getReturnValueType(), (Exp)lReturnValueNode);
                    }
                    if (this.fDbgLevel > 3) {
                        this.io.dbgOpt1.print(4, "changed returnValueNode", lReturnValueNode.toStringWithChildren());
                    }
                }
                lAssignReturnStmt = this.hirRoot.hir.assignStmt(this.hirRoot.hir.varNode(lReturnVar), (Exp)lReturnValueNode.copyWithOperands());
            }
            Stmt lReturnStmt = lSubptreeNode.getStmtContainingThisNode();
            BlockStmt lReturnBlock = lReturnStmt.getBlockStmt();
            if (!(lReturnStmt.getParent() instanceof BlockStmt)) {
                if (lReturnStmt instanceof LabeledStmt) {
                    lReturnStmt = ((LabeledStmt)lReturnStmt).getStmt();
                }
                lReturnBlock = this.hirRoot.hir.blockStmt(null);
                if (lSubp.getReturnValueType() != this.symRoot.typeVoid) {
                    lReturnBlock.addFirstStmt((Stmt)lAssignReturnStmt.copyWithOperands());
                }
                if (lReturnLabel != null) {
                    lReturnBlock.addLastStmt((Stmt)lReturnJumpStmt.copyWithOperands());
                }
                if (this.fDbgLevel > 3) {
                    this.io.dbgOpt1.print(4, " Changed returnStmt", lReturnBlock.toStringWithChildren());
                }
                lReturnStmt.replaceThisStmtWith(lReturnBlock);
                lChangeToReturnVar = true;
                continue;
            }
            if (this.fDbgLevel > 2) {
                this.io.dbgOpt1.print(3, "Unnecessary to make Block for return stmt\n");
            }
            if (lSubp.getReturnValueType() != this.symRoot.typeVoid) {
                lReturnStmt.insertPreviousStmt((Stmt)lAssignReturnStmt.copyWithOperands());
                lChangeToReturnVar = true;
                if (this.fDbgLevel > 3) {
                    this.io.dbgOpt1.print(4, " Insert ", lAssignReturnStmt.toStringWithChildren());
                }
            }
            if (lReturnLabel != null) {
                lReturnStmt.replaceThisStmtWith((Stmt)lReturnJumpStmt.copyWithOperands());
                lChangeToReturnVar = true;
                if (this.fDbgLevel <= 3) continue;
                this.io.dbgOpt1.print(4, " Chang returnStmt to", lReturnJumpStmt.toStringWithChildren());
                continue;
            }
            lReturnStmt.deleteThisStmt();
        }
        Stmt lCallOldStmt = pCallNode.getStmtContainingThisNode();
        BlockStmt lCallBlock = lCallOldStmt.getBlockStmt();
        lNode = pCallNode;
        if (!(lCallOldStmt.getParent() instanceof BlockStmt)) {
            if (lCallOldStmt instanceof LabeledStmt) {
                lCallOldStmt = ((LabeledStmt)lCallOldStmt).getStmt();
            }
            pCallNode.setWork(pCallNode);
            if (this.fDbgLevel > 2) {
                this.io.dbgOpt1.print(3, " setWork to " + ((Object)pCallNode).toString() + " and make BlockStmt ");
            }
            lCallBlock = this.hirRoot.hir.blockStmt(null);
            lcallStmt = (Stmt)lCallOldStmt.copyWithOperandsChangingLabels(null);
            lCallBlock.addLastStmt(lcallStmt);
            HIR lcallStmtParent = (HIR)lCallOldStmt.getParent();
            lCallOldStmt.replaceThisStmtWith(lCallBlock);
            HirIterator lcallBlockIterator = this.hirRoot.hir.hirIterator(lcallStmt);
            while (lcallBlockIterator.hasNext() && ((lNode = lcallBlockIterator.next()) == null || lNode.getOperator() != 33 || lNode.getWork() != pCallNode)) {
            }
            if (lNode != null && lNode.getWork() == pCallNode) {
                lNode.setWork(null);
                if (this.fDbgLevel > 2) {
                    this.io.dbgOpt1.print(3, " Call statement was found ", ((Object)lNode).toString());
                }
            } else if (this.fDbgLevel > 1) {
                this.io.dbgOpt1.print(2, " Call statement was not found ", "Error for " + ((Object)pCallNode).toString());
            }
        } else {
            if (this.fDbgLevel > 3) {
                this.io.dbgOpt1.print(4, " Unnecessary to make block for callStmt ", lCallOldStmt.toString());
            }
            lcallStmt = lCallOldStmt;
        }
        IrList lSubpActualParamList = (IrList)lNode.getChild2();
        ParamNum = 1;
        ListIterator lAIterator = lSubpActualParamList.iterator();
        while (lAIterator.hasNext()) {
            HIR lActualParam = (HIR)lAIterator.next();
            if (lActualParam == null) continue;
            AssignStmt lAssignParamStmt = this.hirRoot.hir.assignStmt(this.hirRoot.hir.varNode(ltempVarTable[ParamNum]), (Exp)lActualParam);
            lcallStmt.insertPreviousStmt(lAssignParamStmt, lCallBlock);
            ++ParamNum;
        }
        BlockStmt lSubpcopyBlock = this.hirRoot.hir.blockStmt((Stmt)lSubpcopy);
        if (lReturnLabel != null) {
            if (this.fDbgLevel > 2) {
                this.io.dbgOpt1.print(3, "\n addReturnLabel " + lReturnLabel.getName());
            }
            lSubpcopyBlock.addNextStmt(this.hirRoot.hir.labeledStmt(lReturnLabel, null));
        }
        lcallStmt.insertPreviousStmt(lSubpcopyBlock, lCallBlock);
        if (lChangeToReturnVar && lReturnVar != null) {
            lNode.replaceThisNode(this.hirRoot.hir.varNode(lReturnVar).copyWithOperands());
        } else {
            lcallStmt.deleteThisStmt();
        }
        if (this.fSubpWithStaticVar != null) {
            this.replaceLocalStaticVariables(lSubp.getSubpDefinition());
            this.fSubpWithStaticVar = null;
        }
    }

    Var getTempForStaticVar(Var pStaticVar, Subp pSubp) {
        Var lTempVar;
        Map<Var, Var> lStaticVarMap;
        if (this.fDbgLevel > 3) {
            this.io.dbgOpt1.print(4, "getTempForStaticVar", pStaticVar.getName() + " in " + pSubp.getName());
        }
        if (this.fFlowImpl.staticVariableMapOfSubp == null) {
            this.fFlowImpl.staticVariableMapOfSubp = new HashMap();
            if (this.fDbgLevel > 1) {
                this.io.dbgOpt1.print(2, "\n create staticVariableMapOfSubp ");
            }
        }
        if (this.fFlowImpl.staticVariableMapOfSubp.containsKey(pSubp)) {
            lStaticVarMap = (Map)this.fFlowImpl.staticVariableMapOfSubp.get(pSubp);
        } else {
            lStaticVarMap = new HashMap();
            this.fFlowImpl.staticVariableMapOfSubp.put(pSubp, lStaticVarMap);
            if (this.fDbgLevel > 1) {
                this.io.dbgOpt1.print(2, "\n create staticVariableMap for " + pSubp.getName());
            }
        }
        if (lStaticVarMap.containsKey(pStaticVar)) {
            lTempVar = (Var)lStaticVarMap.get(pStaticVar);
        } else {
            SymTable lSymTableRoot = this.symRoot.symTableRoot;
            SymTable lSymTableCurrent = pSubp.getSymTable();
            String lUniqueName = lSymTableCurrent.generateUniqueName(pStaticVar, pSubp);
            lTempVar = (Var)lSymTableRoot.defineUnique(lUniqueName, 8, null);
            lTempVar.setSymType(pStaticVar.getSymType());
            lTempVar.setStorageClass(6);
            lTempVar.setVisibility(5);
            if (pStaticVar.getInitialValue() != null) {
                lTempVar.setInitialValue(pStaticVar.getInitialValue());
            }
            lStaticVarMap.put(pStaticVar, lTempVar);
            this.fSubpWithStaticVar = pSubp;
        }
        if (this.fDbgLevel > 2) {
            this.io.dbgOpt1.print(3, "static var " + pSubp.getName() + " temp " + lTempVar.getName());
            if (this.fDbgLevel >= 4) {
                this.io.dbgOpt1.print(4, "staticVarMap of " + pSubp.getName() + " " + lStaticVarMap.toString());
            }
        }
        return lTempVar;
    }

    protected void replaceLocalStaticVariables(SubpDefinition pSubpDef) {
        Subp lSubp = pSubpDef.getSubpSym();
        if (this.fDbgLevel > 0) {
            this.io.dbgOpt1.print(2, "replaceLocalStaticVariables", lSubp.getName());
        }
        BlockStmt lInitPart = pSubpDef.getInitiationPart();
        this.replaceLocalStaticVariablesInSubtree(lInitPart, lSubp);
        Stmt lSubpBody = pSubpDef.getHirBody();
        this.replaceLocalStaticVariablesInSubtree(lSubpBody, lSubp);
    }

    protected void replaceLocalStaticVariablesInSubtree(HIR pHir, Subp pSubp) {
        if (pHir == null) {
            return;
        }
        if (this.fDbgLevel > 0) {
            this.io.dbgOpt1.print(2, "replaceLocalStaticVariablesInSubtree", ((Object)pHir).toString());
        }
        HirIterator lHirIterator = this.hirRoot.hir.hirIterator(pHir);
        while (lHirIterator.hasNext()) {
            Var lVar;
            HIR lSubptreeNode = lHirIterator.next();
            if (lSubptreeNode == null || !(lSubptreeNode instanceof VarNode) || (lVar = (Var)((VarNode)lSubptreeNode).getSymNodeSym()).getStorageClass() != 6 || lVar.getVisibility() != 4 || lVar instanceof Elem) continue;
            Var lTempVar = this.getTempForStaticVar(lVar, pSubp);
            ((VarNode)lSubptreeNode).setSymNodeSym(lTempVar);
            if (this.fDbgLevel <= 2) continue;
            this.io.dbgOpt1.print(3, "replace " + lVar.getName(), "by " + lTempVar.getName());
        }
    }
}

