/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.FlowRoot;
import coins.SymRoot;
import coins.aflow.FlowResults;
import coins.flow.BBlock;
import coins.flow.DataFlow;
import coins.flow.FlowAnalSymVector;
import coins.flow.FlowUtil;
import coins.flow.SetRefRepr;
import coins.flow.SetRefReprList;
import coins.flow.SubpFlow;
import coins.flow.UseDefChain;
import coins.flow.UseDefList;
import coins.ir.IR;
import coins.ir.hir.HIR;
import coins.ir.hir.VarNode;
import coins.opt.Opt;
import coins.opt.OptUtil;
import coins.sym.ExpId;
import coins.sym.FlowAnalSym;
import coins.sym.Sym;
import coins.sym.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;

public class ConstPropagationAndFolding {
    static final int JAVA_BYTE_SIZE = 1;
    static final int JAVA_CHAR_SIZE = 2;
    static final int JAVA_SHORT_SIZE = 2;
    static final int JAVA_INT_SIZE = 4;
    static final int JAVA_LONG_SIZE = 8;
    public final FlowRoot flowRoot;
    public final SymRoot symRoot;
    public final Sym sym;
    FlowResults fResults;
    public final Opt opt;
    public final SubpFlow fSubpFlow;
    protected UseDefList fUDList;
    protected DataFlow fDataFlow;
    protected final int fDbgLevel;

    public ConstPropagationAndFolding(FlowResults pResults) {
        this(pResults.flowRoot);
        this.fResults = pResults;
    }

    HIR SkipConv(HIR exp) {
        HIR Curr = exp;
        Type expType = exp.getType();
        while (Curr.getOperator() == 65 && Curr.getType().getTypeKind() == expType.getTypeKind()) {
            Curr = (HIR)Curr.getChild1();
        }
        return Curr;
    }

    private ConstPropagationAndFolding(FlowRoot pFlowRoot) {
        this.flowRoot = pFlowRoot;
        this.symRoot = this.flowRoot.symRoot;
        this.sym = this.symRoot.sym;
        this.opt = new Opt(this.flowRoot);
        this.fSubpFlow = this.flowRoot.fSubpFlow;
        this.fDbgLevel = this.flowRoot.ioRoot.dbgOpt1.getLevel();
    }

    public boolean doSubp(SubpFlow pSubpFlow) {
        boolean lChanged;
        boolean lChangedAtLeastOnce = false;
        this.fUDList = this.fSubpFlow.getUseDefList();
        this.fDataFlow = this.flowRoot.flow.dataFlow();
        this.fDataFlow.findUseDef();
        this.fDataFlow.findExposed();
        this.fDataFlow.findDefInDefOut();
        HashSet lReplacedNodes = new HashSet();
        do {
            lChanged = false;
            for (BBlock lBBlock : pSubpFlow.getListOfBBlocksFromEntry()) {
                lChanged = this.doBBlock(lBBlock, lReplacedNodes) || lChanged;
            }
            lChangedAtLeastOnce |= lChanged;
        } while (lChanged);
        return lChangedAtLeastOnce;
    }

    protected boolean doBBlock(BBlock pBBlock, Set pReplacedNodes) {
        if (pBBlock == null || pBBlock.getBBlockNumber() == 0) {
            return false;
        }
        SetRefReprList lSetRefReprs = this.fSubpFlow.getSetRefReprList(pBBlock);
        if (this.fDbgLevel >= 2) {
            this.flowRoot.ioRoot.dbgOpt1.print(2, "ConstPropagationAndFolding.doBBlock", "B" + pBBlock.getBBlockNumber());
            this.flowRoot.ioRoot.dbgOpt1.print(4, "lSetRefReprs", lSetRefReprs.toString());
        }
        HashMap lDefs = new HashMap();
        SubpFlow lSubpFlow = pBBlock.getSubpFlow();
        Object lCallNode = null;
        boolean lReplaced = false;
        for (SetRefRepr lSetRefRepr : lSetRefReprs) {
            ListIterator lExpIt = lSetRefRepr.expListIterator();
            while (lExpIt.hasNext()) {
                IR lParent;
                HIR Child2;
                Sym dSym;
                IR lDefNode;
                UseDefChain lUDChain;
                int llTypeKind;
                Sym sSym;
                ExpId lExpId;
                HIR p;
                IR lExp = (IR)lExpIt.next();
                if (pReplacedNodes.contains(lExp) || !FlowUtil.isLvalue(lExp) || FlowUtil.notDereferenced(lExp) || (p = (HIR)lExp.getParent()) != null && p.getOperator() == 32) continue;
                try {
                    int lTypeKind = lExp.getSym().getSymType().getTypeKind();
                    if (lTypeKind == 23 || lTypeKind == 24) {
                        continue;
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                if (lSetRefRepr.sets() && lExp == lSetRefRepr.defNode() || (lExpId = this.fSubpFlow.getExpId(lExp)) == null || (sSym = ((HIR)lExp).getSym()) == null || !(sSym instanceof FlowAnalSym) || lSubpFlow.setOfAddressTakenVariables().contains(sSym) || lSubpFlow.setOfGlobalVariables().contains(sSym) && lSubpFlow.hasCall() || lSubpFlow.getIndexedSym(((FlowAnalSym)sSym).getIndex()) == null || (llTypeKind = lExp.getSym().getSymType().getTypeKind()) > 12) continue;
                if (this.fDbgLevel > 3) {
                    this.opt.dbg(5, "Used var=", ((VarNode)lExp).getVar().toString());
                }
                if ((lUDChain = this.fUDList.getUseDefChain(lExp)) == null) continue;
                if (this.fDbgLevel > 3) {
                    this.opt.dbg(5, "lUDChain", lUDChain);
                }
                if (lUDChain.getDefList().size() != 1 || (lDefNode = (IR)lUDChain.getDefList().get(0)) == null || lDefNode == this.fSubpFlow.getFlowAdapter().dummyUninitialization || lDefNode == this.fSubpFlow.getFlowAdapter().dummySettingByParam || (dSym = ((HIR)lDefNode.getChild1()).getSym()) == null && !(dSym instanceof FlowAnalSym) || sSym != dSym) continue;
                FlowAnalSymVector lExposed = pBBlock.getExposed();
                FlowAnalSymVector lDefIn = pBBlock.getDefIn();
                if (lExposed.contains((FlowAnalSym)sSym) && !lDefIn.contains((FlowAnalSym)sSym) || !FlowUtil.isConstNode(Child2 = this.SkipConv((HIR)FlowUtil.getChild2(lDefNode))) || Child2.getType() != ((HIR)lExp).getType()) continue;
                HIR lConstNode = Child2.copyWithOperands();
                int pTypeKind = lConstNode.getSym().getSymType().getTypeKind();
                lReplaced = true;
                pReplacedNodes.add(lExp);
                OptUtil.replaceNode(lExp, lConstNode);
                IR lFoldedNode = lConstNode;
                while ((lParent = lFoldedNode.getParent()) != null && (lFoldedNode = OptUtil.fold(lParent, this.flowRoot)) != lParent && FlowUtil.isConstNode(lFoldedNode)) {
                }
            }
        }
        return lReplaced;
    }
}

