/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.FlowRoot;
import coins.IoRoot;
import coins.alias.AliasAnal;
import coins.alias.RecordAlias;
import coins.flow.BBlock;
import coins.flow.BBlockHir;
import coins.flow.BBlockHirImpl;
import coins.flow.BBlockHirSubtreeIteratorImpl;
import coins.flow.BBlockSubtreeIterator;
import coins.flow.BBlockSubtreeIteratorImpl;
import coins.flow.SetRefReprHirEImpl;
import coins.flow.SubpFlowImpl;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirList;
import coins.ir.hir.IfStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.VarNode;
import coins.opt.CommonSubexpElimHir;
import coins.opt.OptUtil;
import coins.sym.EnumType;
import coins.sym.ExpId;
import coins.sym.FlowAnalSym;
import coins.sym.PointerType;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.Var;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class CommonSubexpElimHirE
extends CommonSubexpElimHir {
    protected AliasAnal fAlias;
    protected RecordAlias fRecordAlias;
    protected Set fAvailableExps;
    protected Set fAvailableTemps;
    protected Set fReplacedNodes;
    protected Map fLatestNodeForExpId;
    protected int[] fExpCost;
    protected int fIndexMin;
    protected int fIndexMax;
    protected boolean fBeforePRE;
    protected int fThreshold;

    public CommonSubexpElimHirE(FlowRoot pFlowRoot, int pThreshold) {
        super(pFlowRoot);
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgOpt1.print(1, "\nCommonSubexpElimHirE instantiation " + this.flowRoot.subpUnderAnalysis.toStringShort() + " threshold " + pThreshold + "\n");
        }
        this.fGlobalExpTempMap = new HashMap();
        this.fGlobalTempExpMap = new HashMap();
        this.fThreshold = pThreshold;
    }

    public CommonSubexpElimHirE(FlowRoot pFlowRoot, int pThreshold, boolean pBeforePRE) {
        super(pFlowRoot);
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgOpt1.print(1, "\nCommonSubexpElimHirE. threshold=" + pThreshold + "\n");
        }
        this.fBeforePRE = pBeforePRE;
        this.fGlobalExpTempMap = new HashMap();
        this.fGlobalTempExpMap = new HashMap();
        this.fThreshold = pThreshold;
    }

    public boolean doBBlockLocal(BBlock pBBlock) {
        if (pBBlock == null || pBBlock.getBBlockNumber() == 0) {
            return false;
        }
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgOpt1.print(2, "doBBlockLocal Extended ", pBBlock.toString());
        }
        boolean lChanged = false;
        boolean lEliminated = false;
        this.fRecordAlias = this.fSubpFlow.getRecordAlias();
        ArrayList<Stmt> lStmtList = new ArrayList<Stmt>(50);
        Object lIterator = new BBlockHirSubtreeIteratorImpl(this.flowRoot, (BBlockHir)pBBlock);
        while (lIterator.hasNext()) {
            HIR lHir = (HIR)((BBlockSubtreeIteratorImpl)lIterator).next();
            if (!(lHir instanceof Stmt)) continue;
            lStmtList.add((Stmt)lHir);
        }
        this.fAvailableExps = new HashSet();
        this.fAvailableTemps = new HashSet();
        this.fReplacedNodes = new HashSet();
        this.fLatestNodeForExpId = new HashMap();
        lIterator = lStmtList.iterator();
        while (lIterator.hasNext()) {
            lEliminated = false;
            Stmt lStmt = (Stmt)lIterator.next();
            if (lStmt == null) continue;
            if (lStmt instanceof LabeledStmt || lStmt instanceof BlockStmt) {
                if (this.fDbgLevel <= 3) continue;
                this.flowRoot.ioRoot.dbgOpt1.print(4, "lapping Stmt", lStmt.toString() + " continue");
                continue;
            }
            if (this.fDbgLevel > 2) {
                this.flowRoot.ioRoot.dbgOpt1.print(3, "Stmt", lStmt.toString());
            }
            if (lStmt instanceof AssignStmt) {
                if (lStmt.getChild1().getChildCount() > 0) {
                    lEliminated = this.tryToEliminateSubexp((HIR)lStmt.getChild1(), pBBlock, lStmt);
                }
                if (this.tryToEliminateExp((HIR)lStmt.getChild2(), pBBlock, lStmt)) {
                    lEliminated = true;
                }
                this.adjustAvailability(lStmt, lStmt, pBBlock);
            } else {
                lEliminated = this.tryToEliminateSubexp(lStmt, pBBlock, lStmt) | lEliminated;
            }
            lChanged |= lEliminated;
        }
        return lChanged;
    }

    protected boolean tryToEliminateExp(HIR pExp, BBlock pBBlock, Stmt pStmt) {
        boolean lEliminated = false;
        if (pExp == null) {
            return false;
        }
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(4, "tryToEliminateExp", pExp.toStringShort());
        }
        if (pExp.getChildCount() == 0) {
            if (pExp instanceof HirList) {
                lEliminated = this.tryToEliminateSubexp(pExp, pBBlock, pStmt);
            } else if (pExp.getOperator() == 7 && pExp.getIndex() >= this.fIndexMin && pExp.getIndex() <= this.fIndexMax && this.fExpCost[pExp.getIndex() - this.fIndexMin] > this.fThreshold && !this.toBeExcluded(pExp)) {
                lEliminated = this.replaceAvailableExp(pExp, pBBlock, pStmt);
            }
        } else {
            if (!this.toBeExcluded(pExp)) {
                lEliminated = this.replaceAvailableExp(pExp, pBBlock, pStmt);
            }
            if (!lEliminated) {
                lEliminated = this.tryToEliminateSubexp(pExp, pBBlock, pStmt);
            }
            this.adjustAvailability(pExp, pStmt, pBBlock);
        }
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(5, " IS " + pExp.toStringShort() + " CHANGED:" + lEliminated);
        }
        return lEliminated;
    }

    protected boolean tryToEliminateSubexp(HIR pExp, BBlock pBBlock, Stmt pStmt) {
        boolean lChanged;
        block11: {
            block12: {
                block10: {
                    lChanged = false;
                    if (pExp == null) {
                        return false;
                    }
                    if (this.fDbgLevel > 3) {
                        this.flowRoot.ioRoot.dbgOpt1.print(4, " tryToEliminateSubexp", pExp.toStringShort());
                    }
                    if (pExp.getIndex() == 0) {
                        if (this.fDbgLevel > 3) {
                            this.flowRoot.ioRoot.dbgOpt1.print(4, "Generated HIR in tryToEliminateSubexp " + ((Object)pExp).toString());
                        }
                        return false;
                    }
                    if (!(pExp instanceof HirList)) break block10;
                    ListIterator lIterator = ((HirList)pExp).iterator();
                    while (lIterator.hasNext()) {
                        Object lElem = lIterator.next();
                        if (!(lElem instanceof Exp) || !this.tryToEliminateExp((Exp)lElem, pBBlock, pStmt)) continue;
                        lChanged = true;
                    }
                    break block11;
                }
                if (!(pExp instanceof AssignStmt)) break block12;
                Exp lLHS = (Exp)pExp.getChild1();
                if (this.tryToEliminateSubexp(lLHS, pBBlock, pStmt)) {
                    lChanged = true;
                }
                if (!this.tryToEliminateExp((Exp)pExp.getChild2(), pBBlock, pStmt)) break block11;
                lChanged = true;
                break block11;
            }
            if (pExp.getChildCount() == 0) {
                lChanged = this.tryToEliminateExp(pExp, pBBlock, pStmt);
            } else {
                for (int i = 1; i <= pExp.getChildCount(); ++i) {
                    HIR lChild = (HIR)pExp.getChild(i);
                    if (lChild == null) continue;
                    if (lChild.getIndex() == 0) {
                        if (this.fDbgLevel <= 3) continue;
                        this.flowRoot.ioRoot.dbgOpt1.print(4, "Generated HIR in tryToEliminateSubexp " + ((Object)lChild).toString());
                        continue;
                    }
                    if (this.fSubpFlow.getBBlockOfIR(lChild.getIndex()) != pBBlock || !this.tryToEliminateExp(lChild, pBBlock, pStmt)) continue;
                    lChanged = true;
                }
            }
        }
        return lChanged;
    }

    boolean toBeExcluded(HIR pHir) {
        Type lType;
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(4, " toBeExcluded", pHir.toStringShort());
        }
        HIR lHir = pHir;
        HIR lParent = (HIR)pHir.getParent();
        int lOpCode = pHir.getOperator();
        if (lOpCode == 36) {
            lHir = ((ExpStmt)pHir).getExp();
            lOpCode = lHir.getOperator();
        }
        boolean lExclude = lHir.getChildCount() == 0 && !(lHir instanceof VarNode) ? true : (lHir instanceof FunctionExp || lHir instanceof List || lOpCode >= 51 && lOpCode <= 56 || lOpCode == 66 || lOpCode == 67 || lOpCode == 68 || lOpCode == 35 || lParent.getOperator() == 64 || lParent.getOperator() == 68 || lHir instanceof VarNode && lHir.getType() instanceof PointerType ? true : (pHir.getParent() instanceof AssignStmt && pHir.getParent().getChild1() == pHir ? true : ((lType = pHir.getType()).isBasicType() || lType instanceof PointerType || lType instanceof EnumType ? this.containsCall(pHir) : true)));
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(4, " " + lExclude);
        }
        return lExclude;
    }

    public boolean containsCall(HIR pHir) {
        HirIterator lIterator = pHir.hirIterator(pHir);
        while (lIterator.hasNext()) {
            HIR lHir = lIterator.next();
            if (lHir == null || lHir.getOperator() != 33) continue;
            return true;
        }
        return false;
    }

    protected void adjustAvailability(HIR pExp, Stmt pStmt, BBlock pBBlock) {
        Set lAllSubexps;
        if (this.fDbgLevel > 2) {
            IoRoot cfr_ignored_0 = this.flowRoot.ioRoot;
            this.flowRoot.ioRoot.dbgOpt1.print(3, "  adjustAvailability", pExp.toStringShort() + " in " + IoRoot.toStringObjectShort(pStmt));
        }
        if (pExp.getIndex() == 0) {
            if (this.fDbgLevel > 3) {
                this.flowRoot.ioRoot.dbgOpt1.print(4, " Generated HIR for adjustAvailability " + ((Object)pExp).toString());
            }
            return;
        }
        SetRefReprHirEImpl lSetRefRepr = (SetRefReprHirEImpl)this.fSubpFlow.getSetRefReprOfIR(pStmt);
        if (lSetRefRepr == null) {
            lSetRefRepr = (SetRefReprHirEImpl)this.fSubpFlow.getSetRefReprOfIR(pExp);
        }
        if (lSetRefRepr == null) {
            if (this.fDbgLevel > 3) {
                this.flowRoot.ioRoot.dbgOpt1.print(4, " SetRefRepr is null " + ((Object)pExp).toString());
            }
            return;
        }
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(4, "lSetRefRepr", lSetRefRepr + " modSyms " + lSetRefRepr.toString() + " modSymStmt " + lSetRefRepr.modSymsStmt());
        }
        HashSet lModSyms = new HashSet();
        lModSyms.addAll(lSetRefRepr.modSyms());
        lModSyms.addAll(lSetRefRepr.modSymsStmt());
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(4, " lModSyms " + ((Object)lModSyms).toString());
        }
        if ((lAllSubexps = lSetRefRepr.allSubexps()).size() > 0) {
            this.fAvailableExps.addAll(lSetRefRepr.allSubexps());
        }
        HashSet lAvailableExps = new HashSet();
        lAvailableExps.addAll(this.fAvailableExps);
        if (lModSyms.size() > 0) {
            Set lModSymsAndAliases = this.fRecordAlias.aliasSymGroup(lModSyms);
            if (this.fDbgLevel > 3) {
                this.flowRoot.ioRoot.dbgOpt1.print(4, "  modSymsAndAliases ", lModSymsAndAliases.toString());
                this.flowRoot.ioRoot.dbgOpt1.print(4, "  fGlobalExpTempMap ", this.fGlobalExpTempMap.toString());
            }
            for (Sym lSym : lModSymsAndAliases) {
                for (ExpId lExpId : this.fAvailableExps) {
                    Set lLeafOperands;
                    HIR lExp;
                    if (lExpId == null) continue;
                    ExpId lExpIdR = lExpId.getExpInf().getRValueExpId();
                    if (lExpIdR != null) {
                        lExpId = lExpIdR;
                    }
                    if ((lExp = (HIR)lExpId.getLinkedNode()) == null) continue;
                    SetRefReprHirEImpl lExpSetRefRepr = (SetRefReprHirEImpl)this.fSubpFlow.getSetRefReprOfIR(lExp);
                    if (lExpSetRefRepr == null) {
                        if (this.fDbgLevel > 3) {
                            this.flowRoot.ioRoot.dbgOpt1.print(4, " SetRefRepr is null for " + lExp.toStringShort() + " operandSet " + lExpId.getOperandSet());
                        }
                        lLeafOperands = lExpId.getOperandSet();
                    } else {
                        lLeafOperands = lExpSetRefRepr.leafOperands();
                        lLeafOperands.addAll(lExpSetRefRepr.modSyms());
                    }
                    Set lLeafOperandsAndAliases = this.fRecordAlias.aliasSymGroup(lLeafOperands);
                    if (this.fDbgLevel >= 5) {
                        System.out.print("\n Examine " + lExp.toStringShort() + " " + lExpId.getName() + " leafs " + lLeafOperandsAndAliases.toString());
                    }
                    if (!lLeafOperandsAndAliases.contains(lSym) || !lAvailableExps.contains(lExpId)) continue;
                    if (this.fDbgLevel > 3) {
                        this.flowRoot.ioRoot.dbgOpt1.print(5, "\n  " + lExp.toStringShort() + " is killed by " + lSym.getName() + " remove " + lExpId.toStringShort());
                    }
                    lAvailableExps.remove(lExpId);
                    if (!this.fLatestNodeForExpId.containsKey(lExpId)) continue;
                    this.fLatestNodeForExpId.put(lExpId, null);
                }
                if (this.fDbgLevel > 3) {
                    this.flowRoot.ioRoot.dbgOpt1.print(5, "   adjusted available exps ", this.fSubpFlow.sortExpIdCollection(lAvailableExps).toString());
                }
                Iterator lTempIterator = this.fAvailableTemps.iterator();
                while (lTempIterator.hasNext()) {
                    Var lTempVar = (Var)lTempIterator.next();
                    ExpId lExpId2 = (ExpId)this.fGlobalTempExpMap.get(lTempVar);
                    if (this.fDbgLevel >= 5) {
                        System.out.print("\n examine " + lTempVar.getName() + " " + lExpId2.getName());
                    }
                    if (lAvailableExps.contains(lExpId2)) continue;
                    if (this.fDbgLevel > 3) {
                        this.flowRoot.ioRoot.dbgOpt1.print(5, " remove " + lTempVar.toStringShort());
                    }
                    lTempIterator.remove();
                }
            }
        }
        this.fAvailableExps = lAvailableExps;
        if (pExp.getExpId() != null && !this.toBeExcluded(pExp)) {
            this.fAvailableExps.add(pExp.getExpId());
        }
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(5, "adjustAvailability result:", pExp.toStringShort());
            this.flowRoot.ioRoot.dbgOpt1.print(5, "   fAvailableExps ", this.fSubpFlow.sortExpIdCollection(this.fAvailableExps).toString());
            this.flowRoot.ioRoot.dbgOpt1.print(5, "   fAvailableTemps ", this.fAvailableTemps.toString());
        }
    }

    protected boolean replaceAvailableExp(HIR pExp, BBlock pBBlock, Stmt pStmt) {
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(4, " replaceAvailableExp", pExp.toStringShort());
        }
        boolean lReplaced = false;
        int lIrIndex = pExp.getIndex();
        if (pExp.getIndex() == 0) {
            if (this.fDbgLevel > 3) {
                this.flowRoot.ioRoot.dbgOpt1.print(4, " Generated HIR for replaceAvailableExp " + ((Object)pExp).toString());
            }
            return false;
        }
        SetRefReprHirEImpl lSetRefRepr = (SetRefReprHirEImpl)this.fSubpFlow.getSetRefReprOfIR(pExp);
        if (lSetRefRepr == null) {
            return false;
        }
        FlowAnalSym lSym = pExp.getSymOrExpId();
        if (pExp.getOperator() == 7) {
            lSym = pExp.getExpId();
        }
        Set lOperands = lSetRefRepr.leafOperands();
        if (this.fDbgLevel >= 5) {
            System.out.print("  symOrExpId " + lSym + "\n");
            System.out.print("  leafOperands " + lOperands + "\n");
            System.out.print("  fAvailableExps " + this.fSubpFlow.sortExpIdCollection(this.fAvailableExps) + "\n");
        }
        if (lSym instanceof ExpId) {
            if (this.fAvailableExps.contains(lSym) && !this.toBeExcluded(pExp) && this.fExpCost[pExp.getIndex() - this.fIndexMin] >= this.fThreshold && (lReplaced = this.replaceExp(pExp, pBBlock, pStmt))) {
                return true;
            }
            if (!(pExp instanceof Var)) {
                this.fLatestNodeForExpId.put(lSym, pExp);
            }
        }
        return lReplaced;
    }

    protected boolean replaceExp(HIR pExp, BBlock pBBlock, Stmt pStmt) {
        VarNode lNewNode;
        Var lInsertedLHSVar;
        boolean lReplaced = false;
        Object lGlobalLHSVar = null;
        ExpId lExpId = pExp.getExpId();
        if (this.fDbgLevel > 2) {
            this.flowRoot.ioRoot.dbgOpt1.print(3, "replaceExp", pExp.toStringShort() + " " + lExpId.getName());
        }
        if (pExp.getType().getTypeKind() == 14) {
            return lReplaced;
        }
        if (pExp.getOperator() == 64) {
            return lReplaced;
        }
        if (this.fGlobalExpTempMap.containsKey(lExpId)) {
            lInsertedLHSVar = (Var)this.fGlobalExpTempMap.get(lExpId);
        } else {
            lInsertedLHSVar = this.symRoot.symTableCurrent.generateVar(pExp.getType(), this.symRoot.subpCurrent);
            this.recordTempExpCorrespondence(lInsertedLHSVar, (Exp)pExp);
        }
        if (this.fDbgLevel > 2) {
            this.flowRoot.ioRoot.dbgOpt1.print(3, " temp " + lInsertedLHSVar.toStringShort() + " for " + lExpId);
        }
        HIR lLatestCall = null;
        boolean lGlobalVarReplacement = pExp.getOperator() == 7 && ((Var)pExp.getSym()).isGlobal();
        if (!this.fAvailableTemps.contains(lInsertedLHSVar)) {
            HIR lLatestNode = this.fLatestNodeForExpId.containsKey(lExpId) ? (HIR)this.fLatestNodeForExpId.get(lExpId) : null;
            if (this.fDbgLevel > 2) {
                this.flowRoot.ioRoot.dbgOpt1.print(3, " latestNode " + lLatestNode);
            }
            if (lLatestNode == null) {
                return lReplaced;
            }
            HIR lInsertionPoint = lLatestNode;
            Stmt lInsertionPointStmt = lInsertionPoint.getStmtContainingThisNode();
            if (lGlobalVarReplacement && (lLatestCall = this.getLatestCall(pExp, pBBlock)) != null) {
                Stmt lLatestCallStmt = lLatestCall.getStmtContainingThisNode();
                Stmt lNextToLatestCall = lLatestCallStmt.getNextStmt();
                if (lNextToLatestCall == null || lNextToLatestCall.getIndex() > pExp.getIndex()) {
                    if (this.fDbgLevel > 2) {
                        this.flowRoot.ioRoot.dbgOpt1.print(3, " do not replace. ");
                    }
                    return lReplaced;
                }
                if (lNextToLatestCall.getIndex() > lInsertionPointStmt.getIndex()) {
                    lInsertionPoint = lNextToLatestCall;
                }
            }
            Stmt lStmtOfLatestNode = lInsertionPoint.getStmtContainingThisNode();
            Exp lInsertedRHS = (Exp)lLatestNode.copyWithOperands();
            VarNode lInsertedLHS = this.hir.varNode(lInsertedLHSVar);
            AssignStmt lInsertedStmt = this.hir.assignStmt(lInsertedLHS, lInsertedRHS);
            this.insertTheStatement(lStmtOfLatestNode, lInsertedStmt);
            VarNode lNewNode0 = this.hir.varNode(lInsertedLHSVar);
            if (lLatestNode.getIndex() > lStmtOfLatestNode.getIndex()) {
                this.replaceTheExpression(lLatestNode, lNewNode0, pBBlock);
            }
            this.fAvailableTemps.add(lInsertedLHSVar);
            if (pExp.getChildNumber() > 0 && lLatestNode.getChildNumber() > 0 && pExp != lLatestNode) {
                lNewNode = this.hir.varNode(lInsertedLHSVar);
                this.replaceTheExpression(pExp, lNewNode, pBBlock);
            }
        }
        lNewNode = this.hir.varNode(lInsertedLHSVar);
        this.replaceTheExpression(pExp, lNewNode, pBBlock);
        lReplaced = true;
        if (this.fDbgLevel > 2) {
            this.flowRoot.ioRoot.dbgOpt1.print(3, " replaceExp " + pExp.toStringShort() + " IS " + lReplaced);
        }
        return lReplaced;
    }

    protected boolean tryToReplaceSubexp(HIR pExp, BBlock pBBlock, Stmt pStmt) {
        boolean lReplaced = false;
        if (pExp == null || pExp.getChildCount() == 0) {
            return lReplaced;
        }
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(4, "  tryToReplaceSubexp", pExp.toStringShort());
        }
        if (pExp.getIndex() == 0) {
            if (this.fDbgLevel > 3) {
                this.flowRoot.ioRoot.dbgOpt1.print(4, " Generated HIR in tryToReplaceSubexp " + ((Object)pExp).toString());
            }
            return lReplaced;
        }
        for (int i = 1; i <= pExp.getChildCount(); ++i) {
            HIR lChild = (HIR)pExp.getChild(i);
            int lIrIndex = lChild.getIndex();
            if (lIrIndex == 0) {
                if (this.fDbgLevel > 3) {
                    this.flowRoot.ioRoot.dbgOpt1.print(4, " Generated HIR in tryToReplaceSubexp " + ((Object)lChild).toString());
                }
                return lReplaced;
            }
            SetRefReprHirEImpl lSetRefRepr = (SetRefReprHirEImpl)this.fSubpFlow.getSetRefReprOfIR(lChild);
            if (lSetRefRepr == null) {
                if (this.fDbgLevel > 3) {
                    this.flowRoot.ioRoot.dbgOpt1.print(4, " do not replace index " + lIrIndex);
                }
                return lReplaced;
            }
            FlowAnalSym lSym = lChild.getSymOrExpId();
            if (!(lSym instanceof ExpId) || !this.fAvailableExps.contains(lSym) || this.fExpCost[pExp.getIndex() - this.fIndexMin] < this.fThreshold || this.toBeExcluded(lChild)) continue;
            lReplaced = this.replaceExp(lChild, pBBlock, pStmt);
        }
        if (this.fDbgLevel > 2) {
            this.flowRoot.ioRoot.dbgOpt1.print(3, " tryToReplaceSubExp " + pExp.toStringShort() + " IS " + lReplaced);
        }
        return lReplaced;
    }

    protected boolean replaceTheExpression(HIR pOldExp, HIR pNewExp, BBlock pBBlock) {
        boolean lReplaced = false;
        if (pOldExp == null) {
            return lReplaced;
        }
        if (this.fDbgLevel > 2) {
            this.flowRoot.ioRoot.dbgOpt1.print(3, "replaceTheExpression", pOldExp.toStringShort() + " with " + pNewExp.toStringShort());
        }
        if (pOldExp.getChildNumber() < 0 && !(pOldExp.getParent() instanceof HirList) && !(pOldExp.getParent() instanceof BlockStmt)) {
            if (this.fDbgLevel > 0) {
                this.flowRoot.ioRoot.dbgOpt1.print(2, "Parameter of replaceTheExpression", ((Object)pOldExp).toString() + " should have childNumber ");
            }
            return lReplaced;
        }
        HirIterator lIterator = pOldExp.hirIterator(pOldExp);
        while (lIterator.hasNext()) {
            HIR lHir = lIterator.next();
            if (lHir == null) continue;
            this.fReplacedNodes.add(lHir);
        }
        OptUtil.replaceNode(pOldExp, pNewExp);
        return true;
    }

    protected void insertTheStatement(Stmt pInsertionPoint, Stmt pStmtToBeInserted) {
        HIR lContainingStmt;
        Exp lExp;
        Stmt lInsertionPoint;
        if (this.fDbgLevel > 2) {
            this.flowRoot.ioRoot.dbgOpt1.print(3, "insertTheStatement", pStmtToBeInserted.toString() + " at " + pInsertionPoint.toString());
        }
        if ((lInsertionPoint = pInsertionPoint) instanceof LabeledStmt) {
            Stmt lStmtBody = ((LabeledStmt)lInsertionPoint).getStmt();
            if (lStmtBody == null) {
                ((LabeledStmt)lInsertionPoint).setStmt(pStmtToBeInserted);
                return;
            }
            lInsertionPoint = lStmtBody;
        }
        if (lInsertionPoint instanceof ExpStmt && (lExp = ((ExpStmt)lInsertionPoint).getExp()).getType() == this.symRoot.typeBool && ((lContainingStmt = (HIR)pInsertionPoint.getParent()) instanceof IfStmt || lContainingStmt instanceof LoopStmt || lContainingStmt instanceof SwitchStmt)) {
            ((Stmt)lContainingStmt).combineWithConditionalExp(pStmtToBeInserted, lExp);
            return;
        }
        lInsertionPoint.insertPreviousStmt(pStmtToBeInserted, lInsertionPoint.getBlockStmt());
    }

    protected HIR getLatestNodeOfExp(HIR pExp, BBlock pBBlock) {
        List lNodeList;
        if (pExp == null) {
            return null;
        }
        ExpId lExpId = pExp.getExpId();
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(4, "getLatestNodeOfExp", pExp.toStringShort() + " expId " + lExpId + " " + pBBlock);
        }
        if ((lNodeList = ((BBlockHirImpl)pBBlock).getExpNodeList(lExpId)) == null) {
            if (this.fDbgLevel > 3) {
                this.flowRoot.ioRoot.dbgOpt1.print(4, " not found ");
            }
            return null;
        }
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(5, " NodeList", lNodeList.toString());
            this.flowRoot.ioRoot.dbgOpt1.print(5, " fReplacedNodes", this.fReplacedNodes.toString());
        }
        int lIndex = pExp.getIndex();
        HIR lHirPrev = pExp;
        for (HIR lHir : lNodeList) {
            if (this.fReplacedNodes.contains(lHir)) continue;
            int lIndexPrev = lHir.getIndex();
            if (lIndexPrev >= lIndex) break;
            lHirPrev = lHir;
        }
        if (lHirPrev != null) {
            HIR lParent = (HIR)lHirPrev.getParent();
            if (lParent instanceof AssignStmt && lParent.getChild1() == lHirPrev) {
                lHirPrev = null;
            }
            if (lHirPrev == pExp && pExp.getOperator() != 7) {
                lHirPrev = null;
            }
        }
        if (lHirPrev != null) {
            if (this.fDbgLevel > 3) {
                this.flowRoot.ioRoot.dbgOpt1.print(4, " latest " + lHirPrev.toStringShort());
            }
        } else if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(4, " not found ");
        }
        return lHirPrev;
    }

    protected HIR getLatestCall(HIR pExp, BBlock pBBlock) {
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(5, "getLatestCall", pExp.toStringShort() + " " + pBBlock);
        }
        int lIndex = pExp.getIndex();
        HIR lStmtWithCall = null;
        if (pExp.getOperator() == 7 && ((Var)pExp.getSym()).isGlobal()) {
            ExpId lExpIdG = pExp.getExpId();
            BBlockSubtreeIterator lIteratorS = pBBlock.bblockSubtreeIterator();
            while (lIteratorS.hasNext()) {
                Stmt lSubtree = (Stmt)lIteratorS.next();
                if (lSubtree instanceof BlockStmt) {
                    lSubtree = ((BlockStmt)lSubtree).getFirstStmt();
                }
                if (lSubtree == null || lSubtree.getIndex() == 0) continue;
                if (lSubtree.getIndex() > lIndex) break;
                SetRefReprHirEImpl lSetRefRepr = (SetRefReprHirEImpl)this.fSubpFlow.getSetRefReprOfIR(lSubtree);
                if (lSetRefRepr == null || !lSetRefRepr.hasCallWithSideEffect()) continue;
                lStmtWithCall = lSubtree;
            }
        }
        if (lStmtWithCall != null && this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(4, " getLatestCall  " + lStmtWithCall.toStringShort());
        }
        return lStmtWithCall;
    }

    public void estimateExpCost(SubpDefinition pSubpDef) {
        int lIndexMax = pSubpDef.getNodeIndexMax();
        this.fIndexMin = pSubpDef.getNodeIndexMin();
        this.fIndexMax = pSubpDef.getNodeIndexMax();
        this.fExpCost = new int[(lIndexMax - this.fIndexMin) * 2 + 1];
        if (this.fDbgLevel > 0) {
            this.dbg(2, "\n estimateExpCost " + pSubpDef.getSubpSym().toStringShort() + " index " + this.fIndexMin + "-" + lIndexMax);
        }
        this.estimateNodeCost(pSubpDef.getHirBody(), false);
        if (((SubpFlowImpl)this.fSubpFlow).fSubtreesCopied != null) {
            for (HIR lSubtree : ((SubpFlowImpl)this.fSubpFlow).fSubtreesCopied) {
                this.estimateNodeCost(lSubtree, false);
            }
        }
    }

    private int estimateNodeCost(HIR pHir, boolean pLValue) {
        int lCost = 0;
        if (pHir == null) {
            return 0;
        }
        int lOpCode = pHir.getOperator();
        int lChildCount = pHir.getChildCount();
        switch (lOpCode) {
            case 35: {
                for (Stmt lStmt = ((BlockStmt)pHir).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                    lCost += this.estimateNodeCost(lStmt, pLValue);
                }
                break;
            }
            case 14: {
                ListIterator lIterator = ((HirList)pHir).iterator();
                while (lIterator.hasNext()) {
                    lCost += this.estimateNodeCost((HIR)lIterator.next(), pLValue);
                }
                break;
            }
            case 7: {
                if (pLValue) {
                    lCost = 1;
                    break;
                }
                Var lVar = (Var)pHir.getSym();
                if (lVar.isGlobal()) {
                    lCost = this.flowRoot.ioRoot.machineParam.costOfInstruction(2);
                    break;
                }
                lCost = this.flowRoot.ioRoot.machineParam.costOfInstruction(1);
                break;
            }
            case 68: {
                lCost = this.flowRoot.ioRoot.machineParam.costOfInstruction(1) + this.estimateNodeCost((HIR)pHir.getChild1(), true);
                break;
            }
            case 17: {
                int lChildCost = this.estimateNodeCost((HIR)pHir.getChild1(), true) + this.estimateNodeCost((HIR)pHir.getChild2(), false);
                if (pLValue) {
                    lCost = 1 + lChildCost;
                    break;
                }
                lCost = this.flowRoot.ioRoot.machineParam.costOfInstruction(1) + lChildCost;
                break;
            }
            case 22: {
                int lChildCost = this.estimateNodeCost((HIR)pHir.getChild1(), true) + this.estimateNodeCost((HIR)pHir.getChild2(), false);
                lCost = lChildCost + 1;
                break;
            }
            case 33: {
                lCost = this.estimateNodeCost((HIR)pHir.getChild1(), true) + this.estimateNodeCost((HIR)pHir.getChild2(), false) + this.flowRoot.ioRoot.machineParam.costOfInstruction(3);
                break;
            }
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: {
                int lChildCost = this.estimateNodeCost((HIR)pHir.getChild1(), false) + this.estimateNodeCost((HIR)pHir.getChild2(), false);
                if (lOpCode == 41) {
                    lCost = lChildCost + 2;
                    break;
                }
                if (lOpCode == 42 || lOpCode == 43) {
                    lCost = lChildCost + 4;
                    break;
                }
                lCost = lChildCost + 1;
                break;
            }
            case 62: 
            case 63: {
                lCost = 1 + this.estimateNodeCost((HIR)pHir.getChild1(), false);
                break;
            }
            case 28: {
                lCost = 2 + this.estimateNodeCost((HIR)pHir.getChild1(), false);
                break;
            }
            case 23: {
                int lChildCost = this.estimateNodeCost((HIR)pHir.getChild1(), false) + (this.estimateNodeCost((HIR)pHir.getChild2(), false) + this.estimateNodeCost((HIR)pHir.getChild(3), false) + 1) / 2 + 2;
                break;
            }
            case 64: 
            case 66: 
            case 67: {
                for (int lChild = 1; lChild <= lChildCount; ++lChild) {
                    lCost += this.estimateNodeCost((HIR)pHir.getChild(lChild), true);
                }
                break;
            }
            case 3: 
            case 15: 
            case 16: 
            case 21: 
            case 36: {
                for (int lChild = 1; lChild <= lChildCount; ++lChild) {
                    lCost += this.estimateNodeCost((HIR)pHir.getChild(lChild), pLValue);
                }
                break;
            }
            default: {
                for (int lChild = 1; lChild <= lChildCount; ++lChild) {
                    lCost += this.estimateNodeCost((HIR)pHir.getChild(lChild), pLValue);
                }
            }
        }
        this.fExpCost[pHir.getIndex() - this.fIndexMin] = ++lCost;
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgOpt1.print(5, " nodeCost", lCost + " " + pHir.toStringShort());
        }
        return lCost;
    }

    void dbg(int level, Object pObject) {
        this.flowRoot.ioRoot.dbgOpt1.printObject(level, "", pObject);
    }

    void dbg(int level, String pHeader, Object pObject) {
        this.flowRoot.ioRoot.dbgOpt1.printObject(level, pHeader, pObject);
        this.flowRoot.ioRoot.dbgOpt1.println(level);
    }
}

