/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.FlowRoot;
import coins.HirRoot;
import coins.PassException;
import coins.SymRoot;
import coins.aflow.BBlock;
import coins.aflow.BBlockSubtreeIterator;
import coins.aflow.Flow;
import coins.aflow.FlowResults;
import coins.aflow.RegisterFlowAnalClasses;
import coins.aflow.SubpFlow;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.LabelDef;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.mdf.DataDependence;
import coins.mdf.FindScc;
import coins.mdf.MacroTask;
import coins.mdf.MdfEnvironment;
import coins.mdf.TreatLoop;
import coins.mdf.Util;
import coins.sym.Label;
import coins.sym.Sym;
import coins.sym.SymTable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class MacroFlowGraph {
    public final SubpDefinition subpDef;
    final SymRoot symRoot;
    public final HirRoot hirRoot;
    final SubpFlow subpFlow;
    final SymTable symTab;
    final Sym idSym;
    final Sym taskSym;
    private MdfEnvironment env;
    private int taskNumber;
    private LinkedList macroTasks;
    private Hashtable taskMapBBlock;
    private Hashtable taskMapLabel;
    final ControlBranch controlBranch;

    public MacroFlowGraph(MdfEnvironment e, HirRoot hRoot, SubpDefinition subpDefinition) throws PassException {
        this.env = e;
        this.taskNumber = 0;
        this.subpDef = subpDefinition;
        this.hirRoot = hRoot;
        this.symRoot = this.hirRoot.symRoot;
        this.symTab = this.subpDef.getSymTable();
        this.macroTasks = new LinkedList();
        this.taskMapBBlock = new Hashtable();
        this.taskMapLabel = new Hashtable();
        this.idSym = this.symTab.searchOrAdd("_mdf_threadID".intern(), 8, null, true, false);
        this.idSym.setSymType(this.symRoot.typeInt);
        this.taskSym = this.symTab.searchOrAdd("_mdf_task".intern(), 8, null, true, false);
        this.taskSym.setSymType(this.symRoot.typeInt);
        FlowResults.putRegClasses(new RegisterFlowAnalClasses());
        FlowRoot flowRoot = this.hirRoot.getFlowRoot();
        if (flowRoot == null) {
            flowRoot = new FlowRoot(this.hirRoot);
            this.hirRoot.attachFlowRoot(flowRoot);
        }
        Flow flow = flowRoot.aflow;
        FlowResults results = new FlowResults(flowRoot);
        this.subpFlow = flow.subpFlow(this.subpDef, results);
        flowRoot.aflow.setSubpFlow(this.subpFlow);
        this.subpFlow.controlFlowAnal();
        this.subpFlow.makeDominatorTree();
        this.divide(results);
        this.makeGraph();
        this.cleanUp();
        this.controlBranch = new ControlBranch(this);
    }

    private void divideLoops() {
    }

    private void cleanUp() {
    }

    private void makeGraph() throws PassException {
        for (MacroTask mt : this.macroTasks) {
            if (mt.hasReturn()) continue;
            for (BBlock exitBlk : mt.exitBlks()) {
                for (BBlock blk : exitBlk.getSuccList()) {
                    MacroTask succ = (MacroTask)this.taskMapBBlock.get(blk);
                    if (mt == succ || mt.succList.contains(succ)) continue;
                    mt.succList.add(succ);
                    if (succ.predList.contains(mt)) continue;
                    succ.predList.add(mt);
                }
            }
        }
    }

    private void divide(FlowResults results) {
        FindScc findScc = new FindScc(this.env, this.subpFlow);
        LinkedList<BBlock> visited = new LinkedList<BBlock>();
        for (LinkedList elem : findScc.scc) {
            if (elem.size() == 0) continue;
            MacroTask mt = null;
            for (BBlock blk : elem) {
                if (visited.contains(blk)) continue;
                visited.add(blk);
                if (mt == null) {
                    mt = new MacroTask(this.env, this.taskNumber++, this.symTab.generateLabel());
                }
                this.taskMapBBlock.put(blk, mt);
                this.taskMapLabel.put(blk.getLabel(), mt);
                mt.addBasicBlk(blk);
                Stmt stmt = null;
                BBlockSubtreeIterator subIte = blk.bblockSubtreeIterator();
                while (subIte.hasNext()) {
                    stmt = (Stmt)subIte.next();
                    if (stmt instanceof LabeledStmt) {
                        IrList list = ((LabeledStmt)stmt).getLabelDefList();
                        ListIterator lite = list.iterator();
                        while (lite.hasNext()) {
                            Label ll = ((LabelDef)lite.next()).getLabel();
                            MacroTask m = (MacroTask)this.taskMapLabel.get(ll);
                            if (m != null) {
                                this.taskMapLabel.remove(ll);
                            }
                            this.taskMapLabel.put(ll, mt);
                        }
                        continue;
                    }
                    if (stmt instanceof BlockStmt) continue;
                }
                if (!(stmt instanceof LoopStmt)) continue;
                TreatLoop data = new TreatLoop(this.env, this, (LoopStmt)stmt, new LinkedList());
                for (int i = 1; i <= stmt.getChildCount(); ++i) {
                    HIR child = (HIR)stmt.getChild(i);
                    LinkedList labList = data.getLabelsInLoop(child, new LinkedList());
                    for (LabeledStmt labeledStmt : labList) {
                        BBlock blkInLoop = null;
                        blkInLoop = results.getBBlockForLabel(labeledStmt.getLabel());
                        if (blkInLoop == null) continue;
                        visited.add(blkInLoop);
                        this.taskMapBBlock.put(blkInLoop, mt);
                        this.taskMapLabel.put(blkInLoop.getLabel(), mt);
                        mt.addBasicBlk(blkInLoop);
                    }
                }
            }
            if (mt == null) continue;
            this.macroTasks.add(mt);
        }
    }

    int bound() {
        return this.taskNumber;
    }

    int numberOfMacroTasks() {
        return this.macroTasks.size();
    }

    MacroTask macroTask(BBlock blk) {
        return (MacroTask)this.taskMapBBlock.get(blk);
    }

    MacroTask macroTask(Label label) {
        return (MacroTask)this.taskMapLabel.get(label);
    }

    public ListIterator listIterator() {
        return this.macroTasks.listIterator();
    }

    MacroTask entryBlk() {
        for (MacroTask mt : this.macroTasks) {
            if (mt.predList.size() != 0) continue;
            return mt;
        }
        return null;
    }

    List exitBlks() {
        LinkedList<MacroTask> exitBlks = new LinkedList<MacroTask>();
        ListIterator ite = this.macroTasks.listIterator(this.macroTasks.size());
        while (ite.hasPrevious()) {
            MacroTask mt = (MacroTask)ite.previous();
            if (mt.succList.size() != 0 || exitBlks.contains(mt)) continue;
            exitBlks.add(mt);
        }
        return exitBlks;
    }

    void print() {
        this.env.output.println("== MacroFlowGraph for " + this.subpDef.getSubpSym().getName() + " ==");
        for (MacroTask mt : this.macroTasks) {
            this.env.output.println(mt);
        }
    }

    void printGraph(String filename) throws PassException {
        OutputStreamWriter output = new OutputStreamWriter(System.out);
        try {
            FileOutputStream outStream = new FileOutputStream(filename);
            output = new OutputStreamWriter(outStream);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            output.write("digraph G {\n");
        }
        catch (IOException e) {
            this.env.output.println("digraph G {");
        }
        DataDependence ddep = new DataDependence(this.env, this);
        for (MacroTask mt : this.macroTasks) {
            mt.printGraph(output);
            try {
                output.write(mt.taskNumber() + " -> {");
            }
            catch (IOException e) {
                this.env.output.print(mt.taskNumber() + " -> {");
            }
            for (MacroTask dMt : ddep.depend(mt)) {
                try {
                    output.write(dMt.taskNumber() + " ");
                }
                catch (IOException e) {
                    this.env.output.print(dMt.taskNumber() + " ");
                }
            }
            try {
                output.write("} [color=red,dir=back]\n");
            }
            catch (IOException e) {
                this.env.output.println("} [color=red]");
            }
        }
        try {
            output.write("}\n");
            output.close();
        }
        catch (IOException e) {
            this.env.output.println("}");
        }
    }

    class ControlBranch {
        private int number = 0;
        private Hashtable srcMap = new Hashtable();
        private Hashtable branchTable = new Hashtable();
        private MacroFlowGraph mfg;

        ControlBranch(MacroFlowGraph mfg) {
            ListIterator ite = mfg.listIterator();
            while (ite.hasNext()) {
                MacroTask mt = (MacroTask)ite.next();
                if (mt.succList.size() <= 1) continue;
                Hashtable<MacroTask, Integer> dstMap = (Hashtable<MacroTask, Integer>)this.srcMap.get(mt);
                if (dstMap == null) {
                    dstMap = new Hashtable<MacroTask, Integer>();
                    this.srcMap.put(mt, dstMap);
                }
                ListIterator succIte = mt.succList.listIterator();
                while (succIte.hasNext()) {
                    MacroTask succ = (MacroTask)succIte.next();
                    Integer num = (Integer)dstMap.get(succ);
                    if (num != null) continue;
                    MacroTask[] br = new MacroTask[]{mt, succ};
                    this.branchTable.put(new Integer(this.number), br);
                    dstMap.put(succ, new Integer(this.number++));
                }
            }
        }

        int size() {
            return this.number;
        }

        MacroTask[] branchPair(int num) {
            return (MacroTask[])this.branchTable.get(new Integer(num));
        }

        int branchUniqueNum(MacroTask src, MacroTask dst) {
            Hashtable dstMap = (Hashtable)this.srcMap.get(src);
            if (dstMap == null) {
                return -1;
            }
            Integer num = (Integer)dstMap.get(dst);
            if (num == null) {
                return -1;
            }
            return num;
        }

        int[] whichCond(MacroTask src, MacroTask dst) {
            Util util = new Util(MacroFlowGraph.this.env, this.mfg);
            LinkedList list = util.findPreBlks(dst, new LinkedList());
            LinkedList<MacroTask> result = new LinkedList<MacroTask>();
            ListIterator ite = src.succList.listIterator();
            while (ite.hasNext()) {
                MacroTask succ = (MacroTask)ite.next();
                if (!list.contains(succ)) continue;
                result.add(succ);
            }
            int[] res = new int[result.size()];
            int i = 0;
            ListIterator ite2 = result.listIterator();
            while (ite2.hasNext()) {
                MacroTask mt = (MacroTask)ite2.next();
                res[i++] = this.branchUniqueNum(src, mt);
            }
            return res;
        }
    }
}

