/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.HirRoot;
import coins.IoRoot;
import coins.PassException;
import coins.SymRoot;
import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.F77Driver;
import coins.driver.PassStopException;
import coins.driver.Suffix;
import coins.driver.TemporaryFileManager;
import coins.driver.Trace;
import coins.mdf.MdfDriver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FCoCo
extends F77Driver {
    protected String myName = "FCoCo";
    protected static final String DEFAULT_OMPC_NAME = "omcc";
    protected static final String OMPC_NAME_OPTION = "ompc";

    public void compile(File sourceFile, Suffix suffix, InputStream in, OutputStream out, IoRoot io) throws IOException, PassException {
        Iterator ite;
        List list;
        String dstName;
        String srcName;
        CompileSpecification spec = io.getCompileSpecification();
        CoinsOptions coinsOptions = spec.getCoinsOptions();
        Trace trace = spec.getTrace();
        SymRoot symRoot = new SymRoot(io);
        HirRoot hirRoot = new HirRoot(symRoot);
        symRoot.attachHirRoot(hirRoot);
        symRoot.initiate();
        this.makeHirFromSource(sourceFile, hirRoot, suffix, in, io);
        if (!coinsOptions.isSet("onlyhir2c")) {
            MdfDriver mdfDriver = new MdfDriver(hirRoot, io, spec);
            mdfDriver.invoke();
        }
        TemporaryFileManager tmpMngr = new TemporaryFileManager();
        File dest = tmpMngr.createTemporaryFile(".c");
        FileOutputStream fout = new FileOutputStream(dest);
        this.callHirBaseToC(hirRoot, symRoot, io, fout);
        LinkedList<Object> options = new LinkedList<Object>();
        String commandName = DEFAULT_OMPC_NAME;
        if (coinsOptions.isSet(OMPC_NAME_OPTION) && (commandName = coinsOptions.getArg(OMPC_NAME_OPTION)).equals("cc")) {
            options.add("-xopenmp");
        }
        if (spec.isSet("-S")) {
            options.add("-S");
            if (!spec.isSet("-o")) {
                srcName = sourceFile.getAbsolutePath();
                dstName = srcName.substring(0, srcName.lastIndexOf(".c")) + ".s";
                options.add("-o");
                options.add(dstName);
            }
        } else if (spec.isSet("-c")) {
            options.add("-c");
            if (!spec.isSet("-o")) {
                srcName = sourceFile.getAbsolutePath();
                dstName = srcName.substring(0, srcName.lastIndexOf(".c")) + ".o";
                options.add("-o");
                options.add(dstName + " ");
            }
        } else {
            if (spec.isSet("-l")) {
                list = (List)spec.getArg("-l");
                ite = list.iterator();
                while (ite.hasNext()) {
                    options.add("-l" + (String)ite.next());
                }
            }
            if (spec.isSet("-L")) {
                list = (List)spec.getArg("-L");
                ite = list.iterator();
                while (ite.hasNext()) {
                    options.add("-L" + (String)ite.next());
                }
            }
        }
        if (spec.isSet("-o")) {
            options.add("-o");
            options.add(spec.getArg("-o"));
        }
        if (spec.isSet("-D")) {
            list = (List)spec.getArg("-D");
            ite = list.iterator();
            while (ite.hasNext()) {
                options.add("-D" + (String)ite.next());
            }
        }
        if (spec.isSet("-U")) {
            list = (List)spec.getArg("-U");
            ite = list.iterator();
            while (ite.hasNext()) {
                options.add("-U" + (String)ite.next());
            }
        }
        if (spec.isSet("-W")) {
            list = (List)spec.getArg("-W");
            ite = list.iterator();
            while (ite.hasNext()) {
                options.add("-W" + (String)ite.next());
            }
        }
        if (spec.isSet("-I")) {
            list = (List)spec.getArg("-I");
            ite = list.iterator();
            while (ite.hasNext()) {
                options.add("-I" + (String)ite.next());
            }
        }
        if (spec.isSet("-O")) {
            list = (List)spec.getArg("-O");
            ite = list.iterator();
            while (ite.hasNext()) {
                options.add("-O" + (String)ite.next());
            }
        }
        options.add(dest.getPath());
        if (this.runProgram(commandName, options, null, io.msgOut, io) != 0) {
            throw new PassException(sourceFile, OMPC_NAME_OPTION, "Error(s) in ompc.");
        }
        tmpMngr.cleanupTemporaryFiles();
        throw new PassStopException("FCoCo", "exit");
    }

    public static void main(String[] args) {
        new FCoCo().go(args);
    }
}

