/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.PassException;
import coins.aflow.BBlock;
import coins.aflow.BBlockSubtreeIterator;
import coins.ir.IrList;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.ForStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HirList;
import coins.ir.hir.HirSeq;
import coins.ir.hir.IfStmt;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpNode;
import coins.ir.hir.SubscriptedExp;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.VarNode;
import coins.ir.hir.WhileStmt;
import coins.mdf.DeclareExternVariables;
import coins.mdf.DeclareGlobalVariables;
import coins.mdf.DeclareLocalVariables;
import coins.mdf.DeclarePragmas;
import coins.mdf.DeclarePtestVariables;
import coins.mdf.MacroFlowGraph;
import coins.mdf.MacroTask;
import coins.mdf.MdfConditions;
import coins.mdf.MdfEnvironment;
import coins.mdf.TreatIf;
import coins.mdf.TreatLoop;
import coins.mdf.TreatSwitch;
import coins.mdf.Util;
import coins.sym.Label;
import coins.sym.Sym;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.Var;
import java.util.LinkedList;
import java.util.ListIterator;

class ChangeStructure {
    public static final int THR = 2000;
    private MdfEnvironment env;
    private MacroFlowGraph mfg;
    private Label endLabel;
    private SymTable symTab;
    private HIR hirFact;
    private Sym symFact;
    private DeclareExternVariables decExtern;
    private DeclarePtestVariables decPtest;
    private DeclareGlobalVariables decGlobal;
    private DeclareLocalVariables decLocal;
    private DeclarePragmas decPragma;
    private MdfConditions cond;
    private JumpStmt extraJump = null;

    ChangeStructure(MdfEnvironment e, MacroFlowGraph graph) throws PassException {
        this.env = e;
        this.mfg = graph;
        this.cond = new MdfConditions(this.env, this.mfg);
        this.symTab = this.mfg.symTab;
        this.hirFact = this.mfg.hirRoot.hir;
        this.symFact = this.mfg.symRoot.sym;
        this.decPragma = new DeclarePragmas(this.env, this.mfg);
        this.endLabel = this.symTab.generateLabel();
        this.mfg.symRoot.symTableCurrent = this.mfg.symRoot.symTableRoot;
        this.decExtern = new DeclareExternVariables(this.symFact, this.mfg.symRoot);
        this.decGlobal = new DeclareGlobalVariables(this.symFact, this.mfg.symRoot);
        if (this.env.opt.isSet("mdf-ptest")) {
            this.decPtest = new DeclarePtestVariables(this.symFact, this.mfg.symRoot);
        }
        this.mfg.symRoot.symTableCurrent = this.mfg.symTab;
        this.decLocal = new DeclareLocalVariables(this.env, this.mfg);
        BlockStmt allBlk = this.hirFact.blockStmt(null);
        VarNode taskInitVar = this.hirFact.varNode((Var)this.mfg.taskSym);
        AssignStmt taskInitAssign = this.hirFact.assignStmt(taskInitVar, this.hirFact.intConstNode(-1));
        allBlk.addLastStmt(taskInitAssign);
        VarNode finishVar = this.hirFact.varNode(this.decLocal.allFinishVar);
        AssignStmt finishInitAssign = this.hirFact.assignStmt(finishVar, this.hirFact.intConstNode(0));
        allBlk.addLastStmt(finishInitAssign);
        VarNode idVarNode = this.hirFact.varNode((Var)this.mfg.idSym);
        AssignStmt idAssign = this.hirFact.assignStmt(idVarNode, this.hirFact.intConstNode(0));
        allBlk.addLastStmt(idAssign);
        VarNode ompLockNode = this.hirFact.varNode(this.decLocal.ompLock);
        Exp ompLockExp = this.hirFact.exp(64, ompLockNode);
        SubpNode ompInitLockNode = this.hirFact.subpNode(this.decExtern.initLock);
        IrList ompInitLockParam = this.hirFact.irList();
        ompInitLockParam.add(ompLockExp);
        ExpStmt ompInitLockCall = this.hirFact.callStmt(ompInitLockNode, ompInitLockParam);
        ompInitLockCall.addInf("coins_omp", this.decPragma.ifdef);
        allBlk.addLastStmt(ompInitLockCall);
        BlockStmt initTaskBlk = this.makeInitTask();
        initTaskBlk.addInf("coins_omp", this.decPragma.endif);
        allBlk.addLastStmt(initTaskBlk);
        int numThreads = 2;
        if (this.env.opt.isSet("omp-threads")) {
            numThreads = Integer.parseInt(this.env.opt.getArg("omp-threads"));
        }
        this.env.println("MDF : The number of threads ==> " + numThreads, 2000);
        SubpNode ompSetNumThreadsNode = this.hirFact.subpNode(this.decExtern.setNumThreads);
        IrList ompSetNumThreadsParam = this.hirFact.irList();
        ompSetNumThreadsParam.add(this.hirFact.intConstNode(numThreads));
        ExpStmt ompSetNumThreadsCall = this.hirFact.callStmt(ompSetNumThreadsNode, ompSetNumThreadsParam);
        ompSetNumThreadsCall.addInf("coins_omp", this.decPragma.ifdef);
        allBlk.addLastStmt(ompSetNumThreadsCall);
        Stmt nullStmt = this.hirFact.nullStmt();
        nullStmt.addInf("coins_omp", this.decPragma.endif);
        allBlk.addLastStmt(nullStmt);
        BlockStmt pragmaBlock = this.hirFact.blockStmt(null);
        pragmaBlock.addInf("coins_omp", this.decPragma.parallel);
        allBlk.addLastStmt(pragmaBlock);
        if (this.env.opt.isSet("mdf-ptest")) {
            SubpNode watchingReportNode = this.hirFact.subpNode(this.decPtest.watchingReport);
            ExpStmt watchingReportCall = this.hirFact.callStmt(watchingReportNode, this.hirFact.irList());
            watchingReportCall.addInf("coins_omp", this.decPragma.ptest);
            allBlk.addLastStmt(watchingReportCall);
            nullStmt = this.hirFact.nullStmt();
            nullStmt.addInf("coins_omp", this.decPragma.endif);
            allBlk.addLastStmt(nullStmt);
        }
        ompLockNode = this.hirFact.varNode(this.decLocal.ompLock);
        ompLockExp = this.hirFact.exp(64, ompLockNode);
        SubpNode ompDestroyLockNode = this.hirFact.subpNode(this.decExtern.destroyLock);
        IrList ompDestroyLockParam = this.hirFact.irList();
        ompDestroyLockParam.add(ompLockExp);
        ExpStmt ompDestroyLockCall = this.hirFact.callStmt(ompDestroyLockNode, ompDestroyLockParam);
        ompDestroyLockCall.addInf("coins_omp", this.decPragma.ifdef);
        allBlk.addLastStmt(ompDestroyLockCall);
        ReturnStmt returnStmt = null;
        if (this.decLocal.returnStatus == null) {
            returnStmt = this.hirFact.returnStmt();
        } else {
            VarNode statusExp = this.hirFact.varNode(this.decLocal.returnStatus);
            returnStmt = this.hirFact.returnStmt(statusExp);
        }
        returnStmt.addInf("coins_omp", this.decPragma.endif);
        allBlk.addLastStmt(returnStmt);
        idVarNode = this.hirFact.varNode((Var)this.mfg.idSym);
        SubpNode getThreadNode = this.hirFact.subpNode(this.decExtern.getThreadNum);
        ExpStmt getThreadCall = this.hirFact.callStmt(getThreadNode, this.hirFact.irList());
        AssignStmt getThreadAssign = this.hirFact.assignStmt(idVarNode, getThreadCall.getExp());
        getThreadAssign.addInf("coins_omp", this.decPragma.ifdef);
        pragmaBlock.addLastStmt(getThreadAssign);
        nullStmt = this.hirFact.nullStmt();
        nullStmt.addInf("coins_omp", this.decPragma.endif);
        pragmaBlock.addLastStmt(nullStmt);
        if (this.env.opt.isSet("mdf-ptest")) {
            idVarNode = this.hirFact.varNode((Var)this.mfg.idSym);
            SubpNode threadStartNode = this.hirFact.subpNode(this.decPtest.threadStart);
            IrList threadStartParam = this.hirFact.irList();
            threadStartParam.add(idVarNode);
            ExpStmt threadStartCall = this.hirFact.callStmt(threadStartNode, threadStartParam);
            threadStartCall.addInf("coins_omp", this.decPragma.ptest);
            pragmaBlock.addLastStmt(threadStartCall);
            nullStmt = this.hirFact.nullStmt();
            nullStmt.addInf("coins_omp", this.decPragma.endif);
            pragmaBlock.addLastStmt(nullStmt);
        }
        BlockStmt whileBody = this.hirFact.blockStmt(null);
        Exp whileCond = this.hirFact.exp(52, this.hirFact.intConstNode(1), this.hirFact.intConstNode(0));
        Label whileEndLabel = this.symTab.generateLabel();
        Label whileBackLabel = this.symTab.generateLabel();
        Label whileStepLabel = this.symTab.generateLabel();
        finishVar = this.hirFact.varNode(this.decLocal.allFinishVar);
        Exp breakWhileCond = this.hirFact.exp(52, finishVar, this.hirFact.intConstNode(0));
        JumpStmt breakWhileStmt = this.hirFact.jumpStmt(whileEndLabel);
        IfStmt breakWhileIf = this.hirFact.ifStmt(breakWhileCond, breakWhileStmt, null);
        whileBody.addLastStmt(breakWhileIf);
        ompLockNode = this.hirFact.varNode(this.decLocal.ompLock);
        ompLockExp = this.hirFact.exp(64, ompLockNode);
        SubpNode ompSetLockNode = this.hirFact.subpNode(this.decExtern.setLock);
        IrList ompSetLockParam = this.hirFact.irList();
        ompSetLockParam.add(ompLockExp);
        ExpStmt ompSetLockCall = this.hirFact.callStmt(ompSetLockNode, ompSetLockParam);
        ompSetLockCall.addInf("coins_omp", this.decPragma.ifdef);
        whileBody.addLastStmt(ompSetLockCall);
        BlockStmt getTaskBlk = this.makeGetTask();
        getTaskBlk.addInf("coins_omp", this.decPragma.endif);
        whileBody.addLastStmt(getTaskBlk);
        ompLockNode = this.hirFact.varNode(this.decLocal.ompLock);
        ompLockExp = this.hirFact.exp(64, ompLockNode);
        SubpNode ompUnsetLockNode = this.hirFact.subpNode(this.decExtern.unsetLock);
        IrList ompUnsetLockParam = this.hirFact.irList();
        ompUnsetLockParam.add(ompLockExp);
        ExpStmt ompUnsetLockCall = this.hirFact.callStmt(ompUnsetLockNode, ompUnsetLockParam);
        ompUnsetLockCall.addInf("coins_omp", this.decPragma.ifdef);
        whileBody.addLastStmt(ompUnsetLockCall);
        VarNode taskVar = this.hirFact.varNode((Var)this.mfg.taskSym);
        HirList labelList = (HirList)this.hirFact.irList(new LinkedList());
        BlockStmt switchBody = this.makeSwitchBody(labelList);
        SwitchStmt switchStmt = this.hirFact.switchStmt(taskVar, labelList, this.symTab.generateLabel(), switchBody, this.endLabel);
        switchStmt.addInf("coins_omp", this.decPragma.endif);
        whileBody.addLastStmt(switchStmt);
        WhileStmt whileStmt = this.hirFact.whileStmt(whileBackLabel, whileCond, whileBody, whileStepLabel, whileEndLabel);
        whileStmt.removeInf("coins_omp");
        pragmaBlock.addLastStmt(whileStmt);
        if (this.env.opt.isSet("mdf-ptest")) {
            idVarNode = this.hirFact.varNode((Var)this.mfg.idSym);
            SubpNode watchingEndNode = this.hirFact.subpNode(this.decPtest.watchingEnd);
            IrList watchingEndParam = this.hirFact.irList();
            watchingEndParam.add(idVarNode);
            ExpStmt watchingEndCall = this.hirFact.callStmt(watchingEndNode, watchingEndParam);
            watchingEndCall.addInf("coins_omp", this.decPragma.ptest);
            pragmaBlock.addLastStmt(watchingEndCall);
            nullStmt = this.hirFact.nullStmt();
            nullStmt.addInf("coins_omp", this.decPragma.endif);
            pragmaBlock.addLastStmt(nullStmt);
        }
        allBlk.setSymTable(this.symTab);
        this.mfg.subpDef.setHirBody(allBlk);
    }

    BlockStmt makeInitTask() {
        AssignStmt assignStmt;
        int i;
        AssignStmt assignStmt2;
        ConstNode cst;
        long tmp;
        SubscriptedExp subExp2;
        SubscriptedExp subExp1;
        int j;
        int i2;
        Util util = new Util(this.env, this.mfg);
        int arraySize = util.numberOfConditions();
        int vectSize = util.vectorSize();
        int condSize = this.mfg.bound();
        BlockStmt initTaskBlk = this.hirFact.blockStmt(null);
        Type type_uint = this.mfg.symRoot.typeU_Int;
        for (i2 = 0; i2 < condSize; ++i2) {
            int[] exec = this.cond.exec.bitVector(i2);
            for (j = 0; j < vectSize; ++j) {
                VarNode execNode = this.hirFact.varNode(this.decLocal.execCond);
                subExp1 = this.hirFact.subscriptedExp(execNode, this.hirFact.intConstNode(i2));
                subExp2 = this.hirFact.subscriptedExp(subExp1, this.hirFact.intConstNode(j));
                tmp = Long.parseLong(Integer.toHexString(exec[j]), 16);
                cst = this.hirFact.constNode(this.symFact.intConst(tmp, type_uint));
                assignStmt2 = this.hirFact.assignStmt(subExp2, cst);
                initTaskBlk.addLastStmt(assignStmt2);
            }
        }
        for (i2 = 0; i2 < condSize; ++i2) {
            int[] nonExec = this.cond.nonExec.bitVector(i2);
            for (j = 0; j < vectSize; ++j) {
                VarNode nonExecNode = this.hirFact.varNode(this.decLocal.nonExecCond);
                subExp1 = this.hirFact.subscriptedExp(nonExecNode, this.hirFact.intConstNode(i2));
                subExp2 = this.hirFact.subscriptedExp(subExp1, this.hirFact.intConstNode(j));
                tmp = Long.parseLong(Integer.toHexString(nonExec[j]), 16);
                cst = this.hirFact.constNode(this.symFact.intConst(tmp, type_uint));
                assignStmt2 = this.hirFact.assignStmt(subExp2, cst);
                initTaskBlk.addLastStmt(assignStmt2);
            }
        }
        for (i2 = 0; i2 < condSize; ++i2) {
            int[] access = this.cond.access.bitVector(i2);
            for (j = 0; j < vectSize; ++j) {
                VarNode dataAccessNode = this.hirFact.varNode(this.decLocal.dataAccessCond);
                subExp1 = this.hirFact.subscriptedExp(dataAccessNode, this.hirFact.intConstNode(i2));
                subExp2 = this.hirFact.subscriptedExp(subExp1, this.hirFact.intConstNode(j));
                tmp = Long.parseLong(Integer.toHexString(access[j]), 16);
                cst = this.hirFact.constNode(this.symFact.intConst(tmp, type_uint));
                assignStmt2 = this.hirFact.assignStmt(subExp2, cst);
                initTaskBlk.addLastStmt(assignStmt2);
            }
        }
        for (i2 = 0; i2 < arraySize; ++i2) {
            int[] finish = this.cond.finish.bitVector(i2);
            for (j = 0; j < vectSize; ++j) {
                VarNode finishNode = this.hirFact.varNode(this.decLocal.finishCondition);
                subExp1 = this.hirFact.subscriptedExp(finishNode, this.hirFact.intConstNode(i2));
                subExp2 = this.hirFact.subscriptedExp(subExp1, this.hirFact.intConstNode(j));
                tmp = Long.parseLong(Integer.toHexString(finish[j]), 16);
                cst = this.hirFact.constNode(this.symFact.intConst(tmp, type_uint));
                assignStmt2 = this.hirFact.assignStmt(subExp2, cst);
                initTaskBlk.addLastStmt(assignStmt2);
            }
        }
        for (i2 = 0; i2 < vectSize; ++i2) {
            VarNode statNode = this.hirFact.varNode(this.decLocal.curStat);
            SubscriptedExp subExp12 = this.hirFact.subscriptedExp(statNode, this.hirFact.intConstNode(i2));
            AssignStmt assignStmt3 = this.hirFact.assignStmt(subExp12, this.hirFact.intConstNode(0));
            initTaskBlk.addLastStmt(assignStmt3);
        }
        int[] readyTask = this.cond.readyTasks();
        int[] mark = new int[condSize];
        for (i = 0; i < condSize; ++i) {
            mark[i] = 0;
        }
        for (i = 0; i < readyTask.length; ++i) {
            mark[readyTask[i]] = 1;
            VarNode readyQueueNode = this.hirFact.varNode(this.decLocal.readyQueue);
            subExp1 = this.hirFact.subscriptedExp(readyQueueNode, this.hirFact.intConstNode(i));
            assignStmt = this.hirFact.assignStmt(subExp1, this.hirFact.intConstNode(readyTask[i]));
            initTaskBlk.addLastStmt(assignStmt);
        }
        for (i = 0; i < condSize; ++i) {
            VarNode alreadyPutNode = this.hirFact.varNode(this.decLocal.alreadyPut);
            subExp1 = this.hirFact.subscriptedExp(alreadyPutNode, this.hirFact.intConstNode(i));
            assignStmt = this.hirFact.assignStmt(subExp1, this.hirFact.intConstNode(mark[i]));
            initTaskBlk.addLastStmt(assignStmt);
        }
        VarNode varNode = this.hirFact.varNode(this.decLocal.putPos);
        AssignStmt assign = this.hirFact.assignStmt(varNode, this.hirFact.intConstNode(readyTask.length));
        initTaskBlk.addLastStmt(assign);
        varNode = this.hirFact.varNode(this.decLocal.getPos);
        assign = this.hirFact.assignStmt(varNode, this.hirFact.intConstNode(0));
        initTaskBlk.addLastStmt(assign);
        return initTaskBlk;
    }

    BlockStmt makeGetTask() {
        Util util = new Util(this.env, this.mfg);
        int arraySize = util.numberOfConditions();
        int vectSize = util.vectorSize();
        int condSize = this.mfg.bound();
        BlockStmt getTaskBlk = this.hirFact.blockStmt(null);
        SymTable localSymTab = this.mfg.symRoot.symTableCurrent.pushSymTable(null);
        getTaskBlk.setSymTable(localSymTab);
        Var iVar = this.symFact.defineVar("i".intern(), this.mfg.symRoot.typeInt);
        iVar.setVisibility(4);
        Var jVar = this.symFact.defineVar("j".intern(), this.mfg.symRoot.typeInt);
        jVar.setVisibility(4);
        Var isOkVar = this.symFact.defineVar("isOk".intern(), this.mfg.symRoot.typeInt);
        isOkVar.setVisibility(4);
        Var isOk2Var = this.symFact.defineVar("isOk2".intern(), this.mfg.symRoot.typeInt);
        isOkVar.setVisibility(4);
        Var tmpVar = this.symFact.defineVar("tmp".intern(), this.mfg.symRoot.typeInt);
        isOkVar.setVisibility(4);
        Var vPosVar = this.symFact.defineVar("v_pos".intern(), this.mfg.symRoot.typeInt);
        isOkVar.setVisibility(4);
        Var wPosVar = this.symFact.defineVar("w_pos".intern(), this.mfg.symRoot.typeInt);
        isOkVar.setVisibility(4);
        Var maskVar = this.symFact.defineVar("mask".intern(), this.mfg.symRoot.typeInt);
        isOkVar.setVisibility(4);
        Exp ifCmp = this.hirFact.exp(54, this.hirFact.varNode((Var)this.mfg.taskSym), this.hirFact.intConstNode(0));
        BlockStmt thenPart = this.hirFact.blockStmt(null);
        IfStmt ifStmt = this.hirFact.ifStmt(ifCmp, thenPart, null);
        getTaskBlk.addLastStmt(ifStmt);
        VarNode varNode = this.hirFact.varNode(iVar);
        AssignStmt loopInit = this.hirFact.assignStmt(varNode, this.hirFact.intConstNode(0));
        varNode = this.hirFact.varNode(iVar);
        Exp cmp = this.hirFact.exp(55, varNode, this.hirFact.intConstNode(vectSize));
        BlockStmt loopBody = this.hirFact.blockStmt(null);
        varNode = this.hirFact.varNode(iVar);
        Exp add = this.hirFact.exp(38, varNode, this.hirFact.intConstNode(1));
        varNode = this.hirFact.varNode(iVar);
        AssignStmt loopStep = this.hirFact.assignStmt(varNode, add);
        ForStmt forStmt = this.hirFact.forStmt(loopInit, cmp, loopBody, loopStep);
        thenPart.addLastStmt(forStmt);
        varNode = this.hirFact.varNode(this.decLocal.curStat);
        SubscriptedExp subExp1 = this.hirFact.subscriptedExp(varNode, this.hirFact.varNode(iVar));
        VarNode varNode2 = this.hirFact.varNode(this.decLocal.finishCondition);
        SubscriptedExp subExp2 = this.hirFact.subscriptedExp(varNode2, this.hirFact.varNode((Var)this.mfg.taskSym));
        SubscriptedExp subExp3 = this.hirFact.subscriptedExp(subExp2, this.hirFact.varNode(iVar));
        Exp or = this.hirFact.exp(47, subExp1, subExp3);
        varNode = this.hirFact.varNode(this.decLocal.curStat);
        subExp1 = this.hirFact.subscriptedExp(varNode, this.hirFact.varNode(iVar));
        AssignStmt assign = this.hirFact.assignStmt(subExp1, or);
        loopBody.addLastStmt(assign);
        varNode = this.hirFact.varNode(iVar);
        loopInit = this.hirFact.assignStmt(varNode, this.hirFact.intConstNode(0));
        varNode = this.hirFact.varNode(iVar);
        cmp = this.hirFact.exp(55, varNode, this.hirFact.intConstNode(condSize));
        loopBody = this.hirFact.blockStmt(null);
        varNode = this.hirFact.varNode(iVar);
        add = this.hirFact.exp(38, varNode, this.hirFact.intConstNode(1));
        varNode = this.hirFact.varNode(iVar);
        loopStep = this.hirFact.assignStmt(varNode, add);
        forStmt = this.hirFact.forStmt(loopInit, cmp, loopBody, loopStep);
        thenPart.addLastStmt(forStmt);
        varNode = this.hirFact.varNode(this.decLocal.alreadyPut);
        subExp1 = this.hirFact.subscriptedExp(varNode, this.hirFact.varNode(iVar));
        ifCmp = this.hirFact.exp(51, subExp1, this.hirFact.intConstNode(0));
        BlockStmt thenPart2 = this.hirFact.blockStmt(null);
        ifStmt = this.hirFact.ifStmt(ifCmp, thenPart2, null);
        loopBody.addLastStmt(ifStmt);
        varNode = this.hirFact.varNode(isOkVar);
        assign = this.hirFact.assignStmt(varNode, this.hirFact.intConstNode(0));
        thenPart2.addLastStmt(assign);
        varNode = this.hirFact.varNode(jVar);
        loopInit = this.hirFact.assignStmt(varNode, this.hirFact.intConstNode(0));
        varNode = this.hirFact.varNode(jVar);
        cmp = this.hirFact.exp(55, varNode, this.hirFact.intConstNode(vectSize));
        BlockStmt loopBody2 = this.hirFact.blockStmt(null);
        varNode = this.hirFact.varNode(jVar);
        add = this.hirFact.exp(38, varNode, this.hirFact.intConstNode(1));
        varNode = this.hirFact.varNode(jVar);
        loopStep = this.hirFact.assignStmt(varNode, add);
        forStmt = this.hirFact.forStmt(loopInit, cmp, loopBody2, loopStep);
        thenPart2.addLastStmt(forStmt);
        Label breakLab = ((LoopStmt)forStmt).getLoopEndLabel();
        varNode = this.hirFact.varNode(this.decLocal.curStat);
        subExp1 = this.hirFact.subscriptedExp(varNode, this.hirFact.varNode(jVar));
        varNode2 = this.hirFact.varNode(this.decLocal.nonExecCond);
        subExp2 = this.hirFact.subscriptedExp(varNode2, this.hirFact.varNode(iVar));
        subExp3 = this.hirFact.subscriptedExp(subExp2, this.hirFact.varNode(jVar));
        Exp and = this.hirFact.exp(46, subExp1, subExp3);
        assign = this.hirFact.assignStmt(this.hirFact.varNode(tmpVar), and);
        loopBody2.addLastStmt(assign);
        varNode = this.hirFact.varNode(tmpVar);
        ifCmp = this.hirFact.exp(52, varNode, this.hirFact.intConstNode(0));
        BlockStmt thenPart3 = this.hirFact.blockStmt(null);
        ifStmt = this.hirFact.ifStmt(ifCmp, thenPart3, null);
        loopBody2.addLastStmt(ifStmt);
        varNode = this.hirFact.varNode(isOkVar);
        assign = this.hirFact.assignStmt(varNode, this.hirFact.intConstNode(1));
        thenPart3.addLastStmt(assign);
        JumpStmt breakJump = this.hirFact.jumpStmt(breakLab);
        thenPart3.addLastStmt(breakJump);
        varNode = this.hirFact.varNode(isOkVar);
        ifCmp = this.hirFact.exp(51, varNode, this.hirFact.intConstNode(1));
        thenPart3 = this.hirFact.blockStmt(null);
        ifStmt = this.hirFact.ifStmt(ifCmp, thenPart3, null);
        thenPart2.addLastStmt(ifStmt);
        varNode = this.hirFact.varNode(iVar);
        Exp div = this.hirFact.exp(42, varNode, this.hirFact.intConstNode(util.wordSize()));
        varNode = this.hirFact.varNode(vPosVar);
        assign = this.hirFact.assignStmt(varNode, div);
        thenPart3.addLastStmt(assign);
        varNode = this.hirFact.varNode(iVar);
        Exp mod = this.hirFact.exp(43, varNode, this.hirFact.intConstNode(util.wordSize()));
        varNode = this.hirFact.varNode(wPosVar);
        assign = this.hirFact.assignStmt(varNode, mod);
        thenPart3.addLastStmt(assign);
        varNode = this.hirFact.varNode(wPosVar);
        Exp sub = this.hirFact.exp(39, this.hirFact.intConstNode(util.wordSize() - 1), varNode);
        Exp lsh = this.hirFact.exp(58, this.hirFact.intConstNode(1), sub);
        varNode = this.hirFact.varNode(maskVar);
        assign = this.hirFact.assignStmt(varNode, lsh);
        thenPart3.addLastStmt(assign);
        varNode = this.hirFact.varNode(this.decLocal.curStat);
        subExp1 = this.hirFact.subscriptedExp(varNode, this.hirFact.varNode(vPosVar));
        varNode = this.hirFact.varNode(maskVar);
        or = this.hirFact.exp(47, subExp1, varNode);
        varNode = this.hirFact.varNode(this.decLocal.curStat);
        subExp1 = this.hirFact.subscriptedExp(varNode, this.hirFact.varNode(vPosVar));
        assign = this.hirFact.assignStmt(subExp1, or);
        thenPart3.addLastStmt(assign);
        varNode = this.hirFact.varNode(this.decLocal.alreadyPut);
        subExp1 = this.hirFact.subscriptedExp(varNode, this.hirFact.varNode(iVar));
        assign = this.hirFact.assignStmt(subExp1, this.hirFact.intConstNode(1));
        thenPart3.addLastStmt(assign);
        varNode = this.hirFact.varNode(iVar);
        loopInit = this.hirFact.assignStmt(varNode, this.hirFact.intConstNode(0));
        varNode = this.hirFact.varNode(iVar);
        cmp = this.hirFact.exp(55, varNode, this.hirFact.intConstNode(condSize));
        loopBody = this.hirFact.blockStmt(null);
        varNode = this.hirFact.varNode(iVar);
        add = this.hirFact.exp(38, varNode, this.hirFact.intConstNode(1));
        varNode = this.hirFact.varNode(iVar);
        loopStep = this.hirFact.assignStmt(varNode, add);
        forStmt = this.hirFact.forStmt(loopInit, cmp, loopBody, loopStep);
        thenPart.addLastStmt(forStmt);
        varNode = this.hirFact.varNode(this.decLocal.alreadyPut);
        subExp1 = this.hirFact.subscriptedExp(varNode, this.hirFact.varNode(iVar));
        ifCmp = this.hirFact.exp(51, subExp1, this.hirFact.intConstNode(0));
        thenPart2 = this.hirFact.blockStmt(null);
        ifStmt = this.hirFact.ifStmt(ifCmp, thenPart2, null);
        loopBody.addLastStmt(ifStmt);
        varNode = this.hirFact.varNode(isOkVar);
        assign = this.hirFact.assignStmt(varNode, this.hirFact.intConstNode(0));
        thenPart2.addLastStmt(assign);
        varNode = this.hirFact.varNode(jVar);
        loopInit = this.hirFact.assignStmt(varNode, this.hirFact.intConstNode(0));
        varNode = this.hirFact.varNode(jVar);
        cmp = this.hirFact.exp(55, varNode, this.hirFact.intConstNode(vectSize));
        loopBody2 = this.hirFact.blockStmt(null);
        varNode = this.hirFact.varNode(jVar);
        add = this.hirFact.exp(38, varNode, this.hirFact.intConstNode(1));
        varNode = this.hirFact.varNode(jVar);
        loopStep = this.hirFact.assignStmt(varNode, add);
        forStmt = this.hirFact.forStmt(loopInit, cmp, loopBody2, loopStep);
        thenPart2.addLastStmt(forStmt);
        breakLab = ((LoopStmt)forStmt).getLoopEndLabel();
        varNode = this.hirFact.varNode(this.decLocal.curStat);
        subExp1 = this.hirFact.subscriptedExp(varNode, this.hirFact.varNode(jVar));
        varNode2 = this.hirFact.varNode(this.decLocal.execCond);
        subExp2 = this.hirFact.subscriptedExp(varNode2, this.hirFact.varNode(iVar));
        subExp3 = this.hirFact.subscriptedExp(subExp2, this.hirFact.varNode(jVar));
        and = this.hirFact.exp(46, subExp1, subExp3);
        assign = this.hirFact.assignStmt(this.hirFact.varNode(tmpVar), and);
        loopBody2.addLastStmt(assign);
        varNode = this.hirFact.varNode(tmpVar);
        ifCmp = this.hirFact.exp(52, varNode, this.hirFact.intConstNode(0));
        thenPart3 = this.hirFact.blockStmt(null);
        ifStmt = this.hirFact.ifStmt(ifCmp, thenPart3, null);
        loopBody2.addLastStmt(ifStmt);
        varNode = this.hirFact.varNode(isOkVar);
        assign = this.hirFact.assignStmt(varNode, this.hirFact.intConstNode(1));
        thenPart3.addLastStmt(assign);
        breakJump = this.hirFact.jumpStmt(breakLab);
        thenPart3.addLastStmt(breakJump);
        varNode = this.hirFact.varNode(isOkVar);
        ifCmp = this.hirFact.exp(51, varNode, this.hirFact.intConstNode(1));
        thenPart3 = this.hirFact.blockStmt(null);
        ifStmt = this.hirFact.ifStmt(ifCmp, thenPart3, null);
        thenPart2.addLastStmt(ifStmt);
        varNode = this.hirFact.varNode(isOk2Var);
        assign = this.hirFact.assignStmt(varNode, this.hirFact.intConstNode(1));
        thenPart3.addLastStmt(assign);
        varNode = this.hirFact.varNode(jVar);
        loopInit = this.hirFact.assignStmt(varNode, this.hirFact.intConstNode(0));
        varNode = this.hirFact.varNode(jVar);
        cmp = this.hirFact.exp(55, varNode, this.hirFact.intConstNode(vectSize));
        loopBody2 = this.hirFact.blockStmt(null);
        varNode = this.hirFact.varNode(jVar);
        add = this.hirFact.exp(38, varNode, this.hirFact.intConstNode(1));
        varNode = this.hirFact.varNode(jVar);
        loopStep = this.hirFact.assignStmt(varNode, add);
        forStmt = this.hirFact.forStmt(loopInit, cmp, loopBody2, loopStep);
        thenPart3.addLastStmt(forStmt);
        breakLab = ((LoopStmt)forStmt).getLoopEndLabel();
        varNode = this.hirFact.varNode(this.decLocal.curStat);
        subExp1 = this.hirFact.subscriptedExp(varNode, this.hirFact.varNode(jVar));
        varNode2 = this.hirFact.varNode(this.decLocal.dataAccessCond);
        subExp2 = this.hirFact.subscriptedExp(varNode2, this.hirFact.varNode(iVar));
        subExp3 = this.hirFact.subscriptedExp(subExp2, this.hirFact.varNode(jVar));
        and = this.hirFact.exp(46, subExp1, subExp3);
        assign = this.hirFact.assignStmt(this.hirFact.varNode(tmpVar), and);
        loopBody2.addLastStmt(assign);
        varNode = this.hirFact.varNode(tmpVar);
        varNode2 = this.hirFact.varNode(this.decLocal.dataAccessCond);
        subExp1 = this.hirFact.subscriptedExp(varNode2, this.hirFact.varNode(iVar));
        subExp2 = this.hirFact.subscriptedExp(subExp1, this.hirFact.varNode(jVar));
        ifCmp = this.hirFact.exp(52, varNode, subExp2);
        BlockStmt thenPart4 = this.hirFact.blockStmt(null);
        ifStmt = this.hirFact.ifStmt(ifCmp, thenPart4, null);
        loopBody2.addLastStmt(ifStmt);
        varNode = this.hirFact.varNode(isOk2Var);
        assign = this.hirFact.assignStmt(varNode, this.hirFact.intConstNode(0));
        thenPart4.addLastStmt(assign);
        breakJump = this.hirFact.jumpStmt(breakLab);
        thenPart4.addLastStmt(breakJump);
        varNode = this.hirFact.varNode(isOk2Var);
        ifCmp = this.hirFact.exp(51, varNode, this.hirFact.intConstNode(1));
        thenPart4 = this.hirFact.blockStmt(null);
        ifStmt = this.hirFact.ifStmt(ifCmp, thenPart4, null);
        thenPart3.addLastStmt(ifStmt);
        varNode = this.hirFact.varNode(this.decLocal.readyQueue);
        subExp1 = this.hirFact.subscriptedExp(varNode, this.hirFact.varNode(this.decLocal.putPos));
        assign = this.hirFact.assignStmt(subExp1, this.hirFact.varNode(iVar));
        thenPart4.addLastStmt(assign);
        varNode = this.hirFact.varNode(this.decLocal.putPos);
        add = this.hirFact.exp(38, varNode, this.hirFact.intConstNode(1));
        varNode = this.hirFact.varNode(this.decLocal.putPos);
        assign = this.hirFact.assignStmt(varNode, add);
        thenPart4.addLastStmt(assign);
        varNode = this.hirFact.varNode(this.decLocal.alreadyPut);
        subExp1 = this.hirFact.subscriptedExp(varNode, this.hirFact.varNode(iVar));
        assign = this.hirFact.assignStmt(subExp1, this.hirFact.intConstNode(1));
        thenPart4.addLastStmt(assign);
        ifCmp = this.hirFact.exp(53, this.hirFact.varNode(this.decLocal.putPos), this.hirFact.varNode(this.decLocal.getPos));
        thenPart = this.hirFact.blockStmt(null);
        BlockStmt elsePart = this.hirFact.blockStmt(null);
        ifStmt = this.hirFact.ifStmt(ifCmp, thenPart, elsePart);
        getTaskBlk.addLastStmt(ifStmt);
        varNode = this.hirFact.varNode(this.decLocal.readyQueue);
        subExp1 = this.hirFact.subscriptedExp(varNode, this.hirFact.varNode(this.decLocal.getPos));
        assign = this.hirFact.assignStmt(this.hirFact.varNode((Var)this.mfg.taskSym), subExp1);
        thenPart.addLastStmt(assign);
        varNode = this.hirFact.varNode(this.decLocal.getPos);
        add = this.hirFact.exp(38, varNode, this.hirFact.intConstNode(1));
        varNode = this.hirFact.varNode(this.decLocal.getPos);
        assign = this.hirFact.assignStmt(varNode, add);
        thenPart.addLastStmt(assign);
        assign = this.hirFact.assignStmt(this.hirFact.varNode((Var)this.mfg.taskSym), this.hirFact.intConstNode(-1));
        elsePart.addLastStmt(assign);
        localSymTab.popSymTable();
        return getTaskBlk;
    }

    BlockStmt makeSwitchBody(HirList labelList) throws PassException {
        BlockStmt switchBody = this.hirFact.blockStmt(null);
        LinkedList<Label> visited = new LinkedList<Label>();
        ListIterator ite = this.mfg.listIterator();
        while (ite.hasNext()) {
            Stmt lastNode;
            MacroTask mt = (MacroTask)ite.next();
            BlockStmt stmt = this.hirFact.blockStmt(null);
            BBlock[] blks = mt.blks();
            LinkedList<Stmt> ignoreBlk = new LinkedList<Stmt>();
            for (int i = 0; i < blks.length; ++i) {
                Label blkLabel;
                if (mt.succList.size() > 1 && mt.exitBlks().contains(blks[i]) && blks[i].getSuccList().size() == 1) {
                    Stmt lastStmt = null;
                    BBlockSubtreeIterator bite = blks[i].bblockSubtreeIterator();
                    while (bite.hasNext()) {
                        lastStmt = (Stmt)bite.next();
                    }
                    if (lastStmt != null && !(lastStmt instanceof JumpStmt)) {
                        Label lab = ((BBlock)blks[i].getSuccList().get(0)).getLabel();
                        if (this.extraJump == null) {
                            this.extraJump = this.hirFact.jumpStmt(lab);
                        } else {
                            System.err.println("extraJump is not null");
                            throw new PassException("mdf", "internal error");
                        }
                    }
                }
                if (visited.contains(blkLabel = blks[i].getLabel())) continue;
                visited.add(blkLabel);
                BBlockSubtreeIterator subIte = blks[i].bblockSubtreeIterator();
                while (subIte.hasNext()) {
                    Stmt node;
                    Stmt nodeOrg = node = (Stmt)subIte.next();
                    if (ignoreBlk.contains(node.getUpperStmt()) || node instanceof BlockStmt) continue;
                    if (node instanceof LabeledStmt) {
                        int kind = node.getLabel().getLabelKind();
                        if (kind == 11 || kind == 1 || kind == 12) continue;
                        LabeledStmt labStmt = this.hirFact.labeledStmt(node.getLabel(), this.hirFact.nullStmt());
                        stmt.addLastStmt(labStmt);
                        continue;
                    }
                    try {
                        node = (Stmt)node.hirClone();
                    }
                    catch (Exception ex) {
                        System.err.println("Fail cloning");
                        throw new PassException("mdf", "fail node cloning");
                    }
                    if (node instanceof IfStmt) {
                        TreatIf data = new TreatIf(this.env, this.mfg, (IfStmt)node, visited, this.cond);
                        data.replaceReturn(this.endLabel, this.decLocal);
                        data.replace(mt, this.endLabel);
                    } else if (node instanceof SwitchStmt) {
                        TreatSwitch data = new TreatSwitch(this.env, this.mfg, (SwitchStmt)node, visited, this.cond);
                        data.replaceReturn(this.endLabel, this.decLocal);
                        data.replace(mt, this.endLabel);
                    } else if (node instanceof LoopStmt) {
                        TreatLoop data = new TreatLoop(this.env, this.mfg, (LoopStmt)node, visited, this.cond);
                        data.replaceReturn(this.endLabel, this.decLocal);
                        data.replace(mt, this.endLabel);
                        for (int ii = 1; ii <= node.getChildCount(); ++ii) {
                            HIR child = (HIR)node.getChild(ii);
                            LinkedList labList = data.getLabelsInLoop(child, new LinkedList());
                            ListIterator labIte = labList.listIterator();
                            while (labIte.hasNext()) {
                                LabeledStmt labeledStmt = (LabeledStmt)labIte.next();
                                visited.add(labeledStmt.getLabel());
                            }
                        }
                        Stmt initStmt = ((LoopStmt)nodeOrg).getLoopInitPart();
                        if (initStmt != null) {
                            ignoreBlk.add(initStmt);
                        }
                    } else if (node instanceof ReturnStmt) {
                        if (this.decLocal.returnStatus != null) {
                            VarNode statusExp = this.hirFact.varNode(this.decLocal.returnStatus);
                            AssignStmt setStatus = this.hirFact.assignStmt(statusExp, (Exp)node.getChild(1));
                            node = setStatus;
                        } else {
                            node = null;
                        }
                    }
                    if (node == null) continue;
                    stmt.addLastStmt(node);
                }
            }
            if (this.extraJump != null) {
                stmt.addLastStmt(this.extraJump);
                this.extraJump = null;
            }
            if (this.env.opt.isSet("mdf-ptest")) {
                Stmt nullStmt = this.hirFact.nullStmt();
                nullStmt.addInf("coins_omp", this.decPragma.endif);
                stmt.addFirstStmt(nullStmt);
                VarNode taskVarNode = this.hirFact.varNode((Var)this.mfg.taskSym);
                VarNode idVarNode = this.hirFact.varNode((Var)this.mfg.idSym);
                SubpNode mtStartTimeNode = this.hirFact.subpNode(this.decPtest.mtStartTime);
                IrList mtStartTimeParam = this.hirFact.irList();
                mtStartTimeParam.add(idVarNode);
                mtStartTimeParam.add(taskVarNode);
                ExpStmt mtStartTimeCall = this.hirFact.callStmt(mtStartTimeNode, mtStartTimeParam);
                mtStartTimeCall.addInf("coins_omp", this.decPragma.ptest);
                stmt.addFirstStmt(mtStartTimeCall);
                idVarNode = this.hirFact.varNode((Var)this.mfg.idSym);
                SubpNode mtEndTimeNode = this.hirFact.subpNode(this.decPtest.mtEndTime);
                IrList mtEndTimeParam = this.hirFact.irList();
                mtEndTimeParam.add(idVarNode);
                ExpStmt mtEndTimeCall = this.hirFact.callStmt(mtEndTimeNode, mtEndTimeParam);
                mtEndTimeCall.addInf("coins_omp", this.decPragma.ptest);
                stmt.addBeforeBranchStmt(mtEndTimeCall);
                nullStmt = this.hirFact.nullStmt();
                nullStmt.addInf("coins_omp", this.decPragma.endif);
                stmt.addBeforeBranchStmt(nullStmt);
            }
            if (this.mfg.exitBlks().contains(mt)) {
                VarNode finishVar = this.hirFact.varNode(this.decLocal.allFinishVar);
                AssignStmt finishAssign = this.hirFact.assignStmt(finishVar, this.hirFact.intConstNode(1));
                stmt.addBeforeBranchStmt(finishAssign);
            }
            if ((lastNode = stmt.getLastStmt()) instanceof JumpStmt) {
                Label jumpLabel = ((JumpStmt)lastNode).getLabel();
                MacroTask target = this.mfg.macroTask(jumpLabel);
                stmt.addBeforeBranchStmt(this.cond.finish.finishCond(mt, target));
                if (!this.endLabel.equals(jumpLabel) && !mt.equals(target)) {
                    ((JumpStmt)lastNode).changeJumpLabel(this.endLabel);
                }
            } else {
                stmt.addLastStmt(this.hirFact.jumpStmt(this.endLabel));
                stmt.addBeforeBranchStmt(this.cond.finish.finishCond(mt, null));
            }
            LabeledStmt switchLabel = this.hirFact.labeledStmt(mt.label, stmt);
            switchBody.addLastStmt(switchLabel);
            HirSeq seq = this.hirFact.hirSeq(this.hirFact.intConstNode(mt.taskNumber()), this.hirFact.labelNode(mt.label));
            labelList.add(seq);
        }
        return switchBody;
    }
}

