/*
 * Decompiled with CFR 0.152.
 */
package coins.lparallel;

import coins.aflow.FlowResults;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.VarNode;
import coins.lparallel.BasicInduction;
import coins.lparallel.IndExp;
import coins.lparallel.Invariant;
import coins.lparallel.LoopUtil;
import coins.sym.Const;
import coins.sym.PointerType;
import coins.sym.Type;
import java.util.LinkedList;

public class Ref_Array {
    static final int REF_ARRAY_INDUCTION = 1;
    static final int REF_ARRAY_UNKNOWN = 2;
    static final int REF_ARRAY_INV_CONST = 3;
    static final int REF_ARRAY_INVARIANT = 4;
    static final int REF_ARRAY_REG_INV = 5;
    static final int REF_ARRAY_REG_IND_INV = 6;
    static final int REF_ARRAY_REG_UNKNOWN = 7;
    static final int REF_ARRAY_MAX = 8;
    static final int REF_RESULT = 0;
    static final int REF_DDEF = 1;
    static final int REF_USE = 2;
    static final int REF_MOD = 3;
    static final int REF_EUSE = 4;
    static final int REF_LIVE = 5;
    private double dimArea;
    boolean dimdependence;
    int dimension;
    int[] ID;
    long[] ConstValue;
    IndExp[] InductionExp;
    Exp[] IndexExp;
    IndExp[] RegIndInit;
    IndExp[] RegIndLast;
    Exp ArrayNode;
    VarNode VarNode;
    FlowResults fResults;
    LoopUtil fUtil;

    Ref_Array(FlowResults pResults) {
        this.dimension = 1;
        this.dimdependence = false;
        this.dimArea = 0.0;
        this.ID = new int[this.dimension];
        this.ConstValue = new long[this.dimension];
        this.InductionExp = new IndExp[this.dimension];
        this.RegIndInit = new IndExp[this.dimension];
        this.RegIndLast = new IndExp[this.dimension];
        this.IndexExp = new Exp[this.dimension];
        this.RegIndInit[0] = null;
        this.RegIndLast[0] = null;
        this.fResults = pResults;
    }

    public Ref_Array copy() {
        Ref_Array ref = new Ref_Array(this.fResults);
        ref.ID = new int[this.dimension];
        ref.ConstValue = new long[this.dimension];
        ref.InductionExp = new IndExp[this.dimension];
        ref.RegIndInit = new IndExp[this.dimension];
        ref.RegIndLast = new IndExp[this.dimension];
        ref.IndexExp = new Exp[this.dimension];
        ref.ArrayNode = this.ArrayNode;
        ref.VarNode = this.VarNode;
        ref.dimension = this.dimension;
        ref.dimdependence = this.dimdependence;
        ref.dimArea = this.dimArea;
        ref.fUtil = this.fUtil;
        for (int i = 0; i < this.dimension; ++i) {
            ref.ID[i] = this.ID[i];
            ref.ConstValue[i] = this.ConstValue[i];
            if (this.InductionExp[i] != null) {
                ref.InductionExp[i] = this.InductionExp[i].copy();
            }
            if (this.RegIndInit != null) {
                ref.RegIndInit[i] = this.RegIndInit[i];
            }
            if (this.RegIndLast != null) {
                ref.RegIndLast[i] = this.RegIndLast[i];
            }
            ref.IndexExp[i] = this.IndexExp[i];
        }
        return ref;
    }

    Ref_Array(FlowResults pResults, Exp Node2, LinkedList IndList, Invariant pinv, LoopUtil pUtil) {
        int op;
        this.ArrayNode = Node2;
        this.VarNode = null;
        this.fResults = pResults;
        this.fUtil = pUtil;
        this.fUtil.Trace("Ref_Array :ArrayNode=" + this.ArrayNode.toString(), 5);
        Exp tmp = Node2.getExp1();
        while (tmp != null) {
            this.fUtil.Trace("Ref_Array :tmpNode=" + tmp.toString(), 5);
            op = tmp.getOperator();
            if (op == 7 || op == 12) {
                this.VarNode = (VarNode)tmp;
                break;
            }
            if (op == 19) {
                tmp = tmp.getExp2();
                continue;
            }
            tmp = tmp.getExp1();
        }
        this.fUtil.Trace("make_ref Array :Ver=" + this.VarNode.toString(), 5);
        Type vType = this.VarNode.getVar().getSymType();
        this.fUtil.Trace("make_ref Array :vType=" + vType.toString(), 5);
        if (vType.getTypeKind() == 22) {
            vType = ((PointerType)vType).getPointedType();
            if (this.VarNode.getParent().getOperator() == 67) {
                vType = ((HIR)this.VarNode.getParent()).getType();
            }
        } else {
            this.dimension = vType.getDimension();
        }
        this.dimension = vType.getDimension();
        this.fUtil.Trace("make_ref Array :dimension=" + this.dimension, 5);
        this.dimArea = 0.0;
        this.ID = new int[this.dimension];
        this.ConstValue = new long[this.dimension];
        this.InductionExp = new IndExp[this.dimension];
        this.RegIndInit = new IndExp[this.dimension];
        this.RegIndLast = new IndExp[this.dimension];
        this.IndexExp = new Exp[this.dimension];
        int dim = 0;
        tmp = this.ArrayNode;
        while (tmp != null) {
            Exp tmp1;
            op = tmp.getOperator();
            this.fUtil.Trace("make_ref Array tmp=" + tmp.toString(), 5);
            if (op != 17) break;
            this.IndexExp[dim] = tmp1 = this.fUtil.SkipConv(tmp.getSubscriptExp());
            if (tmp1.getOperator() == 5) {
                Const ConstSym = ((ConstNode)tmp1).getConstSym();
                if (ConstSym.getSymType().isInteger()) {
                    this.ConstValue[dim] = ConstSym.longValue();
                    this.ID[dim] = 3;
                }
            } else if (pinv.IsInvariant(tmp1)) {
                this.ID[dim] = 4;
            } else {
                this.fUtil.Trace("make_ref Array tmp1=" + tmp1.toString(), 5);
                IndExp iExp = this.getIndExp(tmp1, IndList);
                if (iExp == null) {
                    this.ID[dim] = 2;
                } else {
                    this.ID[dim] = 1;
                    this.InductionExp[dim] = iExp;
                }
            }
            this.fUtil.Trace("make_ref Array :ID=" + this.ID[dim], 5);
            tmp = tmp.getArrayExp();
            ++dim;
        }
        this.SetdimArea();
    }

    public void SetdimArea() {
        int i;
        int[] ID_Count = new int[8];
        if (this.dimdependence) {
            this.dimArea = 2.9;
            return;
        }
        for (i = 0; i < 8; ++i) {
            ID_Count[i] = 0;
        }
        for (i = 0; i < this.dimension; ++i) {
            int n = this.ID[i];
            ID_Count[n] = ID_Count[n] + 1;
        }
        int RegCount = ID_Count[5] + ID_Count[6] + ID_Count[7];
        if (RegCount == 0) {
            this.dimArea = ID_Count[1] + ID_Count[2] > 0 ? 0.5 : 0.0;
        } else if (RegCount == 1) {
            this.dimArea = ID_Count[7] > 0 ? 1.9 : (ID_Count[1] + ID_Count[2] > 0 ? 1.5 : 1.0);
        } else {
            if (ID_Count[7] > 0) {
                this.dimArea = 2.9;
            }
            this.dimArea = ID_Count[1] > 0 && ID_Count[6] > 0 ? 2.5 : (ID_Count[6] == 0 ? 2.0 : (ID_Count[6] == 1 ? 2.1 : 2.9));
        }
    }

    boolean isRegUNKNOWN() {
        if (this.dimdependence) {
            return true;
        }
        return this.dimArea > 2.1;
    }

    IndExp getIndExp(Exp Node2, LinkedList IndList) {
        this.fUtil.Trace("getIndExp=" + Node2.toString(), 5);
        for (BasicInduction IndTable : IndList) {
            this.fUtil.Trace("Node=" + IndTable.DefVarNode.toString(), 5);
            this.fUtil.Trace("indList Size=" + IndTable.indExpList.size(), 5);
            for (IndExp Ind : IndTable.indExpList) {
                if (Ind.ind_node != Node2) continue;
                return Ind;
            }
        }
        return null;
    }

    boolean EQRefArray(Ref_Array b) {
        if (this.VarNode.getVar() != b.VarNode.getVar()) {
            return false;
        }
        if (this == b) {
            return true;
        }
        if (this.dimension != b.dimension) {
            return false;
        }
        int dim = this.dimension;
        for (int i = 0; i < dim; ++i) {
            if (this.EQRefArrayDim(b, i)) continue;
            return false;
        }
        return true;
    }

    boolean EQRefArrayDim(Ref_Array b, int dim) {
        if (this.VarNode.getVar() != b.VarNode.getVar()) {
            return false;
        }
        if (this.ID[dim] != b.ID[dim]) {
            return false;
        }
        if (this.ID[dim] == 1) {
            IndExp aInd = this.InductionExp[dim];
            IndExp bInd = b.InductionExp[dim];
            if (!aInd.EQindExp(bInd)) {
                return false;
            }
        } else {
            if (this.ID[dim] == 2) {
                return false;
            }
            if (this.ID[dim] == 3) {
                if (this.ConstValue[dim] != b.ConstValue[dim]) {
                    return false;
                }
            } else {
                if (this.ID[dim] == 4) {
                    return this.EQExpression(this.IndexExp[dim], b.IndexExp[dim]);
                }
                if (this.ID[dim] == 5) {
                    IndExp bInd;
                    IndExp aInd = this.InductionExp[dim].AbsIndExp();
                    if (!aInd.EQindExp(bInd = b.InductionExp[dim].AbsIndExp())) {
                        return false;
                    }
                } else if (this.ID[dim] == 6) {
                    IndExp aInd = this.InductionExp[dim].AbsIndExp();
                    IndExp bInd = b.InductionExp[dim].AbsIndExp();
                    IndExp cInd = null;
                    IndExp dInd = null;
                    cInd = this.RegIndInit[dim] == null ? this.RegIndLast[dim].AbsIndExp() : this.RegIndInit[dim].AbsIndExp();
                    dInd = b.RegIndInit[dim] == null ? b.RegIndLast[dim].AbsIndExp() : b.RegIndInit[dim].AbsIndExp();
                    if (aInd.ind_inc != bInd.ind_inc || aInd.InitConst != bInd.InitConst || aInd.LastConst != bInd.LastConst) {
                        return false;
                    }
                    if (aInd.ind_inc != 1L) {
                        return false;
                    }
                    if (aInd.InitConst && aInd.ind_init != bInd.ind_init) {
                        return false;
                    }
                    if (aInd.LastConst && aInd.ind_last != bInd.ind_last) {
                        return false;
                    }
                    if (!cInd.EQindExp(dInd)) {
                        return false;
                    }
                } else if (this.ID[dim] == 7) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean EQExpression(Exp node1, Exp node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        return this.fResults.getFlowExpIdForNode(node1) == this.fResults.getFlowExpIdForNode(node2);
    }

    public String toString() {
        return "ref_Array " + this.VarNode.toStringShort();
    }

    private void Trace(String s) {
        System.out.println(s);
    }

    void DebugArrayRef(LoopUtil pUtil) {
        pUtil.Trace("----------DebugArrayRef---(START)---", 5);
        pUtil.Trace("ArrayNode=" + this.ArrayNode.toString(), 5);
        pUtil.Trace("VarNode=" + this.VarNode.toString(), 5);
        pUtil.Trace("dimension=" + this.dimension, 5);
        pUtil.Trace("dimArea=" + this.dimArea, 5);
        pUtil.Trace("dimdependence=" + this.dimdependence, 5);
        for (int i = 0; i < this.dimension; ++i) {
            pUtil.Trace("ID=" + this.ID[i], 5);
            switch (this.ID[i]) {
                case 1: {
                    pUtil.Trace("ID=ARRAY_INDUCTION", 5);
                    break;
                }
                case 2: {
                    pUtil.Trace("ID=ARRAY_UNKNOWN", 5);
                    break;
                }
                case 3: {
                    pUtil.Trace("ID=ARRAY_INV_CONST", 5);
                    break;
                }
                case 4: {
                    pUtil.Trace("ID=ARRAY_INVARIANT", 5);
                    break;
                }
                case 5: {
                    pUtil.Trace("ID=ARRAY_REG_INV", 5);
                    break;
                }
                case 6: {
                    pUtil.Trace("ID=ARRAY_REG_IND_INV", 5);
                    break;
                }
                case 7: {
                    pUtil.Trace("ID=ARRAY_REG_UNKNOWN", 5);
                }
            }
            pUtil.Trace("Index=" + this.IndexExp[i].toString(), 5);
            pUtil.Trace("ConstValue=" + this.ConstValue[i], 5);
            if (this.InductionExp[i] != null) {
                this.InductionExp[i].DebugIndExp(pUtil);
            }
            if (this.RegIndInit[i] != null) {
                this.RegIndInit[i].DebugIndExp(pUtil);
            }
            if (this.RegIndLast[i] == null) continue;
            this.RegIndLast[i].DebugIndExp(pUtil);
        }
        pUtil.Trace("----------DebugArrayRef---(END)---", 5);
    }
}

