/*
 * Decompiled with CFR 0.152.
 */
package coins.ir.hir;

import coins.HirRoot;
import coins.ir.IrList;
import coins.ir.hir.HIR_Impl;
import coins.ir.hir.HirVisitor;
import coins.ir.hir.LabelDef;
import coins.ir.hir.LabelNode;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.NullNode;
import coins.ir.hir.Stmt;
import coins.ir.hir.StmtImpl;
import coins.sym.Label;
import coins.sym.Sym;
import java.util.ListIterator;

public class LabeledStmtImpl
extends StmtImpl
implements LabeledStmt {
    protected Sym fFileNameSym;
    protected int fLineNumber;

    public LabeledStmtImpl(HirRoot pHirRoot, Label pLabel, Stmt pStmt) {
        super(pHirRoot);
        this.fOperator = 21;
        IrList lLabelDefList = this.hirRoot.hir.irList();
        LabelDef lLabelDefNode = this.hirRoot.hir.labelDef(pLabel);
        lLabelDefList.add(lLabelDefNode);
        this.fChildNode1 = lLabelDefList;
        this.fChildNode2 = pStmt;
        ((HIR_Impl)this.fChildNode1).setParent(this);
        if (this.fChildNode2 != null) {
            ((HIR_Impl)this.fChildNode2).setParent(this);
        }
        this.fChildCount = 2;
        lLabelDefNode.setLabeledStmt(this);
        if (this.hirRoot.symRoot.subpCurrent != null && pLabel != null) {
            pLabel.setHirPosition(this);
        }
        if (pStmt != null) {
            this.fType = pStmt.getType();
            if (((StmtImpl)pStmt).fPrevStmt != null) {
                ((StmtImpl)((StmtImpl)pStmt).fPrevStmt).fNextStmt = null;
            }
            if (((StmtImpl)pStmt).fNextStmt != null) {
                ((StmtImpl)((StmtImpl)pStmt).fNextStmt).fPrevStmt = null;
            }
            ((StmtImpl)pStmt).fPrevStmt = null;
            ((StmtImpl)pStmt).fNextStmt = null;
        } else {
            this.fType = this.hirRoot.symRoot.typeVoid;
        }
    }

    public IrList getLabelDefList() {
        return (IrList)this.fChildNode1;
    }

    public void setLabelDefList(IrList pLabelDefList) {
        this.setChild1(pLabelDefList);
    }

    public Label getLabel() {
        if (this.fChildNode1 != null && this.getLabelDefList().getFirst() != null) {
            return ((LabelDef)this.getLabelDefList().getFirst()).getLabel();
        }
        return null;
    }

    public Stmt getStmt() {
        return (Stmt)this.fChildNode2;
    }

    public void setStmt(Stmt pStmt) {
        if (pStmt != null) {
            ((HIR_Impl)((Object)pStmt)).setParent(this);
            ((StmtImpl)pStmt).fNextStmt = null;
            ((StmtImpl)pStmt).fPrevStmt = null;
        }
        this.fChildNode2 = pStmt;
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(8, "LabeledStmt.setStmt", "" + this.fChildNode1 + ":" + this.fChildNode2);
        }
    }

    public Stmt deleteLabel(Label pLabel) {
        IrList lLabelDefList = this.getLabelDefList();
        if (this.fDbgLevel > 2) {
            this.hirRoot.ioRoot.dbgHir.print(3, "deleteLabel", pLabel.getName() + " of " + this.toString());
        }
        ListIterator lIterator = lLabelDefList.iterator();
        while (lIterator.hasNext()) {
            LabelDef lLabelDef = (LabelDef)lIterator.next();
            if (lLabelDef.getLabel() != pLabel) continue;
            lLabelDefList.remove(lLabelDef);
            pLabel.setHirPosition(null);
            break;
        }
        if (lLabelDefList.isEmpty()) {
            Stmt lStmt = this.getStmt();
            if (lStmt == null || lStmt instanceof NullNode) {
                this.deleteThisStmt();
                return null;
            }
            this.replaceThisStmtWith(lStmt);
            return lStmt;
        }
        return this;
    }

    public void replaceLabelNodesReferingThisStmtToNewOne(Label pNewLabel) {
        IrList lLabelDefList = this.getLabelDefList();
        if (this.fDbgLevel > 2) {
            this.hirRoot.ioRoot.dbgHir.print(3, "replaceLabelNodesReferingThisStmtToNewOne", "to " + pNewLabel.getName());
        }
        ListIterator lIterator = lLabelDefList.iterator();
        while (lIterator.hasNext()) {
            LabelDef lLabelDef = (LabelDef)lIterator.next();
            Label lOldLabel = lLabelDef.getLabel();
            lOldLabel.replaceHirLabel(pNewLabel);
        }
    }

    public void merge(LabeledStmt from) {
        IrList tolist = this.getLabelDefList();
        IrList fromlist = from.getLabelDefList();
        ListIterator fromiter = fromlist.iterator();
        block0: while (fromiter.hasNext()) {
            LabelDef fromdef = (LabelDef)fromiter.next();
            Label fromlabel = fromdef.getLabel();
            ListIterator toiter = tolist.iterator();
            while (toiter.hasNext()) {
                LabelDef todef = (LabelDef)toiter.next();
                Label tolabel = todef.getLabel();
                if (tolabel.getLabelKind() != 16 || tolabel.getLabelKind() != 16) continue;
                fromlabel.replaceHirLabel(tolabel);
                continue block0;
            }
            fromlabel.setHirPosition(this);
            fromdef.setLabeledStmt(this);
            tolist.add(fromdef);
            ((HIR_Impl)((Object)fromdef)).setParent(tolist);
        }
    }

    public LabelNode explicitLabelReference() {
        IrList lHirRefList;
        LabelDef lLabelDef;
        Label lLabel;
        IrList lLabelDefList = this.getLabelDefList();
        if (lLabelDefList == null) {
            return null;
        }
        ListIterator lIterator = lLabelDefList.iterator();
        if (lIterator.hasNext() && (lLabel = (lLabelDef = (LabelDef)lIterator.next()).getLabel()) != null && (lHirRefList = lLabel.getHirRefList()) != null) {
            if (lHirRefList.isEmpty()) {
                return null;
            }
            return (LabelNode)lHirRefList.get(0);
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        LabeledStmt lTree;
        try {
            lTree = (LabeledStmt)super.clone();
        }
        catch (CloneNotSupportedException e) {
            this.hirRoot.ioRoot.msgRecovered.put(1100, "CloneNotSupportedException(labeledStmtImpl) " + this.toString());
            return null;
        }
        ((LabeledStmtImpl)lTree).fFileNameSym = this.fFileNameSym;
        ((LabeledStmtImpl)lTree).fLineNumber = this.fLineNumber;
        return lTree;
    }

    public String toString() {
        String lString = super.toString();
        return lString;
    }

    public void accept(HirVisitor pVisitor) {
        pVisitor.atLabeledStmt(this);
    }
}

