/*
 * Decompiled with CFR 0.152.
 */
package coins.ir.hir;

import coins.HirRoot;
import coins.IoRoot;
import coins.ir.IR;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpListExp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirList;
import coins.ir.hir.Stmt;
import java.util.ArrayList;
import java.util.Iterator;

public class HirIteratorImpl
implements HirIterator {
    public final HirRoot hirRoot;
    public final IoRoot ioRoot;
    protected int fDbgLevel;
    protected ArrayList fNodeList = new ArrayList(1000);
    protected ArrayList fStmtList = new ArrayList(100);
    protected int fNodeCount = 0;
    protected int fStmtCount = 0;
    protected Iterator fNodeListIterator;
    protected Iterator fStmtListIterator;
    protected int fDebLevel;

    public HirIteratorImpl(HirRoot pHirRoot, IR pSubtree, boolean pGoUpward) {
        this.hirRoot = pHirRoot;
        this.ioRoot = pHirRoot.ioRoot;
        this.fDbgLevel = this.ioRoot.dbgHir.getLevel();
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(5, "HirIteratorImpl", IoRoot.toStringObjectShort(pSubtree));
        }
        this.recordNodes((HIR)pSubtree);
        this.fNodeListIterator = this.fNodeList.iterator();
        this.fStmtListIterator = this.fStmtList.iterator();
    }

    public HIR next() {
        HIR lHir = this.fNodeListIterator.hasNext() ? (HIR)this.fNodeListIterator.next() : null;
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgHir.print(6, "HirIterator.next", IoRoot.toStringObjectShort(lHir));
        }
        return lHir;
    }

    public boolean hasNext() {
        return this.fNodeListIterator.hasNext();
    }

    public boolean hasNextStmt() {
        return this.fStmtListIterator.hasNext();
    }

    public HIR getNextExecutableNode() {
        HIR lNextNode = null;
        boolean lExecutable = false;
        lNextNode = this.next();
        while (!lExecutable) {
            block5: {
                block4: {
                    if (lNextNode == null) break block4;
                    switch (lNextNode.getOperator()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 14: 
                        case 15: 
                        case 21: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 32: 
                        case 35: 
                        case 36: 
                        case 73: 
                        case 96: {
                            lExecutable = false;
                            break block5;
                        }
                        default: {
                            lExecutable = true;
                            break;
                        }
                    }
                    break;
                }
                if (!this.hasNext()) break;
            }
            lNextNode = this.next();
        }
        return lNextNode;
    }

    public Stmt nextStmt() {
        Stmt lStmt;
        if (this.fStmtListIterator.hasNext()) {
            lStmt = (Stmt)this.fStmtListIterator.next();
        } else {
            this.ioRoot.msgError.put("HirIterator.nextStmt should be called after testing by hasNextStmt()");
            lStmt = null;
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgHir.print(6, "HirIterator.nextStmt", IoRoot.toStringObjectShort(lStmt));
        }
        return lStmt;
    }

    public Stmt getNextStmt() {
        Stmt lStmt;
        if (this.fStmtListIterator.hasNext()) {
            lStmt = (Stmt)this.fStmtListIterator.next();
        } else {
            this.ioRoot.msgRecovered.put("HirIterator.getNextStmt should be called after testing by hasNextStmt()");
            if (this.fDbgLevel > 0) {
                this.ioRoot.dbgHir.print(2, "HirIterator", "getNextStmt should be called after testing by hasNextStmt()");
            }
            while (this.hasNext()) {
                HIR hIR = this.next();
            }
            lStmt = null;
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgHir.print(6, "HirIterator.nextStmt", IoRoot.toStringObjectShort(lStmt));
        }
        return lStmt;
    }

    protected void recordNodes(HIR pHir) {
        block10: {
            block11: {
                block12: {
                    if (this.fDbgLevel > 3) {
                        this.hirRoot.ioRoot.dbgHir.print(6, "recordNodes", pHir.toStringShort() + " " + this.fNodeCount);
                    }
                    this.fNodeList.add(this.fNodeCount, pHir);
                    ++this.fNodeCount;
                    if (pHir instanceof Stmt) {
                        if (this.fDbgLevel > 3) {
                            this.hirRoot.ioRoot.dbgHir.print(6, " stmt" + this.fStmtCount);
                        }
                        this.fStmtList.add(this.fStmtCount, pHir);
                        ++this.fStmtCount;
                    }
                    if (pHir.getChildCount() != 0) break block11;
                    if (!(pHir instanceof HirList)) break block12;
                    HirList lHirList = (HirList)pHir;
                    int lListSize = lHirList.size();
                    int lIndex = 0;
                    for (int lElemIndex = 0; lElemIndex < lHirList.size(); ++lElemIndex) {
                        HIR lElem = (HIR)lHirList.get(lElemIndex);
                        if (++lIndex <= lListSize) {
                            if (lElem == null) continue;
                            this.recordNodes(lElem);
                            continue;
                        }
                        break block10;
                    }
                    break block10;
                }
                if (!(pHir instanceof ExpListExp)) break block10;
                ExpListExp lExpListExp = (ExpListExp)pHir;
                for (int lElemIndex = 0; lElemIndex < lExpListExp.size(); ++lElemIndex) {
                    Exp lElem = lExpListExp.getExp(lElemIndex);
                    if (lElem == null) continue;
                    this.recordNodes(lElem);
                }
                break block10;
            }
            if (pHir instanceof BlockStmt) {
                BlockStmt lBlockStmt = (BlockStmt)pHir;
                for (Stmt lStmt = lBlockStmt.getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                    this.recordNodes(lStmt);
                }
            } else {
                for (int lChildNumber = 1; lChildNumber <= pHir.getChildCount(); ++lChildNumber) {
                    HIR lChild = (HIR)pHir.getChild(lChildNumber);
                    if (lChild == null) continue;
                    this.recordNodes(lChild);
                }
            }
        }
    }
}

