/*
 * Decompiled with CFR 0.152.
 */
package coins.hir2lir;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.aflow.BBlock;
import coins.aflow.FlowAnalSymVector;
import coins.aflow.FlowResults;
import coins.aflow.SubpFlow;
import coins.aflow.SubpFlowImpl;
import coins.driver.CoinsOptions;
import coins.driver.Trace;
import coins.hir2c.HirBaseToCImpl;
import coins.ir.IrList;
import coins.ir.IrListImpl;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.ForStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.IfStmt;
import coins.ir.hir.InfStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.Program;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.VarNode;
import coins.lparallel.BasicInduction;
import coins.lparallel.LoopParallel;
import coins.lparallel.LoopParallelImpl;
import coins.lparallel.LoopTable;
import coins.lparallel.LoopUtil;
import coins.lparallel.Reduction;
import coins.lparallel.RegisterClasses;
import coins.sym.Param;
import coins.sym.PointerType;
import coins.sym.StringConst;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.Var;
import coins.sym.VectorType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class ReformHir {
    public final IoRoot ioRoot;
    public final SymRoot symRoot;
    public final HirRoot hirRoot;
    protected HIR hir;
    protected Sym sym;
    protected CoinsOptions fCoinsOptions;
    protected boolean fChanged;
    public FlowRoot flowRoot;
    protected LoopParallel fLoopParallel;
    protected LoopUtil fUtil;
    protected coins.flow.SubpFlow fSubpFlow;
    protected SubpFlow subpFlow;
    protected FlowResults fResults;
    protected SymTable fSymTableCurrent;
    protected List fSubpDefinitionList;
    protected Map fStatementsToBeReplaced;
    protected Map fStatementsToBeAdded;
    protected List fStatementsToBeDeleted;
    protected Map fLoopStmtToLoopTable;
    protected List fLoopsToBeParallelized;
    protected int fMaxDegreeOfParallel = 2;
    protected Type fThreadType;
    protected Var fThreadDescriptor;
    protected Var fNumberOfThreads;
    protected Var fThreadIdArray;
    protected Var fThreadIdOfMaster;
    protected boolean fStackInLocalMemory;
    protected Subp fThreadInit;
    protected Subp fThreadEnd;
    protected Subp fThreadPreprocessForDoAllLoop;
    protected Subp fThreadPostprocess;
    protected Subp fThreadForkForDoAll;
    protected Subp fThreadPreprocessForDoAllThread;
    protected Subp fThreadPostprocessForDoAllThread;
    protected Subp fThreadJoin;
    protected Subp fThreadSelfId;
    protected int fDbgLevel;
    public final int fMaximumNumberOfReductions = 2;

    public ReformHir(HirRoot pHirRoot) {
        this.ioRoot = pHirRoot.ioRoot;
        this.symRoot = pHirRoot.symRoot;
        this.hirRoot = pHirRoot;
        this.sym = this.symRoot.sym;
        this.hir = this.hirRoot.hir;
        this.fDbgLevel = this.ioRoot.dbgHir.getLevel();
        this.fChanged = false;
        this.fCoinsOptions = this.ioRoot.getCompileSpecification().getCoinsOptions();
        if (this.fCoinsOptions.isSet("simulate")) {
            this.reformForProfiling();
        }
        if (this.fCoinsOptions.isSet("parallelDoAll")) {
            this.reformForParallel();
        } else if (this.fCoinsOptions.isSet("lparallel2")) {
            // empty if block
        }
        if (this.fChanged) {
            Program lProgram = (Program)this.hirRoot.programRoot;
            HIR lProgInitPart = (HIR)lProgram.getInitiationPart();
            if (lProgInitPart instanceof BlockStmt && ((BlockStmt)lProgInitPart).getFirstStmt() == null) {
                lProgram.setChild2(this.hir.nullNode());
            }
            ((HIR)this.hirRoot.programRoot).finishHir();
        }
    }

    public void reformForProfiling() {
        this.ioRoot.dbgHir.print(1, "\nreformForProfiling\n");
        if (!this.fCoinsOptions.isSet("simulate")) {
            this.ioRoot.dbgHir.print(2, "no simulate option\n");
            return;
        }
        HashSet<Subp> lSubprograms = new HashSet<Subp>();
        HashSet<Subp> lToBeTraced = new HashSet<Subp>();
        HashSet<Subp> lNonTraced = new HashSet<Subp>();
        Program lProgram = (Program)this.hirRoot.programRoot;
        IrList lSubpList = lProgram.getSubpDefinitionList();
        ListIterator lIt = lSubpList.iterator();
        while (lIt.hasNext()) {
            SubpDefinition lSubpDef = (SubpDefinition)lIt.next();
            lSubprograms.add(lSubpDef.getSubpSym());
        }
        this.ioRoot.dbgHir.print(3, "Subprograms defined", lSubprograms + "\n");
        lToBeTraced.addAll(lSubprograms);
        LinkedList<Stmt> lStmtToBeDeleted = new LinkedList<Stmt>();
        HIR lProgInitPart = (HIR)lProgram.getInitiationPart();
        if (lProgInitPart instanceof BlockStmt) {
            for (Stmt lStmt = ((BlockStmt)lProgInitPart).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                Object lSubp;
                ListIterator lIt2;
                int lIndex;
                if (!(lStmt instanceof InfStmt) || ((InfStmt)lStmt).getInfKind() != "simulate") continue;
                this.ioRoot.dbgHir.print(3, lStmt.toString() + "\n");
                IrList lOptionList = ((InfStmt)lStmt).getInfList("simulate");
                this.ioRoot.dbgHir.print(4, " option list " + lOptionList + "\n");
                String lOptionName = ((InfStmt)lStmt).getInfSubkindOf("simulate");
                if (lOptionName == null) {
                    this.ioRoot.dbgHir.print(1, "\nUnknown option subkind " + ((InfStmt)lStmt).toString() + "\n");
                    continue;
                }
                if (lOptionName == "profileOnAll") {
                    lToBeTraced.addAll(lSubprograms);
                    lStmtToBeDeleted.add(lStmt);
                    this.fChanged = true;
                    continue;
                }
                if (lOptionName == "profileOffAll") {
                    lToBeTraced.clear();
                    lNonTraced.addAll(lSubprograms);
                    lStmtToBeDeleted.add(lStmt);
                    this.fChanged = true;
                    continue;
                }
                if (lOptionName == "profileOn") {
                    lIndex = 0;
                    lIt2 = lOptionList.iterator();
                    while (lIt2.hasNext()) {
                        lSubp = lIt2.next();
                        this.ioRoot.dbgHir.print(4, " " + lSubp + " " + lSubp.getClass() + "\n");
                        if (lSubp instanceof Subp) {
                            lToBeTraced.add((Subp)lSubp);
                            lNonTraced.remove(lSubp);
                        }
                        ++lIndex;
                    }
                    lStmtToBeDeleted.add(lStmt);
                    this.fChanged = true;
                    continue;
                }
                if (lOptionName == "profileOff") {
                    lIndex = 0;
                    lIt2 = lOptionList.iterator();
                    while (lIt2.hasNext()) {
                        lSubp = lIt2.next();
                        this.ioRoot.dbgHir.print(4, " " + lSubp + " " + lSubp.getClass() + "\n");
                        if (lIndex > 0 && lSubp instanceof Subp) {
                            lNonTraced.add((Subp)lSubp);
                            lToBeTraced.remove(lSubp);
                        }
                        ++lIndex;
                    }
                    lStmtToBeDeleted.add(lStmt);
                    this.fChanged = true;
                    continue;
                }
                this.ioRoot.dbgHir.print(1, "\nUnknown option " + lOptionName + "\n");
            }
        }
        this.ioRoot.dbgHir.print(1, "To be profiled", ((Object)lToBeTraced).toString());
        this.ioRoot.dbgHir.print(1, "Not to be profiled", ((Object)lNonTraced).toString());
        String lProfOnOff = "profileOn";
        ListIterator lIt3 = lSubpList.iterator();
        while (lIt3.hasNext()) {
            Stmt lSubpBody;
            SubpDefinition lSubpDef = (SubpDefinition)lIt3.next();
            Subp lSubp2 = lSubpDef.getSubpSym();
            if (lToBeTraced.contains(lSubp2)) {
                lProfOnOff = "profileOn";
            }
            if (lNonTraced.contains(lSubp2)) {
                lProfOnOff = "profileOff";
            }
            if ((lSubpBody = lSubpDef.getHirBody()) instanceof LabeledStmt) {
                lSubpBody = ((LabeledStmt)lSubpBody).getStmt();
            }
            if (!(lSubpBody instanceof BlockStmt)) continue;
            IrListImpl lIrList = new IrListImpl(this.hirRoot);
            lIrList.add(lProfOnOff);
            InfStmt lInfStmt = this.hir.infStmt("simulate", lIrList);
            ((BlockStmt)lSubpBody).addFirstStmt(lInfStmt);
            this.ioRoot.dbgHir.print(2, "add to " + lSubpDef.getSubpSym().getName(), lInfStmt.toString());
            this.fChanged = true;
        }
        for (Stmt lStmt2 : lStmtToBeDeleted) {
            lStmt2.deleteThisStmt();
            this.fChanged = true;
        }
    }

    public void reformForParallel() {
        Sym lSym12;
        Sym lSym11;
        Sym lSym10;
        Sym lSym9;
        Sym lSym8;
        Sym lSym7;
        Sym lSym6;
        Sym lSym5;
        Sym lSym4;
        Sym lSym3;
        Sym lSym2;
        Sym lSym1;
        String lOption = this.ioRoot.getCompileSpecification().getCoinsOptions().getArg("parallelDoAll");
        this.fMaxDegreeOfParallel = lOption != null && lOption.charAt(0) >= '0' && lOption.charAt(0) <= '9' ? lOption.charAt(0) - 48 : 2;
        this.fStackInLocalMemory = false;
        this.ioRoot.dbgHir.print(1, "\nreformForParallel", "maximum degree " + lOption + " " + this.fMaxDegreeOfParallel);
        if (!this.fCoinsOptions.isSet("parallelDoAll")) {
            this.ioRoot.dbgHir.print(2, "no parallelDoAll option. Do not parallelize.\n");
            return;
        }
        this.flowRoot = this.hirRoot.getFlowRoot();
        if (this.flowRoot == null) {
            this.flowRoot = new FlowRoot(this.hirRoot);
        }
        HashSet<Subp> lSubprograms = new HashSet<Subp>();
        HashSet lToBeParallelized = new HashSet();
        Program lProgram = (Program)this.hirRoot.programRoot;
        this.fSubpDefinitionList = new ArrayList();
        this.fStatementsToBeAdded = new HashMap();
        this.fStatementsToBeReplaced = new HashMap();
        this.fStatementsToBeDeleted = new ArrayList();
        this.fLoopStmtToLoopTable = new HashMap();
        String lMissingSym = "";
        Sym lSym0 = this.symRoot.symTableRoot.search("coinsThread", 8);
        if (lSym0 == null) {
            lMissingSym = lMissingSym + " coinsThread";
        }
        if ((lSym1 = this.symRoot.symTableRoot.search("coinsNumberOfThreads", 8)) == null) {
            lMissingSym = lMissingSym + " coinsNumberOfThreads";
        }
        if ((lSym2 = this.symRoot.symTableRoot.search("coinsThreadInit", 12)) == null) {
            lMissingSym = lMissingSym + " coinsThreadInit";
        }
        if ((lSym3 = this.symRoot.symTableRoot.search("coinsThreadEnd", 12)) == null) {
            lMissingSym = lMissingSym + " coinsThreadEnd";
        }
        if ((lSym4 = this.symRoot.symTableRoot.search("coinsThreadPreprocessForDoAllLoop", 12)) == null) {
            lMissingSym = lMissingSym + " coinsThreadPreprocessForDoAllLoop";
        }
        if ((lSym5 = this.symRoot.symTableRoot.search("coinsThreadPostprocess", 12)) == null) {
            lMissingSym = lMissingSym + " coinsThreadPostprocess";
        }
        if ((lSym6 = this.symRoot.symTableRoot.search("coinsThreadForkForDoAll", 12)) == null) {
            lMissingSym = lMissingSym + " coinsThreadForkForDoAll";
        }
        if ((lSym7 = this.symRoot.symTableRoot.search("coinsThreadPreprocessForDoAllThread", 12)) == null) {
            lMissingSym = lMissingSym + " coinsThreadPreprocessForDoAllThread";
        }
        if ((lSym8 = this.symRoot.symTableRoot.search("coinsThreadPostprocessForDoAllThread", 12)) == null) {
            lMissingSym = lMissingSym + " coinsThreadPostprocessForDoAllThread";
        }
        if ((lSym9 = this.symRoot.symTableRoot.search("coinsThreadSelfId", 12)) == null) {
            lMissingSym = lMissingSym + " coinsThreadSelfId";
        }
        if ((lSym10 = this.symRoot.symTableRoot.search("coinsThreadIdArray", 8)) == null) {
            lMissingSym = lMissingSym + " coinsThreadIdArray";
        }
        if ((lSym11 = this.symRoot.symTableRoot.search("<TYPEDEF coinsThread_t>", 13)) == null) {
            lMissingSym = lMissingSym + " coinsThread_t";
        }
        if ((lSym12 = this.symRoot.symTableRoot.search("coinsThreadJoin", 12)) == null) {
            lMissingSym = lMissingSym + " coinsThreadJoin";
        }
        String lSpecifiedSymbols = lSym0 + " " + lSym1 + " " + lSym2 + " " + lSym3 + " " + lSym4 + " " + lSym5 + " " + lSym6 + " " + lSym7 + " " + lSym8 + " " + lSym9 + " " + lSym10 + " " + lSym11 + " " + lSym12;
        this.ioRoot.dbgHir.print(4, "Thread symbols " + lSpecifiedSymbols);
        if (!(lSym0 instanceof Var && lSym1 instanceof Var && lSym2 instanceof Subp && lSym3 instanceof Subp && lSym4 instanceof Subp && lSym5 instanceof Subp && lSym6 instanceof Subp && lSym7 instanceof Subp && lSym8 instanceof Subp && lSym9 instanceof Subp && lSym10 instanceof Var && lSym11 instanceof Type)) {
            this.ioRoot.msgNote.put("#include coinsParallelFramework.h does not define symbols " + lMissingSym);
            this.ioRoot.msgError.put("#include coinsParallelFramework.h is missing or incorrect. Parallelization aborted.");
            return;
        }
        this.fThreadDescriptor = (Var)lSym0;
        this.fNumberOfThreads = (Var)lSym1;
        this.fThreadInit = (Subp)lSym2;
        this.fThreadEnd = (Subp)lSym3;
        this.fThreadPreprocessForDoAllLoop = (Subp)lSym4;
        this.fThreadPostprocess = (Subp)lSym5;
        this.fThreadForkForDoAll = (Subp)lSym6;
        this.fThreadPreprocessForDoAllThread = (Subp)lSym7;
        this.fThreadPostprocessForDoAllThread = (Subp)lSym8;
        this.fThreadJoin = (Subp)lSym12;
        this.fThreadSelfId = (Subp)lSym9;
        this.fThreadIdArray = (Var)lSym10;
        this.fThreadType = (Type)lSym11;
        IrList lSubpList = lProgram.getSubpDefinitionList();
        SubpDefinition lMainSubp = null;
        ListIterator lIt = lSubpList.iterator();
        while (lIt.hasNext()) {
            SubpDefinition lSubpDef = (SubpDefinition)lIt.next();
            Subp lSubprogram = lSubpDef.getSubpSym();
            lSubprograms.add(lSubpDef.getSubpSym());
        }
        this.ioRoot.dbgHir.print(2, "Subprograms defined", lSubprograms + "\n");
        HIR lProgInitPart = (HIR)lProgram.getInitiationPart();
        if (lProgInitPart instanceof BlockStmt) {
            for (Stmt lStmt = ((BlockStmt)lProgInitPart).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                String lOptionName;
                if (!(lStmt instanceof InfStmt) || ((InfStmt)lStmt).getInfKind() != "parallel") continue;
                this.ioRoot.dbgHir.print(3, lStmt.toString() + "\n");
                IrList lOptionList = ((InfStmt)lStmt).getInfList("parallel");
                Object lObject = lOptionList.get(0);
                this.ioRoot.dbgHir.print(3, " option name " + lObject + " " + lObject.getClass() + " " + lOptionList + "\n");
                if (lObject instanceof String) {
                    lOptionName = (String)lObject;
                } else if (lObject instanceof StringConst) {
                    lOptionName = ((StringConst)lObject).getStringBody();
                } else if (lObject instanceof Sym) {
                    lOptionName = ((Sym)lObject).getName();
                } else {
                    this.ioRoot.dbgHir.print(1, "\nUnknown option kind" + lObject + "\n");
                    continue;
                }
                lOptionName = lOptionName.intern();
                if (lOptionName == "doAllFunc") {
                    int lIndex = 0;
                    ListIterator lIt2 = lOptionList.iterator();
                    while (lIt2.hasNext()) {
                        Object lSubp = lIt2.next();
                        this.ioRoot.dbgHir.print(4, " " + lSubp + " " + lSubp.getClass() + "\n");
                        if (lSubp instanceof Subp) {
                            lToBeParallelized.add(lSubp);
                        }
                        ++lIndex;
                    }
                    this.fStatementsToBeDeleted.add(lStmt);
                    this.fChanged = true;
                    continue;
                }
                if (lOptionName == "doAllFuncAll") {
                    lToBeParallelized.addAll(lSubprograms);
                    continue;
                }
                this.ioRoot.dbgHir.print(1, "\nUnknown option " + lOptionName + "\n");
            }
        }
        this.ioRoot.dbgHir.print(2, "To be parallelized", ((Object)lToBeParallelized).toString());
        FlowResults.putRegClasses(new RegisterClasses());
        CoinsOptions coinsOptions = this.ioRoot.getCompileSpecification().getCoinsOptions();
        String loopOpt = coinsOptions.isSet("LoopOpt") ? coinsOptions.getArg("LoopOpt") : "";
        ListIterator lIt3 = lSubpList.iterator();
        while (lIt3.hasNext()) {
            boolean lChanged;
            SubpDefinition lSubpDef = (SubpDefinition)lIt3.next();
            Subp lSubp2 = lSubpDef.getSubpSym();
            if (lSubp2.getName().intern() == "main") {
                lMainSubp = lSubpDef;
            }
            if (lToBeParallelized.contains(lSubp2)) {
                lChanged = this.parallelize(lSubpDef);
            } else {
                if (lSubpDef != lMainSubp) continue;
                lChanged = this.reformForInitiation(lSubpDef);
            }
            if (!lChanged) continue;
            this.fChanged = true;
        }
        for (SubpDefinition lSubpDef : this.fSubpDefinitionList) {
            ((Program)this.hirRoot.programRoot).addSubpDefinition(lSubpDef);
        }
        Set lAddStmts = this.fStatementsToBeAdded.keySet();
        for (Stmt lOldStmt : lAddStmts) {
            Stmt lAddStmt = (Stmt)this.fStatementsToBeAdded.get(lOldStmt);
            if (this.fDbgLevel > 0) {
                this.ioRoot.dbgHir.print(2, "Add after " + lOldStmt.toStringShort(), lAddStmt.toString());
            }
            lOldStmt.addNextStmt(lAddStmt);
        }
        Set lReplStmts = this.fStatementsToBeReplaced.keySet();
        for (Stmt lOldStmt : lReplStmts) {
            Stmt lNewStmt = (Stmt)this.fStatementsToBeReplaced.get(lOldStmt);
            if (this.fDbgLevel > 0) {
                this.ioRoot.dbgHir.print(2, "Replace Stmt " + lOldStmt.toStringShort(), lNewStmt.toString());
            }
            lOldStmt.replaceThisNode(lNewStmt);
        }
        for (Stmt lStmt2 : this.fStatementsToBeDeleted) {
            lStmt2.deleteThisStmt();
            this.fChanged = true;
        }
        if (this.fDbgLevel > 1) {
            this.ioRoot.dbgHir.print(2, "\nResult of HIR parallelization \n");
            ((Program)this.hirRoot.programRoot).print(1, true);
        }
        ((Program)this.hirRoot.programRoot).finishHir();
        this.symRoot.symTableRoot.setUniqueNameToAllSym();
        if (this.fDbgLevel > 2) {
            this.symRoot.symTableRoot.printSymTableAllDetail();
        }
        if (coinsOptions.isSet("hir2c")) {
            try {
                this.makeCSourceFromHirBase("loop", this.hirRoot, this.symRoot, this.ioRoot);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    protected boolean parallelize(SubpDefinition pSubpDefinition) {
        this.ioRoot.dbgHir.print(2, "parallelize", pSubpDefinition.getSubpSym().getName());
        this.fLoopParallel = new LoopParallelImpl(this.hirRoot, this.ioRoot, pSubpDefinition, this.flowRoot);
        this.subpFlow = this.flowRoot.subpFlow;
        this.fResults = ((SubpFlowImpl)this.subpFlow).fResults;
        this.fLoopParallel.LoopAnal();
        ((LoopParallelImpl)this.fLoopParallel).ReconstructHir();
        this.fUtil = new LoopUtil(this.fResults, this.subpFlow);
        LinkedList LoopInfoList = (LinkedList)this.fResults.get("LoopParallelList", this.subpFlow);
        this.fLoopParallel.SetOpenMPInfo();
        boolean lChanged = this.reformHirToParallelize();
        return lChanged;
    }

    protected boolean reformForInitiation(SubpDefinition pSubpDefinition) {
        boolean lChanged = false;
        this.ioRoot.dbgHir.print(2, "reformForInitiation", pSubpDefinition.getSubpSym().getName());
        if (this.fDbgLevel >= 4 && this.subpFlow != null) {
            this.ioRoot.dbgHir.print(3, "\nHIR before transformation \n");
            this.subpFlow.getSubpDefinition().print(1, true);
        }
        Stmt lSubpBody = pSubpDefinition.getHirBody();
        HirIterator lStmtIt = this.hir.hirIterator(lSubpBody);
        while (lStmtIt.hasNextStmt()) {
            InfStmt lInfStmt;
            String lInfKind;
            Stmt lStmt = lStmtIt.getNextStmt();
            if (this.fDbgLevel > 2) {
                this.ioRoot.dbgHir.print(6, " " + lStmt.toStringShort());
            }
            if (!(lStmt instanceof InfStmt) || (lInfKind = (lInfStmt = (InfStmt)lStmt).getInfKind().intern()) != "parallel") continue;
            this.ioRoot.dbgHir.print(3, lStmt.toString() + "\n");
            IrList lOptionList = ((InfStmt)lStmt).getInfList(lInfKind);
            Object lObject = lOptionList.get(0);
            this.ioRoot.dbgHir.print(3, " option name " + lObject + " " + lObject.getClass() + " " + lOptionList + "\n");
            String lOptionName = "";
            if (!(lObject instanceof String)) continue;
            lOptionName = (String)lObject;
            if (lOptionName.intern() == "init") {
                IrList lParamList = this.hir.irList();
                lParamList.add(this.hir.intConstNode(this.fMaxDegreeOfParallel));
                AssignStmt lThreadInitStmt = this.hir.assignStmt(this.hir.varNode(this.fNumberOfThreads), this.hir.functionExp(this.hir.subpNode(this.fThreadInit), lParamList));
                this.fStatementsToBeReplaced.put(lStmt, lThreadInitStmt);
                lChanged = true;
                continue;
            }
            if (lOptionName.intern() != "end") continue;
            ExpStmt lThreadEndStmt = this.hir.callStmt(this.hir.subpNode(this.fThreadEnd), this.hir.irList());
            this.fStatementsToBeAdded.put(lStmt, lThreadEndStmt);
            lChanged = true;
        }
        return lChanged;
    }

    protected boolean reformHirToParallelize() {
        LoopTable lTable;
        LinkedList LoopInfoList = (LinkedList)this.fResults.get("LoopParallelList", this.subpFlow);
        this.ioRoot.dbgHir.print(2, "reformHirToParallelize", LoopInfoList.toString());
        if (this.fDbgLevel >= 4) {
            this.ioRoot.dbgHir.print(3, "\nHIR before parallelization \n");
            this.subpFlow.getSubpDefinition().print(1, true);
        }
        this.fLoopStmtToLoopTable = new HashMap();
        this.fLoopsToBeParallelized = new ArrayList();
        SubpDefinition lSubpDefinition = this.subpFlow.getSubpDefinition();
        ListIterator lLoopIt = LoopInfoList.listIterator();
        while (lLoopIt.hasNext()) {
            lTable = (LoopTable)lLoopIt.next();
            this.fLoopStmtToLoopTable.put(lTable.LoopStmt, lTable);
            this.ioRoot.dbgHir.print(2, "LoopTable for ", lTable.LoopStmt.toString());
        }
        Stmt lSubpBody = lSubpDefinition.getHirBody();
        HirIterator lStmtIt = this.hir.hirIterator(lSubpBody);
        while (lStmtIt.hasNextStmt()) {
            InfStmt lInfStmt;
            String lInfKind;
            Stmt lStmt = lStmtIt.getNextStmt();
            if (this.fDbgLevel > 2) {
                this.ioRoot.dbgHir.print(6, " " + lStmt.toStringShort());
            }
            if (!(lStmt instanceof InfStmt) || (lInfKind = (lInfStmt = (InfStmt)lStmt).getInfKind().intern()) != "parallel" && lInfKind != "doAll") continue;
            this.ioRoot.dbgHir.print(3, lStmt.toString() + "\n");
            IrList lOptionList = ((InfStmt)lStmt).getInfList(lInfKind);
            Object lObject = lOptionList.get(0);
            this.ioRoot.dbgHir.print(3, " option name " + lObject + " " + lObject.getClass() + " " + lOptionList + "\n");
            String lOptionName = "";
            if (lInfKind == "parallel" && lObject instanceof String) {
                lOptionName = (String)lObject;
                if (lOptionName.intern() == "init") {
                    IrList lParamList = this.hir.irList();
                    lParamList.add(this.hir.intConstNode(this.fMaxDegreeOfParallel));
                    AssignStmt lThreadInitStmt = this.hir.assignStmt(this.hir.varNode(this.fNumberOfThreads), this.hir.functionExp(this.hir.subpNode(this.fThreadInit), lParamList));
                    this.fStatementsToBeReplaced.put(lStmt, lThreadInitStmt);
                } else if (lOptionName.intern() == "end") {
                    ExpStmt lThreadEndStmt = this.hir.callStmt(this.hir.subpNode(this.fThreadEnd), this.hir.irList());
                    this.fStatementsToBeAdded.put(lStmt, lThreadEndStmt);
                }
            }
            if (lInfKind != "parallel" || !(lObject instanceof String)) continue;
            Object lUnexpectedItem = null;
            lOptionName = ((String)lObject).intern();
            this.ioRoot.dbgHir.print(3, " option name " + lOptionName + "\n");
            if (lOptionName == "doAll" || lOptionName == "forceDoAll") {
                LoopTable lLoopTableOfLoopStmt;
                LoopStmt lLoopNextToInfStmt = null;
                if (lInfStmt.getNextStmt() instanceof LoopStmt) {
                    lLoopNextToInfStmt = (LoopStmt)lInfStmt.getNextStmt();
                } else if (lInfStmt.getNextStmt() instanceof LabeledStmt && ((LabeledStmt)lInfStmt.getNextStmt()).getStmt() instanceof LoopStmt) {
                    lLoopNextToInfStmt = (LoopStmt)((LabeledStmt)lInfStmt.getNextStmt()).getStmt();
                } else {
                    boolean lInfAppeared = false;
                    HirIterator lHirIt = this.hir.hirIterator(lInfStmt.getParent());
                    while (lHirIt.hasNextStmt()) {
                        Stmt lBrotherStmt = lHirIt.getNextStmt();
                        if (this.fDbgLevel > 2 && lBrotherStmt != null) {
                            this.ioRoot.dbgHir.print(6, " " + lBrotherStmt.toStringShort());
                        }
                        if (lBrotherStmt == lInfStmt) {
                            lInfAppeared = true;
                            continue;
                        }
                        if (!lInfAppeared || !(lBrotherStmt instanceof LoopStmt)) continue;
                        lLoopNextToInfStmt = (LoopStmt)lBrotherStmt;
                        break;
                    }
                }
                if (lLoopNextToInfStmt == null) {
                    this.ioRoot.msgRecovered.put("Loop statement is not found after " + lInfStmt.toStringWithChildren());
                    continue;
                }
                if (this.fDbgLevel > 2) {
                    this.ioRoot.dbgHir.print(4, "Parallelize", lLoopNextToInfStmt.toStringShort());
                }
                if ((lLoopTableOfLoopStmt = (LoopTable)this.fLoopStmtToLoopTable.get(lLoopNextToInfStmt)) != null && (lLoopTableOfLoopStmt.getParaFlag() || lOptionName == "forceDoAll")) {
                    this.fLoopsToBeParallelized.add(lLoopNextToInfStmt);
                    if (lOptionName == "forceDoAll") {
                        LoopTable lNewLoopTable = new LoopTable((ForStmt)lLoopNextToInfStmt, this.subpFlow);
                        ListIterator lInfIt1 = lOptionList.iterator();
                        while (lInfIt1.hasNext()) {
                            Object lItem = lInfIt1.next();
                            if (this.fDbgLevel > 0) {
                                this.ioRoot.dbgHir.print(3, "\n option item " + lItem + " " + lItem.getClass() + " " + lObject);
                                if (lItem instanceof IrList) {
                                    this.ioRoot.dbgHir.print(3, " elem " + ((IrList)lItem).get(0));
                                }
                            }
                            if (lItem instanceof IrList && ((IrList)lItem).get(0) instanceof String) {
                                IrList lItemList = (IrList)lItem;
                                String lItemKind = ((String)lItemList.get(0)).intern();
                                this.ioRoot.dbgHir.print(3, "\n item kind " + lItemKind);
                                if (lItemKind == "private" || lItemKind == "lastPrivate") {
                                    HashSet<VarNode> lVarNodes = new HashSet<VarNode>();
                                    for (int lIndex1 = 1; lIndex1 < lItemList.size(); ++lIndex1) {
                                        Object lSubItem1 = lItemList.get(lIndex1);
                                        this.ioRoot.dbgHir.print(3, "\n subItem " + lSubItem1 + " " + lSubItem1.getClass());
                                        if (lSubItem1 instanceof Var) {
                                            lVarNodes.add(this.hir.varNode((Var)lSubItem1));
                                            continue;
                                        }
                                        lUnexpectedItem = lSubItem1;
                                    }
                                    if (lItemKind == "private") {
                                        lNewLoopTable.Private = lVarNodes;
                                        continue;
                                    }
                                    lNewLoopTable.LastPrivate = lVarNodes;
                                    continue;
                                }
                                if (lItemKind != "reduction") continue;
                                LinkedList<Reduction> lRedAddList = new LinkedList<Reduction>();
                                LinkedList<Reduction> lRedMulList = new LinkedList<Reduction>();
                                LinkedList<Reduction> lRedSubList = new LinkedList<Reduction>();
                                LinkedList<Reduction> lRedMaxList = new LinkedList<Reduction>();
                                LinkedList<Reduction> lRedMinList = new LinkedList<Reduction>();
                                LinkedList<Reduction> lRedMaxIndexList = new LinkedList<Reduction>();
                                LinkedList<Reduction> lRedMinIndexList = new LinkedList<Reduction>();
                                block5: for (int lIndex2 = 1; lIndex2 < lItemList.size(); ++lIndex2) {
                                    String lOperatorName = "";
                                    Var lReductionVar = null;
                                    VarNode lArrayExp = null;
                                    Object lSubItem2 = lItemList.get(lIndex2);
                                    if (lSubItem2 instanceof IrList) {
                                        this.ioRoot.dbgHir.print(3, " list size " + ((IrList)lSubItem2).size());
                                        boolean lSingleItem = false;
                                        ListIterator lItemIt2 = ((IrList)lSubItem2).iterator();
                                        while (lItemIt2.hasNext()) {
                                            IrList lReductionDescriptor;
                                            Object lSubItem3 = lItemIt2.next();
                                            this.ioRoot.dbgHir.print(3, "\n subItem3 " + lSubItem3 + " " + lSubItem3.getClass());
                                            if (lSubItem3 instanceof StringConst) {
                                                this.ioRoot.dbgHir.print(3, " There is only one reduction item of size " + ((IrList)lSubItem2).size());
                                                lReductionDescriptor = (IrList)lSubItem2;
                                                lSingleItem = true;
                                            } else if (lSubItem3 instanceof IrList) {
                                                lReductionDescriptor = (IrList)lSubItem3;
                                            } else {
                                                if (lSingleItem) continue;
                                                lUnexpectedItem = lSubItem3;
                                                continue;
                                            }
                                            if (!(lReductionDescriptor.get(0) instanceof StringConst)) {
                                                lUnexpectedItem = lReductionDescriptor.get(0);
                                                continue;
                                            }
                                            lOperatorName = ((StringConst)lReductionDescriptor.get(0)).getStringBody().intern();
                                            this.ioRoot.dbgHir.print(3, "\n operatorName " + lOperatorName);
                                            int lReductionOperator = lOperatorName == "+" ? 38 : (lOperatorName == "*" ? 41 : (lOperatorName == "-" ? 39 : 73));
                                            if (!(lReductionDescriptor.get(1) instanceof Var)) {
                                                lUnexpectedItem = lReductionDescriptor.get(1);
                                                continue;
                                            }
                                            lReductionVar = (Var)lReductionDescriptor.get(1);
                                            this.ioRoot.dbgHir.print(3, " ReductionVar " + lReductionVar);
                                            if (lReductionDescriptor.size() > 2) {
                                                if (lReductionDescriptor.get(2) instanceof Var) {
                                                    lArrayExp = this.hir.varNode((Var)lReductionDescriptor.get(2));
                                                    this.ioRoot.dbgHir.print(3, " arrayExp " + lArrayExp.toString());
                                                } else {
                                                    lUnexpectedItem = lReductionDescriptor.get(2);
                                                    continue;
                                                }
                                            }
                                            Reduction lNewReduction = lReductionOperator == 73 ? new Reduction(null, this.hir.varNode(lReductionVar), this.hir.varNode(lReductionVar), lOperatorName, lArrayExp) : new Reduction(null, this.hir.varNode(lReductionVar), this.hir.varNode(lReductionVar), lReductionOperator);
                                            if (lReductionOperator == 38) {
                                                lRedAddList.add(lNewReduction);
                                            } else if (lReductionOperator == 41) {
                                                lRedMulList.add(lNewReduction);
                                            } else if (lReductionOperator == 39) {
                                                lRedSubList.add(lNewReduction);
                                            } else if (lOperatorName == "max") {
                                                lRedMaxList.add(lNewReduction);
                                            } else if (lOperatorName == "max") {
                                                lRedMaxList.add(lNewReduction);
                                            } else if (lOperatorName == "min") {
                                                lRedMinList.add(lNewReduction);
                                            } else if (lOperatorName == "maxIndex") {
                                                lRedMaxIndexList.add(lNewReduction);
                                            } else if (lOperatorName == "minIndex") {
                                                lRedMinIndexList.add(lNewReduction);
                                            }
                                            if (!(lSubItem3 instanceof String)) continue;
                                            continue block5;
                                        }
                                        continue;
                                    }
                                    lUnexpectedItem = lSubItem2;
                                }
                                lNewLoopTable.ReductionADDList = lRedAddList;
                                lNewLoopTable.ReductionMULList = lRedMulList;
                                lNewLoopTable.ReductionSUBList = lRedSubList;
                                lNewLoopTable.ReductionMAXList = lRedMaxList;
                                lNewLoopTable.ReductionMINList = lRedMinList;
                                lNewLoopTable.ReductionMAXINDEXList = lRedMaxIndexList;
                                lNewLoopTable.ReductionMININDEXList = lRedMinIndexList;
                                continue;
                            }
                            if (lItem instanceof String && ((String)lItem).intern() == "forceDoAll") continue;
                            lUnexpectedItem = lItem;
                        }
                        if (this.fDbgLevel > 1) {
                            this.ioRoot.dbgHir.print(2, "\nNew LoopTable ");
                            lNewLoopTable.print(1);
                        }
                        this.fLoopStmtToLoopTable.put(lLoopNextToInfStmt, lNewLoopTable);
                    }
                }
            }
            if (lUnexpectedItem == null) continue;
            this.ioRoot.msgRecovered.put("Unexpected item in doAll/forceDoAll " + lUnexpectedItem.toString() + " " + lUnexpectedItem.getClass());
        }
        this.symRoot.symTableCurrent = this.fSymTableCurrent = lSubpDefinition.getSymTable();
        this.symRoot.symTableCurrentSubp = this.fSymTableCurrent;
        boolean lChanged = false;
        for (LoopStmt lLoopStmt : this.fLoopsToBeParallelized) {
            lTable = (LoopTable)this.fLoopStmtToLoopTable.get(lLoopStmt);
            this.ioRoot.dbgHir.print(3, "Loop to be parallelized", lTable.LoopStmt.toStringShort());
            if (this.ioRoot.dbgHir.getLevel() >= 3) {
                this.printLoopTable(lTable);
            }
            this.changeLoopToSubprogram(lTable);
            lChanged = true;
        }
        return lChanged;
    }

    protected void changeLoopToSubprogram(LoopTable pTable) {
        Subp lSubp = this.subpFlow.getSubpSym();
        ForStmt lLoopStmt = pTable.LoopStmt;
        BBlock lStartBlock = this.subpFlow.getBBlockOfIR(lLoopStmt.getIndex());
        BBlock lEndBlock = this.subpFlow.getBBlockOfIR(lLoopStmt.getLoopEndPart().getIndex());
        BBlock lLoopExitBlock = this.subpFlow.getBBlockOfIR(lLoopStmt.getLoopStartCondition().getIndex());
        if (lLoopExitBlock == null) {
            lLoopExitBlock = this.subpFlow.getBBlockOfIR(lLoopStmt.getLoopBackPoint().getIndex());
        }
        this.ioRoot.dbgHir.print(3, "changeLoopToSubprogram", lLoopStmt.toStringShort() + " StartBlock " + lStartBlock + " endBlock " + lLoopExitBlock + " endBlock " + lEndBlock);
        ArrayList<Var> lInLoopVarList = new ArrayList<Var>();
        ArrayList<Sym> lInLoopParam = new ArrayList<Sym>();
        Set lPrivate = this.varNodeToVarSet(pTable.Private);
        Set lLastPrivate = this.varNodeToVarSet(pTable.LastPrivate);
        HashSet lReductions = new HashSet();
        HashSet lReductionsToInitiate = new HashSet();
        ArrayList<Sym> lAlreadyGlobal = new ArrayList<Sym>();
        ArrayList<Sym> lChangeToLocal = new ArrayList<Sym>();
        ArrayList<Sym> lChangeToGlobal = new ArrayList<Sym>();
        ArrayList<Var> lPassPointer = new ArrayList<Var>();
        HashSet<Var> lInductionVars = new HashSet<Var>();
        HirIterator lIt1 = this.hir.hirIterator(lLoopStmt);
        while (lIt1.hasNext()) {
            Var lVar;
            HIR lHir = lIt1.next();
            if (!(lHir instanceof VarNode) || lInLoopVarList.contains(lVar = (Var)((VarNode)lHir).getSymNodeSym())) continue;
            lInLoopVarList.add(lVar);
        }
        lReductionsToInitiate.addAll(this.getReductionVar(pTable.ReductionMAXList));
        lReductionsToInitiate.addAll(this.getReductionVar(pTable.ReductionMINList));
        lReductionsToInitiate.addAll(this.getReductionVar(pTable.ReductionMAXINDEXList));
        lReductionsToInitiate.addAll(this.getReductionVar(pTable.ReductionMININDEXList));
        lReductions.addAll(this.getReductionVar(pTable.ReductionADDList));
        lReductions.addAll(this.getReductionVar(pTable.ReductionSUBList));
        lReductions.addAll(this.getReductionVar(pTable.ReductionMULList));
        lReductions.addAll(lReductionsToInitiate);
        FlowAnalSymVector lLiveIn = lStartBlock.getPLiveIn();
        FlowAnalSymVector lLiveOutFromExit = lLoopExitBlock.getPLiveOut();
        FlowAnalSymVector lLiveInToEnd = lEndBlock.getPLiveIn();
        FlowAnalSymVector lLiveOutFromEnd = lEndBlock.getPLiveOut();
        FlowAnalSymVector lExposedAtEnd = lEndBlock.getPExposed();
        FlowAnalSymVector lLiveOut = this.subpFlow.flowAnalSymVector();
        lLiveOutFromExit.vectorAnd(lLiveInToEnd, lLiveOut);
        if (this.fDbgLevel > 3) {
            this.printSet(lLiveOutFromExit.flowAnalSyms(), "LiveOutFromExit");
            this.printSet(lLiveInToEnd.flowAnalSyms(), "LiveInToEnd");
            this.printSet(lExposedAtEnd.flowAnalSyms(), "ExposedAtEnd");
            this.printSet(lLiveOutFromEnd.flowAnalSyms(), "LiveOutFromEnd");
            this.printSet(lLiveOut.flowAnalSyms(), "LiveOut");
        }
        FlowAnalSymVector lDefined = this.subpFlow.flowAnalSymVector();
        Set lLiveInVars = lLiveIn.flowAnalSyms();
        Set lLiveOutVars = lLiveOut.flowAnalSyms();
        HashSet<Sym> lCopyToChild = new HashSet<Sym>();
        HashSet<Sym> lCopyBack = new HashSet<Sym>();
        LinkedList lBBlockList = pTable.BBlockList;
        for (BBlock lBBlock : lBBlockList) {
            lDefined.vectorOr(lBBlock.getPDefined(), lDefined);
        }
        Set lDefinedVars = lDefined.flowAnalSyms();
        ListIterator lIt3 = lSubp.getParamList().iterator();
        while (lIt3.hasNext()) {
            Sym sym = (Sym)lIt3.next();
            if (!lInLoopVarList.contains(sym)) continue;
            lInLoopParam.add(sym);
            lChangeToGlobal.add(sym);
            lCopyToChild.add(sym);
        }
        for (BasicInduction basicInduction : pTable.IndList) {
            VarNode lVarNode = basicInduction.getVarNode();
            Var lIndVar = (Var)lVarNode.getSymNodeSym();
            lInductionVars.add(lIndVar);
        }
        for (Sym sym : lInLoopVarList) {
            if (sym.isGlobal()) {
                lAlreadyGlobal.add(sym);
            }
            if (lPrivate.contains(sym)) {
                if (!sym.isGlobal() || lChangeToLocal.contains(sym)) continue;
                lChangeToLocal.add(sym);
                continue;
            }
            if (lLastPrivate.contains(sym)) {
                if (!sym.isGlobal() || lChangeToLocal.contains(sym)) continue;
                lChangeToLocal.add(sym);
                continue;
            }
            if (lReductions.contains(sym)) {
                if (!sym.isGlobal() || lChangeToLocal.contains(sym)) continue;
                lChangeToLocal.add(sym);
                continue;
            }
            if (sym.isGlobal()) continue;
            if (lLiveInVars.contains(sym) && !lDefinedVars.contains(sym)) {
                if (!lChangeToGlobal.contains(sym)) {
                    lChangeToGlobal.add(sym);
                    lCopyToChild.add(sym);
                }
                if (!this.fStackInLocalMemory) continue;
                lCopyToChild.add(sym);
                continue;
            }
            if (!lLiveOutVars.contains(sym) || !lDefinedVars.contains(sym)) continue;
            if (!lChangeToGlobal.contains(sym)) {
                lChangeToGlobal.add(sym);
                lCopyToChild.add(sym);
            }
            if (!this.fStackInLocalMemory) continue;
            lCopyBack.add(sym);
        }
        for (Var var : lReductions) {
            lPassPointer.add(var);
        }
        if (this.fDbgLevel > 2 && this.ioRoot.dbgHir.getLevel() > 0) {
            this.printLoopTable(pTable);
            this.printList(lInLoopVarList, "InLoopVarList");
            this.printSet(lDefinedVars, "Defined");
            this.printSet(lCopyToChild, "CopyToChild");
            this.printSet(lLiveOutVars, "LiveOut");
            this.printSet(lCopyBack, "CopyBack");
            this.printSet(lInductionVars, "InductionVarriables");
            this.printSet(lReductions, "Reductions");
            this.printSet(lReductionsToInitiate, "ReductionsToInitiate");
            this.printList(lChangeToGlobal, "ChangeToGlobal");
            this.printList(lChangeToLocal, "ChangeToLocal");
            this.printList(lPassPointer, "PassPointer");
        }
        SubpDefinition lSubpDef = this.makeSubpDefinition(pTable, lInLoopVarList, lChangeToLocal, lChangeToGlobal, lInductionVars, lReductions, lReductionsToInitiate, lPassPointer, lCopyToChild, lCopyBack);
    }

    protected SubpDefinition makeSubpDefinition(LoopTable pTable, List pInLoopVarList, List pChangeToLocal, List pChangeToGlobal, Set pInductionVars, Set pReductionVarSet, Set pReductionsToInitiate, List pPassPointer, Set pCopyToChild, Set pCopyBack) {
        Param lParam;
        Type lVarType;
        Subp lCaller = this.subpFlow.getSubpSym();
        SymTable lCallerSymTable = this.subpFlow.getSubpDefinition().getSymTable();
        String lNewSubpName = this.fSymTableCurrent.generateSymName(this.subpFlow.getSubpSym().getName() + "_loop");
        this.symRoot.symTableCurrent = this.symRoot.symTableRoot;
        Subp lCalleeSubp = this.sym.defineSubp(lNewSubpName, this.sym.pointerType(this.symRoot.typeVoid));
        lCalleeSubp.setFlag(2, true);
        lCalleeSubp.setVisibility(2);
        this.symRoot.symTableCurrent = lCaller.getSymTable();
        ForStmt lForStmt = pTable.LoopStmt;
        Set lLastPrivate = new HashSet();
        Set lPrivate = this.varNodeToVarSet(pTable.Private);
        List lReductionList = this.getReductionList(pTable);
        HashSet lVarsToBeReplaced = new HashSet();
        ArrayList<Param> lFormalParamList = new ArrayList<Param>();
        HashMap<Var, Param> lWriteBackPointerParam = new HashMap<Var, Param>();
        HashMap<Var, Exp> lOldSymToNewVarExp = new HashMap<Var, Exp>();
        lVarsToBeReplaced.addAll(pChangeToLocal);
        lLastPrivate = this.varNodeToVarSet(pTable.LastPrivate);
        HashMap<Var, Var> lSetInitValue = new HashMap<Var, Var>();
        HashSet lVarsToInitiate = new HashSet();
        lVarsToInitiate.addAll(pInductionVars);
        lVarsToInitiate.removeAll(pReductionVarSet);
        lVarsToInitiate.addAll(pReductionsToInitiate);
        Var lPrimaryInductionVar = this.getPrimaryInductionVar(lForStmt);
        if (lPrimaryInductionVar != null) {
            lVarsToInitiate.remove(lPrimaryInductionVar);
        }
        for (Var lIndVar : lVarsToInitiate) {
            Var lGlobalToBeInitiated = this.defineVar("_" + lIndVar.getName() + "_global", lIndVar.getSymType(), this.symRoot.symTableRoot, null);
            lSetInitValue.put(lIndVar, lGlobalToBeInitiated);
        }
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgHir.print(1, "makeSubpDefinition for", lForStmt.toStringShort());
            if (this.fDbgLevel > 2) {
                this.printList(pInLoopVarList, "InLoopVarList");
                this.printList(pChangeToLocal, "ChangeToLocal");
                this.printList(pChangeToGlobal, "ChangeToGlobal");
                this.printList(pPassPointer, "PassPointer");
                this.printSet(lPrivate, "Private");
                this.printSet(lLastPrivate, "LastPrivate");
                this.printSet(pInductionVars, "InductionVars");
                this.printSet(pReductionVarSet, "Reductions");
                this.printSet(pReductionsToInitiate, "ReductionsToInitiate");
                this.printSet(pCopyToChild, "CopyToChild");
                this.printSet(pCopyBack, "CopyBack");
                this.printSet(lVarsToInitiate, "VarsToInitiate");
                this.ioRoot.dbgHir.print(5, "\nSetInitValue map " + lSetInitValue);
            }
        }
        BlockStmt lBlockForCallStmt = this.hir.blockStmt(null);
        VectorType lVectorOfDegree = this.sym.vectorType(this.symRoot.typeLong, this.fMaxDegreeOfParallel);
        Var lFromVect = this.defineVar("_index_from", lVectorOfDegree, lCallerSymTable, lCaller);
        Var lToVect = this.defineVar("_index_to", lVectorOfDegree, lCallerSymTable, lCaller);
        IrList lArgListOfPreprocess1 = this.hir.irList();
        lArgListOfPreprocess1.add(this.hir.varNode(this.fNumberOfThreads));
        Stmt lOrgInitPart = pTable.originalLoopInit;
        if (lOrgInitPart != null) {
            lOrgInitPart = (Stmt)lOrgInitPart.copyWithOperands();
            lBlockForCallStmt.addLastStmt(lOrgInitPart);
            this.ioRoot.dbgHir.print(2, " Add loopInitPart", lOrgInitPart.toStringWithChildren());
        }
        Iterator lListIt = pTable.addConditionPart.iterator();
        while (lListIt.hasNext()) {
            Stmt lPreStmt = (Stmt)((Stmt)lListIt.next()).copyWithOperandsChangingLabels(null);
            lBlockForCallStmt.addLastStmt(lPreStmt);
            this.ioRoot.dbgHir.print(2, " Add conditional part", lPreStmt.toStringWithChildren());
        }
        Exp lLoopCountOfForStmt = (Exp)lForStmt.getLoopStartCondition().getChild2();
        Exp lLoopCountArg = (Exp)lLoopCountOfForStmt.copyWithOperands();
        if (lLoopCountArg.getType() != this.symRoot.typeLong) {
            lLoopCountArg = this.hir.convExp(this.symRoot.typeLong, lLoopCountArg);
        }
        lArgListOfPreprocess1.add(lLoopCountArg);
        lArgListOfPreprocess1.add(this.hir.decayExp(this.hir.varNode(lFromVect)));
        lArgListOfPreprocess1.add(this.hir.decayExp(this.hir.varNode(lToVect)));
        ExpStmt lPreprocessForDoAllLoop = this.hir.callStmt(this.hir.subpNode(this.fThreadPreprocessForDoAllLoop), lArgListOfPreprocess1);
        lBlockForCallStmt.addLastStmt(lPreprocessForDoAllLoop);
        Var lI1 = this.defineVar("_I", this.symRoot.typeLong, lCallerSymTable, lCaller);
        BlockStmt lBlockInLoop1 = this.hir.blockStmt(null);
        ForStmt lForStmt1 = this.hir.forStmt(this.hir.assignStmt(this.hir.varNode(lI1), this.hir.intConstNode(0)), this.hir.exp(55, this.hir.varNode(lI1), this.hir.exp(39, this.hir.varNode(this.fNumberOfThreads), this.hir.intConstNode(1))), lBlockInLoop1, this.hir.assignStmt(this.hir.varNode(lI1), this.hir.exp(38, this.hir.varNode(lI1), this.hir.intConstNode(1))));
        BlockStmt lChangeToGlobalBlock = this.hir.blockStmt(null);
        IrList lArgListOfFork = this.hir.irList();
        lArgListOfFork.add(this.hir.addrExp(this.hir.subscriptedExp(this.hir.varNode(this.fThreadDescriptor), this.hir.varNode(lI1))));
        lArgListOfFork.add(this.hir.subpNode(lCalleeSubp));
        lArgListOfFork.add(this.hir.subscriptedExp(this.hir.varNode(this.fThreadIdArray), this.hir.varNode(lI1)));
        lArgListOfFork.add(this.hir.subscriptedExp(this.hir.varNode(lFromVect), this.hir.varNode(lI1)));
        lArgListOfFork.add(this.hir.subscriptedExp(this.hir.varNode(lToVect), this.hir.varNode(lI1)));
        for (Var lReferedVar : pChangeToGlobal) {
            AssignStmt lSetToGlobal;
            Type lGlobalType = lReferedVar.getSymType();
            this.ioRoot.dbgHir.print(4, "\n Change to global " + lReferedVar.getName() + " type " + lGlobalType);
            if (lGlobalType instanceof VectorType) {
                lGlobalType = this.sym.pointerType(((VectorType)lGlobalType).getElemType(), ((VectorType)lGlobalType).getElemCount());
            }
            Var lGlobalToBePassed = this.defineVar("_" + lReferedVar.getName() + "_global", lGlobalType, this.symRoot.symTableRoot, null);
            this.ioRoot.dbgHir.print(4, " generated Var " + lGlobalToBePassed.getName() + " type " + lGlobalType);
            if (lReferedVar.getSymType() instanceof VectorType) {
                if (pCopyToChild.contains(lReferedVar)) {
                    lOldSymToNewVarExp.put(lReferedVar, this.hir.undecayExp((Exp)this.hir.varNode(lGlobalToBePassed), ((VectorType)lReferedVar.getSymType()).getElemCount()));
                    lSetToGlobal = this.hir.assignStmt(this.hir.varNode(lGlobalToBePassed), this.hir.decayExp(this.hir.varNode(lReferedVar)));
                    this.ioRoot.dbgHir.print(4, "\n set global pointer " + lSetToGlobal.toStringWithChildren());
                    lChangeToGlobalBlock.addLastStmt(lSetToGlobal);
                    continue;
                }
                lOldSymToNewVarExp.put(lReferedVar, this.hir.undecayExp((Exp)this.hir.varNode(lGlobalToBePassed), ((VectorType)lReferedVar.getSymType()).getElemCount()));
                lSetToGlobal = this.hir.assignStmt(this.hir.varNode(lGlobalToBePassed), this.hir.decayExp(this.hir.varNode(lReferedVar)));
                this.ioRoot.dbgHir.print(4, "\n set global " + lSetToGlobal.toStringWithChildren());
                lChangeToGlobalBlock.addLastStmt(lSetToGlobal);
                continue;
            }
            if (lReferedVar.getSymType() instanceof PointerType && ((PointerType)lReferedVar.getSymType()).isDeclaredAsArray()) {
                lOldSymToNewVarExp.put(lReferedVar, this.hir.varNode(lGlobalToBePassed));
                this.ioRoot.dbgHir.print(4, " pointerDeclaredAsArray " + lReferedVar + " " + lGlobalToBePassed);
                lSetToGlobal = this.hir.assignStmt(this.hir.varNode(lGlobalToBePassed), this.hir.varNode(lReferedVar));
                this.ioRoot.dbgHir.print(4, "\n set pointer value " + lSetToGlobal.toStringWithChildren());
                lChangeToGlobalBlock.addLastStmt(lSetToGlobal);
                continue;
            }
            lOldSymToNewVarExp.put(lReferedVar, this.hir.varNode(lGlobalToBePassed));
            if (!pCopyToChild.contains(lReferedVar)) continue;
            lSetToGlobal = this.hir.assignStmt(this.hir.varNode(lGlobalToBePassed), this.hir.varNode(lReferedVar));
            this.ioRoot.dbgHir.print(4, "\n set value " + lSetToGlobal.toStringWithChildren());
            lChangeToGlobalBlock.addLastStmt(lSetToGlobal);
        }
        for (Var lVarToInit : lVarsToInitiate) {
            Var lGlobalVar = (Var)lSetInitValue.get(lVarToInit);
            AssignStmt lSetInitVal = this.hir.assignStmt(this.hir.varNode(lGlobalVar), this.hir.varNode(lVarToInit));
            lChangeToGlobalBlock.addLastStmt(lSetInitVal);
        }
        if (lChangeToGlobalBlock.getFirstStmt() != null) {
            this.ioRoot.dbgHir.print(4, "\n add lChangeToGlobalBlock " + lChangeToGlobalBlock.toStringWithChildren());
            lBlockForCallStmt.addLastStmt(lChangeToGlobalBlock);
        }
        HashMap<Var, Var> lReductionReceiver = new HashMap<Var, Var>();
        int lReductionCount = 0;
        for (Var lRedVar : pReductionVarSet) {
            VectorType lVectorType = this.sym.vectorType(lRedVar.getSymType(), this.fMaxDegreeOfParallel);
            Var lReceiverVar = this.defineVar("_" + lRedVar.getName() + "_receiver", lVectorType, lCallerSymTable, lCaller);
            lReductionReceiver.put(lRedVar, lReceiverVar);
            lArgListOfFork.add(this.hir.addrExp(this.hir.subscriptedExp(this.hir.varNode(lReceiverVar), this.hir.varNode(lI1))));
            ++lReductionCount;
        }
        for (int lRCount = lReductionCount; lRCount < 2; ++lRCount) {
            ConstNode lNullNode = this.hir.intConstNode(0);
            lArgListOfFork.add(lNullNode);
        }
        ExpStmt lForkStmt = this.hir.callStmt(this.hir.subpNode(this.fThreadForkForDoAll), lArgListOfFork);
        lBlockInLoop1.addLastStmt(lForkStmt);
        lBlockForCallStmt.addLastStmt(lForStmt1);
        if (lPrimaryInductionVar == null) {
            this.ioRoot.msgNote.put("Induction variable not found in " + lForStmt.toStringShort());
            return null;
        }
        ForStmt lCopiedForStmtForMaster = (ForStmt)lForStmt.copyWithOperandsChangingLabels(null);
        Stmt lLoopBodyForMasterThread = lCopiedForStmtForMaster.getLoopBodyPart() instanceof LabeledStmt ? ((LabeledStmt)lCopiedForStmtForMaster.getLoopBodyPart()).getStmt() : lCopiedForStmtForMaster.getLoopBodyPart();
        lLoopBodyForMasterThread.cutParentLink();
        ForStmt lForStmtForMasterThread = this.hir.forStmt(this.hir.assignStmt(this.hir.varNode(lPrimaryInductionVar), this.hir.subscriptedExp(this.hir.varNode(lFromVect), this.hir.exp(39, this.hir.varNode(this.fNumberOfThreads), this.hir.intConstNode(1)))), this.hir.exp(55, this.hir.varNode(lPrimaryInductionVar), this.hir.subscriptedExp(this.hir.varNode(lToVect), this.hir.exp(39, this.hir.varNode(this.fNumberOfThreads), this.hir.intConstNode(1)))), lLoopBodyForMasterThread, (Stmt)lCopiedForStmtForMaster.getLoopStepPart().copyWithOperands());
        if (lForStmt.getInfList() != null) {
            lForStmtForMasterThread.copyInfListFrom(lForStmt);
        }
        lBlockForCallStmt.addLastStmt(lForStmtForMasterThread);
        IrList lArgListOfPostprocess = this.hir.irList();
        lArgListOfPostprocess.add(this.hir.varNode(this.fNumberOfThreads));
        lArgListOfPostprocess.add(lLoopCountOfForStmt.copyWithOperands());
        ExpStmt lPostprocessStmt = this.hir.callStmt(this.hir.subpNode(this.fThreadPostprocess), lArgListOfPostprocess);
        lBlockForCallStmt.addLastStmt(lPostprocessStmt);
        if (this.fDbgLevel > 2) {
            this.ioRoot.dbgHir.print(2, "\nGenerated ForStmt \n");
            lBlockForCallStmt.print(2, false);
        }
        this.symRoot.symTableCurrent = this.symRoot.symTableRoot;
        SymTable lNewSymTable = this.symRoot.symTableRoot.pushSymTable(lCalleeSubp);
        BlockStmt lSubpBody = this.hir.blockStmt(null);
        Param lThreadId = this.defineParam("_threadId", this.symRoot.typeInt, lNewSymTable);
        lCalleeSubp.addParam(lThreadId);
        Param lIndexFrom = this.defineParam("_indexFrom", this.symRoot.typeLong, lNewSymTable);
        lCalleeSubp.addParam(lIndexFrom);
        Param lIndexTo = this.defineParam("_indexTo", this.symRoot.typeLong, lNewSymTable);
        lCalleeSubp.addParam(lIndexTo);
        int lPointerParamCount = 0;
        for (Var lVar : pPassPointer) {
            lVarType = lVar.getSymType();
            PointerType lPtrType = this.sym.pointerType(lVarType, this.symRoot.symTableRoot);
            lParam = this.defineParam(lVar.getName(), lPtrType, lNewSymTable);
            lCalleeSubp.addParam(lParam);
            lWriteBackPointerParam.put(lVar, lParam);
            lFormalParamList.add(lParam);
            ++lPointerParamCount;
        }
        for (int lParamCount = lPointerParamCount; lParamCount < 2; ++lParamCount) {
            lParam = this.defineParam("_voidPtr", this.sym.pointerType(this.symRoot.typeVoid, this.symRoot.symTableRoot), lNewSymTable);
            lCalleeSubp.addParam(lParam);
        }
        lCalleeSubp.closeSubpHeader();
        for (Var lVar : pInLoopVarList) {
            if (pChangeToGlobal.contains(lVar)) continue;
            if (lVar.isGlobal()) {
                if (!pChangeToLocal.contains(lVar)) continue;
                lVarType = lVar.getSymType();
                Var lNewVar = this.defineVar(lVar.getName(), lVarType, lNewSymTable, lCalleeSubp);
                lOldSymToNewVarExp.put(lVar, this.hir.varNode(lNewVar));
                continue;
            }
            String lLocalVarName = lVar.getName();
            Var lLocalVar = this.sym.defineVar(lLocalVarName, lVar.getSymType());
            lOldSymToNewVarExp.put(lVar, this.hir.varNode(lLocalVar));
            if (!pReductionVarSet.contains(lVar)) continue;
        }
        ExpStmt lPreprocessForThread = this.hir.callStmt(this.hir.subpNode(this.fThreadPreprocessForDoAllThread), this.hir.irList());
        lSubpBody.addLastStmt(lPreprocessForThread);
        for (Var lRedVar2 : pReductionVarSet) {
            Exp lInitValue = pTable.getReductionVarSet(pTable.ReductionMAXINDEXList).contains(lRedVar2) || pTable.getReductionVarSet(pTable.ReductionMININDEXList).contains(lRedVar2) ? this.hir.varNode(lIndexFrom) : this.initialValueOfReduction(pTable, lRedVar2);
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgHir.print(3, "\nReductionVar " + lRedVar2.getName() + " maxIndexList " + pTable.getReductionVarSet(pTable.ReductionMAXINDEXList) + " minIndexList " + pTable.getReductionVarSet(pTable.ReductionMININDEXList));
                this.ioRoot.dbgHir.print(3, "\n initial value " + lInitValue.toStringWithChildren());
            }
            Exp lReductionVarExp = this.hir.varNode(lRedVar2);
            if (lOldSymToNewVarExp.containsKey(lRedVar2)) {
                lReductionVarExp = (Exp)((HIR)lOldSymToNewVarExp.get(lRedVar2)).copyWithOperands();
            }
            AssignStmt lInitValAssign = this.hir.assignStmt(lReductionVarExp, lInitValue);
            lSubpBody.addLastStmt(lInitValAssign);
        }
        for (Var lVarToInit2 : lVarsToInitiate) {
            if (pTable.getReductionVarSet(pTable.ReductionMAXINDEXList).contains(lVarToInit2) || pTable.getReductionVarSet(pTable.ReductionMININDEXList).contains(lVarToInit2)) continue;
            Var lGlobalVar2 = (Var)lSetInitValue.get(lVarToInit2);
            VarNode lReceiver = lOldSymToNewVarExp.containsKey(lVarToInit2) ? (VarNode)((Exp)lOldSymToNewVarExp.get(lVarToInit2)).copyWithOperands() : this.hir.varNode(lVarToInit2);
            AssignStmt lSetInitVal2 = this.hir.assignStmt(lReceiver, this.hir.varNode(lGlobalVar2));
            lSubpBody.addLastStmt(lSetInitVal2);
        }
        Stmt lInitPart = pTable.originalLoopInit;
        if (lInitPart != null) {
            lInitPart = (Stmt)lInitPart.copyWithOperands();
            lInitPart = (Stmt)this.rewriteVariables(lInitPart, lOldSymToNewVarExp);
            lSubpBody.addLastStmt(lInitPart);
        }
        Iterator lListIt2 = pTable.addConditionPart.iterator();
        while (lListIt2.hasNext()) {
            Stmt lPreStmt = (Stmt)((Stmt)lListIt2.next()).copyWithOperandsChangingLabels(null);
            lPreStmt = (Stmt)this.rewriteVariables(lPreStmt, lOldSymToNewVarExp);
            lSubpBody.addLastStmt(lPreStmt);
        }
        ForStmt lCopiedForStmt = (ForStmt)lForStmt.copyWithOperandsChangingLabels(null);
        lCopiedForStmt = (ForStmt)this.rewriteVariables(lCopiedForStmt, lOldSymToNewVarExp);
        Var lNewInductionVar = lPrimaryInductionVar;
        if (lOldSymToNewVarExp.containsKey(lPrimaryInductionVar)) {
            lNewInductionVar = (Var)((HIR)lOldSymToNewVarExp.get(lPrimaryInductionVar)).getSym();
        }
        Stmt lLoopBody = lCopiedForStmt.getLoopBodyPart() instanceof LabeledStmt ? ((LabeledStmt)lCopiedForStmt.getLoopBodyPart()).getStmt() : lCopiedForStmt.getLoopBodyPart();
        lLoopBody.cutParentLink();
        ForStmt lNewForStmt = this.hir.forStmt(this.hir.assignStmt(this.hir.varNode(lNewInductionVar), this.hir.varNode(lIndexFrom)), this.hir.exp(55, this.hir.varNode(lNewInductionVar), this.hir.varNode(lIndexTo)), lLoopBody, this.hir.assignStmt(this.hir.varNode(lNewInductionVar), this.hir.exp(38, this.hir.varNode(lNewInductionVar), this.hir.intConstNode(1))));
        lSubpBody.addLastStmt(lNewForStmt);
        for (Var lRedVar : pReductionVarSet) {
            Var lRedPtr = null;
            if (lWriteBackPointerParam.containsKey(lRedVar)) {
                lRedPtr = (Var)lWriteBackPointerParam.get(lRedVar);
            }
            if (lRedPtr == null) {
                this.ioRoot.msgRecovered.put("Write back pointer not found for " + lRedVar);
                continue;
            }
            Exp lFromVarExp = this.hir.varNode(lRedVar);
            if (lOldSymToNewVarExp.containsKey(lRedVar)) {
                lFromVarExp = (Exp)((HIR)lOldSymToNewVarExp.get(lRedVar)).copyWithOperands();
            }
            Type lVarTypeR = lRedVar.getSymType();
            AssignStmt lWriteBackRedStmt = this.hir.assignStmt(this.hir.contentsExp(this.hir.varNode(lRedPtr)), lFromVarExp);
            lSubpBody.addLastStmt(lWriteBackRedStmt);
        }
        ExpStmt lPostprocessForThread = this.hir.callStmt(this.hir.subpNode(this.fThreadPostprocessForDoAllThread), this.hir.irList());
        lSubpBody.addLastStmt(lPostprocessForThread);
        lSubpBody.setSymTable(lNewSymTable);
        SubpDefinition lSubpDef = this.hir.subpDefinition(lCalleeSubp, lNewSymTable);
        lSubpDef.setHirBody(lSubpBody);
        lCalleeSubp.setSymTable(lNewSymTable);
        this.fSubpDefinitionList.add(lSubpDef);
        if (this.fDbgLevel >= 4) {
            lSubpDef.printHir("Generated subprogram");
        }
        lNewSymTable.popSymTable();
        this.symRoot.symTableCurrent = this.fSymTableCurrent;
        this.symRoot.symTableCurrentSubp = this.fSymTableCurrent;
        for (Var lLiveOutVar : pCopyBack) {
            if (!lOldSymToNewVarExp.containsKey(lLiveOutVar)) continue;
            Exp lVarExp = (Exp)((HIR)lOldSymToNewVarExp.get(lLiveOutVar)).copyWithOperands();
            AssignStmt lWriteBack1 = this.hir.assignStmt(this.hir.varNode(lLiveOutVar), lVarExp);
            lBlockForCallStmt.addLastStmt(lWriteBack1);
        }
        String lOperatorName = "";
        for (Var lRedVar5 : pReductionVarSet) {
            Var lReceiver5 = (Var)lReductionReceiver.get(lRedVar5);
            Reduction lReduction = this.getReductionForVar(lRedVar5, lReductionList);
            if (lReduction == null) continue;
            int lOperator = lReduction.op;
            if (lOperator == 39) {
                lOperator = 38;
            }
            lOperatorName = lReduction.opName;
            Var lIndexRed5 = this.defineVar("_indexR", this.symRoot.typeInt, lCallerSymTable, lCaller);
            BlockStmt lRedLoopBody = this.hir.blockStmt(null);
            if (lOperator != 73) {
                AssignStmt lReductionAssign = this.hir.assignStmt(this.hir.varNode(lRedVar5), this.hir.exp(lOperator, this.hir.varNode(lRedVar5), this.hir.subscriptedExp(this.hir.varNode(lReceiver5), this.hir.varNode(lIndexRed5))));
                lRedLoopBody.addLastStmt(lReductionAssign);
            } else {
                Exp lCompareExp;
                int lCmpOperator = 53;
                if (lOperatorName == "min" || lOperatorName == "minIndex") {
                    lCmpOperator = 55;
                }
                AssignStmt lReviseValue = this.hir.assignStmt(this.hir.varNode(lRedVar5), this.hir.subscriptedExp(this.hir.varNode(lReceiver5), this.hir.varNode(lIndexRed5)));
                if (lOperatorName == "max" || lOperatorName == "min") {
                    lCompareExp = this.hir.exp(lCmpOperator, this.hir.subscriptedExp(this.hir.varNode(lReceiver5), this.hir.varNode(lIndexRed5)), this.hir.varNode(lRedVar5));
                } else if (lReduction.arrayExp != null) {
                    Exp lArrayExp = lReduction.arrayExp;
                    lCompareExp = this.hir.exp(lCmpOperator, this.hir.subscriptedExp((Exp)lArrayExp.copyWithOperands(), this.hir.subscriptedExp(this.hir.varNode(lReceiver5), this.hir.varNode(lIndexRed5))), this.hir.subscriptedExp((Exp)lArrayExp.copyWithOperands(), this.hir.varNode(lRedVar5)));
                } else {
                    this.ioRoot.msgRecovered.put("Array expression is not given as reduction parameter");
                    lCompareExp = this.hir.constNode(this.symRoot.boolConstFalse);
                }
                IfStmt lIfStmt = this.hir.ifStmt(lCompareExp, lReviseValue, null);
                lRedLoopBody.addLastStmt(lIfStmt);
            }
            ForStmt lReductionSynthesis = this.hir.forStmt(this.hir.assignStmt(this.hir.varNode(lIndexRed5), this.hir.intConstNode(0)), this.hir.exp(55, this.hir.varNode(lIndexRed5), this.hir.exp(39, this.hir.varNode(this.fNumberOfThreads), this.hir.intConstNode(1))), lRedLoopBody, this.hir.assignStmt(this.hir.varNode(lIndexRed5), this.hir.exp(38, this.hir.varNode(lIndexRed5), this.hir.intConstNode(1))));
            lBlockForCallStmt.addLastStmt(lReductionSynthesis);
        }
        if (this.fDbgLevel > 2) {
            this.ioRoot.dbgHir.print(2, "\nGenerated ForStmt including call\n");
            lBlockForCallStmt.print(2, false);
        }
        this.fStatementsToBeReplaced.put(lForStmt, lBlockForCallStmt);
        return lSubpDef;
    }

    protected HIR rewriteVariables(HIR pNewHir, Map pOldSymToNewVarExp) {
        if (pNewHir == null || pOldSymToNewVarExp == null) {
            return null;
        }
        if (this.fDbgLevel > 1) {
            this.ioRoot.dbgHir.print(2, "rewriteVariables " + pNewHir.toStringShort(), pOldSymToNewVarExp.toString());
        }
        HirIterator lIt3 = this.hir.hirIterator(pNewHir);
        while (lIt3.hasNext()) {
            Var lOldVar;
            HIR lHir = lIt3.next();
            if (!(lHir instanceof VarNode) || !pOldSymToNewVarExp.containsKey(lOldVar = (Var)((VarNode)lHir).getSymNodeSym())) continue;
            Exp lNewVarExp = (Exp)((HIR)pOldSymToNewVarExp.get(lOldVar)).copyWithOperands();
            lHir.replaceThisNode(lNewVarExp);
            if (this.fDbgLevel <= 0) continue;
            this.ioRoot.dbgHir.print(4, "replace", lOldVar.getName() + " to " + lNewVarExp.toStringShort());
        }
        return pNewHir;
    }

    public Var defineVar(String pHeader, Type pType, SymTable pSymTable, Subp pDefinedIn) {
        SymTable lSymTableSave = this.symRoot.symTableCurrent;
        this.symRoot.symTableCurrent = pSymTable;
        String lName = pSymTable.generateSymName(pHeader);
        Var lVar = this.sym.defineVar(lName, pType, pDefinedIn);
        lVar.setFlag(2, true);
        if (pSymTable == this.symRoot.symTableRoot) {
            lVar.setVisibility(2);
            lVar.setStorageClass(6);
        } else {
            lVar.setVisibility(4);
            lVar.setStorageClass(7);
        }
        this.symRoot.symTableCurrent = lSymTableSave;
        return lVar;
    }

    public Param defineParam(String pHeader, Type pType, SymTable pSymTable) {
        SymTable lSymTableSaved = this.symRoot.symTableCurrent;
        this.symRoot.symTableCurrent = pSymTable;
        String lName = pSymTable.generateSymName(pHeader);
        Param lParam = this.sym.defineParam(lName, pType);
        lParam.setFlag(2, true);
        this.symRoot.symTableCurrent = lSymTableSaved;
        return lParam;
    }

    protected Var getPrimaryInductionVar(ForStmt pForStmt) {
        Stmt lLoopInitPart = pForStmt.getLoopInitPart();
        Stmt lLoopStepStmt = pForStmt.getLoopStepPart();
        Var lInductionVar = null;
        if (this.fDbgLevel > 1) {
            this.ioRoot.dbgHir.print(3, "getPrimaryInductionVar", pForStmt.toString());
            this.ioRoot.dbgHir.print(5, " loopInitPart", lLoopInitPart.toStringWithChildren().toString());
            this.ioRoot.dbgHir.print(5, " loopStepPart", lLoopStepStmt.toStringWithChildren().toString());
        }
        if (lLoopInitPart instanceof BlockStmt) {
            lLoopInitPart = ((BlockStmt)lLoopInitPart).getFirstStmt();
        }
        if (lLoopStepStmt instanceof LabeledStmt) {
            lLoopStepStmt = ((LabeledStmt)lLoopStepStmt).getStmt();
        }
        if (lLoopStepStmt instanceof BlockStmt) {
            lLoopStepStmt = ((BlockStmt)lLoopStepStmt).getFirstStmt();
        }
        if (lLoopInitPart instanceof AssignStmt && lLoopInitPart.getChild1() instanceof VarNode && lLoopStepStmt instanceof AssignStmt && lLoopStepStmt.getChild1() instanceof VarNode) {
            lInductionVar = (Var)((VarNode)lLoopInitPart.getChild1()).getSymNodeSym();
        }
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgHir.print(3, " return " + lInductionVar);
        }
        return lInductionVar;
    }

    protected Stmt writeVector(Var pFromVar, Var pToVar, SymTable pSymTable) {
        VectorType lType2;
        int lDimension;
        this.ioRoot.dbgHir.print(2, "writeVector", " from " + pFromVar.toString() + " to " + pToVar.toString());
        if (!(pToVar.getSymType() instanceof PointerType && ((PointerType)pToVar.getSymType()).getPointedType() instanceof VectorType && pFromVar.getSymType() instanceof VectorType)) {
            this.ioRoot.msgRecovered.put("Type mismatch in writeVector of ReformHir from " + pFromVar.getSymType().toString() + " to " + pToVar.getSymType().toString());
            return null;
        }
        VectorType lType1 = (VectorType)pFromVar.getSymType();
        if (lType1.getElemType().isScalar()) {
            lDimension = 1;
        } else if (lType1.getElemType() instanceof VectorType && ((VectorType)lType1.getElemType()).isScalar()) {
            lDimension = 2;
        } else if (lType1.getElemType() instanceof VectorType && ((VectorType)lType1.getElemType()).getElemType().isScalar()) {
            lDimension = 3;
        } else {
            this.ioRoot.msgRecovered.put("More than 3 dimension array in writeVector of ReformHir from " + pFromVar.getSymType().toString() + " to " + pToVar.getSymType().toString());
            return null;
        }
        VarNode lVarNodeL = this.hir.varNode(pToVar);
        VarNode lVarNodeR = this.hir.varNode(pFromVar);
        Var lIndex1 = pSymTable.generateVar(this.symRoot.typeInt);
        BlockStmt lBlock1 = this.hir.blockStmt(null);
        if (lDimension == 1) {
            AssignStmt lAssign11 = this.hir.assignStmt(this.hir.subscriptedExp(this.hir.contentsExp(lVarNodeL), this.hir.varNode(lIndex1)), this.hir.subscriptedExp(lVarNodeR, this.hir.varNode(lIndex1)));
            lBlock1.addLastStmt(lAssign11);
        } else if (lDimension == 2) {
            lType2 = (VectorType)lType1.getElemType();
            Var lIndex2 = pSymTable.generateVar(this.symRoot.typeInt);
            Exp lArrayExp = this.hir.undecayExp((Exp)lVarNodeL, lType1.getElemCount(), lType1.getLowerBound());
            AssignStmt lAssign12 = this.hir.assignStmt(this.hir.subscriptedExp(this.hir.subscriptedExp(lArrayExp, this.hir.varNode(lIndex2)), this.hir.varNode(lIndex1)), this.hir.subscriptedExp(this.hir.subscriptedExp(lVarNodeR, this.hir.varNode(lIndex2)), this.hir.varNode(lIndex1)));
            BlockStmt lBlock2 = this.hir.blockStmt(lAssign12);
            ForStmt lForStmt2 = this.hir.forStmt(this.hir.assignStmt(this.hir.varNode(lIndex2), this.hir.intConstNode(lType2.getLowerBound())), this.hir.exp(55, this.hir.varNode(lIndex2), this.hir.intConstNode(lType2.getLowerBound() + lType2.getElemCount())), lBlock2, this.hir.assignStmt(this.hir.varNode(lIndex2), this.hir.exp(38, this.hir.varNode(lIndex2), this.hir.intConstNode(1))));
            lBlock1.addLastStmt(lForStmt2);
        } else if (lDimension == 3) {
            lType2 = (VectorType)lType1.getElemType();
            Var lIndex2 = pSymTable.generateVar(this.symRoot.typeInt);
            VectorType lType3 = (VectorType)((VectorType)lType1.getElemType()).getElemType();
            Var lIndex3 = pSymTable.generateVar(this.symRoot.typeInt);
            Exp lArrayExp2 = this.hir.undecayExp((Exp)lVarNodeL, lType1.getElemCount(), lType1.getLowerBound());
            AssignStmt lAssign13 = this.hir.assignStmt(this.hir.subscriptedExp(this.hir.subscriptedExp(this.hir.subscriptedExp(lArrayExp2, this.hir.varNode(lIndex3)), this.hir.varNode(lIndex2)), this.hir.varNode(lIndex1)), this.hir.subscriptedExp(this.hir.subscriptedExp(this.hir.subscriptedExp(lVarNodeR, this.hir.varNode(lIndex3)), this.hir.varNode(lIndex2)), this.hir.varNode(lIndex1)));
            BlockStmt lBlock4 = this.hir.blockStmt(lAssign13);
            ForStmt lForStmt4 = this.hir.forStmt(this.hir.assignStmt(this.hir.varNode(lIndex3), this.hir.intConstNode(lType3.getLowerBound())), this.hir.exp(55, this.hir.varNode(lIndex3), this.hir.intConstNode(lType3.getLowerBound() + lType3.getElemCount())), lBlock4, this.hir.assignStmt(this.hir.varNode(lIndex3), this.hir.exp(38, this.hir.varNode(lIndex3), this.hir.intConstNode(1))));
            BlockStmt lBlock5 = this.hir.blockStmt(lForStmt4);
            ForStmt lForStmt5 = this.hir.forStmt(this.hir.assignStmt(this.hir.varNode(lIndex2), this.hir.intConstNode(lType2.getLowerBound())), this.hir.exp(55, this.hir.varNode(lIndex2), this.hir.intConstNode(lType2.getLowerBound() + lType2.getElemCount())), lBlock5, this.hir.assignStmt(this.hir.varNode(lIndex2), this.hir.exp(38, this.hir.varNode(lIndex2), this.hir.intConstNode(1))));
            lBlock1.addLastStmt(lForStmt5);
        }
        ForStmt lForStmt1 = this.hir.forStmt(this.hir.assignStmt(this.hir.varNode(lIndex1), this.hir.intConstNode(lType1.getLowerBound())), this.hir.exp(55, this.hir.varNode(lIndex1), this.hir.intConstNode(lType1.getLowerBound() + lType1.getElemCount())), lBlock1, this.hir.assignStmt(this.hir.varNode(lIndex1), this.hir.exp(38, this.hir.varNode(lIndex1), this.hir.intConstNode(1))));
        if (this.fDbgLevel > 1) {
            this.ioRoot.dbgHir.print(2, "Result of writeVector", " from " + pFromVar.toString() + " to " + pToVar.toString());
            lForStmt1.print(2);
        }
        return lForStmt1;
    }

    protected void printLoopTable(LoopTable pTable) {
        pTable.print(1);
        pTable.DebugInductionList(this.fUtil);
    }

    public void printList(List pList, String pHeader) {
        if (pList == null) {
            return;
        }
        System.out.print("\n" + pHeader + "(");
        for (Object lItem : pList) {
            if (lItem == null) continue;
            if (lItem instanceof List) {
                this.printList((List)lItem, " ");
                continue;
            }
            if (lItem instanceof HIR) {
                System.out.print(" " + ((HIR)lItem).toStringShort());
                continue;
            }
            if (lItem instanceof Sym) {
                System.out.print(" " + ((Sym)lItem).getName());
                continue;
            }
            if (lItem instanceof LoopTable) {
                ((LoopTable)lItem).print(1);
                continue;
            }
            System.out.print(" class:" + lItem.getClass().toString() + " " + lItem.toString());
        }
        System.out.print(")");
    }

    public void printSet(Set pSet, String pHeader) {
        if (pSet == null) {
            return;
        }
        System.out.print("\n" + pHeader + "[");
        for (Object lItem : pSet) {
            if (lItem == null) continue;
            if (lItem instanceof List) {
                this.printList((List)lItem, " ");
                continue;
            }
            if (lItem instanceof HIR) {
                System.out.print(" " + ((HIR)lItem).toStringShort());
                continue;
            }
            if (lItem instanceof Sym) {
                System.out.print(" " + ((Sym)lItem).getName());
                continue;
            }
            System.out.print(" " + lItem.toString());
        }
        System.out.print("]");
    }

    protected Set varNodeToVarSet(Set pVarNodes) {
        HashSet<Var> lVarSet = new HashSet<Var>();
        for (Object lItem : pVarNodes) {
            if (lItem instanceof VarNode) {
                lVarSet.add((Var)((VarNode)lItem).getSymNodeSym());
                continue;
            }
            if (!(lItem instanceof Var)) continue;
            lVarSet.add((Var)lItem);
        }
        return lVarSet;
    }

    protected Var getVarOfExp(Exp pExp) {
        if (pExp == null) {
            return null;
        }
        if (pExp instanceof VarNode) {
            return (Var)((VarNode)pExp).getSymNodeSym();
        }
        return this.getVarOfExp((Exp)pExp.getChild1());
    }

    protected Set getReductionVar(List pReductionList) {
        HashSet<Sym> lVarSet = new HashSet<Sym>();
        if (pReductionList != null) {
            for (Reduction lRed : pReductionList) {
                if (lRed.DefVarNode == null) continue;
                lVarSet.add(lRed.DefVarNode.getSymNodeSym());
            }
        }
        return lVarSet;
    }

    protected List getReductionList(LoopTable pTable) {
        LinkedList lListOfReductions = new LinkedList();
        lListOfReductions.addAll(pTable.ReductionADDList);
        lListOfReductions.addAll(pTable.ReductionMULList);
        lListOfReductions.addAll(pTable.ReductionSUBList);
        lListOfReductions.addAll(pTable.ReductionMAXList);
        lListOfReductions.addAll(pTable.ReductionMINList);
        lListOfReductions.addAll(pTable.ReductionMAXINDEXList);
        lListOfReductions.addAll(pTable.ReductionMININDEXList);
        if (this.fDbgLevel >= 4) {
            this.printList(lListOfReductions, "getReductionList");
        }
        return lListOfReductions;
    }

    protected Reduction getReductionForVar(Var pVar, List pReductionList) {
        Reduction lReduction2 = null;
        for (Reduction lReduction2 : pReductionList) {
            if (lReduction2.DefVarNode.getSymNodeSym() != pVar) continue;
            return lReduction2;
        }
        this.ioRoot.msgRecovered.put("Reduction table not found for " + pVar.getName());
        return lReduction2;
    }

    protected Exp initialValueOfReduction(LoopTable pTable, Var pReductionVar) {
        Type lRedType = pReductionVar.getSymType();
        ConstNode lInitValue = this.getReductionVar(pTable.ReductionMULList).contains(pReductionVar) ? (lRedType.isFloating() ? this.hir.constNode(this.sym.floatConst(1.0, lRedType)) : this.hir.constNode(this.sym.intConst(1L, lRedType))) : (lRedType.isFloating() ? this.hir.constNode(this.sym.floatConst(0.0, lRedType)) : this.hir.constNode(this.sym.intConst(0L, lRedType)));
        return lInitValue;
    }

    protected boolean makeCSourceFromHirBase(String timing, HirRoot hirRoot, SymRoot symRoot, IoRoot io) throws IOException {
        File fHir2CFile = this.createHir2CFile(io);
        FileOutputStream out = new FileOutputStream(fHir2CFile);
        this.callHirBaseToC(hirRoot, symRoot, io, out);
        return true;
    }

    private File createHir2CFile(IoRoot io) throws IOException {
        CoinsOptions coinsOptions = io.getCompileSpecification().getCoinsOptions();
        File source = io.getSourceFile();
        String sourcePath = source.getPath();
        String root = sourcePath.substring(0, sourcePath.lastIndexOf(46));
        String Hir2CFileName = root.concat("-loop.c");
        File openMPFile = new File(Hir2CFileName);
        return openMPFile;
    }

    protected void callHirBaseToC(HirRoot hirRoot, SymRoot symRoot, IoRoot io, OutputStream out) throws IOException {
        Trace trace = io.getCompileSpecification().getTrace();
        HirBaseToCImpl HirToC = new HirBaseToCImpl(hirRoot, symRoot, new PrintStream(out), trace);
        HirToC.Converter();
    }
}

