/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.IoRoot;
import coins.flow.BBlock;
import coins.flow.BBlockSubtreeIterator;
import coins.flow.BitVector;
import coins.flow.DataFlow;
import coins.flow.DataFlowImpl;
import coins.flow.DefUseChain;
import coins.flow.DefUseList;
import coins.flow.DefVector;
import coins.flow.ExpVector;
import coins.flow.PointVector;
import coins.flow.ShowDataFlowByName;
import coins.flow.SubpFlow;
import coins.flow.UseDefList;
import coins.ir.IR;
import coins.sym.ExpId;
import coins.sym.FlowAnalSym;
import coins.sym.Sym;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class ShowDataFlow {
    public final FlowRoot flowRoot;
    public final IoRoot ioRoot;
    public final SubpFlow fSubpFlow;
    private DataFlow fDataFlow;
    private int fDefCount;
    private int fExpIdCount;
    private int fPointCount;
    private int fBBlockCount;
    private List fBBlockList;
    private ShowDataFlowByName fShowDataFlowByName = null;

    public ShowDataFlow() {
        this.flowRoot = null;
        this.ioRoot = null;
        this.fSubpFlow = null;
    }

    public ShowDataFlow(DataFlow pDataFlow) {
        this.fDataFlow = pDataFlow;
        this.flowRoot = ((DataFlowImpl)pDataFlow).flowRoot;
        this.ioRoot = this.flowRoot.ioRoot;
        this.fSubpFlow = this.flowRoot.fSubpFlow;
        this.initData();
    }

    private void initData() {
        this.fDefCount = this.fDataFlow.getDefCount();
        this.fExpIdCount = this.fDataFlow.getFlowAnalSymCount();
        this.fPointCount = this.fDataFlow.getPointCount();
        this.fBBlockCount = this.fSubpFlow.getNumberOfBBlocks();
        this.fBBlockList = this.fDataFlow.getBBlockList();
    }

    public void showAll() {
        this.showPno();
        this.showAllBitVectors();
        this.showDefUse();
        this.showUseDef();
    }

    public void showSummary() {
        this.fSubpFlow.printExpIdAndIrCorrespondence();
        ShowDataFlowByName lShow = ((DataFlowImpl)this.fDataFlow).showDataFlowByName;
        ListIterator lListIterator = this.fBBlockList.listIterator();
        while (lListIterator.hasNext()) {
            BBlock lBBlock = (BBlock)lListIterator.next();
            this.ioRoot.printOut.print("BBlock " + lBBlock.getBlockNumber() + " " + lBBlock.getLabel().getName() + "\n");
            this.ioRoot.printOut.print(" def    ");
            lShow.showPointVectorByName(lBBlock.getDef());
            this.ioRoot.printOut.print(" kill   ");
            lShow.showPointVectorByName(lBBlock.getKill());
            this.ioRoot.printOut.print(" reach  ");
            lShow.showPointVectorByName(lBBlock.getReach());
            this.ioRoot.printOut.print(" defined  ");
            lShow.showExpVectorByName(lBBlock.getDefined());
            this.ioRoot.printOut.print(" used   ");
            lShow.showExpVectorByName(lBBlock.getUsed());
            this.ioRoot.printOut.print(" exposed  ");
            lShow.showExpVectorByName(lBBlock.getExposed());
            this.ioRoot.printOut.print(" eGen   ");
            lShow.showExpVectorByName(lBBlock.getEGen());
            this.ioRoot.printOut.print(" eKill  ");
            lShow.showExpVectorByName(lBBlock.getEKill());
            if (this.ioRoot.dbgFlow.getLevel() >= 3) {
                this.ioRoot.printOut.print(" eKillAll");
                lShow.showExpVectorByName(lBBlock.getEKillAll());
            }
            this.ioRoot.printOut.print(" availin  ");
            lShow.showExpVectorByName(lBBlock.getAvailIn());
            this.ioRoot.printOut.print(" availOut ");
            lShow.showExpVectorByName(lBBlock.getAvailOut());
            this.ioRoot.printOut.print(" liveIn   ");
            lShow.showExpVectorByName(lBBlock.getLiveIn());
            this.ioRoot.printOut.print(" liveOut  ");
            lShow.showExpVectorByName(lBBlock.getLiveOut());
            this.ioRoot.printOut.print(" defIn  ");
            lShow.showExpVectorByName(lBBlock.getDefIn());
            this.ioRoot.printOut.print(" defOut   ");
            lShow.showExpVectorByName(lBBlock.getDefOut());
            this.ioRoot.printOut.print(" defNodes ");
            lShow.showNodeSet(lBBlock.getDefNodes());
        }
        this.showDefUse();
        this.showUseDef();
    }

    public void showDefVector(DefVector pdef) {
        if (this.ioRoot.dbgFlow.getLevel() > 3) {
            this.showVector((BitVector)pdef, this.fDefCount);
        }
        ((DataFlowImpl)this.fDataFlow).showDataFlowByName.showPointVectorByName(pdef);
        this.ioRoot.printOut.print("\n");
    }

    public void showExpVector(ExpVector pexp) {
        if (this.ioRoot.dbgFlow.getLevel() > 3) {
            this.showVector((BitVector)pexp, this.fExpIdCount);
        }
        ((DataFlowImpl)this.fDataFlow).showDataFlowByName.showExpVectorByName(pexp);
        this.ioRoot.printOut.print("\n");
    }

    public void showPointVector(PointVector pPoint) {
        if (this.ioRoot.dbgFlow.getLevel() > 3) {
            this.showVector((BitVector)pPoint, this.fPointCount);
        }
        ((DataFlowImpl)this.fDataFlow).showDataFlowByName.showPointVectorByName(pPoint);
        this.ioRoot.printOut.print("\n");
    }

    public void showVector(BitVector pbit, int pMaxno) {
        if (pMaxno == 0) {
            this.ioRoot.printOut.print("0 Length Vector\n");
        }
        int col = 30;
        int col1 = this.getCol(pMaxno) + 1;
        for (int i = 1; i <= pMaxno; ++i) {
            if (i % col == 1) {
                int j;
                this.ioRoot.printOut.print("\n");
                for (j = i; j < i + col; ++j) {
                    this.outNumber(j, col1);
                    if (j == pMaxno) break;
                }
                this.ioRoot.printOut.print("\n");
                for (j = i; j < i + col; ++j) {
                    for (int k = 1; k <= col1; ++k) {
                        this.ioRoot.printOut.print("-");
                    }
                    if (j == pMaxno) break;
                }
                this.ioRoot.printOut.print("\n");
            }
            if (pbit.getBit(i) == 1) {
                this.outNumber(1, col1);
                continue;
            }
            this.outNumber(0, col1);
        }
        this.ioRoot.printOut.print("\n");
    }

    void showVector(BitVector pBitVector) {
        if (pBitVector instanceof DefVector) {
            this.showDefVector((DefVector)pBitVector);
        } else if (pBitVector instanceof ExpVector) {
            this.showExpVector((ExpVector)pBitVector);
        } else if (pBitVector instanceof PointVector) {
            this.showPointVector((PointVector)pBitVector);
        } else {
            throw new IllegalArgumentException("Unexpected argument type.");
        }
    }

    void showVector(BitVector pBitVector, String pComment) {
        this.ioRoot.printOut.print(pComment + "\n");
        this.showVector(pBitVector);
    }

    private int getCol(int pnum) {
        String intStr = String.valueOf(pnum);
        return intStr.length();
    }

    private void outNumber(int pnum, int pcol) {
        int sp = pcol - this.getCol(pnum);
        for (int i = 0; i < sp; ++i) {
            this.ioRoot.printOut.print(" ");
        }
        this.ioRoot.printOut.print(pnum);
    }

    public void showPno() {
        this.initData();
        this.ioRoot.printOut.print("=====[Pno]=====\n");
        this.initData();
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            IR s;
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            BBlockSubtreeIterator Is = b.bblockSubtreeIterator();
            while (Is.hasNext() && (s = Is.next()) != null) {
                int NodeIndex = s.getIndex();
                int NodePno = this.fDataFlow.getDefIndex(NodeIndex);
                this.ioRoot.printOut.print("NodeIndex=" + NodeIndex);
                this.ioRoot.printOut.print("\tPNO=" + NodePno + "\n");
            }
        }
    }

    public void showDef() {
        this.initData();
        this.ioRoot.printOut.print("=====[Def(B)]=====\n");
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            this.showDefVector(b.getDef());
        }
    }

    public void showKill() {
        this.initData();
        this.ioRoot.printOut.print("=====[Kill(B)]=====\n");
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            this.showDefVector(b.getKill());
        }
    }

    public void showReach() {
        this.initData();
        this.ioRoot.printOut.print("=====[Reach(B)]=====\n");
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            this.showDefVector(b.getReach());
        }
    }

    public void showDefined() {
        this.initData();
        this.ioRoot.printOut.print("=====[Defined(B)]=====\n");
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            this.showExpVector(b.getDefined());
        }
    }

    public void showUsed() {
        this.initData();
        this.ioRoot.printOut.print("=====[Used(B)]=====\n");
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            this.showExpVector(b.getUsed());
        }
    }

    public void showExposed() {
        this.initData();
        this.ioRoot.printOut.print("=====[Exposed(B)]=====\n");
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            this.showExpVector(b.getExposed());
        }
    }

    public void showEGen() {
        this.initData();
        this.ioRoot.printOut.print("=====[EGen(B)]=====\n");
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            this.showExpVector(b.getEGen());
        }
    }

    public void showEKill() {
        this.initData();
        this.ioRoot.printOut.print("=====[EKill(B)]=====\n");
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            this.showExpVector(b.getEKill());
        }
    }

    public void showAvailIn() {
        this.initData();
        this.ioRoot.printOut.print("=====[AvailIn(B)]=====\n");
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            this.showExpVector(b.getAvailIn());
        }
    }

    public void showAvailOut() {
        this.initData();
        this.ioRoot.printOut.print("=====[AvailOut(B)]=====\n");
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            this.showExpVector(b.getAvailOut());
        }
    }

    public void showLiveIn() {
        this.initData();
        this.ioRoot.printOut.print("=====[LiveIn(B)]=====\n");
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            this.showExpVector(b.getLiveIn());
        }
    }

    public void showLiveOut() {
        this.initData();
        this.ioRoot.printOut.print("=====[LiveOut(B)]=====\n");
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            this.showExpVector(b.getLiveOut());
        }
    }

    public void showDefIn() {
        this.initData();
        this.ioRoot.printOut.print("=====[DefIn(B)]=====\n");
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            this.showExpVector(b.getDefIn());
        }
    }

    public void showDefOut() {
        this.initData();
        this.ioRoot.printOut.print("=====[DefOut(B)]=====\n");
        ListIterator Ie = this.fBBlockList.listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            this.showExpVector(b.getDefOut());
        }
    }

    void showDefVectors() {
        this.showDef();
        this.showKill();
        this.showReach();
    }

    void showExpVectors() {
        this.showDefined();
        this.showUsed();
        this.showExposed();
        this.showEGen();
        this.showEKill();
        this.showAvailIn();
        this.showAvailOut();
        this.showLiveIn();
        this.showLiveOut();
        this.showDefIn();
        this.showDefOut();
    }

    void showBasic() {
        this.showDef();
        this.showKill();
        this.showDefined();
        this.showExposed();
        this.showEGen();
        this.showEKill();
    }

    void showSolved() {
        this.showReach();
        this.showAvailIn();
        this.showAvailOut();
        this.showLiveIn();
        this.showLiveOut();
        this.showDefIn();
        this.showDefOut();
    }

    void showReachRelated() {
        this.showDef();
        this.showKill();
        this.showReach();
    }

    void showAvailInAvailOutRelated() {
        this.showEGen();
        this.showEKill();
        this.showAvailIn();
        this.showAvailOut();
    }

    void showLiveInLiveOutRelated() {
        this.showExposed();
        this.showDefined();
        this.showLiveIn();
        this.showLiveOut();
    }

    void showDefInDefOutRelated() {
        this.showDefined();
        this.showDefIn();
        this.showDefOut();
    }

    void showAllBitVectors() {
        this.showDefVectors();
        this.showExpVectors();
    }

    public void showDefUseOld() {
        HashSet lDefUseSyms = new HashSet();
        lDefUseSyms.addAll(this.fSubpFlow.getDefinedSyms());
        lDefUseSyms.addAll(this.fSubpFlow.getUsedSyms());
        this.ioRoot.printOut.print("=====[DefUse]===== of " + this.fSubpFlow.getSubpSym().getName() + "\n");
        DefUseList lDefUseList = this.fSubpFlow.getDefUseList();
        for (FlowAnalSym lSym : lDefUseSyms) {
            Set lUndefinedUseNodes;
            if (lSym != null) {
                this.ioRoot.printOut.print("\n " + lSym.getName());
                Sym lLinkedSym = null;
                if (lSym instanceof ExpId) {
                    lLinkedSym = ((ExpId)lSym).getLinkedSym();
                }
                if (lLinkedSym != null) {
                    this.ioRoot.printOut.print("(" + lLinkedSym.getName() + ")");
                }
                List lDefNodeList = this.fSubpFlow.getDefNodeList(lSym);
                Iterator lNodeIt = lDefNodeList.iterator();
                while (lNodeIt.hasNext()) {
                    DefUseChain lDefUseChain = lDefUseList.getDefUseChain((IR)lNodeIt.next());
                    if (lDefUseChain == null) continue;
                    this.ioRoot.printOut.print("\n  " + lDefUseChain.toStringByName());
                }
            }
            if ((lUndefinedUseNodes = this.fDataFlow.getUndefinedUseNodeOfSym(lSym)) == null) continue;
            this.ioRoot.printOut.print("\n  Use-nodes without corresponding Def-node\n   ");
            for (IR lUseNode2 : lUndefinedUseNodes) {
                this.ioRoot.printOut.print(" " + lUseNode2.toStringShort());
            }
        }
    }

    public void showDefUse() {
        if (!this.fSubpFlow.isComputed(24)) {
            this.flowRoot.flow.dataFlow().findDefUse();
        }
        DefUseList lDefUseList = this.fSubpFlow.getDefUseList();
        this.ioRoot.printOut.print("\n=====[DefUse]===== of " + this.fSubpFlow.getSubpSym().getName() + "\n");
        lDefUseList.print();
    }

    public void showUseDef() {
        if (!this.fSubpFlow.isComputed(25)) {
            this.flowRoot.flow.dataFlow().findUseDef();
        }
        UseDefList lUseDefList = this.fSubpFlow.getUseDefList();
        this.ioRoot.printOut.print("\n=====[UseDef]===== of " + this.fSubpFlow.getSubpSym().getName() + "\n");
        this.ioRoot.printOut.print(lUseDefList.toStringByName());
        this.ioRoot.printOut.print("\n");
    }

    public void setShowDataFlowByName(ShowDataFlowByName pShowDataFlowByName) {
        this.fShowDataFlowByName = pShowDataFlowByName;
    }
}

