/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.IoRoot;
import coins.flow.BBlock;
import coins.flow.BBlockSubtreeIterator;
import coins.flow.ControlFlow;
import coins.flow.ControlFlowImpl;
import coins.flow.SubpFlow;
import coins.ir.IR;
import coins.ir.hir.LabeledStmt;
import java.util.List;
import java.util.ListIterator;

public class ShowControlFlow {
    public final FlowRoot flowRoot;
    public final IoRoot ioRoot;
    private SubpFlow fFlow;
    public ControlFlowImpl fcFlow;

    public ShowControlFlow(SubpFlow pFlow, ControlFlow pcFlow) {
        this.flowRoot = ((ControlFlowImpl)pcFlow).flowRoot;
        this.ioRoot = ((ControlFlowImpl)pcFlow).ioRoot;
        this.fFlow = pFlow;
        this.fcFlow = (ControlFlowImpl)pcFlow;
    }

    public void showAll() {
        this.ioRoot.printOut.print("\n*[START]******** ControlFlowGraph *******\n");
        this.showBasicBlock();
        this.showDominator();
        this.showPostDominator();
        this.showImmediatelyDominate();
        this.showDominatedChildren();
        this.showImmediatelyPostDominate();
        this.showPostDominatedChildren();
        this.ioRoot.printOut.print("\n*[END]********** ControlFlowGraph *******\n");
    }

    public void showBasicBlock() {
        int maxBBlockNo = this.fFlow.getNumberOfBBlocks();
        this.ioRoot.printOut.print("=====[Basic Block]=====\n");
        for (int i = 1; i <= maxBBlockNo; ++i) {
            BBlock edge;
            BBlock b = this.fFlow.getBBlock(i);
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + " " + b.getIrLink().toStringShort() + " " + b.getLabel().getName() + " " + ((LabeledStmt)b.getIrLink()).getStmt() + "\n");
            if (b.isEntryBlock()) {
                this.ioRoot.printOut.print("(ENTRY BLOCK)\n");
            }
            if (b.isExitBlock()) {
                this.ioRoot.printOut.print("(EXIT BLOCK)\n");
            }
            this.ioRoot.printOut.print("\t ==Succ List==>(");
            List l = b.getSuccList();
            boolean first = true;
            ListIterator Ie = l.listIterator();
            while (Ie.hasNext()) {
                edge = (BBlock)Ie.next();
                if (first) {
                    first = false;
                } else {
                    this.ioRoot.printOut.print(",");
                }
                this.ioRoot.printOut.print(edge.getBlockNumber());
            }
            this.ioRoot.printOut.print(")\n");
            this.ioRoot.printOut.print("\t ==Pred List==>(");
            l = b.getPredList();
            first = true;
            Ie = l.listIterator();
            while (Ie.hasNext()) {
                edge = (BBlock)Ie.next();
                if (first) {
                    first = false;
                } else {
                    this.ioRoot.printOut.print(",");
                }
                this.ioRoot.printOut.print(edge.getBlockNumber());
            }
            this.ioRoot.printOut.print(")\n");
            this.ioRoot.printOut.print("\t ==Stmt List==\n");
            BBlockSubtreeIterator Is = b.bblockSubtreeIterator();
            while (Is.hasNext()) {
                IR s = Is.next();
                this.ioRoot.printOut.print("\t ");
                this.ioRoot.printOut.print(s + "\n");
            }
        }
    }

    public void showDominator() {
        this.ioRoot.printOut.print("=====[Dominator]=====\n");
        int maxBBlockNo = this.fFlow.getNumberOfBBlocks();
        for (int i = 1; i <= maxBBlockNo; ++i) {
            BBlock b = this.fFlow.getBBlock(i);
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber());
            this.ioRoot.printOut.print(" (");
            int lookUp = this.fcFlow.domLookUp(b.getBlockNumber());
            boolean first = true;
            if (this.fcFlow.fDom[lookUp] != null) {
                for (int j = 1; j <= maxBBlockNo; ++j) {
                    if (this.fcFlow.fDom[lookUp].getBit(j) != 1) continue;
                    if (first) {
                        first = false;
                    } else {
                        this.ioRoot.printOut.print(",");
                    }
                    this.ioRoot.printOut.print(this.fcFlow.domBitLookUp(j));
                }
            }
            this.ioRoot.printOut.print(")\n");
        }
    }

    public void showImmediatelyDominate() {
        this.ioRoot.printOut.print("=====[ImmediateDominator]=====\n");
        int maxBBlockNo = this.fFlow.getNumberOfBBlocks();
        for (int i = 1; i <= maxBBlockNo; ++i) {
            BBlock b = this.fFlow.getBBlock(i);
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            BBlock Idom = b.getImmediateDominator();
            this.ioRoot.printOut.print("\tImmediateDominator=");
            if (Idom == null) {
                this.ioRoot.printOut.print("NULL\n");
                continue;
            }
            this.ioRoot.printOut.print(Idom.getBlockNumber() + "\n");
        }
    }

    public void showDominatedChildren() {
        this.ioRoot.printOut.print("=====[DominatedChildren]=====\n");
        int maxBBlockNo = this.fFlow.getNumberOfBBlocks();
        for (int i = 1; i <= maxBBlockNo; ++i) {
            BBlock b = this.fFlow.getBBlock(i);
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            List l = b.getDominatedChildren();
            this.ioRoot.printOut.print("\t Child  List==>(");
            boolean first = true;
            ListIterator Ie = l.listIterator();
            while (Ie.hasNext()) {
                BBlock child = (BBlock)Ie.next();
                if (first) {
                    first = false;
                } else {
                    this.ioRoot.printOut.print(",");
                }
                this.ioRoot.printOut.print(child.getBlockNumber());
            }
            this.ioRoot.printOut.print(")\n");
        }
    }

    public void showPostDominatedChildren() {
        this.ioRoot.printOut.print("=====[PostDominatedChildren]=====\n");
        int maxBBlockNo = this.fFlow.getNumberOfBBlocks();
        for (int i = 1; i <= maxBBlockNo; ++i) {
            BBlock b = this.fFlow.getBBlock(i);
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            List l = b.getPostDominatedChildren();
            this.ioRoot.printOut.print("\t Child  List==>(");
            boolean first = true;
            ListIterator Ie = l.listIterator();
            while (Ie.hasNext()) {
                BBlock child = (BBlock)Ie.next();
                if (first) {
                    first = false;
                } else {
                    this.ioRoot.printOut.print(",");
                }
                this.ioRoot.printOut.print(child.getBlockNumber());
            }
            this.ioRoot.printOut.print(")\n");
        }
    }

    public void showImmediatelyPostDominate() {
        this.ioRoot.printOut.print("=====[ImmediatePostDominator]=====\n");
        int maxBBlockNo = this.fFlow.getNumberOfBBlocks();
        for (int i = 1; i <= maxBBlockNo; ++i) {
            BBlock b = this.fFlow.getBBlock(i);
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber() + "\n");
            BBlock Idom = b.getImmediatePostDominator();
            this.ioRoot.printOut.print("\tImmediatePostDominator=");
            if (Idom == null) {
                this.ioRoot.printOut.print("NULL\n");
                continue;
            }
            this.ioRoot.printOut.print(Idom.getBlockNumber() + "\n");
        }
    }

    private void showPostDominator() {
        this.ioRoot.printOut.print("=====[Post Dominator]=====\n");
        int maxBBlockNo = this.fFlow.getNumberOfBBlocks();
        for (int i = 1; i <= maxBBlockNo; ++i) {
            BBlock b = this.fFlow.getBBlock(i);
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber());
            this.ioRoot.printOut.print(" (");
            int lookUp = this.fcFlow.domLookUp(b.getBlockNumber());
            boolean first = true;
            for (int j = 1; j <= maxBBlockNo; ++j) {
                if (this.fcFlow.fPostDom[lookUp].getBit(j) != 1) continue;
                if (first) {
                    first = false;
                } else {
                    this.ioRoot.printOut.print(",");
                }
                this.ioRoot.printOut.print(this.fcFlow.domBitLookUp(j));
            }
            this.ioRoot.printOut.print(")\n");
        }
    }

    private void showStrictlyDominator() {
        this.ioRoot.printOut.print("=====[Strictly Dominator]=====\n");
        int maxBBlockNo = this.fFlow.getNumberOfBBlocks();
        for (int i = 1; i <= maxBBlockNo; ++i) {
            BBlock b = this.fFlow.getBBlock(i);
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber());
            this.ioRoot.printOut.print(" (");
            int lookUp = this.fcFlow.domLookUp(b.getBlockNumber());
            boolean first = true;
            for (int j = 1; j <= maxBBlockNo; ++j) {
                if (this.fcFlow.fsDom[lookUp].getBit(j) != 1) continue;
                if (first) {
                    first = false;
                } else {
                    this.ioRoot.printOut.print(",");
                }
                this.ioRoot.printOut.print(this.fcFlow.domBitLookUp(j));
            }
            this.ioRoot.printOut.print(")\n");
        }
    }

    public void showPostStrictlyDominator() {
        this.ioRoot.printOut.print("=====[PostStrictly Dominator]=====\n");
        int maxBBlockNo = this.fFlow.getNumberOfBBlocks();
        for (int i = 1; i <= maxBBlockNo; ++i) {
            BBlock b = this.fFlow.getBBlock(i);
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBlockNumber());
            this.ioRoot.printOut.print(" (");
            int lookUp = this.fcFlow.domLookUp(b.getBlockNumber());
            boolean first = true;
            for (int j = 1; j <= maxBBlockNo; ++j) {
                if (this.fcFlow.fPostsDom[lookUp].getBit(j) != 1) continue;
                if (first) {
                    first = false;
                } else {
                    this.ioRoot.printOut.print(",");
                }
                this.ioRoot.printOut.print(this.fcFlow.domBitLookUp(j));
            }
            this.ioRoot.printOut.print(")\n");
        }
    }
}

