/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.flow.BBlock;
import coins.flow.BBlockHirImpl;
import coins.flow.BBlockImpl;
import coins.flow.BBlockSubtreeIterator;
import coins.flow.ExpInf;
import coins.flow.FlowImpl;
import coins.flow.FlowUtil;
import coins.flow.HirSubpFlow;
import coins.flow.SetRefReprHirEImpl;
import coins.flow.SetRefReprList;
import coins.flow.SubpFlowImpl;
import coins.ir.IR;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.HIR_Impl;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirList;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabelDef;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.VarNode;
import coins.sym.ExpId;
import coins.sym.ExpIdImpl;
import coins.sym.FlowAnalSym;
import coins.sym.Label;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.SymTableImpl;
import coins.sym.Var;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class HirSubpFlowImpl
extends SubpFlowImpl
implements HirSubpFlow {
    public static final int EXP_ID_HASH_SIZE = 257;
    private ExpId[] fExpIdHashTable;
    private ExpId fFirstExpId = null;
    private int[] fHashCodeOfNode;
    public HIR[] fStmtExpSeq = null;
    public int[] fStmtExpSeqIndexForBBlock = null;
    public int fStmtExpCount = 0;

    public HirSubpFlowImpl(FlowRoot pFlowRoot, SubpDefinition pSubpDefinition) {
        super(pFlowRoot, pSubpDefinition);
        pFlowRoot.fSubpFlow = this;
        ((FlowImpl)pFlowRoot.flow).fSubpFlow = this;
        ((FlowImpl)pFlowRoot.flow).fSubpFlowCurrent = this;
        pFlowRoot.setHirAnalysis();
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgFlow.print(2, "HirSubpFlowImpl \n ");
        }
    }

    public boolean divideHirIntoBasicBlocks() {
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgFlow.print(2, "divideHirIntoBasicBlocks ", this.flowRoot.subpUnderAnalysis.getName() + " fIrIndexMin " + this.fIrIndexMin + " Max " + this.fIrIndexMax);
        }
        this.recordBBlock(this.bblock(), 0);
        Subp lSubp = this.fSubpDefinition.getSubpSym();
        this.fNodeCount = this.fIrIndexMax - this.fIrIndexMin + 1;
        this.fFlowIrLinkSize = this.fNodeCount + 1;
        this.fFlowIrLink = new IR[this.fFlowIrLinkSize];
        BBlock lBBlock = null;
        boolean lImmediatelyAfterJumpReturn = false;
        HirIterator lHirIterator = this.hirRoot.hir.hirIterator(this.fSubpDefinition.getHirBody());
        block11: while (lHirIterator.hasNext()) {
            int lNodeIndex;
            Sym lSym;
            HIR lNode = lHirIterator.next();
            if (lNode == null) continue;
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgFlow.print(6, " lNode", lNode.toStringShort());
            }
            if ((lSym = lNode.getSym()) != null && lSym instanceof FlowAnalSym) {
                FlowAnalSym lFlowAnalSym = (FlowAnalSym)lSym;
                if (lFlowAnalSym.getIndex() == 0) {
                    this.recordSym(lFlowAnalSym);
                } else if (this.fDbgLevel > 0) {
                    this.flow.dbg(6, " " + lFlowAnalSym.getName() + ":" + lFlowAnalSym.getIndex());
                }
            }
            if ((lNodeIndex = lNode.getIndex()) < this.fIrIndexMin) {
                this.ioRoot.msgRecovered.put(5010, "\nNode index " + lNodeIndex + " should be greater or equal to " + this.fIrIndexMin + " in " + this.fSubpDefinition.getSubpSym().getName() + "\n  Skip the flow analysis and the optimization.");
                return false;
            }
            this.fFlowIrLink[lNodeIndex - this.fIrIndexMin] = lNode;
            this.fBBlockOfIR[lNodeIndex - this.fIrIndexMin] = lBBlock;
            if (lImmediatelyAfterJumpReturn && lNode.getOperator() != 21) continue;
            lImmediatelyAfterJumpReturn = false;
            switch (lNode.getOperator()) {
                case 21: {
                    Label lLabel;
                    this.fBBlockOfIR[lNodeIndex - this.fIrIndexMin] = lBBlock = this.bblock((LabeledStmt)lNode);
                    IrList lLabelDefList = ((LabeledStmt)lNode).getLabelDefList();
                    if (lLabelDefList != null) {
                        ListIterator lIterator = lLabelDefList.iterator();
                        while (lIterator.hasNext()) {
                            lLabel = ((LabelDef)lIterator.next()).getLabel();
                            this.flowRoot.fSubpFlow.setBBlock(lLabel, lBBlock);
                        }
                    }
                    lImmediatelyAfterJumpReturn = false;
                    break;
                }
                case 68: {
                    HIR lParent = (HIR)lNode.getParent();
                    if (lParent.getOperator() == 22) {
                        lBBlock.setFlag(14, true);
                    }
                }
                case 20: 
                case 64: {
                    lBBlock.setFlag(15, true);
                    break;
                }
                case 19: {
                    lBBlock.setFlag(16, true);
                    break;
                }
                case 33: {
                    lBBlock.setFlag(13, true);
                    ++this.fCallCount;
                    this.fSubtreesContainingCall.add(lNode);
                    for (HIR lHir = (HIR)lNode.getParent(); lHir != null; lHir = (HIR)lHir.getParent()) {
                        this.fSubtreesContainingCall.add(lNode);
                    }
                    continue block11;
                }
                case 22: {
                    ++this.fAssignCount;
                    break;
                }
                case 28: {
                    Label lLabel = ((JumpStmt)lNode).getLabel();
                    lImmediatelyAfterJumpReturn = true;
                    ((BBlockImpl)lBBlock).fControlTransfer = lNode;
                    break;
                }
                case 34: {
                    lImmediatelyAfterJumpReturn = true;
                    ((BBlockImpl)lBBlock).fControlTransfer = lNode;
                    break;
                }
                case 32: {
                    Label lLabel;
                    SwitchStmt lSwitchStmt = (SwitchStmt)lNode;
                    int lCaseCount = lSwitchStmt.getCaseCount();
                    for (int i = 0; i < lCaseCount; ++i) {
                        lLabel = lSwitchStmt.getCaseLabel(i);
                    }
                    break;
                }
            }
        }
        this.fUsedSymCount = this.fSymExpCount;
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgFlow.print(2, lSubp.getName() + " Number of", "Symbols:" + this.fUsedSymCount + " Nodes:" + this.fNodeCount + " ");
        }
        this.fExpVectorBitCount = this.fUsedSymCount + 2;
        this.fExpVectorWordCount = (this.fExpVectorBitCount + 63) / 64;
        int lNodeCount = this.fIrIndexMax - this.fIrIndexMin;
        if (lNodeCount > 1000) {
            this.fComplexity = 2;
        }
        if (this.fSymExpCount > 100) {
            this.fComplexity = 2;
        }
        if (lNodeCount > 3000) {
            this.fComplexity = 3;
        }
        if (this.fSymExpCount > 200) {
            this.fComplexity = 3;
        }
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(1, "\n Node count " + lNodeCount + " BBlock count " + this.getNumberOfBBlocks() + " UsedSymCount " + this.getUsedSymCount() + " SymExpCount " + this.getSymExpCount() + "\n  AssignCount " + this.getAssignCount() + " CallCount " + this.getCallCount());
            this.ioRoot.dbgFlow.print(1, "\nComplexity level of ", this.getSubpSym().getName() + " is " + this.fComplexity);
            if (this.fComplexity > 1) {
                this.ioRoot.dbgFlow.print(1, "\n  Simplify alias analysis.");
            }
            if (this.fComplexity > 2) {
                this.ioRoot.dbgFlow.print(1, "\n  Simplify data flow analysis.");
            }
        }
        this.setComputedFlag(3);
        return true;
    }

    public void divideLirIntoBasicBlocks() {
    }

    public void allocateExpIdForSubp() {
        int lSymCount;
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgFlow.print(2, "allocateExpIdForSubp", this.flowRoot.subpUnderAnalysis.getName() + " UsedSymCount " + this.fUsedSymCount + " IrIndex " + this.fIrIndexMax + "-" + this.fIrIndexMin + " BBlockCount " + this.fBBlockCount);
        }
        if (this.isComputed(7)) {
            if (this.fDbgLevel > 0) {
                this.ioRoot.dbgFlow.print(2, " use computed ExpIds.");
            }
            return;
        }
        this.symRoot.symTableFlow = new SymTableImpl(this.symRoot);
        ((SymTableImpl)this.symRoot.symTableFlow).fTableName = "FlowAnal";
        this.setUnderComputation(7);
        this.fExpIdHashTable = new ExpId[257];
        int lNodeCount = this.fIrIndexMax - this.fIrIndexMin + 1;
        this.fDefRefIndex = new int[lNodeCount * 2 + 2];
        this.fDefIndex = new int[lNodeCount * 2 + 2];
        this.fDefRefPoint = new IR[lNodeCount * 2 + 2];
        this.fDefRefPoint[0] = null;
        this.fDefPoint = new IR[lNodeCount / 3];
        this.fDefPoint[0] = null;
        this.fExpIdTable = new ExpId[lNodeCount * 2 + 3];
        this.fSubtreesCopied = new ArrayList();
        this.fFirstExpId = null;
        this.fDefRefCount = 0;
        this.fHashCodeOfNode = new int[lNodeCount * 2 + 3];
        this.fMaxIndexOfCopiedNode = this.fIrIndexMax;
        this.allocateExpIdToNode(this.fSubpDefinition.getHirBody());
        this.fSymIndexTable = new FlowAnalSym[this.fSymExpCount + 3];
        for (FlowAnalSym lSym : this.fUsedSymSet) {
            if (lSym == null) continue;
            int lSymIndex = lSym.getIndex();
            this.fSymIndexTable[lSymIndex] = lSym;
        }
        this.setComputedFlag(7);
        if (this.fDbgLevel >= 3) {
            this.ioRoot.dbgFlow.print(3, "\nHIR after ExpId allocation", this.fSubpDefinition.getSubpSym().getName());
            this.fSubpDefinition.print(1);
        }
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgFlow.print(2, " SymExpCount", " " + this.getSymExpCount());
            if (this.fDbgLevel >= 2) {
                if (this.fDbgLevel >= 4) {
                    this.printExpIdAndIrCorrespondence();
                }
                System.out.print("\nMaximalCompoundVars " + this.getMaximalCompoundVars());
            }
        }
        if (this.fSymExpCount > (lSymCount = this.fDefinedSyms.size() + this.fUsedSymSet.size())) {
            lSymCount = this.fSymExpCount;
        }
        this.fFlowAnalSymTable = new FlowAnalSym[lSymCount + 2];
        Iterator lSymIt = this.fDefinedSyms.iterator();
        while (lSymIt.hasNext()) {
            FlowAnalSym lSym;
            this.fFlowAnalSymTable[lSym.getIndex()] = lSym = (FlowAnalSym)lSymIt.next();
        }
        if (this.fDbgLevel >= 2) {
            this.ioRoot.dbgFlow.print(2, "\nFlowAnalSymTable length=" + this.fFlowAnalSymTable.length + " ");
            for (int lIndex = 1; lIndex <= lSymCount; ++lIndex) {
                if (this.fFlowAnalSymTable[lIndex] == null) continue;
                this.ioRoot.dbgFlow.print(2, this.fFlowAnalSymTable[lIndex].getName() + " ");
            }
        }
    }

    public ExpInf allocateExpIdToNode(HIR pSubtree) {
        ExpId lExpIdOfTemp;
        Exp lExp;
        ExpId lExpId = null;
        if (pSubtree == null) {
            return null;
        }
        int lOpCode = pSubtree.getOperator();
        ExpInf lExpInfOfThis = new ExpInf(pSubtree);
        if (lOpCode == 7 && (lExp = this.getExpOfTemp((Var)pSubtree.getSym())) != null && (lExpIdOfTemp = this.getExpId(lExp)) != null) {
            ExpInf lExpInfTemp = lExpIdOfTemp.getExpInf();
            lExpInfTemp.combineTo(lExpInfOfThis);
        }
        ExpInf lExpInf = null;
        if (lOpCode == 35) {
            for (Stmt lStmt = ((BlockStmt)pSubtree).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                lExpInf = this.allocateExpIdToNode(lStmt);
                if (lExpInf == null) continue;
                lExpInf.combineTo(lExpInfOfThis);
            }
        } else {
            int lChildCount = pSubtree.getChildCount();
            if (lChildCount == 0) {
                if (pSubtree instanceof HirList) {
                    ListIterator lIterator = ((HirList)pSubtree).iterator();
                    while (lIterator.hasNext()) {
                        HIR lListElem = (HIR)lIterator.next();
                        lExpInf = this.allocateExpIdToNode(lListElem);
                        if (lExpInf == null) continue;
                        lExpInf.combineTo(lExpInfOfThis);
                    }
                }
            } else {
                for (int lChild = 1; lChild <= lChildCount; ++lChild) {
                    HIR lChildNode = (HIR)pSubtree.getChild(lChild);
                    lExpInf = this.allocateExpIdToNode(lChildNode);
                    if (lExpInf == null) continue;
                    lExpInf.combineTo(lExpInfOfThis);
                }
            }
        }
        switch (lOpCode) {
            case 33: {
                lExpInfOfThis.setCallFlag();
            }
            case 6: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 76: 
            case 77: 
            case 78: {
                lExpId = this.selectExpId(pSubtree, lExpInfOfThis);
                lExpInfOfThis.setNumberOfOperations(lExpInfOfThis.getNumberOfOperations() + 1);
                this.recordDefRefPoint(pSubtree);
                break;
            }
            case 37: {
                lExpInfOfThis.setNumberOfOperations(lExpInfOfThis.getNumberOfOperations() + 1);
                this.recordDefRefPoint(pSubtree);
                this.recordDefPoint(pSubtree);
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                lExpId = this.selectExpId(pSubtree, lExpInfOfThis);
                this.recordDefRefPoint(pSubtree);
                Var lVar = (Var)((VarNode)pSubtree).getSymNodeSym();
                lExpInfOfThis.getOperandSet().add(lVar);
                HIR lParent = (HIR)pSubtree.getParent();
                if (lParent != null && lParent.getOperator() == 64 && !this.dereferenced(pSubtree)) break;
                lExpInfOfThis.getOperandSet0().add(lVar);
                break;
            }
            case 22: {
                int lIndex = pSubtree.getIndex();
                this.recordDefRefPoint(pSubtree);
                this.recordDefPoint(pSubtree);
                ExpId lExpId_LHS = this.getExpId(pSubtree.getChild1());
                if (lExpId_LHS == null) break;
                lExpId_LHS.setFlag(24, true);
                ExpInf lExpInfOfLHS = lExpId_LHS.getExpInf();
                if (lExpInfOfLHS.getRValueExpId() != null) break;
                HIR lRValueExp = ((HIR)pSubtree.getChild1()).copyWithOperands();
                this.fMaxIndexOfCopiedNode = ((HIR_Impl)lRValueExp).setIndexNumberToAllNodes2(this.fMaxIndexOfCopiedNode + 1, false);
                ExpInf lRValueExpInf = this.allocateExpIdToNode(lRValueExp);
                ExpId lRValueExpId = this.getExpId(lRValueExp, lRValueExp.getIndex());
                lExpInfOfLHS.setRValueExpId(lRValueExpId);
                this.fSubtreesCopied.add(lRValueExp);
                this.fExpIdTable[lRValueExp.getIndex() - this.fIrIndexMin] = lRValueExpId;
                if (this.fDbgLevel <= 3) break;
                this.ioRoot.dbgFlow.print(6, " r-value ExpId=" + lRValueExpId.getName());
                break;
            }
        }
        this.fExpIdTable[pSubtree.getIndex() - this.fIrIndexMin] = lExpId;
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(6, "allocateExpIdToNode ", pSubtree.getIrName() + " position " + Integer.toString(this.fDefRefCount, 10));
        }
        return lExpInfOfThis;
    }

    ExpId selectExpId(HIR pSubtree, ExpInf pExpInf) {
        if (pSubtree == null) {
            return null;
        }
        ExpId lExpId = this.getExpId(pSubtree);
        if (lExpId != null) {
            return lExpId;
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(6, " selectExpId ", pSubtree.getIrName());
        }
        int lHashCode = this.computeHashCodeOfNode(pSubtree);
        for (lExpId = this.fExpIdHashTable[lHashCode]; lExpId != null; lExpId = lExpId.getNextId()) {
            if (!this.isSameTree(this.getLinkedSubtreeOfExpId(lExpId), pSubtree)) continue;
            if (this.fDbgLevel <= 3) break;
            this.ioRoot.dbgFlow.print(7, " same to " + this.getLinkedSubtreeOfExpId(lExpId).toStringShort());
            break;
        }
        if (lExpId == null) {
            String lExpIdName = this.generateExpIdName();
            lExpId = (ExpIdImpl)this.symRoot.symTableFlow.searchOrAdd(lExpIdName, 17, this.symRoot.subpCurrent, true, true);
            if (this.fFirstExpId == null) {
                this.fFirstExpId = lExpId;
            }
            lExpId.setExpInf(pExpInf);
            this.recordSym(lExpId);
            this.fExpIdList.add(lExpId);
            if (this.fExpIdHashTable[lHashCode] != null) {
                lExpId.setNextId(this.fExpIdHashTable[lHashCode]);
            }
            this.fExpIdHashTable[lHashCode] = lExpId;
        }
        this.setExpId(pSubtree, lExpId);
        if (!this.fDefinedSyms.contains(lExpId)) {
            this.fDefinedSyms.add(lExpId);
        }
        switch (pSubtree.getOperator()) {
            case 19: {
                if (pSubtree.getParent() != null && pSubtree.getParent().getOperator() == 19) break;
                this.getMaximalCompoundVars().add(lExpId);
                break;
            }
            case 20: {
                if (pSubtree.getParent() != null && pSubtree.getParent().getOperator() == 20) break;
                this.getMaximalCompoundVars().add(lExpId);
                break;
            }
            case 17: {
                if (pSubtree.getParent() != null && pSubtree.getParent().getOperator() == 17 && pSubtree.getChildNumber() == 1) break;
                this.getMaximalCompoundVars().add(lExpId);
                break;
            }
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(6, lExpId.getName() + " " + lExpId.getIndex());
        }
        return lExpId;
    }

    public int getHashCodeOfIndexedNode(int pNodeIndex) {
        return this.fHashCodeOfNode[pNodeIndex - this.fIrIndexMin];
    }

    public void setHashCodeOfIndexedNode(int pNodeIndex, int pHashCode) {
        this.fHashCodeOfNode[pNodeIndex - this.fIrIndexMin] = pHashCode;
    }

    int computeHashCodeOfNode(HIR pNode) {
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(7, " computeHashCodeOfNode ");
        }
        if (pNode == null) {
            return 0;
        }
        int lNodeIndex = pNode.getIndex();
        int lCode = this.getHashCodeOfIndexedNode(lNodeIndex);
        if (lCode != 0) {
            return lCode;
        }
        lCode = pNode.getOperator() + System.identityHashCode(pNode.getType());
        Sym lSym = pNode.getSym();
        if (lSym != null) {
            lCode = lCode * 2 + System.identityHashCode(lSym);
        } else {
            int lChildCount = pNode.getChildCount();
            for (int lChild = 1; lChild <= lChildCount; ++lChild) {
                lCode = lCode * 2 + this.computeHashCodeOfNode((HIR)pNode.getChild(lChild));
            }
        }
        if (FlowUtil.isAssignLHS(pNode)) {
            lCode *= 2;
        }
        lCode = (lCode & Integer.MAX_VALUE) % 257;
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(7, Integer.toString(lCode, 10));
        }
        this.setHashCodeOfIndexedNode(lNodeIndex, lCode);
        return lCode;
    }

    protected boolean isSameTree(HIR pTree1, HIR pTree2) {
        if (pTree1 == pTree2) {
            return true;
        }
        if (pTree1 == null || pTree2 == null) {
            return false;
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.print(7, " isSameTree " + pTree1.getIrName() + " " + pTree2.getIrName());
        }
        if (this.computeHashCodeOfNode(pTree1) != this.computeHashCodeOfNode(pTree2)) {
            return false;
        }
        Sym lSym1 = pTree1.getSym();
        if (lSym1 != null) {
            return lSym1 == pTree2.getSym();
        }
        int lChildCount = pTree1.getChildCount();
        if (pTree1.getOperator() != pTree2.getOperator() || pTree2.getChildCount() != lChildCount || pTree1.getType() != pTree2.getType()) {
            return false;
        }
        for (int lChild = 1; lChild <= lChildCount; ++lChild) {
            if (this.isSameTree((HIR)pTree1.getChild(lChild), (HIR)pTree2.getChild(lChild))) continue;
            return false;
        }
        return true;
    }

    public void computeBBlockSetRefReprs() {
        if (this.fDbgLevel > 0) {
            this.flowRoot.flow.dbg(4, "\ncomputeBBlockSetRefReprs");
        }
        this.recordSetRefReprs();
    }

    private boolean dereferenced(HIR pHir) {
        for (HIR lHir = pHir; lHir != null && lHir != pHir; lHir = (HIR)lHir.getParent()) {
            if (lHir.getOperator() != 68) continue;
            return true;
        }
        return false;
    }

    public boolean hasCall() {
        return this.fCallCount > 0;
    }

    public IR[] getFlowIrLink() {
        return this.fFlowIrLink;
    }

    public void recordSetRefReprs() {
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgFlow.print(2, "\nrecordSetRefReprs", this.getSubpSym().getName());
        }
        if (this.isComputedOrUnderComputation(8)) {
            if (this.fDbgLevel > 0) {
                this.ioRoot.dbgFlow.print(2, "already computed");
            }
            return;
        }
        if (!this.isComputed(7)) {
            this.allocateExpIdForSubp();
        }
        this.setUnderComputation(8);
        if (this.fArrayOfSetRefReprList == null) {
            this.fArrayOfSetRefReprList = new SetRefReprList[this.fBBlockCount + 1];
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgFlow.print(4, "allocate fArrayOfSetRefReprList " + this.fBBlockCount + 1);
            }
        }
        for (BBlock lBBlock : this.getBBlockList()) {
            if (!this.flowRoot.isHirAnalysis()) continue;
            this.recordSetRefReprs((BBlockHirImpl)lBBlock);
        }
        this.fDefCount = this.getDefCount();
        this.setComputedFlag(8);
    }

    public void recordSetRefReprs(BBlockHirImpl pBBlock) {
        if (pBBlock == null) {
            return;
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.printObject(4, "recordSetRefReprs", "B" + pBBlock.getBBlockNumber());
        }
        int lNodeIndexMin = this.getIrIndexMin();
        if (this.flowRoot.isHirAnalysis()) {
            SetRefReprList lSetRefReprList = new SetRefReprList(pBBlock);
            BBlockSubtreeIterator lBBlockSubtreeIterator = pBBlock.bblockSubtreeIterator();
            while (lBBlockSubtreeIterator.hasNext()) {
                IR lSubtree = lBBlockSubtreeIterator.next();
                if (lSubtree == null) continue;
                if (this.fDbgLevel > 3) {
                    this.ioRoot.dbgFlow.printObject(4, " next subtree in recordSetRefReprs", lSubtree.toStringShort());
                }
                this.recordSetRefReprsForNode((HIR)lSubtree, lSetRefReprList, pBBlock);
            }
            this.setSetRefReprList(pBBlock, lSetRefReprList);
            if (this.fDbgLevel >= 5) {
                this.ioRoot.dbgFlow.print(5, this.getSetRefReprList(pBBlock).toString());
            }
        } else {
            throw new RuntimeException("Not implemented.");
        }
    }

    public void recordSetRefReprsForNode(HIR pSubtree, List pSetRefReprList, BBlock pBBlock) {
        int lNodeIndexMin = this.getIrIndexMin();
        int lChildCount = pSubtree.getChildCount();
        if (lChildCount <= 0 && !(pSubtree instanceof VarNode)) {
            return;
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgFlow.printObject(5, "\n  recordSetRefReprsForNode", pSubtree.toStringShort() + " " + this.getExpId(pSubtree));
        }
        int lOpCode = pSubtree.getOperator();
        switch (lOpCode) {
            case 22: {
                SetRefReprHirEImpl lSetRefRepr = new SetRefReprHirEImpl(pSubtree, pBBlock, true, null);
                pSetRefReprList.add(lSetRefRepr);
                this.setSetRefReprOfIR(lSetRefRepr, pSubtree);
                if (!lSetRefRepr.sets()) break;
                break;
            }
            case 34: 
            case 36: {
                HIR lChild1 = (HIR)pSubtree.getChild1();
                if (lChild1 == null) break;
                if (lChild1.getOperator() == 33) {
                    this.recordSetRefReprsForNode((HIR)pSubtree.getChild1(), pSetRefReprList, pBBlock);
                    break;
                }
                SetRefReprHirEImpl lSetRefRepr = new SetRefReprHirEImpl(lChild1, pBBlock, false, null);
                pSetRefReprList.add(lSetRefRepr);
                break;
            }
            case 33: {
                SetRefReprHirEImpl lSetRefRepr = new SetRefReprHirEImpl(pSubtree, pBBlock, false, null);
                pSetRefReprList.add(lSetRefRepr);
                this.setSetRefReprOfIR(lSetRefRepr, pSubtree);
                break;
            }
            case 37: {
                SetRefReprHirEImpl lSetRefRepr = new SetRefReprHirEImpl(pSubtree, pBBlock, false, null);
                pSetRefReprList.add(lSetRefRepr);
                this.setSetRefReprOfIR(lSetRefRepr, pSubtree);
                break;
            }
            case 28: {
                break;
            }
            case 21: {
                break;
            }
            default: {
                if (!(pSubtree instanceof Exp)) break;
                SetRefReprHirEImpl lSetRefRepr = new SetRefReprHirEImpl(pSubtree, pBBlock, false, null);
                pSetRefReprList.add(lSetRefRepr);
                this.setSetRefReprOfIR(lSetRefRepr, pSubtree);
            }
        }
    }
}

